// Code generated by sdkgen. DO NOT EDIT.

// nolint
package datatransfer

import (
	"context"

	"google.golang.org/grpc"

	datatransfer "github.com/yandex-cloud/go-genproto/yandex/cloud/datatransfer/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// EndpointServiceClient is a datatransfer.EndpointServiceClient with
// lazy GRPC connection initialization.
type EndpointServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements datatransfer.EndpointServiceClient
func (c *EndpointServiceClient) Create(ctx context.Context, in *datatransfer.CreateEndpointRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return datatransfer.NewEndpointServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements datatransfer.EndpointServiceClient
func (c *EndpointServiceClient) Delete(ctx context.Context, in *datatransfer.DeleteEndpointRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return datatransfer.NewEndpointServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements datatransfer.EndpointServiceClient
func (c *EndpointServiceClient) Get(ctx context.Context, in *datatransfer.GetEndpointRequest, opts ...grpc.CallOption) (*datatransfer.Endpoint, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return datatransfer.NewEndpointServiceClient(conn).Get(ctx, in, opts...)
}

// List implements datatransfer.EndpointServiceClient
func (c *EndpointServiceClient) List(ctx context.Context, in *datatransfer.ListEndpointsRequest, opts ...grpc.CallOption) (*datatransfer.ListEndpointsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return datatransfer.NewEndpointServiceClient(conn).List(ctx, in, opts...)
}

type EndpointIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *EndpointServiceClient
	request *datatransfer.ListEndpointsRequest

	items []*datatransfer.Endpoint
}

func (c *EndpointServiceClient) EndpointIterator(ctx context.Context, req *datatransfer.ListEndpointsRequest, opts ...grpc.CallOption) *EndpointIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &EndpointIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *EndpointIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Endpoints
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *EndpointIterator) Take(size int64) ([]*datatransfer.Endpoint, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*datatransfer.Endpoint

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *EndpointIterator) TakeAll() ([]*datatransfer.Endpoint, error) {
	return it.Take(0)
}

func (it *EndpointIterator) Value() *datatransfer.Endpoint {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *EndpointIterator) Error() error {
	return it.err
}

// Update implements datatransfer.EndpointServiceClient
func (c *EndpointServiceClient) Update(ctx context.Context, in *datatransfer.UpdateEndpointRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return datatransfer.NewEndpointServiceClient(conn).Update(ctx, in, opts...)
}
