// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v3.21.12
// source: yandex/cloud/mdb/postgresql/v1/cluster.proto

package postgresql

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/postgresql/v1/config"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy:
	// only hotfixes are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

// Enum value maps for Cluster_Environment.
var (
	Cluster_Environment_name = map[int32]string{
		0: "ENVIRONMENT_UNSPECIFIED",
		1: "PRODUCTION",
		2: "PRESTABLE",
	}
	Cluster_Environment_value = map[string]int32{
		"ENVIRONMENT_UNSPECIFIED": 0,
		"PRODUCTION":              1,
		"PRESTABLE":               2,
	}
)

func (x Cluster_Environment) Enum() *Cluster_Environment {
	p := new(Cluster_Environment)
	*p = x
	return p
}

func (x Cluster_Environment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Environment) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[0].Descriptor()
}

func (Cluster_Environment) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[0]
}

func (x Cluster_Environment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Environment.Descriptor instead.
func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{0, 0}
}

type Cluster_Health int32

const (
	// State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] for every host in the cluster is DEAD).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE).
	Cluster_DEGRADED Cluster_Health = 3
)

// Enum value maps for Cluster_Health.
var (
	Cluster_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Cluster_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Cluster_Health) Enum() *Cluster_Health {
	p := new(Cluster_Health)
	*p = x
	return p
}

func (x Cluster_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[1].Descriptor()
}

func (Cluster_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[1]
}

func (x Cluster_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Health.Descriptor instead.
func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "CREATING",
		2: "RUNNING",
		3: "ERROR",
		4: "UPDATING",
		5: "STOPPING",
		6: "STOPPED",
		7: "STARTING",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNKNOWN": 0,
		"CREATING":       1,
		"RUNNING":        2,
		"ERROR":          3,
		"UPDATING":       4,
		"STOPPING":       5,
		"STOPPED":        6,
		"STARTING":       7,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[2].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[2]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{0, 2}
}

type ConnectionPoolerConfig_PoolingMode int32

const (
	ConnectionPoolerConfig_POOLING_MODE_UNSPECIFIED ConnectionPoolerConfig_PoolingMode = 0
	// Session pooling mode.
	ConnectionPoolerConfig_SESSION ConnectionPoolerConfig_PoolingMode = 1
	// Transaction pooling mode.
	ConnectionPoolerConfig_TRANSACTION ConnectionPoolerConfig_PoolingMode = 2
	// Statement pooling mode.
	ConnectionPoolerConfig_STATEMENT ConnectionPoolerConfig_PoolingMode = 3
)

// Enum value maps for ConnectionPoolerConfig_PoolingMode.
var (
	ConnectionPoolerConfig_PoolingMode_name = map[int32]string{
		0: "POOLING_MODE_UNSPECIFIED",
		1: "SESSION",
		2: "TRANSACTION",
		3: "STATEMENT",
	}
	ConnectionPoolerConfig_PoolingMode_value = map[string]int32{
		"POOLING_MODE_UNSPECIFIED": 0,
		"SESSION":                  1,
		"TRANSACTION":              2,
		"STATEMENT":                3,
	}
)

func (x ConnectionPoolerConfig_PoolingMode) Enum() *ConnectionPoolerConfig_PoolingMode {
	p := new(ConnectionPoolerConfig_PoolingMode)
	*p = x
	return p
}

func (x ConnectionPoolerConfig_PoolingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConnectionPoolerConfig_PoolingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[3].Descriptor()
}

func (ConnectionPoolerConfig_PoolingMode) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[3]
}

func (x ConnectionPoolerConfig_PoolingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConnectionPoolerConfig_PoolingMode.Descriptor instead.
func (ConnectionPoolerConfig_PoolingMode) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{3, 0}
}

type Host_Role int32

const (
	// Role of the host in the cluster is unknown. Default value.
	Host_ROLE_UNKNOWN Host_Role = 0
	// Host is the master PostgreSQL server in the cluster.
	Host_MASTER Host_Role = 1
	// Host is a replica (standby) PostgreSQL server in the cluster.
	Host_REPLICA Host_Role = 2
)

// Enum value maps for Host_Role.
var (
	Host_Role_name = map[int32]string{
		0: "ROLE_UNKNOWN",
		1: "MASTER",
		2: "REPLICA",
	}
	Host_Role_value = map[string]int32{
		"ROLE_UNKNOWN": 0,
		"MASTER":       1,
		"REPLICA":      2,
	}
)

func (x Host_Role) Enum() *Host_Role {
	p := new(Host_Role)
	*p = x
	return p
}

func (x Host_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[4].Descriptor()
}

func (Host_Role) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[4]
}

func (x Host_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Role.Descriptor instead.
func (Host_Role) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{4, 0}
}

type Host_ReplicaType int32

const (
	Host_REPLICA_TYPE_UNKNOWN Host_ReplicaType = 0 // Replica type is unknown (we have no data) or it's master
	Host_ASYNC                Host_ReplicaType = 1
	Host_SYNC                 Host_ReplicaType = 2
	Host_QUORUM               Host_ReplicaType = 3
)

// Enum value maps for Host_ReplicaType.
var (
	Host_ReplicaType_name = map[int32]string{
		0: "REPLICA_TYPE_UNKNOWN",
		1: "ASYNC",
		2: "SYNC",
		3: "QUORUM",
	}
	Host_ReplicaType_value = map[string]int32{
		"REPLICA_TYPE_UNKNOWN": 0,
		"ASYNC":                1,
		"SYNC":                 2,
		"QUORUM":               3,
	}
)

func (x Host_ReplicaType) Enum() *Host_ReplicaType {
	p := new(Host_ReplicaType)
	*p = x
	return p
}

func (x Host_ReplicaType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_ReplicaType) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[5].Descriptor()
}

func (Host_ReplicaType) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[5]
}

func (x Host_ReplicaType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_ReplicaType.Descriptor instead.
func (Host_ReplicaType) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{4, 1}
}

type Host_Health int32

const (
	// Health of the host is unknown. Default value.
	Host_HEALTH_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
	// The host is alive, but in read-only mode.
	Host_READONLY Host_Health = 4
)

// Enum value maps for Host_Health.
var (
	Host_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
		4: "READONLY",
	}
	Host_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
		"READONLY":       4,
	}
)

func (x Host_Health) Enum() *Host_Health {
	p := new(Host_Health)
	*p = x
	return p
}

func (x Host_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[6].Descriptor()
}

func (Host_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[6]
}

func (x Host_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Health.Descriptor instead.
func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{4, 2}
}

type Service_Type int32

const (
	// Service type of the host is unspecified. Default value.
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is a PostgreSQL server.
	Service_POSTGRESQL Service_Type = 1
	// The host is a PgBouncer server.
	Service_POOLER Service_Type = 2
)

// Enum value maps for Service_Type.
var (
	Service_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "POSTGRESQL",
		2: "POOLER",
	}
	Service_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"POSTGRESQL":       1,
		"POOLER":           2,
	}
)

func (x Service_Type) Enum() *Service_Type {
	p := new(Service_Type)
	*p = x
	return p
}

func (x Service_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[7].Descriptor()
}

func (Service_Type) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[7]
}

func (x Service_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_Type.Descriptor instead.
func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{6, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown. Default value.
	Service_HEALTH_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
	// The server is in read-only mode.
	Service_READONLY Service_Health = 3
)

// Enum value maps for Service_Health.
var (
	Service_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "READONLY",
	}
	Service_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"READONLY":       3,
	}
)

func (x Service_Health) Enum() *Service_Health {
	p := new(Service_Health)
	*p = x
	return p
}

func (x Service_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[8].Descriptor()
}

func (Service_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes[8]
}

func (x Service_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_Health.Descriptor instead.
func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{6, 1}
}

// A PostgreSQL Cluster resource. For more information, see
// the [Concepts](/docs/managed-postgresql/concepts) section of the documentation.
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the PostgreSQL cluster.
	// This ID is assigned by MDB at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the PostgreSQL cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the PostgreSQL cluster.
	// The name is unique within the folder. 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the PostgreSQL cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the PostgreSQL cluster as “ key:value “ pairs.
	// Maximum 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the PostgreSQL cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.postgresql.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the PostgreSQL cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the PostgreSQL cluster.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.postgresql.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.postgresql.v1.Cluster_Status" json:"status,omitempty"`
	// Maintenance window for the cluster.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,13,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Planned maintenance operation to be started for the cluster within the nearest [maintenance_window].
	PlannedOperation *MaintenanceOperation `protobuf:"bytes,14,opt,name=planned_operation,json=plannedOperation,proto3" json:"planned_operation,omitempty"`
	// User security groups
	SecurityGroupIds []string `protobuf:"bytes,15,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	// Deletion Protection inhibits deletion of the cluster
	DeletionProtection bool `protobuf:"varint,16,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
	// Host groups hosting VMs of the cluster.
	HostGroupIds []string `protobuf:"bytes,17,rep,name=host_group_ids,json=hostGroupIds,proto3" json:"host_group_ids,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cluster) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Cluster) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetEnvironment() Cluster_Environment {
	if x != nil {
		return x.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (x *Cluster) GetMonitoring() []*Monitoring {
	if x != nil {
		return x.Monitoring
	}
	return nil
}

func (x *Cluster) GetConfig() *ClusterConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Cluster) GetNetworkId() string {
	if x != nil {
		return x.NetworkId
	}
	return ""
}

func (x *Cluster) GetHealth() Cluster_Health {
	if x != nil {
		return x.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (x *Cluster) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Cluster) GetPlannedOperation() *MaintenanceOperation {
	if x != nil {
		return x.PlannedOperation
	}
	return nil
}

func (x *Cluster) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

func (x *Cluster) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

func (x *Cluster) GetHostGroupIds() []string {
	if x != nil {
		return x.HostGroupIds
	}
	return nil
}

// Monitoring system.
type Monitoring struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the PostgreSQL cluster.
	Link string `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
}

func (x *Monitoring) Reset() {
	*x = Monitoring{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Monitoring) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Monitoring) ProtoMessage() {}

func (x *Monitoring) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Monitoring.ProtoReflect.Descriptor instead.
func (*Monitoring) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *Monitoring) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Monitoring) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Monitoring) GetLink() string {
	if x != nil {
		return x.Link
	}
	return ""
}

type ClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version of PostgreSQL server software.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration for PostgreSQL servers in the cluster.
	//
	// Types that are assignable to PostgresqlConfig:
	//
	//	*ClusterConfig_PostgresqlConfig_9_6
	//	*ClusterConfig_PostgresqlConfig_10_1C
	//	*ClusterConfig_PostgresqlConfig_10
	//	*ClusterConfig_PostgresqlConfig_11
	//	*ClusterConfig_PostgresqlConfig_11_1C
	//	*ClusterConfig_PostgresqlConfig_12
	//	*ClusterConfig_PostgresqlConfig_12_1C
	//	*ClusterConfig_PostgresqlConfig_13
	//	*ClusterConfig_PostgresqlConfig_13_1C
	//	*ClusterConfig_PostgresqlConfig_14
	//	*ClusterConfig_PostgresqlConfig_14_1C
	//	*ClusterConfig_PostgresqlConfig_15
	//	*ClusterConfig_PostgresqlConfig_15_1C
	//	*ClusterConfig_PostgresqlConfig_16
	//	*ClusterConfig_PostgresqlConfig_16_1C
	//	*ClusterConfig_PostgresqlConfig_17
	//	*ClusterConfig_PostgresqlConfig_17_1C
	PostgresqlConfig isClusterConfig_PostgresqlConfig `protobuf_oneof:"postgresql_config"`
	// Configuration of the connection pooler.
	PoolerConfig *ConnectionPoolerConfig `protobuf:"bytes,4,opt,name=pooler_config,json=poolerConfig,proto3" json:"pooler_config,omitempty"`
	// Resources allocated to PostgreSQL hosts.
	Resources *Resources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	// Configuration setting which enables/disables autofailover in cluster.
	Autofailover *wrapperspb.BoolValue `protobuf:"bytes,6,opt,name=autofailover,proto3" json:"autofailover,omitempty"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,7,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Retention policy of automated backups.
	BackupRetainPeriodDays *wrapperspb.Int64Value `protobuf:"bytes,17,opt,name=backup_retain_period_days,json=backupRetainPeriodDays,proto3" json:"backup_retain_period_days,omitempty"`
	// Access policy to DB
	Access *Access `protobuf:"bytes,9,opt,name=access,proto3" json:"access,omitempty"`
	// Configuration of the performance diagnostics service.
	PerformanceDiagnostics *PerformanceDiagnostics `protobuf:"bytes,12,opt,name=performance_diagnostics,json=performanceDiagnostics,proto3" json:"performance_diagnostics,omitempty"`
	// Disk size autoscaling
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,23,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *ClusterConfig) Reset() {
	*x = ClusterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterConfig) ProtoMessage() {}

func (x *ClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterConfig.ProtoReflect.Descriptor instead.
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *ClusterConfig) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (m *ClusterConfig) GetPostgresqlConfig() isClusterConfig_PostgresqlConfig {
	if m != nil {
		return m.PostgresqlConfig
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_9_6() *config.PostgresqlConfigSet9_6 {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_9_6); ok {
		return x.PostgresqlConfig_9_6
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_10_1C() *config.PostgresqlConfigSet10_1C {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_10_1C); ok {
		return x.PostgresqlConfig_10_1C
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_10() *config.PostgresqlConfigSet10 {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_10); ok {
		return x.PostgresqlConfig_10
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_11() *config.PostgresqlConfigSet11 {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_11); ok {
		return x.PostgresqlConfig_11
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_11_1C() *config.PostgresqlConfigSet11_1C {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_11_1C); ok {
		return x.PostgresqlConfig_11_1C
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_12() *config.PostgresqlConfigSet12 {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_12); ok {
		return x.PostgresqlConfig_12
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_12_1C() *config.PostgresqlConfigSet12_1C {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_12_1C); ok {
		return x.PostgresqlConfig_12_1C
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_13() *config.PostgresqlConfigSet13 {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_13); ok {
		return x.PostgresqlConfig_13
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_13_1C() *config.PostgresqlConfigSet13_1C {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_13_1C); ok {
		return x.PostgresqlConfig_13_1C
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_14() *config.PostgresqlConfigSet14 {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_14); ok {
		return x.PostgresqlConfig_14
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_14_1C() *config.PostgresqlConfigSet14_1C {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_14_1C); ok {
		return x.PostgresqlConfig_14_1C
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_15() *config.PostgresqlConfigSet15 {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_15); ok {
		return x.PostgresqlConfig_15
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_15_1C() *config.PostgresqlConfigSet15_1C {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_15_1C); ok {
		return x.PostgresqlConfig_15_1C
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_16() *config.PostgresqlConfigSet16 {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_16); ok {
		return x.PostgresqlConfig_16
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_16_1C() *config.PostgresqlConfigSet16_1C {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_16_1C); ok {
		return x.PostgresqlConfig_16_1C
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_17() *config.PostgresqlConfigSet17 {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_17); ok {
		return x.PostgresqlConfig_17
	}
	return nil
}

func (x *ClusterConfig) GetPostgresqlConfig_17_1C() *config.PostgresqlConfigSet17_1C {
	if x, ok := x.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_17_1C); ok {
		return x.PostgresqlConfig_17_1C
	}
	return nil
}

func (x *ClusterConfig) GetPoolerConfig() *ConnectionPoolerConfig {
	if x != nil {
		return x.PoolerConfig
	}
	return nil
}

func (x *ClusterConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *ClusterConfig) GetAutofailover() *wrapperspb.BoolValue {
	if x != nil {
		return x.Autofailover
	}
	return nil
}

func (x *ClusterConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if x != nil {
		return x.BackupWindowStart
	}
	return nil
}

func (x *ClusterConfig) GetBackupRetainPeriodDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.BackupRetainPeriodDays
	}
	return nil
}

func (x *ClusterConfig) GetAccess() *Access {
	if x != nil {
		return x.Access
	}
	return nil
}

func (x *ClusterConfig) GetPerformanceDiagnostics() *PerformanceDiagnostics {
	if x != nil {
		return x.PerformanceDiagnostics
	}
	return nil
}

func (x *ClusterConfig) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type isClusterConfig_PostgresqlConfig interface {
	isClusterConfig_PostgresqlConfig()
}

type ClusterConfig_PostgresqlConfig_9_6 struct {
	// Configuration of a PostgreSQL 9.6 server.
	PostgresqlConfig_9_6 *config.PostgresqlConfigSet9_6 `protobuf:"bytes,2,opt,name=postgresql_config_9_6,json=postgresqlConfig_9_6,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_10_1C struct {
	// Configuration of a PostgreSQL 10 1C server.
	PostgresqlConfig_10_1C *config.PostgresqlConfigSet10_1C `protobuf:"bytes,10,opt,name=postgresql_config_10_1c,json=postgresqlConfig_10_1c,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_10 struct {
	// Configuration of a PostgreSQL 10 server.
	PostgresqlConfig_10 *config.PostgresqlConfigSet10 `protobuf:"bytes,3,opt,name=postgresql_config_10,json=postgresqlConfig_10,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_11 struct {
	// Configuration of a PostgreSQL 11 server.
	PostgresqlConfig_11 *config.PostgresqlConfigSet11 `protobuf:"bytes,8,opt,name=postgresql_config_11,json=postgresqlConfig_11,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_11_1C struct {
	// Configuration of a PostgreSQL 11 1C server.
	PostgresqlConfig_11_1C *config.PostgresqlConfigSet11_1C `protobuf:"bytes,13,opt,name=postgresql_config_11_1c,json=postgresqlConfig_11_1c,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_12 struct {
	// Configuration of a PostgreSQL 12 server.
	PostgresqlConfig_12 *config.PostgresqlConfigSet12 `protobuf:"bytes,11,opt,name=postgresql_config_12,json=postgresqlConfig_12,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_12_1C struct {
	// Configuration of a PostgreSQL 12 1C server.
	PostgresqlConfig_12_1C *config.PostgresqlConfigSet12_1C `protobuf:"bytes,14,opt,name=postgresql_config_12_1c,json=postgresqlConfig_12_1c,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_13 struct {
	// Configuration of a PostgreSQL 13 server.
	PostgresqlConfig_13 *config.PostgresqlConfigSet13 `protobuf:"bytes,15,opt,name=postgresql_config_13,json=postgresqlConfig_13,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_13_1C struct {
	// Configuration of a PostgreSQL 13 1C server.
	PostgresqlConfig_13_1C *config.PostgresqlConfigSet13_1C `protobuf:"bytes,18,opt,name=postgresql_config_13_1c,json=postgresqlConfig_13_1c,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_14 struct {
	// Configuration of a PostgreSQL 14 server.
	PostgresqlConfig_14 *config.PostgresqlConfigSet14 `protobuf:"bytes,16,opt,name=postgresql_config_14,json=postgresqlConfig_14,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_14_1C struct {
	// Configuration of a PostgreSQL 14 1C server.
	PostgresqlConfig_14_1C *config.PostgresqlConfigSet14_1C `protobuf:"bytes,19,opt,name=postgresql_config_14_1c,json=postgresqlConfig_14_1c,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_15 struct {
	// Configuration of a PostgreSQL 15 server.
	PostgresqlConfig_15 *config.PostgresqlConfigSet15 `protobuf:"bytes,21,opt,name=postgresql_config_15,json=postgresqlConfig_15,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_15_1C struct {
	// Configuration of a PostgreSQL 15 1C server.
	PostgresqlConfig_15_1C *config.PostgresqlConfigSet15_1C `protobuf:"bytes,22,opt,name=postgresql_config_15_1c,json=postgresqlConfig_15_1c,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_16 struct {
	// Configuration of a PostgreSQL 16 server.
	PostgresqlConfig_16 *config.PostgresqlConfigSet16 `protobuf:"bytes,24,opt,name=postgresql_config_16,json=postgresqlConfig_16,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_16_1C struct {
	// Configuration of a PostgreSQL 16 1C server.
	PostgresqlConfig_16_1C *config.PostgresqlConfigSet16_1C `protobuf:"bytes,25,opt,name=postgresql_config_16_1c,json=postgresqlConfig_16_1c,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_17 struct {
	// Configuration of a PostgreSQL 17 server.
	PostgresqlConfig_17 *config.PostgresqlConfigSet17 `protobuf:"bytes,27,opt,name=postgresql_config_17,json=postgresqlConfig_17,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_17_1C struct {
	// Configuration of a PostgreSQL 17 1C server.
	PostgresqlConfig_17_1C *config.PostgresqlConfigSet17_1C `protobuf:"bytes,28,opt,name=postgresql_config_17_1c,json=postgresqlConfig_17_1c,proto3,oneof"`
}

func (*ClusterConfig_PostgresqlConfig_9_6) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_10_1C) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_10) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_11) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_11_1C) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_12) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_12_1C) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_13) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_13_1C) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_14) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_14_1C) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_15) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_15_1C) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_16) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_16_1C) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_17) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_17_1C) isClusterConfig_PostgresqlConfig() {}

type ConnectionPoolerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mode that the connection pooler is working in.
	// See descriptions of all modes in the [documentation for PgBouncer](https://pgbouncer.github.io/usage).
	PoolingMode ConnectionPoolerConfig_PoolingMode `protobuf:"varint,1,opt,name=pooling_mode,json=poolingMode,proto3,enum=yandex.cloud.mdb.postgresql.v1.ConnectionPoolerConfig_PoolingMode" json:"pooling_mode,omitempty"`
	// Setting `server_reset_query_always` parameter in PgBouncer.
	PoolDiscard *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=pool_discard,json=poolDiscard,proto3" json:"pool_discard,omitempty"`
}

func (x *ConnectionPoolerConfig) Reset() {
	*x = ConnectionPoolerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionPoolerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionPoolerConfig) ProtoMessage() {}

func (x *ConnectionPoolerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionPoolerConfig.ProtoReflect.Descriptor instead.
func (*ConnectionPoolerConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *ConnectionPoolerConfig) GetPoolingMode() ConnectionPoolerConfig_PoolingMode {
	if x != nil {
		return x.PoolingMode
	}
	return ConnectionPoolerConfig_POOLING_MODE_UNSPECIFIED
}

func (x *ConnectionPoolerConfig) GetPoolDiscard() *wrapperspb.BoolValue {
	if x != nil {
		return x.PoolDiscard
	}
	return nil
}

type Host struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the PostgreSQL host. The host name is assigned by MDB at creation time, and cannot be changed.
	// 1-63 characters long.
	//
	// The name is unique across all MDB hosts that exist on the platform, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the PostgreSQL host. The ID is assigned by MDB at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the PostgreSQL host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Resources allocated to the PostgreSQL host.
	Resources *Resources `protobuf:"bytes,4,opt,name=resources,proto3" json:"resources,omitempty"`
	// Role of the host in the cluster. If the field has default value, it is not returned in the response.
	Role Host_Role `protobuf:"varint,5,opt,name=role,proto3,enum=yandex.cloud.mdb.postgresql.v1.Host_Role" json:"role,omitempty"`
	// Aggregated health of the host. If the field has default value, it is not returned in the response.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.postgresql.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services []*Service `protobuf:"bytes,7,rep,name=services,proto3" json:"services,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Name of the host to be used as the replication source for cascading replication.
	ReplicationSource string `protobuf:"bytes,9,opt,name=replication_source,json=replicationSource,proto3" json:"replication_source,omitempty"`
	// Priority of the host as a replica. Higher value means higher priority.
	//
	// The host with the highest priority is the synchronous replica. All others are asynchronous.
	// The synchronous replica replaces the master when needed.
	//
	// When a replica becomes the master, its priority is ignored.
	Priority *wrapperspb.Int64Value `protobuf:"bytes,10,opt,name=priority,proto3" json:"priority,omitempty"`
	// Configuration of a PostgreSQL server for the host.
	Config *HostConfig `protobuf:"bytes,11,opt,name=config,proto3" json:"config,omitempty"`
	// Flag showing public IP assignment status to this host.
	AssignPublicIp bool             `protobuf:"varint,12,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	ReplicaType    Host_ReplicaType `protobuf:"varint,13,opt,name=replica_type,json=replicaType,proto3,enum=yandex.cloud.mdb.postgresql.v1.Host_ReplicaType" json:"replica_type,omitempty"`
}

func (x *Host) Reset() {
	*x = Host{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Host) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host) ProtoMessage() {}

func (x *Host) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host.ProtoReflect.Descriptor instead.
func (*Host) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *Host) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Host) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *Host) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *Host) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Host) GetRole() Host_Role {
	if x != nil {
		return x.Role
	}
	return Host_ROLE_UNKNOWN
}

func (x *Host) GetHealth() Host_Health {
	if x != nil {
		return x.Health
	}
	return Host_HEALTH_UNKNOWN
}

func (x *Host) GetServices() []*Service {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *Host) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *Host) GetReplicationSource() string {
	if x != nil {
		return x.ReplicationSource
	}
	return ""
}

func (x *Host) GetPriority() *wrapperspb.Int64Value {
	if x != nil {
		return x.Priority
	}
	return nil
}

func (x *Host) GetConfig() *HostConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Host) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

func (x *Host) GetReplicaType() Host_ReplicaType {
	if x != nil {
		return x.ReplicaType
	}
	return Host_REPLICA_TYPE_UNKNOWN
}

type HostConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration of a PostgreSQL server for the host.
	//
	// Types that are assignable to PostgresqlConfig:
	//
	//	*HostConfig_PostgresqlConfig_9_6
	//	*HostConfig_PostgresqlConfig_10_1C
	//	*HostConfig_PostgresqlConfig_10
	//	*HostConfig_PostgresqlConfig_11
	//	*HostConfig_PostgresqlConfig_11_1C
	//	*HostConfig_PostgresqlConfig_12
	//	*HostConfig_PostgresqlConfig_12_1C
	//	*HostConfig_PostgresqlConfig_13
	//	*HostConfig_PostgresqlConfig_13_1C
	//	*HostConfig_PostgresqlConfig_14
	//	*HostConfig_PostgresqlConfig_14_1C
	//	*HostConfig_PostgresqlConfig_15
	//	*HostConfig_PostgresqlConfig_15_1C
	//	*HostConfig_PostgresqlConfig_16
	//	*HostConfig_PostgresqlConfig_16_1C
	//	*HostConfig_PostgresqlConfig_17
	//	*HostConfig_PostgresqlConfig_17_1C
	PostgresqlConfig isHostConfig_PostgresqlConfig `protobuf_oneof:"postgresql_config"`
}

func (x *HostConfig) Reset() {
	*x = HostConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HostConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HostConfig) ProtoMessage() {}

func (x *HostConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HostConfig.ProtoReflect.Descriptor instead.
func (*HostConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{5}
}

func (m *HostConfig) GetPostgresqlConfig() isHostConfig_PostgresqlConfig {
	if m != nil {
		return m.PostgresqlConfig
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_9_6() *config.PostgresqlHostConfig9_6 {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_9_6); ok {
		return x.PostgresqlConfig_9_6
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_10_1C() *config.PostgresqlHostConfig10_1C {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_10_1C); ok {
		return x.PostgresqlConfig_10_1C
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_10() *config.PostgresqlHostConfig10 {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_10); ok {
		return x.PostgresqlConfig_10
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_11() *config.PostgresqlHostConfig11 {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_11); ok {
		return x.PostgresqlConfig_11
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_11_1C() *config.PostgresqlHostConfig11_1C {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_11_1C); ok {
		return x.PostgresqlConfig_11_1C
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_12() *config.PostgresqlHostConfig12 {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_12); ok {
		return x.PostgresqlConfig_12
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_12_1C() *config.PostgresqlHostConfig12_1C {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_12_1C); ok {
		return x.PostgresqlConfig_12_1C
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_13() *config.PostgresqlHostConfig13 {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_13); ok {
		return x.PostgresqlConfig_13
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_13_1C() *config.PostgresqlHostConfig13_1C {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_13_1C); ok {
		return x.PostgresqlConfig_13_1C
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_14() *config.PostgresqlHostConfig14 {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_14); ok {
		return x.PostgresqlConfig_14
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_14_1C() *config.PostgresqlHostConfig14_1C {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_14_1C); ok {
		return x.PostgresqlConfig_14_1C
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_15() *config.PostgresqlHostConfig15 {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_15); ok {
		return x.PostgresqlConfig_15
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_15_1C() *config.PostgresqlHostConfig15_1C {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_15_1C); ok {
		return x.PostgresqlConfig_15_1C
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_16() *config.PostgresqlHostConfig16 {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_16); ok {
		return x.PostgresqlConfig_16
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_16_1C() *config.PostgresqlHostConfig16_1C {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_16_1C); ok {
		return x.PostgresqlConfig_16_1C
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_17() *config.PostgresqlHostConfig17 {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_17); ok {
		return x.PostgresqlConfig_17
	}
	return nil
}

func (x *HostConfig) GetPostgresqlConfig_17_1C() *config.PostgresqlHostConfig17_1C {
	if x, ok := x.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_17_1C); ok {
		return x.PostgresqlConfig_17_1C
	}
	return nil
}

type isHostConfig_PostgresqlConfig interface {
	isHostConfig_PostgresqlConfig()
}

type HostConfig_PostgresqlConfig_9_6 struct {
	// Configuration for a host with PostgreSQL 9.6 server deployed.
	PostgresqlConfig_9_6 *config.PostgresqlHostConfig9_6 `protobuf:"bytes,1,opt,name=postgresql_config_9_6,json=postgresqlHostConfig_9_6,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_10_1C struct {
	// Configuration for a host with PostgreSQL 10 1C server deployed.
	PostgresqlConfig_10_1C *config.PostgresqlHostConfig10_1C `protobuf:"bytes,4,opt,name=postgresql_config_10_1c,json=postgresqlHostConfig_10_1c,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_10 struct {
	// Configuration for a host with PostgreSQL 10 server deployed.
	PostgresqlConfig_10 *config.PostgresqlHostConfig10 `protobuf:"bytes,2,opt,name=postgresql_config_10,json=postgresqlHostConfig_10,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_11 struct {
	// Configuration for a host with PostgreSQL 11 server deployed.
	PostgresqlConfig_11 *config.PostgresqlHostConfig11 `protobuf:"bytes,3,opt,name=postgresql_config_11,json=postgresqlHostConfig_11,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_11_1C struct {
	// Configuration for a host with PostgreSQL 11 1C server deployed.
	PostgresqlConfig_11_1C *config.PostgresqlHostConfig11_1C `protobuf:"bytes,6,opt,name=postgresql_config_11_1c,json=postgresqlHostConfig_11_1c,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_12 struct {
	// Configuration for a host with PostgreSQL 12 server deployed.
	PostgresqlConfig_12 *config.PostgresqlHostConfig12 `protobuf:"bytes,5,opt,name=postgresql_config_12,json=postgresqlHostConfig_12,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_12_1C struct {
	// Configuration for a host with PostgreSQL 12 1C server deployed.
	PostgresqlConfig_12_1C *config.PostgresqlHostConfig12_1C `protobuf:"bytes,7,opt,name=postgresql_config_12_1c,json=postgresqlHostConfig_12_1c,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_13 struct {
	// Configuration for a host with PostgreSQL 13 server deployed.
	PostgresqlConfig_13 *config.PostgresqlHostConfig13 `protobuf:"bytes,8,opt,name=postgresql_config_13,json=postgresqlHostConfig_13,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_13_1C struct {
	// Configuration for a host with PostgreSQL 13 1C server deployed.
	PostgresqlConfig_13_1C *config.PostgresqlHostConfig13_1C `protobuf:"bytes,10,opt,name=postgresql_config_13_1c,json=postgresqlHostConfig_13_1c,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_14 struct {
	// Configuration for a host with PostgreSQL 14 server deployed.
	PostgresqlConfig_14 *config.PostgresqlHostConfig14 `protobuf:"bytes,9,opt,name=postgresql_config_14,json=postgresqlHostConfig_14,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_14_1C struct {
	// Configuration for a host with PostgreSQL 14 1C server deployed.
	PostgresqlConfig_14_1C *config.PostgresqlHostConfig14_1C `protobuf:"bytes,11,opt,name=postgresql_config_14_1c,json=postgresqlHostConfig_14_1c,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_15 struct {
	// Configuration for a host with PostgreSQL 15 server deployed.
	PostgresqlConfig_15 *config.PostgresqlHostConfig15 `protobuf:"bytes,12,opt,name=postgresql_config_15,json=postgresqlHostConfig_15,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_15_1C struct {
	// Configuration for a host with PostgreSQL 15 1C server deployed.
	PostgresqlConfig_15_1C *config.PostgresqlHostConfig15_1C `protobuf:"bytes,13,opt,name=postgresql_config_15_1c,json=postgresqlHostConfig_15_1c,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_16 struct {
	// Configuration for a host with PostgreSQL 16 server deployed.
	PostgresqlConfig_16 *config.PostgresqlHostConfig16 `protobuf:"bytes,14,opt,name=postgresql_config_16,json=postgresqlHostConfig_16,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_16_1C struct {
	// Configuration for a host with PostgreSQL 16 1C server deployed.
	PostgresqlConfig_16_1C *config.PostgresqlHostConfig16_1C `protobuf:"bytes,15,opt,name=postgresql_config_16_1c,json=postgresqlHostConfig_16_1c,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_17 struct {
	// Configuration for a host with PostgreSQL 17 server deployed.
	PostgresqlConfig_17 *config.PostgresqlHostConfig17 `protobuf:"bytes,16,opt,name=postgresql_config_17,json=postgresqlHostConfig_17,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_17_1C struct {
	// Configuration for a host with PostgreSQL 17 1C server deployed.
	PostgresqlConfig_17_1C *config.PostgresqlHostConfig17_1C `protobuf:"bytes,17,opt,name=postgresql_config_17_1c,json=postgresqlHostConfig_17_1c,proto3,oneof"`
}

func (*HostConfig_PostgresqlConfig_9_6) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_10_1C) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_10) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_11) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_11_1C) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_12) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_12_1C) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_13) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_13_1C) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_14) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_14_1C) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_15) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_15_1C) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_16) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_16_1C) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_17) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_17_1C) isHostConfig_PostgresqlConfig() {}

type Service struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the service provided by the host. If the field has default value, it is not returned in the response.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.postgresql.v1.Service_Type" json:"type,omitempty"`
	// Aggregated health of the service. If the field has default value, it is not returned in the response.
	Health Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.postgresql.v1.Service_Health" json:"health,omitempty"`
}

func (x *Service) Reset() {
	*x = Service{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *Service) GetType() Service_Type {
	if x != nil {
		return x.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (x *Service) GetHealth() Service_Health {
	if x != nil {
		return x.Health
	}
	return Service_HEALTH_UNKNOWN
}

type Resources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the preset for computational resources available to a host (CPU, memory etc.).
	// All available presets are listed in the [documentation](/docs/managed-postgresql/concepts/instance-types).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	// Possible values:
	// * network-hdd - network HDD drive,
	// * network-ssd - network SSD drive,
	// * local-ssd - local SSD storage.
	DiskTypeId string `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
}

func (x *Resources) Reset() {
	*x = Resources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *Resources) GetResourcePresetId() string {
	if x != nil {
		return x.ResourcePresetId
	}
	return ""
}

func (x *Resources) GetDiskSize() int64 {
	if x != nil {
		return x.DiskSize
	}
	return 0
}

func (x *Resources) GetDiskTypeId() string {
	if x != nil {
		return x.DiskTypeId
	}
	return ""
}

type Access struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Allow access for DataLens
	DataLens bool `protobuf:"varint,1,opt,name=data_lens,json=dataLens,proto3" json:"data_lens,omitempty"`
	// Allow SQL queries to the cluster databases from the management console.
	//
	// See [SQL queries in the management console](/docs/managed-postgresql/operations/web-sql-query) for more details.
	WebSql bool `protobuf:"varint,2,opt,name=web_sql,json=webSql,proto3" json:"web_sql,omitempty"`
	// Allow access for Serverless
	Serverless bool `protobuf:"varint,3,opt,name=serverless,proto3" json:"serverless,omitempty"`
	// Allow access for DataTransfer.
	DataTransfer bool `protobuf:"varint,4,opt,name=data_transfer,json=dataTransfer,proto3" json:"data_transfer,omitempty"`
	// Allow access for YandexQuery.
	YandexQuery bool `protobuf:"varint,5,opt,name=yandex_query,json=yandexQuery,proto3" json:"yandex_query,omitempty"`
}

func (x *Access) Reset() {
	*x = Access{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Access) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Access) ProtoMessage() {}

func (x *Access) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Access.ProtoReflect.Descriptor instead.
func (*Access) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *Access) GetDataLens() bool {
	if x != nil {
		return x.DataLens
	}
	return false
}

func (x *Access) GetWebSql() bool {
	if x != nil {
		return x.WebSql
	}
	return false
}

func (x *Access) GetServerless() bool {
	if x != nil {
		return x.Serverless
	}
	return false
}

func (x *Access) GetDataTransfer() bool {
	if x != nil {
		return x.DataTransfer
	}
	return false
}

func (x *Access) GetYandexQuery() bool {
	if x != nil {
		return x.YandexQuery
	}
	return false
}

type PerformanceDiagnostics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration setting which enables/disables performance diagnostics service in cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Interval (in seconds) for pg_stat_activity sampling
	SessionsSamplingInterval int64 `protobuf:"varint,2,opt,name=sessions_sampling_interval,json=sessionsSamplingInterval,proto3" json:"sessions_sampling_interval,omitempty"`
	// Interval (in seconds) for pg_stat_statements sampling
	StatementsSamplingInterval int64 `protobuf:"varint,3,opt,name=statements_sampling_interval,json=statementsSamplingInterval,proto3" json:"statements_sampling_interval,omitempty"`
}

func (x *PerformanceDiagnostics) Reset() {
	*x = PerformanceDiagnostics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PerformanceDiagnostics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PerformanceDiagnostics) ProtoMessage() {}

func (x *PerformanceDiagnostics) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PerformanceDiagnostics.ProtoReflect.Descriptor instead.
func (*PerformanceDiagnostics) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *PerformanceDiagnostics) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *PerformanceDiagnostics) GetSessionsSamplingInterval() int64 {
	if x != nil {
		return x.SessionsSamplingInterval
	}
	return 0
}

func (x *PerformanceDiagnostics) GetStatementsSamplingInterval() int64 {
	if x != nil {
		return x.StatementsSamplingInterval
	}
	return 0
}

type DiskSizeAutoscaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Threshold of storage usage (in percent) that triggers automatic scaling of the storage during the maintenance window. Zero value means disabled threshold.
	PlannedUsageThreshold int64 `protobuf:"varint,1,opt,name=planned_usage_threshold,json=plannedUsageThreshold,proto3" json:"planned_usage_threshold,omitempty"`
	// Threshold of storage usage (in percent) that triggers immediate automatic scaling of the storage. Zero value means disabled threshold.
	EmergencyUsageThreshold int64 `protobuf:"varint,2,opt,name=emergency_usage_threshold,json=emergencyUsageThreshold,proto3" json:"emergency_usage_threshold,omitempty"`
	// New storage size (in bytes) that is set when one of the thresholds is achieved.
	DiskSizeLimit int64 `protobuf:"varint,3,opt,name=disk_size_limit,json=diskSizeLimit,proto3" json:"disk_size_limit,omitempty"`
}

func (x *DiskSizeAutoscaling) Reset() {
	*x = DiskSizeAutoscaling{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskSizeAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskSizeAutoscaling) ProtoMessage() {}

func (x *DiskSizeAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskSizeAutoscaling.ProtoReflect.Descriptor instead.
func (*DiskSizeAutoscaling) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP(), []int{10}
}

func (x *DiskSizeAutoscaling) GetPlannedUsageThreshold() int64 {
	if x != nil {
		return x.PlannedUsageThreshold
	}
	return 0
}

func (x *DiskSizeAutoscaling) GetEmergencyUsageThreshold() int64 {
	if x != nil {
		return x.EmergencyUsageThreshold
	}
	return 0
}

func (x *DiskSizeAutoscaling) GetDiskSizeLimit() int64 {
	if x != nil {
		return x.DiskSizeLimit
	}
	return 0
}

var File_yandex_cloud_mdb_postgresql_v1_cluster_proto protoreflect.FileDescriptor

var file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x6f, 0x66, 0x64, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2f, 0x68, 0x6f, 0x73, 0x74, 0x31, 0x30, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x35, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x68, 0x6f, 0x73, 0x74, 0x31, 0x30, 0x5f, 0x31,
	0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x68,
	0x6f, 0x73, 0x74, 0x31, 0x31, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2f, 0x68, 0x6f, 0x73, 0x74, 0x31, 0x31, 0x5f, 0x31, 0x63, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x32, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f,
	0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x68, 0x6f, 0x73, 0x74, 0x31, 0x32,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x68, 0x6f,
	0x73, 0x74, 0x31, 0x32, 0x5f, 0x31, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f,
	0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2f, 0x68, 0x6f, 0x73, 0x74, 0x31, 0x33, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x35, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x68, 0x6f, 0x73, 0x74, 0x31, 0x33, 0x5f,
	0x31, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f,
	0x68, 0x6f, 0x73, 0x74, 0x31, 0x34, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2f, 0x68, 0x6f, 0x73, 0x74, 0x31, 0x34, 0x5f, 0x31, 0x63, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x68, 0x6f, 0x73, 0x74, 0x31,
	0x35, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x68,
	0x6f, 0x73, 0x74, 0x31, 0x35, 0x5f, 0x31, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62,
	0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x68, 0x6f, 0x73, 0x74, 0x31, 0x36, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x35, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f,
	0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x68, 0x6f, 0x73, 0x74, 0x31, 0x36,
	0x5f, 0x31, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74,
	0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2f, 0x68, 0x6f, 0x73, 0x74, 0x31, 0x37, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f,
	0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2f, 0x68, 0x6f, 0x73, 0x74, 0x31, 0x37, 0x5f, 0x31, 0x63, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71,
	0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x68, 0x6f, 0x73, 0x74,
	0x39, 0x5f, 0x36, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74,
	0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x31, 0x30, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x31, 0x30, 0x5f, 0x31, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x38, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73,
	0x71, 0x6c, 0x31, 0x31, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73,
	0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x31, 0x31, 0x5f, 0x31,
	0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x70,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x31, 0x32, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x3b, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x31, 0x32, 0x5f, 0x31, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62,
	0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c,
	0x31, 0x33, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f,
	0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x31, 0x33, 0x5f, 0x31, 0x63, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x70, 0x6f, 0x73,
	0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x31, 0x34, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x3b, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64,
	0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71,
	0x6c, 0x31, 0x34, 0x5f, 0x31, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x31, 0x35,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x70, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x31, 0x35, 0x5f, 0x31, 0x63, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x31, 0x36, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f,
	0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x31,
	0x36, 0x5f, 0x31, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73,
	0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x31, 0x37, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71,
	0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x70, 0x6f, 0x73, 0x74,
	0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x31, 0x37, 0x5f, 0x31, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x39, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x39, 0x5f, 0x36, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x61, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x99, 0x0a,
	0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x55, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73,
	0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b,
	0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x0a, 0x6d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x0a, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x45, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d,
	0x0a, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x12, 0x46, 0x0a,
	0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x52, 0x06, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x46, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x60, 0x0a,
	0x12, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73,
	0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x11, 0x6d, 0x61,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12,
	0x61, 0x0a, 0x11, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x10, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x73,
	0x12, 0x2f, 0x0a, 0x13, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x24, 0x0a, 0x0e, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x68, 0x6f, 0x73, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x49, 0x0a, 0x0b, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x50, 0x52, 0x45, 0x53, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x22, 0x3f, 0x0a,
	0x06, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x0e, 0x48, 0x45, 0x41, 0x4c, 0x54,
	0x48, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41,
	0x4c, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x41, 0x44, 0x10, 0x02,
	0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x47, 0x52, 0x41, 0x44, 0x45, 0x44, 0x10, 0x03, 0x22, 0x79,
	0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55,
	0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04,
	0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0b,
	0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x53,
	0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x22, 0x56, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6c, 0x69, 0x6e,
	0x6b, 0x22, 0xe2, 0x15, 0x0a, 0x0d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x74, 0x0a,
	0x15, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x39, 0x5f, 0x36, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x39, 0x5f, 0x36, 0x48, 0x00, 0x52, 0x14, 0x70,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x39, 0x5f, 0x36, 0x12, 0x7a, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71,
	0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x30, 0x5f, 0x31, 0x63, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73,
	0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74,
	0x31, 0x30, 0x5f, 0x31, 0x43, 0x48, 0x00, 0x52, 0x16, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x30, 0x5f, 0x31, 0x63, 0x12,
	0x71, 0x0a, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x30, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x31, 0x30, 0x48, 0x00, 0x52, 0x13, 0x70,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x31, 0x30, 0x12, 0x71, 0x0a, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x31, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x31, 0x31, 0x48, 0x00,
	0x52, 0x13, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x31, 0x31, 0x12, 0x7a, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x31, 0x5f, 0x31, 0x63,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53,
	0x65, 0x74, 0x31, 0x31, 0x5f, 0x31, 0x43, 0x48, 0x00, 0x52, 0x16, 0x70, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x31, 0x5f, 0x31,
	0x63, 0x12, 0x71, 0x0a, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x32, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73,
	0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x31, 0x32, 0x48, 0x00, 0x52,
	0x13, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x31, 0x32, 0x12, 0x7a, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73,
	0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x32, 0x5f, 0x31, 0x63, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65,
	0x74, 0x31, 0x32, 0x5f, 0x31, 0x43, 0x48, 0x00, 0x52, 0x16, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x32, 0x5f, 0x31, 0x63,
	0x12, 0x71, 0x0a, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x33, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71,
	0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x31, 0x33, 0x48, 0x00, 0x52, 0x13,
	0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5f, 0x31, 0x33, 0x12, 0x7a, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71,
	0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x33, 0x5f, 0x31, 0x63, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73,
	0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74,
	0x31, 0x33, 0x5f, 0x31, 0x43, 0x48, 0x00, 0x52, 0x16, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x33, 0x5f, 0x31, 0x63, 0x12,
	0x71, 0x0a, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x34, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x31, 0x34, 0x48, 0x00, 0x52, 0x13, 0x70,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x31, 0x34, 0x12, 0x7a, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x34, 0x5f, 0x31, 0x63, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74,
	0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x31,
	0x34, 0x5f, 0x31, 0x43, 0x48, 0x00, 0x52, 0x16, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73,
	0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x34, 0x5f, 0x31, 0x63, 0x12, 0x71,
	0x0a, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x31, 0x35, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x31, 0x35, 0x48, 0x00, 0x52, 0x13, 0x70, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31,
	0x35, 0x12, 0x7a, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x35, 0x5f, 0x31, 0x63, 0x18, 0x16, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x31, 0x35,
	0x5f, 0x31, 0x43, 0x48, 0x00, 0x52, 0x16, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71,
	0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x35, 0x5f, 0x31, 0x63, 0x12, 0x71, 0x0a,
	0x14, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x31, 0x36, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x31, 0x36, 0x48, 0x00, 0x52, 0x13, 0x70, 0x6f, 0x73,
	0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x36,
	0x12, 0x7a, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x36, 0x5f, 0x31, 0x63, 0x18, 0x19, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x31, 0x36, 0x5f,
	0x31, 0x43, 0x48, 0x00, 0x52, 0x16, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x36, 0x5f, 0x31, 0x63, 0x12, 0x71, 0x0a, 0x14,
	0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x31, 0x37, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x31, 0x37, 0x48, 0x00, 0x52, 0x13, 0x70, 0x6f, 0x73, 0x74,
	0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x37, 0x12,
	0x7a, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x37, 0x5f, 0x31, 0x63, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x31, 0x37, 0x5f, 0x31,
	0x43, 0x48, 0x00, 0x52, 0x16, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x37, 0x5f, 0x31, 0x63, 0x12, 0x5b, 0x0a, 0x0d, 0x70,
	0x6f, 0x6f, 0x6c, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6f, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x70, 0x6f, 0x6f, 0x6c,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x47, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x3e, 0x0a, 0x0c, 0x61, 0x75, 0x74, 0x6f, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65,
	0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0c, 0x61, 0x75, 0x74, 0x6f, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65,
	0x72, 0x12, 0x46, 0x0a, 0x13, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x52, 0x11, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x60, 0x0a, 0x19, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x08, 0xfa, 0xc7, 0x31, 0x04, 0x37,
	0x2d, 0x36, 0x30, 0x52, 0x16, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x74, 0x61, 0x69,
	0x6e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x44, 0x61, 0x79, 0x73, 0x12, 0x3e, 0x0a, 0x06, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x52, 0x06, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x6f, 0x0a, 0x17, 0x70,
	0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x61, 0x67, 0x6e,
	0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65,
	0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73,
	0x74, 0x69, 0x63, 0x73, 0x52, 0x16, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63,
	0x65, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x12, 0x67, 0x0a, 0x15,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73,
	0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x13, 0x0a, 0x11, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4a, 0x04, 0x08, 0x14, 0x10, 0x15,
	0x4a, 0x04, 0x08, 0x1a, 0x10, 0x1b, 0x22, 0x98, 0x02, 0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6f, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x65, 0x0a, 0x0c, 0x70, 0x6f, 0x6f, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6f, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x50, 0x6f, 0x6f, 0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0b, 0x70, 0x6f, 0x6f,
	0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x3d, 0x0a, 0x0c, 0x70, 0x6f, 0x6f, 0x6c,
	0x5f, 0x64, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x70, 0x6f, 0x6f, 0x6c,
	0x44, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x22, 0x58, 0x0a, 0x0b, 0x50, 0x6f, 0x6f, 0x6c, 0x69,
	0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x4f, 0x4f, 0x4c, 0x49, 0x4e,
	0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10,
	0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x54, 0x41, 0x54, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x10,
	0x03, 0x22, 0xf8, 0x06, 0x0a, 0x04, 0x48, 0x6f, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x17, 0x0a,
	0x07, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x7a, 0x6f, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73,
	0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x3d, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x48,
	0x6f, 0x73, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x43,
	0x0a, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x48, 0x6f, 0x73, 0x74, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x52, 0x06, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x12, 0x43, 0x0a, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x08,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x6e,
	0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x49, 0x64, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x37, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x42, 0x0a,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x48,
	0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x28, 0x0a, 0x10, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x5f, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x69, 0x70, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x61, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70, 0x12, 0x53, 0x0a, 0x0c, 0x72,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x54, 0x79, 0x70, 0x65,
	0x22, 0x31, 0x0a, 0x04, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x4f, 0x4c, 0x45,
	0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x41,
	0x53, 0x54, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43,
	0x41, 0x10, 0x02, 0x22, 0x48, 0x0a, 0x0b, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05,
	0x41, 0x53, 0x59, 0x4e, 0x43, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x59, 0x4e, 0x43, 0x10,
	0x02, 0x12, 0x0a, 0x0a, 0x06, 0x51, 0x55, 0x4f, 0x52, 0x55, 0x4d, 0x10, 0x03, 0x22, 0x4d, 0x0a,
	0x06, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x0e, 0x48, 0x45, 0x41, 0x4c, 0x54,
	0x48, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41,
	0x4c, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x41, 0x44, 0x10, 0x02,
	0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x47, 0x52, 0x41, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0c,
	0x0a, 0x08, 0x52, 0x45, 0x41, 0x44, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x04, 0x22, 0xe4, 0x10, 0x0a,
	0x0a, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x79, 0x0a, 0x15, 0x70,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5f, 0x39, 0x5f, 0x36, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x39, 0x5f, 0x36, 0x48, 0x00, 0x52, 0x18, 0x70, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x39, 0x5f, 0x36, 0x12, 0x7f, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x30, 0x5f, 0x31,
	0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x31, 0x30, 0x5f, 0x31, 0x43, 0x48, 0x00, 0x52, 0x1a, 0x70, 0x6f, 0x73,
	0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x31, 0x30, 0x5f, 0x31, 0x63, 0x12, 0x76, 0x0a, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x30, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x31, 0x30, 0x48, 0x00, 0x52, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73,
	0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x30, 0x12,
	0x76, 0x0a, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x31, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c,
	0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x31, 0x31, 0x48, 0x00, 0x52, 0x17,
	0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x31, 0x12, 0x7f, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x31, 0x5f,
	0x31, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74,
	0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x31, 0x31, 0x5f, 0x31, 0x43, 0x48, 0x00, 0x52, 0x1a, 0x70, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x31, 0x31, 0x5f, 0x31, 0x63, 0x12, 0x76, 0x0a, 0x14, 0x70, 0x6f, 0x73, 0x74,
	0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x32,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x31, 0x32, 0x48, 0x00, 0x52, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x32,
	0x12, 0x7f, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x32, 0x5f, 0x31, 0x63, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x40, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x31, 0x32,
	0x5f, 0x31, 0x43, 0x48, 0x00, 0x52, 0x1a, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71,
	0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x32, 0x5f, 0x31,
	0x63, 0x12, 0x76, 0x0a, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x33, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73,
	0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x31, 0x33, 0x48, 0x00,
	0x52, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x33, 0x12, 0x7f, 0x0a, 0x17, 0x70, 0x6f, 0x73,
	0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31,
	0x33, 0x5f, 0x31, 0x63, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x31, 0x33, 0x5f, 0x31, 0x43, 0x48, 0x00, 0x52, 0x1a,
	0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x33, 0x5f, 0x31, 0x63, 0x12, 0x76, 0x0a, 0x14, 0x70, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x31, 0x34, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74,
	0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x31, 0x34, 0x48, 0x00, 0x52, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x31, 0x34, 0x12, 0x7f, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x34, 0x5f, 0x31, 0x63, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74,
	0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x31, 0x34, 0x5f, 0x31, 0x43, 0x48, 0x00, 0x52, 0x1a, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x34,
	0x5f, 0x31, 0x63, 0x12, 0x76, 0x0a, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71,
	0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x35, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x31, 0x35,
	0x48, 0x00, 0x52, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x35, 0x12, 0x7f, 0x0a, 0x17, 0x70,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5f, 0x31, 0x35, 0x5f, 0x31, 0x63, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48,
	0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x31, 0x35, 0x5f, 0x31, 0x43, 0x48, 0x00,
	0x52, 0x1a, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x35, 0x5f, 0x31, 0x63, 0x12, 0x76, 0x0a, 0x14,
	0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x31, 0x36, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x31, 0x36, 0x48, 0x00, 0x52, 0x17, 0x70, 0x6f, 0x73,
	0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x31, 0x36, 0x12, 0x7f, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73,
	0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x36, 0x5f, 0x31, 0x63, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x31, 0x36, 0x5f, 0x31, 0x43, 0x48, 0x00, 0x52, 0x1a, 0x70, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x31, 0x36, 0x5f, 0x31, 0x63, 0x12, 0x76, 0x0a, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x37, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74,
	0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x31, 0x37, 0x48, 0x00, 0x52, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c,
	0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x37, 0x12, 0x7f, 0x0a,
	0x17, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x31, 0x37, 0x5f, 0x31, 0x63, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71,
	0x6c, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x31, 0x37, 0x5f, 0x31, 0x43,
	0x48, 0x00, 0x52, 0x1a, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x48, 0x6f,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x31, 0x37, 0x5f, 0x31, 0x63, 0x42, 0x13,
	0x0a, 0x11, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x22, 0x8e, 0x02, 0x0a, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x40, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x46, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x52, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x22, 0x38, 0x0a, 0x04, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x4f, 0x53, 0x54, 0x47,
	0x52, 0x45, 0x53, 0x51, 0x4c, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x4f, 0x4f, 0x4c, 0x45,
	0x52, 0x10, 0x02, 0x22, 0x3f, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x12, 0x0a,
	0x0e, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04,
	0x44, 0x45, 0x41, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x41, 0x44, 0x4f, 0x4e,
	0x4c, 0x59, 0x10, 0x03, 0x22, 0x78, 0x0a, 0x09, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x72,
	0x65, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x65, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12,
	0x1b, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x20, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x22, 0xa6,
	0x01, 0x0a, 0x06, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x6c, 0x65, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x61,
	0x74, 0x61, 0x4c, 0x65, 0x6e, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x77, 0x65, 0x62, 0x5f, 0x73, 0x71,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x77, 0x65, 0x62, 0x53, 0x71, 0x6c, 0x12,
	0x1e, 0x0a, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x6c, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x6c, 0x65, 0x73, 0x73, 0x12,
	0x23, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x51, 0x75, 0x65, 0x72, 0x79, 0x22, 0xcc, 0x01, 0x0a, 0x16, 0x50, 0x65, 0x72, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69,
	0x63, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x49, 0x0a, 0x1a,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e,
	0x67, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x0b, 0xfa, 0xc7, 0x31, 0x07, 0x31, 0x2d, 0x38, 0x36, 0x34, 0x30, 0x30, 0x52, 0x18, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x4d, 0x0a, 0x1c, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x0b, 0xfa,
	0xc7, 0x31, 0x07, 0x31, 0x2d, 0x38, 0x36, 0x34, 0x30, 0x30, 0x52, 0x1a, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x22, 0xcf, 0x01, 0x0a, 0x13, 0x44, 0x69, 0x73, 0x6b, 0x53,
	0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x45,
	0x0a, 0x17, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x0d, 0xe8, 0xc7, 0x31, 0x00, 0xfa, 0xc7, 0x31, 0x05, 0x30, 0x2d, 0x31, 0x30, 0x30, 0x52, 0x15,
	0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x55, 0x73, 0x61, 0x67, 0x65, 0x54, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x49, 0x0a, 0x19, 0x65, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f,
	0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x0d, 0xe8, 0xc7, 0x31, 0x00, 0xfa, 0xc7,
	0x31, 0x05, 0x30, 0x2d, 0x31, 0x30, 0x30, 0x52, 0x17, 0x65, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x6e,
	0x63, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x12, 0x26, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x6b, 0x53,
	0x69, 0x7a, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x73, 0x0a, 0x22, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x5a, 0x4d,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6f, 0x2d, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x2f,
	0x76, 0x31, 0x3b, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescOnce sync.Once
	file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescData = file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDesc
)

func file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescGZIP() []byte {
	file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescData)
	})
	return file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDescData
}

var file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 9)
var file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_yandex_cloud_mdb_postgresql_v1_cluster_proto_goTypes = []any{
	(Cluster_Environment)(0),                 // 0: yandex.cloud.mdb.postgresql.v1.Cluster.Environment
	(Cluster_Health)(0),                      // 1: yandex.cloud.mdb.postgresql.v1.Cluster.Health
	(Cluster_Status)(0),                      // 2: yandex.cloud.mdb.postgresql.v1.Cluster.Status
	(ConnectionPoolerConfig_PoolingMode)(0),  // 3: yandex.cloud.mdb.postgresql.v1.ConnectionPoolerConfig.PoolingMode
	(Host_Role)(0),                           // 4: yandex.cloud.mdb.postgresql.v1.Host.Role
	(Host_ReplicaType)(0),                    // 5: yandex.cloud.mdb.postgresql.v1.Host.ReplicaType
	(Host_Health)(0),                         // 6: yandex.cloud.mdb.postgresql.v1.Host.Health
	(Service_Type)(0),                        // 7: yandex.cloud.mdb.postgresql.v1.Service.Type
	(Service_Health)(0),                      // 8: yandex.cloud.mdb.postgresql.v1.Service.Health
	(*Cluster)(nil),                          // 9: yandex.cloud.mdb.postgresql.v1.Cluster
	(*Monitoring)(nil),                       // 10: yandex.cloud.mdb.postgresql.v1.Monitoring
	(*ClusterConfig)(nil),                    // 11: yandex.cloud.mdb.postgresql.v1.ClusterConfig
	(*ConnectionPoolerConfig)(nil),           // 12: yandex.cloud.mdb.postgresql.v1.ConnectionPoolerConfig
	(*Host)(nil),                             // 13: yandex.cloud.mdb.postgresql.v1.Host
	(*HostConfig)(nil),                       // 14: yandex.cloud.mdb.postgresql.v1.HostConfig
	(*Service)(nil),                          // 15: yandex.cloud.mdb.postgresql.v1.Service
	(*Resources)(nil),                        // 16: yandex.cloud.mdb.postgresql.v1.Resources
	(*Access)(nil),                           // 17: yandex.cloud.mdb.postgresql.v1.Access
	(*PerformanceDiagnostics)(nil),           // 18: yandex.cloud.mdb.postgresql.v1.PerformanceDiagnostics
	(*DiskSizeAutoscaling)(nil),              // 19: yandex.cloud.mdb.postgresql.v1.DiskSizeAutoscaling
	nil,                                      // 20: yandex.cloud.mdb.postgresql.v1.Cluster.LabelsEntry
	(*timestamppb.Timestamp)(nil),            // 21: google.protobuf.Timestamp
	(*MaintenanceWindow)(nil),                // 22: yandex.cloud.mdb.postgresql.v1.MaintenanceWindow
	(*MaintenanceOperation)(nil),             // 23: yandex.cloud.mdb.postgresql.v1.MaintenanceOperation
	(*config.PostgresqlConfigSet9_6)(nil),    // 24: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet9_6
	(*config.PostgresqlConfigSet10_1C)(nil),  // 25: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet10_1C
	(*config.PostgresqlConfigSet10)(nil),     // 26: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet10
	(*config.PostgresqlConfigSet11)(nil),     // 27: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet11
	(*config.PostgresqlConfigSet11_1C)(nil),  // 28: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet11_1C
	(*config.PostgresqlConfigSet12)(nil),     // 29: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet12
	(*config.PostgresqlConfigSet12_1C)(nil),  // 30: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet12_1C
	(*config.PostgresqlConfigSet13)(nil),     // 31: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet13
	(*config.PostgresqlConfigSet13_1C)(nil),  // 32: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet13_1C
	(*config.PostgresqlConfigSet14)(nil),     // 33: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet14
	(*config.PostgresqlConfigSet14_1C)(nil),  // 34: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet14_1C
	(*config.PostgresqlConfigSet15)(nil),     // 35: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet15
	(*config.PostgresqlConfigSet15_1C)(nil),  // 36: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet15_1C
	(*config.PostgresqlConfigSet16)(nil),     // 37: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet16
	(*config.PostgresqlConfigSet16_1C)(nil),  // 38: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet16_1C
	(*config.PostgresqlConfigSet17)(nil),     // 39: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet17
	(*config.PostgresqlConfigSet17_1C)(nil),  // 40: yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet17_1C
	(*wrapperspb.BoolValue)(nil),             // 41: google.protobuf.BoolValue
	(*timeofday.TimeOfDay)(nil),              // 42: google.type.TimeOfDay
	(*wrapperspb.Int64Value)(nil),            // 43: google.protobuf.Int64Value
	(*config.PostgresqlHostConfig9_6)(nil),   // 44: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig9_6
	(*config.PostgresqlHostConfig10_1C)(nil), // 45: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig10_1C
	(*config.PostgresqlHostConfig10)(nil),    // 46: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig10
	(*config.PostgresqlHostConfig11)(nil),    // 47: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig11
	(*config.PostgresqlHostConfig11_1C)(nil), // 48: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig11_1C
	(*config.PostgresqlHostConfig12)(nil),    // 49: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig12
	(*config.PostgresqlHostConfig12_1C)(nil), // 50: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig12_1C
	(*config.PostgresqlHostConfig13)(nil),    // 51: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig13
	(*config.PostgresqlHostConfig13_1C)(nil), // 52: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig13_1C
	(*config.PostgresqlHostConfig14)(nil),    // 53: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig14
	(*config.PostgresqlHostConfig14_1C)(nil), // 54: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig14_1C
	(*config.PostgresqlHostConfig15)(nil),    // 55: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig15
	(*config.PostgresqlHostConfig15_1C)(nil), // 56: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig15_1C
	(*config.PostgresqlHostConfig16)(nil),    // 57: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig16
	(*config.PostgresqlHostConfig16_1C)(nil), // 58: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig16_1C
	(*config.PostgresqlHostConfig17)(nil),    // 59: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig17
	(*config.PostgresqlHostConfig17_1C)(nil), // 60: yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig17_1C
}
var file_yandex_cloud_mdb_postgresql_v1_cluster_proto_depIdxs = []int32{
	21, // 0: yandex.cloud.mdb.postgresql.v1.Cluster.created_at:type_name -> google.protobuf.Timestamp
	20, // 1: yandex.cloud.mdb.postgresql.v1.Cluster.labels:type_name -> yandex.cloud.mdb.postgresql.v1.Cluster.LabelsEntry
	0,  // 2: yandex.cloud.mdb.postgresql.v1.Cluster.environment:type_name -> yandex.cloud.mdb.postgresql.v1.Cluster.Environment
	10, // 3: yandex.cloud.mdb.postgresql.v1.Cluster.monitoring:type_name -> yandex.cloud.mdb.postgresql.v1.Monitoring
	11, // 4: yandex.cloud.mdb.postgresql.v1.Cluster.config:type_name -> yandex.cloud.mdb.postgresql.v1.ClusterConfig
	1,  // 5: yandex.cloud.mdb.postgresql.v1.Cluster.health:type_name -> yandex.cloud.mdb.postgresql.v1.Cluster.Health
	2,  // 6: yandex.cloud.mdb.postgresql.v1.Cluster.status:type_name -> yandex.cloud.mdb.postgresql.v1.Cluster.Status
	22, // 7: yandex.cloud.mdb.postgresql.v1.Cluster.maintenance_window:type_name -> yandex.cloud.mdb.postgresql.v1.MaintenanceWindow
	23, // 8: yandex.cloud.mdb.postgresql.v1.Cluster.planned_operation:type_name -> yandex.cloud.mdb.postgresql.v1.MaintenanceOperation
	24, // 9: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_9_6:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet9_6
	25, // 10: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_10_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet10_1C
	26, // 11: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_10:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet10
	27, // 12: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_11:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet11
	28, // 13: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_11_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet11_1C
	29, // 14: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_12:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet12
	30, // 15: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_12_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet12_1C
	31, // 16: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_13:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet13
	32, // 17: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_13_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet13_1C
	33, // 18: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_14:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet14
	34, // 19: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_14_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet14_1C
	35, // 20: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_15:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet15
	36, // 21: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_15_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet15_1C
	37, // 22: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_16:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet16
	38, // 23: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_16_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet16_1C
	39, // 24: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_17:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet17
	40, // 25: yandex.cloud.mdb.postgresql.v1.ClusterConfig.postgresql_config_17_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlConfigSet17_1C
	12, // 26: yandex.cloud.mdb.postgresql.v1.ClusterConfig.pooler_config:type_name -> yandex.cloud.mdb.postgresql.v1.ConnectionPoolerConfig
	16, // 27: yandex.cloud.mdb.postgresql.v1.ClusterConfig.resources:type_name -> yandex.cloud.mdb.postgresql.v1.Resources
	41, // 28: yandex.cloud.mdb.postgresql.v1.ClusterConfig.autofailover:type_name -> google.protobuf.BoolValue
	42, // 29: yandex.cloud.mdb.postgresql.v1.ClusterConfig.backup_window_start:type_name -> google.type.TimeOfDay
	43, // 30: yandex.cloud.mdb.postgresql.v1.ClusterConfig.backup_retain_period_days:type_name -> google.protobuf.Int64Value
	17, // 31: yandex.cloud.mdb.postgresql.v1.ClusterConfig.access:type_name -> yandex.cloud.mdb.postgresql.v1.Access
	18, // 32: yandex.cloud.mdb.postgresql.v1.ClusterConfig.performance_diagnostics:type_name -> yandex.cloud.mdb.postgresql.v1.PerformanceDiagnostics
	19, // 33: yandex.cloud.mdb.postgresql.v1.ClusterConfig.disk_size_autoscaling:type_name -> yandex.cloud.mdb.postgresql.v1.DiskSizeAutoscaling
	3,  // 34: yandex.cloud.mdb.postgresql.v1.ConnectionPoolerConfig.pooling_mode:type_name -> yandex.cloud.mdb.postgresql.v1.ConnectionPoolerConfig.PoolingMode
	41, // 35: yandex.cloud.mdb.postgresql.v1.ConnectionPoolerConfig.pool_discard:type_name -> google.protobuf.BoolValue
	16, // 36: yandex.cloud.mdb.postgresql.v1.Host.resources:type_name -> yandex.cloud.mdb.postgresql.v1.Resources
	4,  // 37: yandex.cloud.mdb.postgresql.v1.Host.role:type_name -> yandex.cloud.mdb.postgresql.v1.Host.Role
	6,  // 38: yandex.cloud.mdb.postgresql.v1.Host.health:type_name -> yandex.cloud.mdb.postgresql.v1.Host.Health
	15, // 39: yandex.cloud.mdb.postgresql.v1.Host.services:type_name -> yandex.cloud.mdb.postgresql.v1.Service
	43, // 40: yandex.cloud.mdb.postgresql.v1.Host.priority:type_name -> google.protobuf.Int64Value
	14, // 41: yandex.cloud.mdb.postgresql.v1.Host.config:type_name -> yandex.cloud.mdb.postgresql.v1.HostConfig
	5,  // 42: yandex.cloud.mdb.postgresql.v1.Host.replica_type:type_name -> yandex.cloud.mdb.postgresql.v1.Host.ReplicaType
	44, // 43: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_9_6:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig9_6
	45, // 44: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_10_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig10_1C
	46, // 45: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_10:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig10
	47, // 46: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_11:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig11
	48, // 47: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_11_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig11_1C
	49, // 48: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_12:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig12
	50, // 49: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_12_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig12_1C
	51, // 50: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_13:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig13
	52, // 51: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_13_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig13_1C
	53, // 52: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_14:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig14
	54, // 53: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_14_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig14_1C
	55, // 54: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_15:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig15
	56, // 55: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_15_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig15_1C
	57, // 56: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_16:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig16
	58, // 57: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_16_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig16_1C
	59, // 58: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_17:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig17
	60, // 59: yandex.cloud.mdb.postgresql.v1.HostConfig.postgresql_config_17_1c:type_name -> yandex.cloud.mdb.postgresql.v1.config.PostgresqlHostConfig17_1C
	7,  // 60: yandex.cloud.mdb.postgresql.v1.Service.type:type_name -> yandex.cloud.mdb.postgresql.v1.Service.Type
	8,  // 61: yandex.cloud.mdb.postgresql.v1.Service.health:type_name -> yandex.cloud.mdb.postgresql.v1.Service.Health
	62, // [62:62] is the sub-list for method output_type
	62, // [62:62] is the sub-list for method input_type
	62, // [62:62] is the sub-list for extension type_name
	62, // [62:62] is the sub-list for extension extendee
	0,  // [0:62] is the sub-list for field type_name
}

func init() { file_yandex_cloud_mdb_postgresql_v1_cluster_proto_init() }
func file_yandex_cloud_mdb_postgresql_v1_cluster_proto_init() {
	if File_yandex_cloud_mdb_postgresql_v1_cluster_proto != nil {
		return
	}
	file_yandex_cloud_mdb_postgresql_v1_maintenance_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*Monitoring); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ClusterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ConnectionPoolerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*Host); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*HostConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*Service); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*Resources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*Access); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*PerformanceDiagnostics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*DiskSizeAutoscaling); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[2].OneofWrappers = []any{
		(*ClusterConfig_PostgresqlConfig_9_6)(nil),
		(*ClusterConfig_PostgresqlConfig_10_1C)(nil),
		(*ClusterConfig_PostgresqlConfig_10)(nil),
		(*ClusterConfig_PostgresqlConfig_11)(nil),
		(*ClusterConfig_PostgresqlConfig_11_1C)(nil),
		(*ClusterConfig_PostgresqlConfig_12)(nil),
		(*ClusterConfig_PostgresqlConfig_12_1C)(nil),
		(*ClusterConfig_PostgresqlConfig_13)(nil),
		(*ClusterConfig_PostgresqlConfig_13_1C)(nil),
		(*ClusterConfig_PostgresqlConfig_14)(nil),
		(*ClusterConfig_PostgresqlConfig_14_1C)(nil),
		(*ClusterConfig_PostgresqlConfig_15)(nil),
		(*ClusterConfig_PostgresqlConfig_15_1C)(nil),
		(*ClusterConfig_PostgresqlConfig_16)(nil),
		(*ClusterConfig_PostgresqlConfig_16_1C)(nil),
		(*ClusterConfig_PostgresqlConfig_17)(nil),
		(*ClusterConfig_PostgresqlConfig_17_1C)(nil),
	}
	file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes[5].OneofWrappers = []any{
		(*HostConfig_PostgresqlConfig_9_6)(nil),
		(*HostConfig_PostgresqlConfig_10_1C)(nil),
		(*HostConfig_PostgresqlConfig_10)(nil),
		(*HostConfig_PostgresqlConfig_11)(nil),
		(*HostConfig_PostgresqlConfig_11_1C)(nil),
		(*HostConfig_PostgresqlConfig_12)(nil),
		(*HostConfig_PostgresqlConfig_12_1C)(nil),
		(*HostConfig_PostgresqlConfig_13)(nil),
		(*HostConfig_PostgresqlConfig_13_1C)(nil),
		(*HostConfig_PostgresqlConfig_14)(nil),
		(*HostConfig_PostgresqlConfig_14_1C)(nil),
		(*HostConfig_PostgresqlConfig_15)(nil),
		(*HostConfig_PostgresqlConfig_15_1C)(nil),
		(*HostConfig_PostgresqlConfig_16)(nil),
		(*HostConfig_PostgresqlConfig_16_1C)(nil),
		(*HostConfig_PostgresqlConfig_17)(nil),
		(*HostConfig_PostgresqlConfig_17_1C)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDesc,
			NumEnums:      9,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_mdb_postgresql_v1_cluster_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_mdb_postgresql_v1_cluster_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_mdb_postgresql_v1_cluster_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_mdb_postgresql_v1_cluster_proto_msgTypes,
	}.Build()
	File_yandex_cloud_mdb_postgresql_v1_cluster_proto = out.File
	file_yandex_cloud_mdb_postgresql_v1_cluster_proto_rawDesc = nil
	file_yandex_cloud_mdb_postgresql_v1_cluster_proto_goTypes = nil
	file_yandex_cloud_mdb_postgresql_v1_cluster_proto_depIdxs = nil
}
