// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v3.21.12
// source: yandex/cloud/mdb/kafka/v1/cluster.proto

package kafka

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/descriptorpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy when only hotfixes are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with a more aggressive update policy when new versions are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

// Enum value maps for Cluster_Environment.
var (
	Cluster_Environment_name = map[int32]string{
		0: "ENVIRONMENT_UNSPECIFIED",
		1: "PRODUCTION",
		2: "PRESTABLE",
	}
	Cluster_Environment_value = map[string]int32{
		"ENVIRONMENT_UNSPECIFIED": 0,
		"PRODUCTION":              1,
		"PRESTABLE":               2,
	}
)

func (x Cluster_Environment) Enum() *Cluster_Environment {
	p := new(Cluster_Environment)
	*p = x
	return p
}

func (x Cluster_Environment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Environment) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[0].Descriptor()
}

func (Cluster_Environment) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[0]
}

func (x Cluster_Environment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Environment.Descriptor instead.
func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{0, 0}
}

type Cluster_Health int32

const (
	// State of the cluster is unknown ([Host.health] of all hosts in the cluster is `UNKNOWN`).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well ([Host.health] of all hosts in the cluster is `ALIVE`).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] of all hosts in the cluster is `DEAD`).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is in degraded state ([Host.health] of at least one of the hosts in the cluster is not `ALIVE`).
	Cluster_DEGRADED Cluster_Health = 3
)

// Enum value maps for Cluster_Health.
var (
	Cluster_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Cluster_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Cluster_Health) Enum() *Cluster_Health {
	p := new(Cluster_Health)
	*p = x
	return p
}

func (x Cluster_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[1].Descriptor()
}

func (Cluster_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[1]
}

func (x Cluster_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Health.Descriptor instead.
func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "CREATING",
		2: "RUNNING",
		3: "ERROR",
		4: "UPDATING",
		5: "STOPPING",
		6: "STOPPED",
		7: "STARTING",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNKNOWN": 0,
		"CREATING":       1,
		"RUNNING":        2,
		"ERROR":          3,
		"UPDATING":       4,
		"STOPPING":       5,
		"STOPPED":        6,
		"STARTING":       7,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[2].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[2]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{0, 2}
}

type Host_Role int32

const (
	// Role of the host is unspecified. Default value.
	Host_ROLE_UNSPECIFIED Host_Role = 0
	// The host is a Kafka broker.
	Host_KAFKA Host_Role = 1
	// The host is a ZooKeeper server.
	Host_ZOOKEEPER Host_Role = 2
)

// Enum value maps for Host_Role.
var (
	Host_Role_name = map[int32]string{
		0: "ROLE_UNSPECIFIED",
		1: "KAFKA",
		2: "ZOOKEEPER",
	}
	Host_Role_value = map[string]int32{
		"ROLE_UNSPECIFIED": 0,
		"KAFKA":            1,
		"ZOOKEEPER":        2,
	}
)

func (x Host_Role) Enum() *Host_Role {
	p := new(Host_Role)
	*p = x
	return p
}

func (x Host_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[3].Descriptor()
}

func (Host_Role) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[3]
}

func (x Host_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Role.Descriptor instead.
func (Host_Role) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{6, 0}
}

type Host_Health int32

const (
	// Health of the host is unknown. Default value.
	Host_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

// Enum value maps for Host_Health.
var (
	Host_Health_name = map[int32]string{
		0: "UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Host_Health_value = map[string]int32{
		"UNKNOWN":  0,
		"ALIVE":    1,
		"DEAD":     2,
		"DEGRADED": 3,
	}
)

func (x Host_Health) Enum() *Host_Health {
	p := new(Host_Health)
	*p = x
	return p
}

func (x Host_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[4].Descriptor()
}

func (Host_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[4]
}

func (x Host_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Health.Descriptor instead.
func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{6, 1}
}

// An Apache Kafka® cluster resource.
// For more information, see the [Concepts](/docs/managed-kafka/concepts) section of the documentation.
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the Apache Kafka® cluster.
	// This ID is assigned at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the Apache Kafka® cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the Apache Kafka® cluster.
	// The name must be unique within the folder. 1-63 characters long. Value must match the regular expression `[a-zA-Z0-9_-]*`.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the Apache Kafka® cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the Apache Kafka® cluster as `key:value` pairs.
	// A maximum of 64 labels per resource is allowed.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the Apache Kafka® cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.kafka.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the Apache Kafka® cluster.
	// * The field is ignored for response of List method.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the Apache Kafka® cluster.
	// * The field is ignored for response of List method.
	Config *ConfigSpec `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.kafka.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.kafka.v1.Cluster_Status" json:"status,omitempty"`
	// User security groups
	SecurityGroupIds []string `protobuf:"bytes,13,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	// Host groups hosting VMs of the cluster.
	HostGroupIds []string `protobuf:"bytes,14,rep,name=host_group_ids,json=hostGroupIds,proto3" json:"host_group_ids,omitempty"`
	// Deletion Protection inhibits deletion of the cluster
	DeletionProtection bool `protobuf:"varint,15,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
	// Window of maintenance operations.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,16,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Scheduled maintenance operation.
	PlannedOperation *MaintenanceOperation `protobuf:"bytes,17,opt,name=planned_operation,json=plannedOperation,proto3" json:"planned_operation,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cluster) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Cluster) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetEnvironment() Cluster_Environment {
	if x != nil {
		return x.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (x *Cluster) GetMonitoring() []*Monitoring {
	if x != nil {
		return x.Monitoring
	}
	return nil
}

func (x *Cluster) GetConfig() *ConfigSpec {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Cluster) GetNetworkId() string {
	if x != nil {
		return x.NetworkId
	}
	return ""
}

func (x *Cluster) GetHealth() Cluster_Health {
	if x != nil {
		return x.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (x *Cluster) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

func (x *Cluster) GetHostGroupIds() []string {
	if x != nil {
		return x.HostGroupIds
	}
	return nil
}

func (x *Cluster) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

func (x *Cluster) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Cluster) GetPlannedOperation() *MaintenanceOperation {
	if x != nil {
		return x.PlannedOperation
	}
	return nil
}

// Metadata of monitoring system.
type Monitoring struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the Apache Kafka® cluster.
	Link string `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
}

func (x *Monitoring) Reset() {
	*x = Monitoring{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Monitoring) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Monitoring) ProtoMessage() {}

func (x *Monitoring) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Monitoring.ProtoReflect.Descriptor instead.
func (*Monitoring) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *Monitoring) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Monitoring) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Monitoring) GetLink() string {
	if x != nil {
		return x.Link
	}
	return ""
}

type ConfigSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version of Apache Kafka® used in the cluster. Possible values: `2.8`, `3.0`, `3.1`, `3.2`, `3.3`, `3.4`, `3.5`, `3.6`.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration and resource allocation for Kafka brokers.
	Kafka *ConfigSpec_Kafka `protobuf:"bytes,2,opt,name=kafka,proto3" json:"kafka,omitempty"`
	// Configuration and resource allocation for ZooKeeper hosts.
	Zookeeper *ConfigSpec_Zookeeper `protobuf:"bytes,3,opt,name=zookeeper,proto3" json:"zookeeper,omitempty"`
	// IDs of availability zones where Kafka brokers reside.
	ZoneId []string `protobuf:"bytes,4,rep,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// The number of Kafka brokers deployed in each availability zone.
	BrokersCount *wrapperspb.Int64Value `protobuf:"bytes,5,opt,name=brokers_count,json=brokersCount,proto3" json:"brokers_count,omitempty"`
	// The flag that defines whether a public IP address is assigned to the cluster.
	// If the value is `true`, then Apache Kafka® cluster is available on the Internet via it's public IP address.
	AssignPublicIp bool `protobuf:"varint,6,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// Allows to manage topics via AdminAPI
	// Deprecated. Feature enabled permanently.
	//
	// Deprecated: Marked as deprecated in yandex/cloud/mdb/kafka/v1/cluster.proto.
	UnmanagedTopics bool `protobuf:"varint,7,opt,name=unmanaged_topics,json=unmanagedTopics,proto3" json:"unmanaged_topics,omitempty"`
	// Enables managed schema registry on cluster
	SchemaRegistry bool `protobuf:"varint,8,opt,name=schema_registry,json=schemaRegistry,proto3" json:"schema_registry,omitempty"`
	// Access policy for external services.
	Access *Access `protobuf:"bytes,9,opt,name=access,proto3" json:"access,omitempty"`
	// Configuration of REST API.
	RestApiConfig *ConfigSpec_RestAPIConfig `protobuf:"bytes,10,opt,name=rest_api_config,json=restApiConfig,proto3" json:"rest_api_config,omitempty"`
	// DiskSizeAutoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,11,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	// Configuration and resource allocation for KRaft-controller hosts.
	Kraft *ConfigSpec_KRaft `protobuf:"bytes,12,opt,name=kraft,proto3" json:"kraft,omitempty"`
}

func (x *ConfigSpec) Reset() {
	*x = ConfigSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSpec) ProtoMessage() {}

func (x *ConfigSpec) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSpec.ProtoReflect.Descriptor instead.
func (*ConfigSpec) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *ConfigSpec) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ConfigSpec) GetKafka() *ConfigSpec_Kafka {
	if x != nil {
		return x.Kafka
	}
	return nil
}

func (x *ConfigSpec) GetZookeeper() *ConfigSpec_Zookeeper {
	if x != nil {
		return x.Zookeeper
	}
	return nil
}

func (x *ConfigSpec) GetZoneId() []string {
	if x != nil {
		return x.ZoneId
	}
	return nil
}

func (x *ConfigSpec) GetBrokersCount() *wrapperspb.Int64Value {
	if x != nil {
		return x.BrokersCount
	}
	return nil
}

func (x *ConfigSpec) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

// Deprecated: Marked as deprecated in yandex/cloud/mdb/kafka/v1/cluster.proto.
func (x *ConfigSpec) GetUnmanagedTopics() bool {
	if x != nil {
		return x.UnmanagedTopics
	}
	return false
}

func (x *ConfigSpec) GetSchemaRegistry() bool {
	if x != nil {
		return x.SchemaRegistry
	}
	return false
}

func (x *ConfigSpec) GetAccess() *Access {
	if x != nil {
		return x.Access
	}
	return nil
}

func (x *ConfigSpec) GetRestApiConfig() *ConfigSpec_RestAPIConfig {
	if x != nil {
		return x.RestApiConfig
	}
	return nil
}

func (x *ConfigSpec) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

func (x *ConfigSpec) GetKraft() *ConfigSpec_KRaft {
	if x != nil {
		return x.Kraft
	}
	return nil
}

type Resources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the preset for computational resources available to a host (CPU, memory, etc.).
	// All available presets are listed in the [documentation](/docs/managed-kafka/concepts/instance-types).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes. Must be greater than 2 * partition segment size in bytes * partitions count, so each partition can have one active segment file and one closed segment file that can be deleted.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	DiskTypeId string `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
}

func (x *Resources) Reset() {
	*x = Resources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *Resources) GetResourcePresetId() string {
	if x != nil {
		return x.ResourcePresetId
	}
	return ""
}

func (x *Resources) GetDiskSize() int64 {
	if x != nil {
		return x.DiskSize
	}
	return 0
}

func (x *Resources) GetDiskTypeId() string {
	if x != nil {
		return x.DiskTypeId
	}
	return ""
}

// Kafka version 2.8 broker configuration.
type KafkaConfig2_8 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cluster topics compression type.
	CompressionType CompressionType `protobuf:"varint,1,opt,name=compression_type,json=compressionType,proto3,enum=yandex.cloud.mdb.kafka.v1.CompressionType" json:"compression_type,omitempty"`
	// The number of messages accumulated on a log partition before messages are flushed to disk.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.flush_messages] setting.
	LogFlushIntervalMessages *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=log_flush_interval_messages,json=logFlushIntervalMessages,proto3" json:"log_flush_interval_messages,omitempty"`
	// The maximum time (in milliseconds) that a message in any topic is kept in memory before flushed to disk.
	// If not set, the value of [log_flush_scheduler_interval_ms] is used.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.flush_ms] setting.
	LogFlushIntervalMs *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=log_flush_interval_ms,json=logFlushIntervalMs,proto3" json:"log_flush_interval_ms,omitempty"`
	// The frequency of checks (in milliseconds) for any logs that need to be flushed to disk.
	// This check is done by the log flusher.
	LogFlushSchedulerIntervalMs *wrapperspb.Int64Value `protobuf:"bytes,4,opt,name=log_flush_scheduler_interval_ms,json=logFlushSchedulerIntervalMs,proto3" json:"log_flush_scheduler_interval_ms,omitempty"`
	// Partition size limit; Kafka will discard old log segments to free up space if `delete` [TopicConfig2_8.cleanup_policy] is in effect.
	// This setting is helpful if you need to control the size of a log due to limited disk space.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.retention_bytes] setting.
	LogRetentionBytes *wrapperspb.Int64Value `protobuf:"bytes,5,opt,name=log_retention_bytes,json=logRetentionBytes,proto3" json:"log_retention_bytes,omitempty"`
	// The number of hours to keep a log segment file before deleting it.
	LogRetentionHours *wrapperspb.Int64Value `protobuf:"bytes,6,opt,name=log_retention_hours,json=logRetentionHours,proto3" json:"log_retention_hours,omitempty"`
	// The number of minutes to keep a log segment file before deleting it.
	//
	// If not set, the value of [log_retention_hours] is used.
	LogRetentionMinutes *wrapperspb.Int64Value `protobuf:"bytes,7,opt,name=log_retention_minutes,json=logRetentionMinutes,proto3" json:"log_retention_minutes,omitempty"`
	// The number of milliseconds to keep a log segment file before deleting it.
	//
	// If not set, the value of [log_retention_minutes] is used.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.retention_ms] setting.
	LogRetentionMs *wrapperspb.Int64Value `protobuf:"bytes,8,opt,name=log_retention_ms,json=logRetentionMs,proto3" json:"log_retention_ms,omitempty"`
	// The maximum size of a single log file.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.segment_bytes] setting.
	LogSegmentBytes *wrapperspb.Int64Value `protobuf:"bytes,9,opt,name=log_segment_bytes,json=logSegmentBytes,proto3" json:"log_segment_bytes,omitempty"`
	// Should pre allocate file when create new segment?
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.preallocate] setting.
	LogPreallocate *wrapperspb.BoolValue `protobuf:"bytes,10,opt,name=log_preallocate,json=logPreallocate,proto3" json:"log_preallocate,omitempty"`
	// The SO_SNDBUF buffer of the socket server sockets. If the value is -1, the OS default will be used.
	SocketSendBufferBytes *wrapperspb.Int64Value `protobuf:"bytes,11,opt,name=socket_send_buffer_bytes,json=socketSendBufferBytes,proto3" json:"socket_send_buffer_bytes,omitempty"`
	// The SO_RCVBUF buffer of the socket server sockets. If the value is -1, the OS default will be used.
	SocketReceiveBufferBytes *wrapperspb.Int64Value `protobuf:"bytes,12,opt,name=socket_receive_buffer_bytes,json=socketReceiveBufferBytes,proto3" json:"socket_receive_buffer_bytes,omitempty"`
	// Enable auto creation of topic on the server
	AutoCreateTopicsEnable *wrapperspb.BoolValue `protobuf:"bytes,13,opt,name=auto_create_topics_enable,json=autoCreateTopicsEnable,proto3" json:"auto_create_topics_enable,omitempty"`
	// Default number of partitions per topic on the whole cluster
	NumPartitions *wrapperspb.Int64Value `protobuf:"bytes,14,opt,name=num_partitions,json=numPartitions,proto3" json:"num_partitions,omitempty"`
	// Default replication factor of the topic on the whole cluster
	DefaultReplicationFactor *wrapperspb.Int64Value `protobuf:"bytes,15,opt,name=default_replication_factor,json=defaultReplicationFactor,proto3" json:"default_replication_factor,omitempty"`
	// The largest record batch size allowed by Kafka. Default value: 1048588.
	MessageMaxBytes *wrapperspb.Int64Value `protobuf:"bytes,16,opt,name=message_max_bytes,json=messageMaxBytes,proto3" json:"message_max_bytes,omitempty"`
	// The number of bytes of messages to attempt to fetch for each partition. Default value: 1048576.
	ReplicaFetchMaxBytes *wrapperspb.Int64Value `protobuf:"bytes,17,opt,name=replica_fetch_max_bytes,json=replicaFetchMaxBytes,proto3" json:"replica_fetch_max_bytes,omitempty"`
	// A list of cipher suites.
	SslCipherSuites []string `protobuf:"bytes,18,rep,name=ssl_cipher_suites,json=sslCipherSuites,proto3" json:"ssl_cipher_suites,omitempty"`
	// Offset storage time after a consumer group loses all its consumers. Default: 10080.
	OffsetsRetentionMinutes *wrapperspb.Int64Value `protobuf:"bytes,19,opt,name=offsets_retention_minutes,json=offsetsRetentionMinutes,proto3" json:"offsets_retention_minutes,omitempty"`
	// The list of SASL mechanisms enabled in the Kafka server. Default: [SCRAM_SHA_512].
	SaslEnabledMechanisms []SaslMechanism `protobuf:"varint,20,rep,packed,name=sasl_enabled_mechanisms,json=saslEnabledMechanisms,proto3,enum=yandex.cloud.mdb.kafka.v1.SaslMechanism" json:"sasl_enabled_mechanisms,omitempty"`
}

func (x *KafkaConfig2_8) Reset() {
	*x = KafkaConfig2_8{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KafkaConfig2_8) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KafkaConfig2_8) ProtoMessage() {}

func (x *KafkaConfig2_8) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KafkaConfig2_8.ProtoReflect.Descriptor instead.
func (*KafkaConfig2_8) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *KafkaConfig2_8) GetCompressionType() CompressionType {
	if x != nil {
		return x.CompressionType
	}
	return CompressionType_COMPRESSION_TYPE_UNSPECIFIED
}

func (x *KafkaConfig2_8) GetLogFlushIntervalMessages() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogFlushIntervalMessages
	}
	return nil
}

func (x *KafkaConfig2_8) GetLogFlushIntervalMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogFlushIntervalMs
	}
	return nil
}

func (x *KafkaConfig2_8) GetLogFlushSchedulerIntervalMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogFlushSchedulerIntervalMs
	}
	return nil
}

func (x *KafkaConfig2_8) GetLogRetentionBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionBytes
	}
	return nil
}

func (x *KafkaConfig2_8) GetLogRetentionHours() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionHours
	}
	return nil
}

func (x *KafkaConfig2_8) GetLogRetentionMinutes() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionMinutes
	}
	return nil
}

func (x *KafkaConfig2_8) GetLogRetentionMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionMs
	}
	return nil
}

func (x *KafkaConfig2_8) GetLogSegmentBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogSegmentBytes
	}
	return nil
}

func (x *KafkaConfig2_8) GetLogPreallocate() *wrapperspb.BoolValue {
	if x != nil {
		return x.LogPreallocate
	}
	return nil
}

func (x *KafkaConfig2_8) GetSocketSendBufferBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.SocketSendBufferBytes
	}
	return nil
}

func (x *KafkaConfig2_8) GetSocketReceiveBufferBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.SocketReceiveBufferBytes
	}
	return nil
}

func (x *KafkaConfig2_8) GetAutoCreateTopicsEnable() *wrapperspb.BoolValue {
	if x != nil {
		return x.AutoCreateTopicsEnable
	}
	return nil
}

func (x *KafkaConfig2_8) GetNumPartitions() *wrapperspb.Int64Value {
	if x != nil {
		return x.NumPartitions
	}
	return nil
}

func (x *KafkaConfig2_8) GetDefaultReplicationFactor() *wrapperspb.Int64Value {
	if x != nil {
		return x.DefaultReplicationFactor
	}
	return nil
}

func (x *KafkaConfig2_8) GetMessageMaxBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.MessageMaxBytes
	}
	return nil
}

func (x *KafkaConfig2_8) GetReplicaFetchMaxBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.ReplicaFetchMaxBytes
	}
	return nil
}

func (x *KafkaConfig2_8) GetSslCipherSuites() []string {
	if x != nil {
		return x.SslCipherSuites
	}
	return nil
}

func (x *KafkaConfig2_8) GetOffsetsRetentionMinutes() *wrapperspb.Int64Value {
	if x != nil {
		return x.OffsetsRetentionMinutes
	}
	return nil
}

func (x *KafkaConfig2_8) GetSaslEnabledMechanisms() []SaslMechanism {
	if x != nil {
		return x.SaslEnabledMechanisms
	}
	return nil
}

// Kafka version 3.x broker configuration.
type KafkaConfig3 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cluster topics compression type.
	CompressionType CompressionType `protobuf:"varint,1,opt,name=compression_type,json=compressionType,proto3,enum=yandex.cloud.mdb.kafka.v1.CompressionType" json:"compression_type,omitempty"`
	// The number of messages accumulated on a log partition before messages are flushed to disk.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.flush_messages] setting.
	LogFlushIntervalMessages *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=log_flush_interval_messages,json=logFlushIntervalMessages,proto3" json:"log_flush_interval_messages,omitempty"`
	// The maximum time (in milliseconds) that a message in any topic is kept in memory before flushed to disk.
	// If not set, the value of [log_flush_scheduler_interval_ms] is used.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.flush_ms] setting.
	LogFlushIntervalMs *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=log_flush_interval_ms,json=logFlushIntervalMs,proto3" json:"log_flush_interval_ms,omitempty"`
	// The frequency of checks (in milliseconds) for any logs that need to be flushed to disk.
	// This check is done by the log flusher.
	LogFlushSchedulerIntervalMs *wrapperspb.Int64Value `protobuf:"bytes,4,opt,name=log_flush_scheduler_interval_ms,json=logFlushSchedulerIntervalMs,proto3" json:"log_flush_scheduler_interval_ms,omitempty"`
	// Partition size limit; Kafka will discard old log segments to free up space if `delete` [TopicConfig3.cleanup_policy] is in effect.
	// This setting is helpful if you need to control the size of a log due to limited disk space.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.retention_bytes] setting.
	LogRetentionBytes *wrapperspb.Int64Value `protobuf:"bytes,5,opt,name=log_retention_bytes,json=logRetentionBytes,proto3" json:"log_retention_bytes,omitempty"`
	// The number of hours to keep a log segment file before deleting it.
	LogRetentionHours *wrapperspb.Int64Value `protobuf:"bytes,6,opt,name=log_retention_hours,json=logRetentionHours,proto3" json:"log_retention_hours,omitempty"`
	// The number of minutes to keep a log segment file before deleting it.
	//
	// If not set, the value of [log_retention_hours] is used.
	LogRetentionMinutes *wrapperspb.Int64Value `protobuf:"bytes,7,opt,name=log_retention_minutes,json=logRetentionMinutes,proto3" json:"log_retention_minutes,omitempty"`
	// The number of milliseconds to keep a log segment file before deleting it.
	//
	// If not set, the value of [log_retention_minutes] is used.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.retention_ms] setting.
	LogRetentionMs *wrapperspb.Int64Value `protobuf:"bytes,8,opt,name=log_retention_ms,json=logRetentionMs,proto3" json:"log_retention_ms,omitempty"`
	// The maximum size of a single log file.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.segment_bytes] setting.
	LogSegmentBytes *wrapperspb.Int64Value `protobuf:"bytes,9,opt,name=log_segment_bytes,json=logSegmentBytes,proto3" json:"log_segment_bytes,omitempty"`
	// Should pre allocate file when create new segment?
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.preallocate] setting.
	LogPreallocate *wrapperspb.BoolValue `protobuf:"bytes,10,opt,name=log_preallocate,json=logPreallocate,proto3" json:"log_preallocate,omitempty"`
	// The SO_SNDBUF buffer of the socket server sockets. If the value is -1, the OS default will be used.
	SocketSendBufferBytes *wrapperspb.Int64Value `protobuf:"bytes,11,opt,name=socket_send_buffer_bytes,json=socketSendBufferBytes,proto3" json:"socket_send_buffer_bytes,omitempty"`
	// The SO_RCVBUF buffer of the socket server sockets. If the value is -1, the OS default will be used.
	SocketReceiveBufferBytes *wrapperspb.Int64Value `protobuf:"bytes,12,opt,name=socket_receive_buffer_bytes,json=socketReceiveBufferBytes,proto3" json:"socket_receive_buffer_bytes,omitempty"`
	// Enable auto creation of topic on the server
	AutoCreateTopicsEnable *wrapperspb.BoolValue `protobuf:"bytes,13,opt,name=auto_create_topics_enable,json=autoCreateTopicsEnable,proto3" json:"auto_create_topics_enable,omitempty"`
	// Default number of partitions per topic on the whole cluster
	NumPartitions *wrapperspb.Int64Value `protobuf:"bytes,14,opt,name=num_partitions,json=numPartitions,proto3" json:"num_partitions,omitempty"`
	// Default replication factor of the topic on the whole cluster
	DefaultReplicationFactor *wrapperspb.Int64Value `protobuf:"bytes,15,opt,name=default_replication_factor,json=defaultReplicationFactor,proto3" json:"default_replication_factor,omitempty"`
	// The largest record batch size allowed by Kafka. Default value: 1048588.
	MessageMaxBytes *wrapperspb.Int64Value `protobuf:"bytes,16,opt,name=message_max_bytes,json=messageMaxBytes,proto3" json:"message_max_bytes,omitempty"`
	// The number of bytes of messages to attempt to fetch for each partition. Default value: 1048576.
	ReplicaFetchMaxBytes *wrapperspb.Int64Value `protobuf:"bytes,17,opt,name=replica_fetch_max_bytes,json=replicaFetchMaxBytes,proto3" json:"replica_fetch_max_bytes,omitempty"`
	// A list of cipher suites.
	SslCipherSuites []string `protobuf:"bytes,18,rep,name=ssl_cipher_suites,json=sslCipherSuites,proto3" json:"ssl_cipher_suites,omitempty"`
	// Offset storage time after a consumer group loses all its consumers. Default: 10080.
	OffsetsRetentionMinutes *wrapperspb.Int64Value `protobuf:"bytes,19,opt,name=offsets_retention_minutes,json=offsetsRetentionMinutes,proto3" json:"offsets_retention_minutes,omitempty"`
	// The list of SASL mechanisms enabled in the Kafka server. Default: [SCRAM_SHA_512].
	SaslEnabledMechanisms []SaslMechanism `protobuf:"varint,20,rep,packed,name=sasl_enabled_mechanisms,json=saslEnabledMechanisms,proto3,enum=yandex.cloud.mdb.kafka.v1.SaslMechanism" json:"sasl_enabled_mechanisms,omitempty"`
}

func (x *KafkaConfig3) Reset() {
	*x = KafkaConfig3{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KafkaConfig3) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KafkaConfig3) ProtoMessage() {}

func (x *KafkaConfig3) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KafkaConfig3.ProtoReflect.Descriptor instead.
func (*KafkaConfig3) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *KafkaConfig3) GetCompressionType() CompressionType {
	if x != nil {
		return x.CompressionType
	}
	return CompressionType_COMPRESSION_TYPE_UNSPECIFIED
}

func (x *KafkaConfig3) GetLogFlushIntervalMessages() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogFlushIntervalMessages
	}
	return nil
}

func (x *KafkaConfig3) GetLogFlushIntervalMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogFlushIntervalMs
	}
	return nil
}

func (x *KafkaConfig3) GetLogFlushSchedulerIntervalMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogFlushSchedulerIntervalMs
	}
	return nil
}

func (x *KafkaConfig3) GetLogRetentionBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionBytes
	}
	return nil
}

func (x *KafkaConfig3) GetLogRetentionHours() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionHours
	}
	return nil
}

func (x *KafkaConfig3) GetLogRetentionMinutes() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionMinutes
	}
	return nil
}

func (x *KafkaConfig3) GetLogRetentionMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionMs
	}
	return nil
}

func (x *KafkaConfig3) GetLogSegmentBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogSegmentBytes
	}
	return nil
}

func (x *KafkaConfig3) GetLogPreallocate() *wrapperspb.BoolValue {
	if x != nil {
		return x.LogPreallocate
	}
	return nil
}

func (x *KafkaConfig3) GetSocketSendBufferBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.SocketSendBufferBytes
	}
	return nil
}

func (x *KafkaConfig3) GetSocketReceiveBufferBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.SocketReceiveBufferBytes
	}
	return nil
}

func (x *KafkaConfig3) GetAutoCreateTopicsEnable() *wrapperspb.BoolValue {
	if x != nil {
		return x.AutoCreateTopicsEnable
	}
	return nil
}

func (x *KafkaConfig3) GetNumPartitions() *wrapperspb.Int64Value {
	if x != nil {
		return x.NumPartitions
	}
	return nil
}

func (x *KafkaConfig3) GetDefaultReplicationFactor() *wrapperspb.Int64Value {
	if x != nil {
		return x.DefaultReplicationFactor
	}
	return nil
}

func (x *KafkaConfig3) GetMessageMaxBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.MessageMaxBytes
	}
	return nil
}

func (x *KafkaConfig3) GetReplicaFetchMaxBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.ReplicaFetchMaxBytes
	}
	return nil
}

func (x *KafkaConfig3) GetSslCipherSuites() []string {
	if x != nil {
		return x.SslCipherSuites
	}
	return nil
}

func (x *KafkaConfig3) GetOffsetsRetentionMinutes() *wrapperspb.Int64Value {
	if x != nil {
		return x.OffsetsRetentionMinutes
	}
	return nil
}

func (x *KafkaConfig3) GetSaslEnabledMechanisms() []SaslMechanism {
	if x != nil {
		return x.SaslEnabledMechanisms
	}
	return nil
}

// Cluster host metadata.
type Host struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the Apache Kafka® cluster.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Host role. If the field has default value, it is not returned in the response.
	Role Host_Role `protobuf:"varint,4,opt,name=role,proto3,enum=yandex.cloud.mdb.kafka.v1.Host_Role" json:"role,omitempty"`
	// Computational resources allocated to the host.
	Resources *Resources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	// Aggregated host health data. If the field has default value, it is not returned in the response.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.kafka.v1.Host_Health" json:"health,omitempty"`
	// ID of the subnet the host resides in.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// The flag that defines whether a public IP address is assigned to the node.
	//
	// If the value is `true`, then this node is available on the Internet via it's public IP address.
	AssignPublicIp bool `protobuf:"varint,9,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
}

func (x *Host) Reset() {
	*x = Host{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Host) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host) ProtoMessage() {}

func (x *Host) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host.ProtoReflect.Descriptor instead.
func (*Host) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *Host) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Host) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *Host) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *Host) GetRole() Host_Role {
	if x != nil {
		return x.Role
	}
	return Host_ROLE_UNSPECIFIED
}

func (x *Host) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Host) GetHealth() Host_Health {
	if x != nil {
		return x.Health
	}
	return Host_UNKNOWN
}

func (x *Host) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *Host) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

type Access struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Allow access for DataTransfer.
	DataTransfer bool `protobuf:"varint,1,opt,name=data_transfer,json=dataTransfer,proto3" json:"data_transfer,omitempty"`
}

func (x *Access) Reset() {
	*x = Access{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Access) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Access) ProtoMessage() {}

func (x *Access) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Access.ProtoReflect.Descriptor instead.
func (*Access) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *Access) GetDataTransfer() bool {
	if x != nil {
		return x.DataTransfer
	}
	return false
}

type DiskSizeAutoscaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Threshold of storage usage (in percent) that triggers automatic scaling of the storage during the maintenance window. Zero value means disabled threshold.
	PlannedUsageThreshold int64 `protobuf:"varint,1,opt,name=planned_usage_threshold,json=plannedUsageThreshold,proto3" json:"planned_usage_threshold,omitempty"`
	// Threshold of storage usage (in percent) that triggers immediate automatic scaling of the storage. Zero value means disabled threshold.
	EmergencyUsageThreshold int64 `protobuf:"varint,2,opt,name=emergency_usage_threshold,json=emergencyUsageThreshold,proto3" json:"emergency_usage_threshold,omitempty"`
	// New storage size (in bytes) that is set when one of the thresholds is achieved.
	DiskSizeLimit int64 `protobuf:"varint,3,opt,name=disk_size_limit,json=diskSizeLimit,proto3" json:"disk_size_limit,omitempty"`
}

func (x *DiskSizeAutoscaling) Reset() {
	*x = DiskSizeAutoscaling{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskSizeAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskSizeAutoscaling) ProtoMessage() {}

func (x *DiskSizeAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskSizeAutoscaling.ProtoReflect.Descriptor instead.
func (*DiskSizeAutoscaling) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *DiskSizeAutoscaling) GetPlannedUsageThreshold() int64 {
	if x != nil {
		return x.PlannedUsageThreshold
	}
	return 0
}

func (x *DiskSizeAutoscaling) GetEmergencyUsageThreshold() int64 {
	if x != nil {
		return x.EmergencyUsageThreshold
	}
	return 0
}

func (x *DiskSizeAutoscaling) GetDiskSizeLimit() int64 {
	if x != nil {
		return x.DiskSizeLimit
	}
	return 0
}

type ConfigSpec_Kafka struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resources allocated to Kafka brokers.
	Resources *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	// Kafka broker configuration.
	//
	// Types that are assignable to KafkaConfig:
	//
	//	*ConfigSpec_Kafka_KafkaConfig_2_8
	//	*ConfigSpec_Kafka_KafkaConfig_3
	KafkaConfig isConfigSpec_Kafka_KafkaConfig `protobuf_oneof:"kafka_config"`
}

func (x *ConfigSpec_Kafka) Reset() {
	*x = ConfigSpec_Kafka{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigSpec_Kafka) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSpec_Kafka) ProtoMessage() {}

func (x *ConfigSpec_Kafka) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSpec_Kafka.ProtoReflect.Descriptor instead.
func (*ConfigSpec_Kafka) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ConfigSpec_Kafka) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (m *ConfigSpec_Kafka) GetKafkaConfig() isConfigSpec_Kafka_KafkaConfig {
	if m != nil {
		return m.KafkaConfig
	}
	return nil
}

func (x *ConfigSpec_Kafka) GetKafkaConfig_2_8() *KafkaConfig2_8 {
	if x, ok := x.GetKafkaConfig().(*ConfigSpec_Kafka_KafkaConfig_2_8); ok {
		return x.KafkaConfig_2_8
	}
	return nil
}

func (x *ConfigSpec_Kafka) GetKafkaConfig_3() *KafkaConfig3 {
	if x, ok := x.GetKafkaConfig().(*ConfigSpec_Kafka_KafkaConfig_3); ok {
		return x.KafkaConfig_3
	}
	return nil
}

type isConfigSpec_Kafka_KafkaConfig interface {
	isConfigSpec_Kafka_KafkaConfig()
}

type ConfigSpec_Kafka_KafkaConfig_2_8 struct {
	KafkaConfig_2_8 *KafkaConfig2_8 `protobuf:"bytes,4,opt,name=kafka_config_2_8,json=kafkaConfig_2_8,proto3,oneof"`
}

type ConfigSpec_Kafka_KafkaConfig_3 struct {
	KafkaConfig_3 *KafkaConfig3 `protobuf:"bytes,5,opt,name=kafka_config_3,json=kafkaConfig_3,proto3,oneof"`
}

func (*ConfigSpec_Kafka_KafkaConfig_2_8) isConfigSpec_Kafka_KafkaConfig() {}

func (*ConfigSpec_Kafka_KafkaConfig_3) isConfigSpec_Kafka_KafkaConfig() {}

type ConfigSpec_Zookeeper struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resources allocated to ZooKeeper hosts.
	Resources *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *ConfigSpec_Zookeeper) Reset() {
	*x = ConfigSpec_Zookeeper{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigSpec_Zookeeper) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSpec_Zookeeper) ProtoMessage() {}

func (x *ConfigSpec_Zookeeper) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSpec_Zookeeper.ProtoReflect.Descriptor instead.
func (*ConfigSpec_Zookeeper) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{2, 1}
}

func (x *ConfigSpec_Zookeeper) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type ConfigSpec_KRaft struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resources allocated to KRaft controller hosts.
	Resources *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *ConfigSpec_KRaft) Reset() {
	*x = ConfigSpec_KRaft{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigSpec_KRaft) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSpec_KRaft) ProtoMessage() {}

func (x *ConfigSpec_KRaft) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSpec_KRaft.ProtoReflect.Descriptor instead.
func (*ConfigSpec_KRaft) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{2, 2}
}

func (x *ConfigSpec_KRaft) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type ConfigSpec_RestAPIConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Is REST API enabled for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *ConfigSpec_RestAPIConfig) Reset() {
	*x = ConfigSpec_RestAPIConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigSpec_RestAPIConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSpec_RestAPIConfig) ProtoMessage() {}

func (x *ConfigSpec_RestAPIConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSpec_RestAPIConfig.ProtoReflect.Descriptor instead.
func (*ConfigSpec_RestAPIConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{2, 3}
}

func (x *ConfigSpec_RestAPIConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

var File_yandex_cloud_mdb_kafka_v1_cluster_proto protoreflect.FileDescriptor

var file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDesc = []byte{
	0x0a, 0x27, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x64, 0x62, 0x2f, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b,
	0x61, 0x2e, 0x76, 0x31, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2f,
	0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2b, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64,
	0x62, 0x2f, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xee, 0x09, 0x0a, 0x07,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x50, 0x0a,
	0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x45, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x3d, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x70, 0x65, 0x63, 0x52, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x49, 0x64, 0x12, 0x41, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x41, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x73, 0x12, 0x24, 0x0a, 0x0e, 0x68, 0x6f, 0x73, 0x74,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0c, 0x68, 0x6f, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x73, 0x12, 0x2f,
	0x0a, 0x13, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x5b, 0x0a, 0x12, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x77,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b,
	0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x11, 0x6d, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x5c, 0x0a, 0x11,
	0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65,
	0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x49, 0x0a, 0x0b, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d,
	0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x01, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52, 0x45, 0x53, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02,
	0x22, 0x3f, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x0e, 0x48, 0x45,
	0x41, 0x4c, 0x54, 0x48, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x41, 0x4c, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x41,
	0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x47, 0x52, 0x41, 0x44, 0x45, 0x44, 0x10,
	0x03, 0x22, 0x79, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12, 0x0a, 0x0e, 0x53,
	0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a,
	0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10,
	0x05, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0c,
	0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x22, 0x56, 0x0a, 0x0a,
	0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x12, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6c, 0x69, 0x6e, 0x6b, 0x22, 0xab, 0x09, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a,
	0x05, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x4b, 0x61, 0x66, 0x6b, 0x61, 0x52, 0x05, 0x6b, 0x61, 0x66, 0x6b, 0x61,
	0x12, 0x4d, 0x0a, 0x09, 0x7a, 0x6f, 0x6f, 0x6b, 0x65, 0x65, 0x70, 0x65, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x5a, 0x6f, 0x6f, 0x6b, 0x65,
	0x65, 0x70, 0x65, 0x72, 0x52, 0x09, 0x7a, 0x6f, 0x6f, 0x6b, 0x65, 0x65, 0x70, 0x65, 0x72, 0x12,
	0x17, 0x0a, 0x07, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x06, 0x7a, 0x6f, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x0d, 0x62, 0x72, 0x6f, 0x6b,
	0x65, 0x72, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x62, 0x72,
	0x6f, 0x6b, 0x65, 0x72, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x61, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x49, 0x70, 0x12, 0x2d, 0x0a, 0x10, 0x75, 0x6e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x0f, 0x75, 0x6e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x54, 0x6f, 0x70,
	0x69, 0x63, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x12, 0x39, 0x0a, 0x06,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52,
	0x06, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x5b, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x74, 0x5f,
	0x61, 0x70, 0x69, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x41, 0x50, 0x49, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x74, 0x41, 0x70, 0x69, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x62, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x41, 0x0a, 0x05, 0x6b, 0x72, 0x61, 0x66,
	0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4b,
	0x52, 0x61, 0x66, 0x74, 0x52, 0x05, 0x6b, 0x72, 0x61, 0x66, 0x74, 0x1a, 0x8b, 0x02, 0x0a, 0x05,
	0x4b, 0x61, 0x66, 0x6b, 0x61, 0x12, 0x42, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b,
	0x61, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x10, 0x6b, 0x61, 0x66,
	0x6b, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x32, 0x5f, 0x38, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e,
	0x4b, 0x61, 0x66, 0x6b, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x5f, 0x38, 0x48, 0x00,
	0x52, 0x0f, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x32, 0x5f,
	0x38, 0x12, 0x50, 0x0a, 0x0e, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x33, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66,
	0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x61, 0x66, 0x6b, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x33, 0x48, 0x00, 0x52, 0x0d, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x33, 0x42, 0x0e, 0x0a, 0x0c, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x04, 0x1a, 0x4f, 0x0a, 0x09, 0x5a, 0x6f, 0x6f,
	0x6b, 0x65, 0x65, 0x70, 0x65, 0x72, 0x12, 0x42, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66,
	0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x4b, 0x0a, 0x05, 0x4b, 0x52,
	0x61, 0x66, 0x74, 0x12, 0x42, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x29, 0x0a, 0x0d, 0x52, 0x65, 0x73, 0x74, 0x41,
	0x50, 0x49, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x22, 0x78, 0x0a, 0x09, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x2c, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x73,
	0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x65, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a,
	0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x22, 0xe2, 0x0c, 0x0a,
	0x0e, 0x4b, 0x61, 0x66, 0x6b, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x5f, 0x38, 0x12,
	0x55, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66,
	0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a, 0x1b, 0x6c, 0x6f, 0x67, 0x5f, 0x66, 0x6c,
	0x75, 0x73, 0x68, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x6c, 0x6f, 0x67, 0x46, 0x6c, 0x75,
	0x73, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x73, 0x12, 0x4e, 0x0a, 0x15, 0x6c, 0x6f, 0x67, 0x5f, 0x66, 0x6c, 0x75, 0x73, 0x68, 0x5f,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12,
	0x6c, 0x6f, 0x67, 0x46, 0x6c, 0x75, 0x73, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c,
	0x4d, 0x73, 0x12, 0x61, 0x0a, 0x1f, 0x6c, 0x6f, 0x67, 0x5f, 0x66, 0x6c, 0x75, 0x73, 0x68, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x5f, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1b, 0x6c, 0x6f, 0x67, 0x46, 0x6c, 0x75,
	0x73, 0x68, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x4d, 0x73, 0x12, 0x4b, 0x0a, 0x13, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x65, 0x74,
	0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x11, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x12, 0x4b, 0x0a, 0x13, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x6c, 0x6f,
	0x67, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x12,
	0x4f, 0x0a, 0x15, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x6c, 0x6f, 0x67,
	0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73,
	0x12, 0x45, 0x0a, 0x10, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x73, 0x12, 0x47, 0x0a, 0x11, 0x6c, 0x6f, 0x67, 0x5f, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0f, 0x6c, 0x6f, 0x67, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x43, 0x0a, 0x0f, 0x6c, 0x6f, 0x67, 0x5f, 0x70, 0x72, 0x65, 0x61, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x6c, 0x6f, 0x67, 0x50, 0x72, 0x65, 0x61, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x65, 0x12, 0x54, 0x0a, 0x18, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x5f,
	0x73, 0x65, 0x6e, 0x64, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x65, 0x6e, 0x64,
	0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x1b, 0x73,
	0x6f, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x5f, 0x62, 0x75,
	0x66, 0x66, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x73,
	0x6f, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x42, 0x75, 0x66, 0x66,
	0x65, 0x72, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x55, 0x0a, 0x19, 0x61, 0x75, 0x74, 0x6f, 0x5f,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x5f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x61, 0x75, 0x74, 0x6f, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x42,
	0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0d, 0x6e, 0x75, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x59, 0x0a, 0x1a, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x72, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x18, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x47, 0x0a,
	0x11, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4d, 0x61,
	0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x17, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x5f, 0x66, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x4d, 0x61, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x73,
	0x6c, 0x5f, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x5f, 0x73, 0x75, 0x69, 0x74, 0x65, 0x73, 0x18,
	0x12, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x73, 0x6c, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72,
	0x53, 0x75, 0x69, 0x74, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x19, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x73, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x69, 0x6e, 0x75,
	0x74, 0x65, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x12,
	0x60, 0x0a, 0x17, 0x73, 0x61, 0x73, 0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x5f,
	0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x73,
	0x6c, 0x4d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x52, 0x15, 0x73, 0x61, 0x73, 0x6c,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x4d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d,
	0x73, 0x22, 0xe0, 0x0c, 0x0a, 0x0c, 0x4b, 0x61, 0x66, 0x6b, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x33, 0x12, 0x55, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a, 0x1b, 0x6c, 0x6f, 0x67,
	0x5f, 0x66, 0x6c, 0x75, 0x73, 0x68, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x6c, 0x6f, 0x67,
	0x46, 0x6c, 0x75, 0x73, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x4e, 0x0a, 0x15, 0x6c, 0x6f, 0x67, 0x5f, 0x66, 0x6c, 0x75,
	0x73, 0x68, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f, 0x6d, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x12, 0x6c, 0x6f, 0x67, 0x46, 0x6c, 0x75, 0x73, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x4d, 0x73, 0x12, 0x61, 0x0a, 0x1f, 0x6c, 0x6f, 0x67, 0x5f, 0x66, 0x6c, 0x75,
	0x73, 0x68, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1b, 0x6c, 0x6f, 0x67,
	0x46, 0x6c, 0x75, 0x73, 0x68, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x4d, 0x73, 0x12, 0x4b, 0x0a, 0x13, 0x6c, 0x6f, 0x67, 0x5f,
	0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x11, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x13, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x65, 0x74,
	0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x11, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x6f, 0x75,
	0x72, 0x73, 0x12, 0x4f, 0x0a, 0x15, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13,
	0x6c, 0x6f, 0x67, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x69, 0x6e, 0x75,
	0x74, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x10, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x6c, 0x6f, 0x67, 0x52,
	0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x73, 0x12, 0x47, 0x0a, 0x11, 0x6c, 0x6f,
	0x67, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0f, 0x6c, 0x6f, 0x67, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x12, 0x43, 0x0a, 0x0f, 0x6c, 0x6f, 0x67, 0x5f, 0x70, 0x72, 0x65, 0x61, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42,
	0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x6c, 0x6f, 0x67, 0x50, 0x72, 0x65,
	0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x12, 0x54, 0x0a, 0x18, 0x73, 0x6f, 0x63, 0x6b,
	0x65, 0x74, 0x5f, 0x73, 0x65, 0x6e, 0x64, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x53,
	0x65, 0x6e, 0x64, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x5a,
	0x0a, 0x1b, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65,
	0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x18, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x42,
	0x75, 0x66, 0x66, 0x65, 0x72, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x55, 0x0a, 0x19, 0x61, 0x75,
	0x74, 0x6f, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x61, 0x75, 0x74, 0x6f, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x12, 0x42, 0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x6e, 0x75, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59, 0x0a, 0x1a, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x63,
	0x74, 0x6f, 0x72, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72,
	0x12, 0x47, 0x0a, 0x11, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x6d, 0x61, 0x78, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x4d, 0x61, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x17, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x5f, 0x66, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x4d, 0x61, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x2a, 0x0a,
	0x11, 0x73, 0x73, 0x6c, 0x5f, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x5f, 0x73, 0x75, 0x69, 0x74,
	0x65, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x73, 0x6c, 0x43, 0x69, 0x70,
	0x68, 0x65, 0x72, 0x53, 0x75, 0x69, 0x74, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x19, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x69, 0x6e, 0x75, 0x74,
	0x65, 0x73, 0x12, 0x60, 0x0a, 0x17, 0x73, 0x61, 0x73, 0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x5f, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x73, 0x18, 0x14, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x61, 0x73, 0x6c, 0x4d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x52, 0x15, 0x73,
	0x61, 0x73, 0x6c, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x4d, 0x65, 0x63, 0x68, 0x61, 0x6e,
	0x69, 0x73, 0x6d, 0x73, 0x22, 0xcf, 0x03, 0x0a, 0x04, 0x48, 0x6f, 0x73, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x17, 0x0a, 0x07, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x7a, 0x6f, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x38, 0x0a, 0x04, 0x72, 0x6f, 0x6c,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61,
	0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x04, 0x72,
	0x6f, 0x6c, 0x65, 0x12, 0x42, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6b, 0x61, 0x66, 0x6b, 0x61,
	0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x6e, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x75, 0x62, 0x6e,
	0x65, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x5f, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e,
	0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70, 0x22, 0x36,
	0x0a, 0x04, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05,
	0x4b, 0x41, 0x46, 0x4b, 0x41, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x5a, 0x4f, 0x4f, 0x4b, 0x45,
	0x45, 0x50, 0x45, 0x52, 0x10, 0x02, 0x22, 0x38, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x41, 0x4c, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x41, 0x44,
	0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x47, 0x52, 0x41, 0x44, 0x45, 0x44, 0x10, 0x03,
	0x4a, 0x04, 0x08, 0x07, 0x10, 0x08, 0x22, 0x2d, 0x0a, 0x06, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x12, 0x23, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x22, 0xcf, 0x01, 0x0a, 0x13, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69,
	0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x45, 0x0a,
	0x17, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x0d,
	0xe8, 0xc7, 0x31, 0x00, 0xfa, 0xc7, 0x31, 0x05, 0x30, 0x2d, 0x31, 0x30, 0x30, 0x52, 0x15, 0x70,
	0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x55, 0x73, 0x61, 0x67, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x12, 0x49, 0x0a, 0x19, 0x65, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x6e, 0x63,
	0x79, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x0d, 0xe8, 0xc7, 0x31, 0x00, 0xfa, 0xc7, 0x31,
	0x05, 0x30, 0x2d, 0x31, 0x30, 0x30, 0x52, 0x17, 0x65, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x6e, 0x63,
	0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12,
	0x26, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69,
	0x7a, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x64, 0x0a, 0x1d, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x5a, 0x43, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2d, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x67, 0x6f, 0x2d, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6b,
	0x61, 0x66, 0x6b, 0x61, 0x2f, 0x76, 0x31, 0x3b, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescOnce sync.Once
	file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescData = file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDesc
)

func file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP() []byte {
	file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescData)
	})
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescData
}

var file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_yandex_cloud_mdb_kafka_v1_cluster_proto_goTypes = []any{
	(Cluster_Environment)(0),         // 0: yandex.cloud.mdb.kafka.v1.Cluster.Environment
	(Cluster_Health)(0),              // 1: yandex.cloud.mdb.kafka.v1.Cluster.Health
	(Cluster_Status)(0),              // 2: yandex.cloud.mdb.kafka.v1.Cluster.Status
	(Host_Role)(0),                   // 3: yandex.cloud.mdb.kafka.v1.Host.Role
	(Host_Health)(0),                 // 4: yandex.cloud.mdb.kafka.v1.Host.Health
	(*Cluster)(nil),                  // 5: yandex.cloud.mdb.kafka.v1.Cluster
	(*Monitoring)(nil),               // 6: yandex.cloud.mdb.kafka.v1.Monitoring
	(*ConfigSpec)(nil),               // 7: yandex.cloud.mdb.kafka.v1.ConfigSpec
	(*Resources)(nil),                // 8: yandex.cloud.mdb.kafka.v1.Resources
	(*KafkaConfig2_8)(nil),           // 9: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8
	(*KafkaConfig3)(nil),             // 10: yandex.cloud.mdb.kafka.v1.KafkaConfig3
	(*Host)(nil),                     // 11: yandex.cloud.mdb.kafka.v1.Host
	(*Access)(nil),                   // 12: yandex.cloud.mdb.kafka.v1.Access
	(*DiskSizeAutoscaling)(nil),      // 13: yandex.cloud.mdb.kafka.v1.DiskSizeAutoscaling
	nil,                              // 14: yandex.cloud.mdb.kafka.v1.Cluster.LabelsEntry
	(*ConfigSpec_Kafka)(nil),         // 15: yandex.cloud.mdb.kafka.v1.ConfigSpec.Kafka
	(*ConfigSpec_Zookeeper)(nil),     // 16: yandex.cloud.mdb.kafka.v1.ConfigSpec.Zookeeper
	(*ConfigSpec_KRaft)(nil),         // 17: yandex.cloud.mdb.kafka.v1.ConfigSpec.KRaft
	(*ConfigSpec_RestAPIConfig)(nil), // 18: yandex.cloud.mdb.kafka.v1.ConfigSpec.RestAPIConfig
	(*timestamppb.Timestamp)(nil),    // 19: google.protobuf.Timestamp
	(*MaintenanceWindow)(nil),        // 20: yandex.cloud.mdb.kafka.v1.MaintenanceWindow
	(*MaintenanceOperation)(nil),     // 21: yandex.cloud.mdb.kafka.v1.MaintenanceOperation
	(*wrapperspb.Int64Value)(nil),    // 22: google.protobuf.Int64Value
	(CompressionType)(0),             // 23: yandex.cloud.mdb.kafka.v1.CompressionType
	(*wrapperspb.BoolValue)(nil),     // 24: google.protobuf.BoolValue
	(SaslMechanism)(0),               // 25: yandex.cloud.mdb.kafka.v1.SaslMechanism
}
var file_yandex_cloud_mdb_kafka_v1_cluster_proto_depIdxs = []int32{
	19, // 0: yandex.cloud.mdb.kafka.v1.Cluster.created_at:type_name -> google.protobuf.Timestamp
	14, // 1: yandex.cloud.mdb.kafka.v1.Cluster.labels:type_name -> yandex.cloud.mdb.kafka.v1.Cluster.LabelsEntry
	0,  // 2: yandex.cloud.mdb.kafka.v1.Cluster.environment:type_name -> yandex.cloud.mdb.kafka.v1.Cluster.Environment
	6,  // 3: yandex.cloud.mdb.kafka.v1.Cluster.monitoring:type_name -> yandex.cloud.mdb.kafka.v1.Monitoring
	7,  // 4: yandex.cloud.mdb.kafka.v1.Cluster.config:type_name -> yandex.cloud.mdb.kafka.v1.ConfigSpec
	1,  // 5: yandex.cloud.mdb.kafka.v1.Cluster.health:type_name -> yandex.cloud.mdb.kafka.v1.Cluster.Health
	2,  // 6: yandex.cloud.mdb.kafka.v1.Cluster.status:type_name -> yandex.cloud.mdb.kafka.v1.Cluster.Status
	20, // 7: yandex.cloud.mdb.kafka.v1.Cluster.maintenance_window:type_name -> yandex.cloud.mdb.kafka.v1.MaintenanceWindow
	21, // 8: yandex.cloud.mdb.kafka.v1.Cluster.planned_operation:type_name -> yandex.cloud.mdb.kafka.v1.MaintenanceOperation
	15, // 9: yandex.cloud.mdb.kafka.v1.ConfigSpec.kafka:type_name -> yandex.cloud.mdb.kafka.v1.ConfigSpec.Kafka
	16, // 10: yandex.cloud.mdb.kafka.v1.ConfigSpec.zookeeper:type_name -> yandex.cloud.mdb.kafka.v1.ConfigSpec.Zookeeper
	22, // 11: yandex.cloud.mdb.kafka.v1.ConfigSpec.brokers_count:type_name -> google.protobuf.Int64Value
	12, // 12: yandex.cloud.mdb.kafka.v1.ConfigSpec.access:type_name -> yandex.cloud.mdb.kafka.v1.Access
	18, // 13: yandex.cloud.mdb.kafka.v1.ConfigSpec.rest_api_config:type_name -> yandex.cloud.mdb.kafka.v1.ConfigSpec.RestAPIConfig
	13, // 14: yandex.cloud.mdb.kafka.v1.ConfigSpec.disk_size_autoscaling:type_name -> yandex.cloud.mdb.kafka.v1.DiskSizeAutoscaling
	17, // 15: yandex.cloud.mdb.kafka.v1.ConfigSpec.kraft:type_name -> yandex.cloud.mdb.kafka.v1.ConfigSpec.KRaft
	23, // 16: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.compression_type:type_name -> yandex.cloud.mdb.kafka.v1.CompressionType
	22, // 17: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_flush_interval_messages:type_name -> google.protobuf.Int64Value
	22, // 18: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_flush_interval_ms:type_name -> google.protobuf.Int64Value
	22, // 19: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_flush_scheduler_interval_ms:type_name -> google.protobuf.Int64Value
	22, // 20: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_retention_bytes:type_name -> google.protobuf.Int64Value
	22, // 21: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_retention_hours:type_name -> google.protobuf.Int64Value
	22, // 22: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_retention_minutes:type_name -> google.protobuf.Int64Value
	22, // 23: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_retention_ms:type_name -> google.protobuf.Int64Value
	22, // 24: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_segment_bytes:type_name -> google.protobuf.Int64Value
	24, // 25: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_preallocate:type_name -> google.protobuf.BoolValue
	22, // 26: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.socket_send_buffer_bytes:type_name -> google.protobuf.Int64Value
	22, // 27: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.socket_receive_buffer_bytes:type_name -> google.protobuf.Int64Value
	24, // 28: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.auto_create_topics_enable:type_name -> google.protobuf.BoolValue
	22, // 29: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.num_partitions:type_name -> google.protobuf.Int64Value
	22, // 30: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.default_replication_factor:type_name -> google.protobuf.Int64Value
	22, // 31: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.message_max_bytes:type_name -> google.protobuf.Int64Value
	22, // 32: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.replica_fetch_max_bytes:type_name -> google.protobuf.Int64Value
	22, // 33: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.offsets_retention_minutes:type_name -> google.protobuf.Int64Value
	25, // 34: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.sasl_enabled_mechanisms:type_name -> yandex.cloud.mdb.kafka.v1.SaslMechanism
	23, // 35: yandex.cloud.mdb.kafka.v1.KafkaConfig3.compression_type:type_name -> yandex.cloud.mdb.kafka.v1.CompressionType
	22, // 36: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_flush_interval_messages:type_name -> google.protobuf.Int64Value
	22, // 37: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_flush_interval_ms:type_name -> google.protobuf.Int64Value
	22, // 38: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_flush_scheduler_interval_ms:type_name -> google.protobuf.Int64Value
	22, // 39: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_retention_bytes:type_name -> google.protobuf.Int64Value
	22, // 40: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_retention_hours:type_name -> google.protobuf.Int64Value
	22, // 41: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_retention_minutes:type_name -> google.protobuf.Int64Value
	22, // 42: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_retention_ms:type_name -> google.protobuf.Int64Value
	22, // 43: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_segment_bytes:type_name -> google.protobuf.Int64Value
	24, // 44: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_preallocate:type_name -> google.protobuf.BoolValue
	22, // 45: yandex.cloud.mdb.kafka.v1.KafkaConfig3.socket_send_buffer_bytes:type_name -> google.protobuf.Int64Value
	22, // 46: yandex.cloud.mdb.kafka.v1.KafkaConfig3.socket_receive_buffer_bytes:type_name -> google.protobuf.Int64Value
	24, // 47: yandex.cloud.mdb.kafka.v1.KafkaConfig3.auto_create_topics_enable:type_name -> google.protobuf.BoolValue
	22, // 48: yandex.cloud.mdb.kafka.v1.KafkaConfig3.num_partitions:type_name -> google.protobuf.Int64Value
	22, // 49: yandex.cloud.mdb.kafka.v1.KafkaConfig3.default_replication_factor:type_name -> google.protobuf.Int64Value
	22, // 50: yandex.cloud.mdb.kafka.v1.KafkaConfig3.message_max_bytes:type_name -> google.protobuf.Int64Value
	22, // 51: yandex.cloud.mdb.kafka.v1.KafkaConfig3.replica_fetch_max_bytes:type_name -> google.protobuf.Int64Value
	22, // 52: yandex.cloud.mdb.kafka.v1.KafkaConfig3.offsets_retention_minutes:type_name -> google.protobuf.Int64Value
	25, // 53: yandex.cloud.mdb.kafka.v1.KafkaConfig3.sasl_enabled_mechanisms:type_name -> yandex.cloud.mdb.kafka.v1.SaslMechanism
	3,  // 54: yandex.cloud.mdb.kafka.v1.Host.role:type_name -> yandex.cloud.mdb.kafka.v1.Host.Role
	8,  // 55: yandex.cloud.mdb.kafka.v1.Host.resources:type_name -> yandex.cloud.mdb.kafka.v1.Resources
	4,  // 56: yandex.cloud.mdb.kafka.v1.Host.health:type_name -> yandex.cloud.mdb.kafka.v1.Host.Health
	8,  // 57: yandex.cloud.mdb.kafka.v1.ConfigSpec.Kafka.resources:type_name -> yandex.cloud.mdb.kafka.v1.Resources
	9,  // 58: yandex.cloud.mdb.kafka.v1.ConfigSpec.Kafka.kafka_config_2_8:type_name -> yandex.cloud.mdb.kafka.v1.KafkaConfig2_8
	10, // 59: yandex.cloud.mdb.kafka.v1.ConfigSpec.Kafka.kafka_config_3:type_name -> yandex.cloud.mdb.kafka.v1.KafkaConfig3
	8,  // 60: yandex.cloud.mdb.kafka.v1.ConfigSpec.Zookeeper.resources:type_name -> yandex.cloud.mdb.kafka.v1.Resources
	8,  // 61: yandex.cloud.mdb.kafka.v1.ConfigSpec.KRaft.resources:type_name -> yandex.cloud.mdb.kafka.v1.Resources
	62, // [62:62] is the sub-list for method output_type
	62, // [62:62] is the sub-list for method input_type
	62, // [62:62] is the sub-list for extension type_name
	62, // [62:62] is the sub-list for extension extendee
	0,  // [0:62] is the sub-list for field type_name
}

func init() { file_yandex_cloud_mdb_kafka_v1_cluster_proto_init() }
func file_yandex_cloud_mdb_kafka_v1_cluster_proto_init() {
	if File_yandex_cloud_mdb_kafka_v1_cluster_proto != nil {
		return
	}
	file_yandex_cloud_mdb_kafka_v1_common_proto_init()
	file_yandex_cloud_mdb_kafka_v1_maintenance_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*Monitoring); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ConfigSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*Resources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*KafkaConfig2_8); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*KafkaConfig3); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*Host); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*Access); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*DiskSizeAutoscaling); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*ConfigSpec_Kafka); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*ConfigSpec_Zookeeper); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*ConfigSpec_KRaft); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*ConfigSpec_RestAPIConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[10].OneofWrappers = []any{
		(*ConfigSpec_Kafka_KafkaConfig_2_8)(nil),
		(*ConfigSpec_Kafka_KafkaConfig_3)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_mdb_kafka_v1_cluster_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_mdb_kafka_v1_cluster_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes,
	}.Build()
	File_yandex_cloud_mdb_kafka_v1_cluster_proto = out.File
	file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDesc = nil
	file_yandex_cloud_mdb_kafka_v1_cluster_proto_goTypes = nil
	file_yandex_cloud_mdb_kafka_v1_cluster_proto_depIdxs = nil
}
