// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: yandex/cloud/cdn/v1/resource_service.proto

package cdn

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	ResourceService_Get_FullMethodName              = "/yandex.cloud.cdn.v1.ResourceService/Get"
	ResourceService_List_FullMethodName             = "/yandex.cloud.cdn.v1.ResourceService/List"
	ResourceService_Create_FullMethodName           = "/yandex.cloud.cdn.v1.ResourceService/Create"
	ResourceService_Update_FullMethodName           = "/yandex.cloud.cdn.v1.ResourceService/Update"
	ResourceService_Delete_FullMethodName           = "/yandex.cloud.cdn.v1.ResourceService/Delete"
	ResourceService_GetProviderCName_FullMethodName = "/yandex.cloud.cdn.v1.ResourceService/GetProviderCName"
)

// ResourceServiceClient is the client API for ResourceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Provider's resources management service.
type ResourceServiceClient interface {
	// Get client's CDN resource by resource id.
	Get(ctx context.Context, in *GetResourceRequest, opts ...grpc.CallOption) (*Resource, error)
	// Lists CDN resources.
	List(ctx context.Context, in *ListResourcesRequest, opts ...grpc.CallOption) (*ListResourcesResponse, error)
	// Creates a CDN resource in the specified folder.
	//
	// Creation may take up to 15 minutes.
	Create(ctx context.Context, in *CreateResourceRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified CDN resource.
	//
	// The method implements patch behaviour, i.e. only the fields specified in the request are updated in the resource.
	//
	// Changes may take up to 15 minutes to apply. Afterwards, it is recommended to purge the resource's cache via a
	// [CacheService.Purge] request.
	Update(ctx context.Context, in *UpdateResourceRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes client's CDN resource.
	Delete(ctx context.Context, in *DeleteResourceRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Get Provider's CNAME (edge endpoint) bind to specified folder id.
	// Returns UNIMPLEMENTED error, if provider doesn't support CNAME request.
	GetProviderCName(ctx context.Context, in *GetProviderCNameRequest, opts ...grpc.CallOption) (*GetProviderCNameResponse, error)
}

type resourceServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewResourceServiceClient(cc grpc.ClientConnInterface) ResourceServiceClient {
	return &resourceServiceClient{cc}
}

func (c *resourceServiceClient) Get(ctx context.Context, in *GetResourceRequest, opts ...grpc.CallOption) (*Resource, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Resource)
	err := c.cc.Invoke(ctx, ResourceService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceServiceClient) List(ctx context.Context, in *ListResourcesRequest, opts ...grpc.CallOption) (*ListResourcesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListResourcesResponse)
	err := c.cc.Invoke(ctx, ResourceService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceServiceClient) Create(ctx context.Context, in *CreateResourceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ResourceService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceServiceClient) Update(ctx context.Context, in *UpdateResourceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ResourceService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceServiceClient) Delete(ctx context.Context, in *DeleteResourceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ResourceService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceServiceClient) GetProviderCName(ctx context.Context, in *GetProviderCNameRequest, opts ...grpc.CallOption) (*GetProviderCNameResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetProviderCNameResponse)
	err := c.cc.Invoke(ctx, ResourceService_GetProviderCName_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ResourceServiceServer is the server API for ResourceService service.
// All implementations should embed UnimplementedResourceServiceServer
// for forward compatibility.
//
// Provider's resources management service.
type ResourceServiceServer interface {
	// Get client's CDN resource by resource id.
	Get(context.Context, *GetResourceRequest) (*Resource, error)
	// Lists CDN resources.
	List(context.Context, *ListResourcesRequest) (*ListResourcesResponse, error)
	// Creates a CDN resource in the specified folder.
	//
	// Creation may take up to 15 minutes.
	Create(context.Context, *CreateResourceRequest) (*operation.Operation, error)
	// Updates the specified CDN resource.
	//
	// The method implements patch behaviour, i.e. only the fields specified in the request are updated in the resource.
	//
	// Changes may take up to 15 minutes to apply. Afterwards, it is recommended to purge the resource's cache via a
	// [CacheService.Purge] request.
	Update(context.Context, *UpdateResourceRequest) (*operation.Operation, error)
	// Deletes client's CDN resource.
	Delete(context.Context, *DeleteResourceRequest) (*operation.Operation, error)
	// Get Provider's CNAME (edge endpoint) bind to specified folder id.
	// Returns UNIMPLEMENTED error, if provider doesn't support CNAME request.
	GetProviderCName(context.Context, *GetProviderCNameRequest) (*GetProviderCNameResponse, error)
}

// UnimplementedResourceServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedResourceServiceServer struct{}

func (UnimplementedResourceServiceServer) Get(context.Context, *GetResourceRequest) (*Resource, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedResourceServiceServer) List(context.Context, *ListResourcesRequest) (*ListResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedResourceServiceServer) Create(context.Context, *CreateResourceRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedResourceServiceServer) Update(context.Context, *UpdateResourceRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedResourceServiceServer) Delete(context.Context, *DeleteResourceRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedResourceServiceServer) GetProviderCName(context.Context, *GetProviderCNameRequest) (*GetProviderCNameResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProviderCName not implemented")
}
func (UnimplementedResourceServiceServer) testEmbeddedByValue() {}

// UnsafeResourceServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ResourceServiceServer will
// result in compilation errors.
type UnsafeResourceServiceServer interface {
	mustEmbedUnimplementedResourceServiceServer()
}

func RegisterResourceServiceServer(s grpc.ServiceRegistrar, srv ResourceServiceServer) {
	// If the following call pancis, it indicates UnimplementedResourceServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&ResourceService_ServiceDesc, srv)
}

func _ResourceService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ResourceService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceServiceServer).Get(ctx, req.(*GetResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ResourceService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceServiceServer).List(ctx, req.(*ListResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ResourceService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceServiceServer).Create(ctx, req.(*CreateResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ResourceService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceServiceServer).Update(ctx, req.(*UpdateResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ResourceService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceServiceServer).Delete(ctx, req.(*DeleteResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceService_GetProviderCName_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProviderCNameRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceServiceServer).GetProviderCName(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ResourceService_GetProviderCName_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceServiceServer).GetProviderCName(ctx, req.(*GetProviderCNameRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ResourceService_ServiceDesc is the grpc.ServiceDesc for ResourceService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ResourceService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.cdn.v1.ResourceService",
	HandlerType: (*ResourceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ResourceService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ResourceService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _ResourceService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ResourceService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ResourceService_Delete_Handler,
		},
		{
			MethodName: "GetProviderCName",
			Handler:    _ResourceService_GetProviderCName_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/cdn/v1/resource_service.proto",
}
