// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceTCPCheckDefaultsOKCode is the HTTP code returned for type ReplaceTCPCheckDefaultsOK
const ReplaceTCPCheckDefaultsOKCode int = 200

/*
ReplaceTCPCheckDefaultsOK TCP check replaced

swagger:response replaceTcpCheckDefaultsOK
*/
type ReplaceTCPCheckDefaultsOK struct {

	/*
	  In: Body
	*/
	Payload *models.TCPCheck `json:"body,omitempty"`
}

// NewReplaceTCPCheckDefaultsOK creates ReplaceTCPCheckDefaultsOK with default headers values
func NewReplaceTCPCheckDefaultsOK() *ReplaceTCPCheckDefaultsOK {

	return &ReplaceTCPCheckDefaultsOK{}
}

// WithPayload adds the payload to the replace Tcp check defaults o k response
func (o *ReplaceTCPCheckDefaultsOK) WithPayload(payload *models.TCPCheck) *ReplaceTCPCheckDefaultsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp check defaults o k response
func (o *ReplaceTCPCheckDefaultsOK) SetPayload(payload *models.TCPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPCheckDefaultsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceTCPCheckDefaultsAcceptedCode is the HTTP code returned for type ReplaceTCPCheckDefaultsAccepted
const ReplaceTCPCheckDefaultsAcceptedCode int = 202

/*
ReplaceTCPCheckDefaultsAccepted Configuration change accepted and reload requested

swagger:response replaceTcpCheckDefaultsAccepted
*/
type ReplaceTCPCheckDefaultsAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.TCPCheck `json:"body,omitempty"`
}

// NewReplaceTCPCheckDefaultsAccepted creates ReplaceTCPCheckDefaultsAccepted with default headers values
func NewReplaceTCPCheckDefaultsAccepted() *ReplaceTCPCheckDefaultsAccepted {

	return &ReplaceTCPCheckDefaultsAccepted{}
}

// WithReloadID adds the reloadId to the replace Tcp check defaults accepted response
func (o *ReplaceTCPCheckDefaultsAccepted) WithReloadID(reloadID string) *ReplaceTCPCheckDefaultsAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Tcp check defaults accepted response
func (o *ReplaceTCPCheckDefaultsAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Tcp check defaults accepted response
func (o *ReplaceTCPCheckDefaultsAccepted) WithPayload(payload *models.TCPCheck) *ReplaceTCPCheckDefaultsAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp check defaults accepted response
func (o *ReplaceTCPCheckDefaultsAccepted) SetPayload(payload *models.TCPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPCheckDefaultsAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceTCPCheckDefaultsBadRequestCode is the HTTP code returned for type ReplaceTCPCheckDefaultsBadRequest
const ReplaceTCPCheckDefaultsBadRequestCode int = 400

/*
ReplaceTCPCheckDefaultsBadRequest Bad request

swagger:response replaceTcpCheckDefaultsBadRequest
*/
type ReplaceTCPCheckDefaultsBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceTCPCheckDefaultsBadRequest creates ReplaceTCPCheckDefaultsBadRequest with default headers values
func NewReplaceTCPCheckDefaultsBadRequest() *ReplaceTCPCheckDefaultsBadRequest {

	return &ReplaceTCPCheckDefaultsBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Tcp check defaults bad request response
func (o *ReplaceTCPCheckDefaultsBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceTCPCheckDefaultsBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Tcp check defaults bad request response
func (o *ReplaceTCPCheckDefaultsBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Tcp check defaults bad request response
func (o *ReplaceTCPCheckDefaultsBadRequest) WithPayload(payload *models.Error) *ReplaceTCPCheckDefaultsBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp check defaults bad request response
func (o *ReplaceTCPCheckDefaultsBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPCheckDefaultsBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceTCPCheckDefaultsNotFoundCode is the HTTP code returned for type ReplaceTCPCheckDefaultsNotFound
const ReplaceTCPCheckDefaultsNotFoundCode int = 404

/*
ReplaceTCPCheckDefaultsNotFound The specified resource was not found

swagger:response replaceTcpCheckDefaultsNotFound
*/
type ReplaceTCPCheckDefaultsNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceTCPCheckDefaultsNotFound creates ReplaceTCPCheckDefaultsNotFound with default headers values
func NewReplaceTCPCheckDefaultsNotFound() *ReplaceTCPCheckDefaultsNotFound {

	return &ReplaceTCPCheckDefaultsNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Tcp check defaults not found response
func (o *ReplaceTCPCheckDefaultsNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceTCPCheckDefaultsNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Tcp check defaults not found response
func (o *ReplaceTCPCheckDefaultsNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Tcp check defaults not found response
func (o *ReplaceTCPCheckDefaultsNotFound) WithPayload(payload *models.Error) *ReplaceTCPCheckDefaultsNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp check defaults not found response
func (o *ReplaceTCPCheckDefaultsNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPCheckDefaultsNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceTCPCheckDefaultsDefault General Error

swagger:response replaceTcpCheckDefaultsDefault
*/
type ReplaceTCPCheckDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceTCPCheckDefaultsDefault creates ReplaceTCPCheckDefaultsDefault with default headers values
func NewReplaceTCPCheckDefaultsDefault(code int) *ReplaceTCPCheckDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceTCPCheckDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace TCP check defaults default response
func (o *ReplaceTCPCheckDefaultsDefault) WithStatusCode(code int) *ReplaceTCPCheckDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace TCP check defaults default response
func (o *ReplaceTCPCheckDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace TCP check defaults default response
func (o *ReplaceTCPCheckDefaultsDefault) WithConfigurationVersion(configurationVersion string) *ReplaceTCPCheckDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace TCP check defaults default response
func (o *ReplaceTCPCheckDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace TCP check defaults default response
func (o *ReplaceTCPCheckDefaultsDefault) WithPayload(payload *models.Error) *ReplaceTCPCheckDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace TCP check defaults default response
func (o *ReplaceTCPCheckDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPCheckDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
