/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.tools.I18n;

public enum ComparePairType {
    MY_WITH_THEIR(I18n.tr("My with Their", new Object[0]), ListRole.MY_ENTRIES, ListRole.THEIR_ENTRIES),
    MY_WITH_MERGED(I18n.tr("My with Merged", new Object[0]), ListRole.MY_ENTRIES, ListRole.MERGED_ENTRIES),
    THEIR_WITH_MERGED(I18n.tr("Their with Merged", new Object[0]), ListRole.THEIR_ENTRIES, ListRole.MERGED_ENTRIES);

    private final String displayName;
    private final ListRole participatingRole1;
    private final ListRole participatingRole2;

    private ComparePairType(String displayName, ListRole participatingRole1, ListRole participatingRole2) {
        this.displayName = displayName;
        this.participatingRole1 = participatingRole1;
        this.participatingRole2 = participatingRole2;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isParticipatingIn(ListRole role) {
        return this.participatingRole1 == role || this.participatingRole2 == role;
    }

    public ListRole[] getParticipatingRoles() {
        return new ListRole[]{this.participatingRole1, this.participatingRole2};
    }

    public ListRole getOppositeRole(ListRole role) {
        if (!this.isParticipatingIn(role)) {
            throw new IllegalStateException(I18n.tr("Role {0} is not participating in compare pair {1}.", role.toString(), this.toString()));
        }
        return this.participatingRole1 == role ? this.participatingRole2 : this.participatingRole1;
    }
}

