// Generated by gir (https://github.com/gtk-rs/gir @ d7c0763cacbc)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git @ 4d1189172a70)
// DO NOT EDIT

#![cfg(unix)]

use libshumate_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::{Command, Stdio};
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["shumate-1.0"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {cmd:?} failed, {status}").into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{name} {err}").into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing ';' separator");
        c_constants.push((name.to_owned(), value.to_owned()));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {rust_name}\nRust: {rust_value:?}\nC:    {c_value:?}",
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing first ';' separator");
        let (size, alignment) = value.split_once(';').expect("Missing second ';' separator");
        let size = size.parse().expect("Failed to parse size");
        let alignment = alignment.parse().expect("Failed to parse alignment");
        c_layouts.push((name.to_owned(), Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!("Layout mismatch for {rust_name}\nRust: {rust_layout:?}\nC:    {c_layout:?}",);
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut cmd = Command::new(exe);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }

    Ok(String::from_utf8(out.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "ShumateCompassClass",
        Layout {
            size: size_of::<ShumateCompassClass>(),
            alignment: align_of::<ShumateCompassClass>(),
        },
    ),
    (
        "ShumateCoordinate",
        Layout {
            size: size_of::<ShumateCoordinate>(),
            alignment: align_of::<ShumateCoordinate>(),
        },
    ),
    (
        "ShumateCoordinateClass",
        Layout {
            size: size_of::<ShumateCoordinateClass>(),
            alignment: align_of::<ShumateCoordinateClass>(),
        },
    ),
    (
        "ShumateDataSource",
        Layout {
            size: size_of::<ShumateDataSource>(),
            alignment: align_of::<ShumateDataSource>(),
        },
    ),
    (
        "ShumateDataSourceClass",
        Layout {
            size: size_of::<ShumateDataSourceClass>(),
            alignment: align_of::<ShumateDataSourceClass>(),
        },
    ),
    (
        "ShumateDataSourceRequest",
        Layout {
            size: size_of::<ShumateDataSourceRequest>(),
            alignment: align_of::<ShumateDataSourceRequest>(),
        },
    ),
    (
        "ShumateDataSourceRequestClass",
        Layout {
            size: size_of::<ShumateDataSourceRequestClass>(),
            alignment: align_of::<ShumateDataSourceRequestClass>(),
        },
    ),
    (
        "ShumateFileCacheClass",
        Layout {
            size: size_of::<ShumateFileCacheClass>(),
            alignment: align_of::<ShumateFileCacheClass>(),
        },
    ),
    (
        "ShumateFileCacheError",
        Layout {
            size: size_of::<ShumateFileCacheError>(),
            alignment: align_of::<ShumateFileCacheError>(),
        },
    ),
    (
        "ShumateGeometryType",
        Layout {
            size: size_of::<ShumateGeometryType>(),
            alignment: align_of::<ShumateGeometryType>(),
        },
    ),
    (
        "ShumateLayer",
        Layout {
            size: size_of::<ShumateLayer>(),
            alignment: align_of::<ShumateLayer>(),
        },
    ),
    (
        "ShumateLayerClass",
        Layout {
            size: size_of::<ShumateLayerClass>(),
            alignment: align_of::<ShumateLayerClass>(),
        },
    ),
    (
        "ShumateLicenseClass",
        Layout {
            size: size_of::<ShumateLicenseClass>(),
            alignment: align_of::<ShumateLicenseClass>(),
        },
    ),
    (
        "ShumateLocationInterface",
        Layout {
            size: size_of::<ShumateLocationInterface>(),
            alignment: align_of::<ShumateLocationInterface>(),
        },
    ),
    (
        "ShumateMapClass",
        Layout {
            size: size_of::<ShumateMapClass>(),
            alignment: align_of::<ShumateMapClass>(),
        },
    ),
    (
        "ShumateMapLayerClass",
        Layout {
            size: size_of::<ShumateMapLayerClass>(),
            alignment: align_of::<ShumateMapLayerClass>(),
        },
    ),
    (
        "ShumateMapProjection",
        Layout {
            size: size_of::<ShumateMapProjection>(),
            alignment: align_of::<ShumateMapProjection>(),
        },
    ),
    (
        "ShumateMapSource",
        Layout {
            size: size_of::<ShumateMapSource>(),
            alignment: align_of::<ShumateMapSource>(),
        },
    ),
    (
        "ShumateMapSourceClass",
        Layout {
            size: size_of::<ShumateMapSourceClass>(),
            alignment: align_of::<ShumateMapSourceClass>(),
        },
    ),
    (
        "ShumateMapSourceRegistryClass",
        Layout {
            size: size_of::<ShumateMapSourceRegistryClass>(),
            alignment: align_of::<ShumateMapSourceRegistryClass>(),
        },
    ),
    (
        "ShumateMarker",
        Layout {
            size: size_of::<ShumateMarker>(),
            alignment: align_of::<ShumateMarker>(),
        },
    ),
    (
        "ShumateMarkerClass",
        Layout {
            size: size_of::<ShumateMarkerClass>(),
            alignment: align_of::<ShumateMarkerClass>(),
        },
    ),
    (
        "ShumateMarkerLayerClass",
        Layout {
            size: size_of::<ShumateMarkerLayerClass>(),
            alignment: align_of::<ShumateMarkerLayerClass>(),
        },
    ),
    (
        "ShumatePathLayerClass",
        Layout {
            size: size_of::<ShumatePathLayerClass>(),
            alignment: align_of::<ShumatePathLayerClass>(),
        },
    ),
    (
        "ShumatePointClass",
        Layout {
            size: size_of::<ShumatePointClass>(),
            alignment: align_of::<ShumatePointClass>(),
        },
    ),
    (
        "ShumateRasterRendererClass",
        Layout {
            size: size_of::<ShumateRasterRendererClass>(),
            alignment: align_of::<ShumateRasterRendererClass>(),
        },
    ),
    (
        "ShumateScaleClass",
        Layout {
            size: size_of::<ShumateScaleClass>(),
            alignment: align_of::<ShumateScaleClass>(),
        },
    ),
    (
        "ShumateSimpleMapClass",
        Layout {
            size: size_of::<ShumateSimpleMapClass>(),
            alignment: align_of::<ShumateSimpleMapClass>(),
        },
    ),
    (
        "ShumateState",
        Layout {
            size: size_of::<ShumateState>(),
            alignment: align_of::<ShumateState>(),
        },
    ),
    (
        "ShumateStyleError",
        Layout {
            size: size_of::<ShumateStyleError>(),
            alignment: align_of::<ShumateStyleError>(),
        },
    ),
    (
        "ShumateSymbolEventClass",
        Layout {
            size: size_of::<ShumateSymbolEventClass>(),
            alignment: align_of::<ShumateSymbolEventClass>(),
        },
    ),
    (
        "ShumateTileClass",
        Layout {
            size: size_of::<ShumateTileClass>(),
            alignment: align_of::<ShumateTileClass>(),
        },
    ),
    (
        "ShumateTileDownloaderClass",
        Layout {
            size: size_of::<ShumateTileDownloaderClass>(),
            alignment: align_of::<ShumateTileDownloaderClass>(),
        },
    ),
    (
        "ShumateTileDownloaderError",
        Layout {
            size: size_of::<ShumateTileDownloaderError>(),
            alignment: align_of::<ShumateTileDownloaderError>(),
        },
    ),
    (
        "ShumateUnit",
        Layout {
            size: size_of::<ShumateUnit>(),
            alignment: align_of::<ShumateUnit>(),
        },
    ),
    (
        "ShumateVectorReaderClass",
        Layout {
            size: size_of::<ShumateVectorReaderClass>(),
            alignment: align_of::<ShumateVectorReaderClass>(),
        },
    ),
    (
        "ShumateVectorReaderIterClass",
        Layout {
            size: size_of::<ShumateVectorReaderIterClass>(),
            alignment: align_of::<ShumateVectorReaderIterClass>(),
        },
    ),
    (
        "ShumateVectorRendererClass",
        Layout {
            size: size_of::<ShumateVectorRendererClass>(),
            alignment: align_of::<ShumateVectorRendererClass>(),
        },
    ),
    (
        "ShumateVectorSpriteClass",
        Layout {
            size: size_of::<ShumateVectorSpriteClass>(),
            alignment: align_of::<ShumateVectorSpriteClass>(),
        },
    ),
    (
        "ShumateVectorSpriteSheetClass",
        Layout {
            size: size_of::<ShumateVectorSpriteSheetClass>(),
            alignment: align_of::<ShumateVectorSpriteSheetClass>(),
        },
    ),
    (
        "ShumateViewportClass",
        Layout {
            size: size_of::<ShumateViewportClass>(),
            alignment: align_of::<ShumateViewportClass>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) SHUMATE_FILE_CACHE_ERROR_FAILED", "0"),
    ("(gint) SHUMATE_GEOMETRY_TYPE_LINESTRING", "3"),
    ("(gint) SHUMATE_GEOMETRY_TYPE_MULTILINESTRING", "4"),
    ("(gint) SHUMATE_GEOMETRY_TYPE_MULTIPOINT", "2"),
    ("(gint) SHUMATE_GEOMETRY_TYPE_MULTIPOLYGON", "6"),
    ("(gint) SHUMATE_GEOMETRY_TYPE_POINT", "1"),
    ("(gint) SHUMATE_GEOMETRY_TYPE_POLYGON", "5"),
    ("(gint) SHUMATE_GEOMETRY_TYPE_UNKNOWN", "0"),
    ("SHUMATE_MAJOR_VERSION", "1"),
    ("(gint) SHUMATE_MAP_PROJECTION_MERCATOR", "0"),
    ("SHUMATE_MAP_SOURCE_MFF_RELIEF", "mff-relief"),
    ("SHUMATE_MAP_SOURCE_OSM_CYCLE_MAP", "osm-cyclemap"),
    ("SHUMATE_MAP_SOURCE_OSM_MAPNIK", "osm-mapnik"),
    ("SHUMATE_MAP_SOURCE_OSM_TRANSPORT_MAP", "osm-transportmap"),
    ("SHUMATE_MAP_SOURCE_OWM_CLOUDS", "owm-clouds"),
    ("SHUMATE_MAP_SOURCE_OWM_PRECIPITATION", "owm-precipitation"),
    ("SHUMATE_MAP_SOURCE_OWM_PRESSURE", "owm-pressure"),
    ("SHUMATE_MAP_SOURCE_OWM_TEMPERATURE", "owm-temperature"),
    ("SHUMATE_MAP_SOURCE_OWM_WIND", "owm-wind"),
    ("SHUMATE_MAX_LATITUDE", "85.0511287798"),
    ("SHUMATE_MAX_LONGITUDE", "180.0"),
    ("SHUMATE_MIN_LATITUDE", "-85.0511287798"),
    ("SHUMATE_MIN_LONGITUDE", "-180.0"),
    ("(gint) SHUMATE_STATE_DONE", "3"),
    ("(gint) SHUMATE_STATE_LOADED", "2"),
    ("(gint) SHUMATE_STATE_LOADING", "1"),
    ("(gint) SHUMATE_STATE_NONE", "0"),
    ("(gint) SHUMATE_STYLE_ERROR_FAILED", "0"),
    ("(gint) SHUMATE_STYLE_ERROR_INVALID_EXPRESSION", "3"),
    ("(gint) SHUMATE_STYLE_ERROR_MALFORMED_STYLE", "1"),
    ("(gint) SHUMATE_STYLE_ERROR_SUPPORT_OMITTED", "4"),
    ("(gint) SHUMATE_STYLE_ERROR_UNSUPPORTED", "5"),
    ("(gint) SHUMATE_STYLE_ERROR_UNSUPPORTED_LAYER", "2"),
    ("(gint) SHUMATE_TILE_DOWNLOADER_ERROR_BAD_RESPONSE", "1"),
    (
        "(gint) SHUMATE_TILE_DOWNLOADER_ERROR_COULD_NOT_CONNECT",
        "2",
    ),
    ("(gint) SHUMATE_TILE_DOWNLOADER_ERROR_FAILED", "0"),
    ("(gint) SHUMATE_TILE_DOWNLOADER_ERROR_MALFORMED_URL", "3"),
    ("(gint) SHUMATE_TILE_DOWNLOADER_ERROR_OFFLINE", "4"),
    ("(gint) SHUMATE_UNIT_BOTH", "0"),
    ("(gint) SHUMATE_UNIT_IMPERIAL", "2"),
    ("(gint) SHUMATE_UNIT_METRIC", "1"),
];
