SYD-EMACS(1)

# NAME

syd-emacs - convenience wrapper to run Emacs under Syd

# SYNOPSIS

*syd-emacs* _[command-line switches]_ _[files...]_

# DESCRIPTION

*syd-emacs* is a convenience wrapper to run Emacs under Syd.
All command-line arguments are passed directly to _emacs_(1).

# FILES

|[ /dev/syd.el
:< Emacs Lisp _syd_(2) API library.
| 
:< Access assumes sandbox lock is accessible, ie "lock:off" or "lock:exec".
|[ ~/.emacs.d/init.syd-3
:< Emacs Syd profile, if this file does not exist, the "lib" profile is used instead.
| 
:< Note, the "lib" profile turns all sandboxing off and sets "lock:exec" to allow access to the virtual file "/dev/syd.el".
| 
:< If you do not want to turn all sandboxing off, you're encouraged to configure a profile with this file.
| 
:< Ensure to add "lock:exec" in the end so that the initial _emacs_(1) process can access the sandbox to load "/dev/syd.el".
| 
:< Ensure to call "(syd-lock :lock-on)" from within _emacs_(1) when you're done configuring _syd_(1) using the _syd_(2) API.
| 
:< If you do not want to allow access to the sandbox lock, you're encouraged to call _syd_(1) manually with _emacs_(1).
| 
:< This is just a convenience wrapper.
|[ ~/.emacs.d/syd.log
:< Emacs Syd log file, access violations are logged to this file.
| 
:< _syd-emacs_(1) opens this file, and sets *SYD_LOG_FD* environment variable to the value of the file descriptor.
| 
:< The file is opened for create+append-only.

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5), _emacs_(1)

*syd* homepage: https://sydbox.exherbo.org/

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
