/*
 * Decompiled with CFR 0.152.
 */
package zmq.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class MultiMap<K extends Comparable<? super K>, V> {
    private final Comparator<? super Map.Entry<V, K>> comparator = new EntryComparator();
    private final Map<K, List<V>> data = new HashMap<K, List<V>>();
    private final Map<V, K> inverse = new HashMap<V, K>();

    public void clear() {
        this.data.clear();
        this.inverse.clear();
    }

    public Collection<Map.Entry<V, K>> entries() {
        ArrayList<Map.Entry<V, K>> list = new ArrayList<Map.Entry<V, K>>(this.inverse.entrySet());
        list.sort(this.comparator);
        return list;
    }

    @Deprecated
    public Collection<V> values() {
        return this.inverse.keySet();
    }

    public boolean contains(V value) {
        return this.inverse.containsKey(value);
    }

    public K key(V value) {
        return (K)((Comparable)this.inverse.get(value));
    }

    public V find(V copy) {
        Comparable key2 = (Comparable)this.inverse.get(copy);
        if (key2 != null) {
            List<V> list = this.data.get(key2);
            return list.get(list.indexOf(copy));
        }
        return null;
    }

    public boolean hasValues(K key2) {
        List<V> list = this.data.get(key2);
        if (list == null) {
            return false;
        }
        return !list.isEmpty();
    }

    public boolean isEmpty() {
        return this.inverse.isEmpty();
    }

    private List<V> getValues(K key2) {
        return this.data.computeIfAbsent((Comparable)key2, (Function<Comparable, List<List>>)((Function<Comparable, List>)k -> new ArrayList()));
    }

    public boolean insert(K key2, V value) {
        boolean inserted;
        Comparable old = (Comparable)this.inverse.get(value);
        if (old != null) {
            boolean rc = this.removeData(old, value);
            assert (rc);
        }
        if (inserted = this.getValues(key2).add(value)) {
            this.inverse.put(value, key2);
        } else {
            this.inverse.remove(value);
        }
        return inserted;
    }

    public Collection<V> remove(K key2) {
        List<V> removed = this.data.remove(key2);
        if (removed != null) {
            for (V val : removed) {
                this.inverse.remove(val);
            }
        }
        return removed;
    }

    public boolean remove(V value) {
        Comparable key2 = (Comparable)this.inverse.remove(value);
        if (key2 != null) {
            return this.removeData(key2, value);
        }
        return false;
    }

    public boolean remove(K key2, V value) {
        boolean removed = this.removeData(key2, value);
        if (removed) {
            this.inverse.remove(value);
        }
        return removed;
    }

    private boolean removeData(K key2, V value) {
        boolean removed = false;
        List<V> list = this.data.get(key2);
        if (list != null) {
            removed = list.remove(value);
            if (list.isEmpty()) {
                this.data.remove(key2);
            }
        }
        return removed;
    }

    public String toString() {
        return this.data.toString();
    }

    private final class EntryComparator
    implements Comparator<Map.Entry<V, K>> {
        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<V, K> first, Map.Entry<V, K> second) {
            return ((Comparable)first.getValue()).compareTo(second.getValue());
        }
    }
}

