/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.mechanism.curve;

import java.nio.ByteBuffer;
import zmq.Msg;
import zmq.Options;
import zmq.ZMQ;
import zmq.io.SessionBase;
import zmq.io.mechanism.Mechanism;
import zmq.io.mechanism.Mechanisms;
import zmq.io.mechanism.curve.Curve;
import zmq.io.net.Address;
import zmq.util.Errno;
import zmq.util.Wire;

public class CurveServerMechanism
extends Mechanism {
    private long cnNonce = 1L;
    private long cnPeerNonce = 1L;
    private final byte[] secretKey;
    private final byte[] cnPublic;
    private final byte[] cnSecret;
    private final byte[] cnClient = new byte[Curve.Size.PUBLICKEY.bytes()];
    private byte[] cookieKey;
    private final byte[] cnPrecom = new byte[Curve.Size.BEFORENM.bytes()];
    private State state = State.EXPECT_HELLO;
    private final Curve cryptoBox;
    private final Errno errno;

    public CurveServerMechanism(SessionBase session, Address peerAddress, Options options2) {
        super(session, peerAddress, options2);
        this.secretKey = options2.curveSecretKey;
        assert (this.secretKey != null && this.secretKey.length == Curve.Size.SECRETKEY.bytes());
        this.cryptoBox = new Curve();
        byte[][] keys = this.cryptoBox.keypair();
        assert (keys != null && keys.length == 2);
        this.cnPublic = keys[0];
        assert (this.cnPublic != null && this.cnPublic.length == Curve.Size.PUBLICKEY.bytes());
        this.cnSecret = keys[1];
        assert (this.cnSecret != null && this.cnSecret.length == Curve.Size.SECRETKEY.bytes());
        this.errno = options2.errno;
    }

    @Override
    public int nextHandshakeCommand(Msg msg) {
        int rc;
        switch (this.state.ordinal()) {
            case 1: {
                rc = this.produceWelcome(msg);
                if (rc != 0) break;
                this.state = State.EXPECT_INITIATE;
                break;
            }
            case 4: {
                rc = this.produceReady(msg);
                if (rc != 0) break;
                this.state = State.CONNECTED;
                break;
            }
            case 5: {
                rc = this.produceError(msg);
                if (rc != 0) break;
                this.state = State.ERROR_SENT;
                break;
            }
            default: {
                rc = 35;
            }
        }
        return rc;
    }

    @Override
    public int processHandshakeCommand(Msg msg) {
        int rc;
        switch (this.state.ordinal()) {
            case 0: {
                rc = this.processHello(msg);
                break;
            }
            case 2: {
                rc = this.processInitiate(msg);
                break;
            }
            default: {
                this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000000);
                rc = 156384820;
            }
        }
        return rc;
    }

    @Override
    public Msg encode(Msg msg) {
        assert (this.state == State.CONNECTED);
        byte flags = 0;
        if (msg.hasMore()) {
            flags = (byte)(flags | 1);
        }
        if (msg.isCommand()) {
            flags = (byte)(flags | 2);
        }
        ByteBuffer messageNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        messageNonce.put("CurveZMQMESSAGES".getBytes(ZMQ.CHARSET));
        Wire.putUInt64(messageNonce, this.cnNonce);
        int mlen = Curve.Size.ZERO.bytes() + 1 + msg.size();
        ByteBuffer messagePlaintext = ByteBuffer.allocate(mlen);
        messagePlaintext.put(Curve.Size.ZERO.bytes(), flags);
        messagePlaintext.position(Curve.Size.ZERO.bytes() + 1);
        msg.transfer(messagePlaintext, 0, msg.size());
        ByteBuffer messageBox = ByteBuffer.allocate(mlen);
        int rc = this.cryptoBox.afternm(messageBox, messagePlaintext, mlen, messageNonce, this.cnPrecom);
        assert (rc == 0);
        Msg encoded = new Msg(16 + mlen - Curve.Size.BOXZERO.bytes());
        encoded.putShortString("MESSAGE");
        encoded.put(messageNonce, 16, 8);
        encoded.put(messageBox, Curve.Size.BOXZERO.bytes(), mlen - Curve.Size.BOXZERO.bytes());
        ++this.cnNonce;
        return encoded;
    }

    @Override
    public Msg decode(Msg msg) {
        assert (this.state == State.CONNECTED);
        if (!this.compare(msg, "MESSAGE", true)) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000001);
            this.errno.set(156384820);
            return null;
        }
        if (msg.size() < 33) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000012);
            this.errno.set(156384820);
            return null;
        }
        ByteBuffer messageNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        messageNonce.put("CurveZMQMESSAGEC".getBytes(ZMQ.CHARSET));
        msg.transfer(messageNonce, 8, 8);
        long nonce = msg.getLong(8);
        if (nonce <= this.cnPeerNonce) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000002);
            this.errno.set(156384820);
            return null;
        }
        this.cnPeerNonce = nonce;
        int clen = Curve.Size.BOXZERO.bytes() + msg.size() - 16;
        ByteBuffer messagePlaintext = ByteBuffer.allocate(clen);
        ByteBuffer messageBox = ByteBuffer.allocate(clen);
        messageBox.position(Curve.Size.BOXZERO.bytes());
        msg.transfer(messageBox, 16, msg.size() - 16);
        int rc = this.cryptoBox.openAfternm(messagePlaintext, messageBox, clen, messageNonce, this.cnPrecom);
        if (rc == 0) {
            Msg decoded = new Msg(clen - 1 - Curve.Size.ZERO.bytes());
            byte flags = messagePlaintext.get(Curve.Size.ZERO.bytes());
            if ((flags & 1) != 0) {
                decoded.setFlags(1);
            }
            if ((flags & 2) != 0) {
                decoded.setFlags(2);
            }
            messagePlaintext.position(Curve.Size.ZERO.bytes() + 1);
            decoded.put(messagePlaintext);
            return decoded;
        }
        this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x11000001);
        this.errno.set(156384820);
        return null;
    }

    @Override
    public int zapMsgAvailable() {
        if (this.state != State.EXPECT_ZAP_REPLY) {
            return 156384763;
        }
        int rc = this.receiveAndProcessZapReply();
        if (rc == 0) {
            this.state = "200".equals(this.statusCode) ? State.SEND_READY : State.SEND_ERROR;
        }
        return rc;
    }

    @Override
    public Mechanism.Status status() {
        if (this.state == State.CONNECTED) {
            return Mechanism.Status.READY;
        }
        if (this.state == State.ERROR_SENT) {
            return Mechanism.Status.ERROR;
        }
        return Mechanism.Status.HANDSHAKING;
    }

    private int processHello(Msg msg) {
        if (!this.compare(msg, "HELLO", true)) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000001);
            return 156384820;
        }
        if (msg.size() != 200) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000013);
            return 156384820;
        }
        byte major = msg.get(6);
        byte minor = msg.get(7);
        if (major != 1 || minor != 0) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000013);
            return 156384820;
        }
        msg.getBytes(80, this.cnClient, 0, Curve.Size.PUBLICKEY.bytes());
        ByteBuffer helloNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        ByteBuffer helloPlaintext = ByteBuffer.allocate(Curve.Size.ZERO.bytes() + 64);
        ByteBuffer helloBox = ByteBuffer.allocate(Curve.Size.BOXZERO.bytes() + 80);
        helloNonce.put("CurveZMQHELLO---".getBytes(ZMQ.CHARSET));
        msg.transfer(helloNonce, 112, 8);
        this.cnPeerNonce = msg.getLong(112);
        helloBox.position(Curve.Size.BOXZERO.bytes());
        msg.transfer(helloBox, 120, 80);
        int rc = this.cryptoBox.open(helloPlaintext, helloBox, helloBox.capacity(), helloNonce, this.cnClient, this.secretKey);
        if (rc != 0) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x11000001);
            this.state = State.SEND_ERROR;
            this.statusCode = null;
            return 0;
        }
        this.state = State.SEND_WELCOME;
        return 0;
    }

    private int produceWelcome(Msg msg) {
        ByteBuffer cookieNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        ByteBuffer cookiePlaintext = ByteBuffer.allocate(Curve.Size.ZERO.bytes() + 64);
        ByteBuffer cookieCiphertext = ByteBuffer.allocate(Curve.Size.BOXZERO.bytes() + 80);
        cookieNonce.put("COOKIE--".getBytes(ZMQ.CHARSET));
        cookieNonce.put(this.cryptoBox.random(16));
        cookiePlaintext.position(Curve.Size.ZERO.bytes());
        cookiePlaintext.put(this.cnClient);
        cookiePlaintext.put(this.cnSecret);
        this.cookieKey = this.cryptoBox.random(Curve.Size.KEY.bytes());
        int rc = this.cryptoBox.secretbox(cookieCiphertext, cookiePlaintext, cookiePlaintext.capacity(), cookieNonce, this.cookieKey);
        assert (rc == 0);
        ByteBuffer welcomeNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        ByteBuffer welcomePlaintext = ByteBuffer.allocate(Curve.Size.ZERO.bytes() + 128);
        ByteBuffer welcomeCiphertext = ByteBuffer.allocate(Curve.Size.BOXZERO.bytes() + 144);
        welcomeNonce.put("WELCOME-".getBytes(ZMQ.CHARSET));
        welcomeNonce.put(this.cryptoBox.random(Curve.Size.NONCE.bytes() - 8));
        welcomePlaintext.position(Curve.Size.ZERO.bytes());
        welcomePlaintext.put(this.cnPublic);
        cookieNonce.limit(24).position(8);
        welcomePlaintext.put(cookieNonce);
        cookieCiphertext.limit(Curve.Size.BOXZERO.bytes() + 80).position(Curve.Size.BOXZERO.bytes());
        welcomePlaintext.put(cookieCiphertext);
        rc = this.cryptoBox.box(welcomeCiphertext, welcomePlaintext, welcomePlaintext.capacity(), welcomeNonce, this.cnClient, this.secretKey);
        if (rc == -1) {
            return -1;
        }
        msg.putShortString("WELCOME");
        msg.put(welcomeNonce, 8, 16);
        msg.put(welcomeCiphertext, Curve.Size.BOXZERO.bytes(), 144);
        assert (msg.size() == 168);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int processInitiate(Msg msg) {
        if (!this.compare(msg, "INITIATE", true)) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000001);
            return 156384820;
        }
        if (msg.size() < 257) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000014);
            return 156384820;
        }
        ByteBuffer cookieNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        ByteBuffer cookiePlaintext = ByteBuffer.allocate(Curve.Size.ZERO.bytes() + 64);
        ByteBuffer cookieBox = ByteBuffer.allocate(Curve.Size.BOXZERO.bytes() + 80);
        cookieBox.position(Curve.Size.BOXZERO.bytes());
        msg.transfer(cookieBox, 25, 80);
        cookieNonce.put("COOKIE--".getBytes(ZMQ.CHARSET));
        msg.transfer(cookieNonce, 9, 16);
        int rc = this.cryptoBox.secretboxOpen(cookiePlaintext, cookieBox, cookieBox.capacity(), cookieNonce, this.cookieKey);
        if (rc != 0) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x11000001);
            return 156384820;
        }
        if (!this.compare(cookiePlaintext, this.cnClient, Curve.Size.ZERO.bytes(), 32) || !this.compare(cookiePlaintext, this.cnSecret, Curve.Size.ZERO.bytes() + 32, 32)) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x11000001);
            return 156384820;
        }
        int clen = msg.size() - 113 + Curve.Size.BOXZERO.bytes();
        ByteBuffer initiateNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        ByteBuffer initiatePlaintext = ByteBuffer.allocate(Curve.Size.ZERO.bytes() + 128 + 256);
        ByteBuffer initiateBox = ByteBuffer.allocate(Curve.Size.BOXZERO.bytes() + 144 + 256);
        initiateBox.position(Curve.Size.BOXZERO.bytes());
        msg.transfer(initiateBox, 113, clen - Curve.Size.BOXZERO.bytes());
        initiateNonce.put("CurveZMQINITIATE".getBytes(ZMQ.CHARSET));
        msg.transfer(initiateNonce, 105, 8);
        this.cnPeerNonce = msg.getLong(105);
        rc = this.cryptoBox.open(initiatePlaintext, initiateBox, clen, initiateNonce, this.cnClient, this.cnSecret);
        if (rc != 0) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x11000001);
            return 156384820;
        }
        byte[] clientKey = new byte[384];
        initiatePlaintext.position(Curve.Size.ZERO.bytes());
        initiatePlaintext.get(clientKey);
        ByteBuffer vouchNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        ByteBuffer vouchPlaintext = ByteBuffer.allocate(Curve.Size.ZERO.bytes() + 64);
        ByteBuffer vouchBox = ByteBuffer.allocate(Curve.Size.BOXZERO.bytes() + 80);
        vouchBox.position(Curve.Size.BOXZERO.bytes());
        initiatePlaintext.limit(Curve.Size.ZERO.bytes() + 48 + 80).position(Curve.Size.ZERO.bytes() + 48);
        vouchBox.put(initiatePlaintext);
        vouchNonce.put("VOUCH---".getBytes(ZMQ.CHARSET));
        initiatePlaintext.limit(Curve.Size.ZERO.bytes() + 32 + 16).position(Curve.Size.ZERO.bytes() + 32);
        vouchNonce.put(initiatePlaintext);
        rc = this.cryptoBox.open(vouchPlaintext, vouchBox, vouchBox.capacity(), vouchNonce, clientKey, this.cnSecret);
        if (rc != 0) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x11000001);
            return 156384820;
        }
        if (!this.compare(vouchPlaintext, this.cnClient, Curve.Size.ZERO.bytes(), 32)) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000003);
            return 156384820;
        }
        rc = this.cryptoBox.beforenm(this.cnPrecom, this.cnClient, this.cnSecret);
        assert (rc == 0);
        rc = this.session.zapConnect();
        if (rc == 0) {
            this.sendZapRequest(clientKey);
            rc = this.receiveAndProcessZapReply();
            if (rc == 0) {
                this.state = "200".equals(this.statusCode) ? State.SEND_READY : State.SEND_ERROR;
            } else {
                if (rc != 35) return -1;
                this.state = State.EXPECT_ZAP_REPLY;
            }
        } else {
            this.state = State.SEND_READY;
        }
        initiatePlaintext.position(0);
        initiatePlaintext.limit(clen);
        return this.parseMetadata(initiatePlaintext, Curve.Size.ZERO.bytes() + 128, false);
    }

    private int produceReady(Msg msg) {
        ByteBuffer readyNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        ByteBuffer readyPlaintext = ByteBuffer.allocate(Curve.Size.ZERO.bytes() + 256);
        ByteBuffer readyBox = ByteBuffer.allocate(Curve.Size.BOXZERO.bytes() + 16 + 256);
        readyPlaintext.position(Curve.Size.ZERO.bytes());
        String socketType = this.socketType();
        this.addProperty(readyPlaintext, "Socket-Type", socketType);
        if (this.options.type == 3 || this.options.type == 5 || this.options.type == 6) {
            this.addProperty(readyPlaintext, "Identity", this.options.identity);
        }
        int mlen = readyPlaintext.position();
        readyNonce.put("CurveZMQREADY---".getBytes(ZMQ.CHARSET));
        Wire.putUInt64(readyNonce, this.cnNonce);
        int rc = this.cryptoBox.afternm(readyBox, readyPlaintext, mlen, readyNonce, this.cnPrecom);
        assert (rc == 0);
        msg.putShortString("READY");
        msg.put(readyNonce, 16, 8);
        msg.put(readyBox, Curve.Size.BOXZERO.bytes(), mlen - Curve.Size.BOXZERO.bytes());
        assert (msg.size() == 14 + mlen - Curve.Size.BOXZERO.bytes());
        ++this.cnNonce;
        return 0;
    }

    private int produceError(Msg msg) {
        assert (this.statusCode == null || this.statusCode.length() == 3);
        msg.putShortString("ERROR");
        if (this.statusCode != null) {
            msg.putShortString(this.statusCode);
        } else {
            msg.putShortString("");
        }
        return 0;
    }

    private void sendZapRequest(byte[] key2) {
        this.sendZapRequest(Mechanisms.CURVE, true);
        Msg msg = new Msg(Curve.Size.PUBLICKEY.bytes());
        msg.put(key2, 0, Curve.Size.PUBLICKEY.bytes());
        boolean rc = this.session.writeZapMsg(msg);
        assert (rc);
    }

    private static enum State {
        EXPECT_HELLO,
        SEND_WELCOME,
        EXPECT_INITIATE,
        EXPECT_ZAP_REPLY,
        SEND_READY,
        SEND_ERROR,
        ERROR_SENT,
        CONNECTED;

    }
}

