/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.mechanism;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import zmq.Msg;
import zmq.Options;
import zmq.ZMQ;
import zmq.io.Metadata;
import zmq.io.Msgs;
import zmq.io.SessionBase;
import zmq.io.mechanism.Mechanisms;
import zmq.io.net.Address;
import zmq.socket.Sockets;
import zmq.util.Blob;
import zmq.util.Wire;

public abstract class Mechanism {
    protected final Options options;
    private Blob identity;
    private Blob userId;
    public final Metadata zapProperties = new Metadata();
    public final Metadata zmtpProperties = new Metadata();
    protected final SessionBase session;
    private final Address peerAddress;
    protected String statusCode;

    protected Mechanism(SessionBase session, Address peerAddress, Options options2) {
        this.session = session;
        this.options = options2;
        this.peerAddress = peerAddress;
    }

    public abstract Status status();

    private void setPeerIdentity(byte[] data) {
        this.identity = Blob.createBlob(data);
    }

    public final Msg peerIdentity() {
        byte[] data = new byte[]{};
        int size = 0;
        if (this.identity != null) {
            data = this.identity.data();
            size = this.identity.size();
        }
        Msg msg = new Msg(size);
        msg.put(data, 0, size);
        msg.setFlags(64);
        return msg;
    }

    private void setUserId(byte[] data) {
        this.userId = Blob.createBlob(data);
        this.zapProperties.put("User-Id", new String(data, ZMQ.CHARSET));
    }

    public final Blob getUserId() {
        return this.userId;
    }

    protected final void addProperty(ByteBuffer buf, String name, String value) {
        this.addProperty(buf, name, value.getBytes(ZMQ.CHARSET));
    }

    protected final void addProperty(Msg msg, String name, String value) {
        this.addProperty(msg, name, value.getBytes(ZMQ.CHARSET));
    }

    protected final void addProperty(ByteBuffer buf, String name, byte[] value) {
        byte[] nameB = name.getBytes(ZMQ.CHARSET);
        int nameLength = nameB.length;
        assert (nameLength <= 255);
        int valueLength = value == null ? 0 : value.length;
        buf.put((byte)nameLength);
        buf.put(nameB);
        Wire.putUInt32(buf, valueLength);
        if (value != null) {
            buf.put(value);
        }
    }

    protected final void addProperty(Msg msg, String name, byte[] value) {
        byte[] nameB = name.getBytes(ZMQ.CHARSET);
        int nameLength = nameB.length;
        assert (nameLength <= 255);
        int valueLength = value == null ? 0 : value.length;
        msg.put((byte)nameLength);
        msg.put(nameB);
        Wire.putUInt32(msg, valueLength);
        if (value != null) {
            msg.put(value);
        }
    }

    protected final int parseMetadata(Msg msg, int offset, boolean zapFlag) {
        return this.parseMetadata(msg.buf(), offset, zapFlag);
    }

    protected final int parseMetadata(ByteBuffer msg, int offset, boolean zapFlag) {
        Metadata meta = zapFlag ? this.zapProperties : this.zmtpProperties;
        return meta.read(msg, offset, (name, value, valueAsString) -> {
            int type2;
            int n = type2 = this.options.asType != -1 ? this.options.asType : this.options.type;
            if ("Identity".equals(name) && this.options.recvIdentity) {
                this.setPeerIdentity(value);
            } else if ("Socket-Type".equals(name)) {
                if (!Sockets.compatible(type2, valueAsString)) {
                    return 22;
                }
            } else {
                int rc = this.property(name, value);
                if (rc == -1) {
                    return -1;
                }
            }
            return 0;
        });
    }

    protected int property(String name, byte[] value) {
        return 0;
    }

    protected final String socketType() {
        if (this.options.asType != -1) {
            return Sockets.name(this.options.asType);
        }
        return Sockets.name(this.options.type);
    }

    protected boolean compare(Msg msg, String data, boolean includeLength) {
        return Msgs.startsWith(msg, data, includeLength);
    }

    protected boolean compare(ByteBuffer a1, byte[] b, int offset, int length) {
        if (length > b.length) {
            return false;
        }
        boolean comparison = true;
        for (int idx = 0; idx < length; ++idx) {
            boolean bl = comparison = a1.get(idx + offset) == b[idx];
            if (!comparison) break;
        }
        return comparison;
    }

    public Msg decode(Msg msg) {
        return msg;
    }

    public Msg encode(Msg msg) {
        return msg;
    }

    public abstract int zapMsgAvailable();

    public abstract int processHandshakeCommand(Msg var1);

    public abstract int nextHandshakeCommand(Msg var1);

    protected int parseErrorMessage(Msg msg) {
        if (msg.size() < 7 && msg.size() != 6) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000015);
            return 156384820;
        }
        if (msg.size() >= 7) {
            byte[] statusBuffer;
            String statusCode;
            byte errorReasonLength = msg.get(6);
            if (errorReasonLength > msg.size() - 7) {
                this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000015);
                return 156384820;
            }
            if (msg.size() == 10 && this.handleErrorReason(statusCode = new String(statusBuffer = Arrays.copyOfRange(msg.data(), 7, 10), ZMQ.CHARSET)) < 0) {
                return 156384820;
            }
        }
        return 0;
    }

    protected int handleErrorReason(String reason) {
        int rc = -1;
        if (reason.length() == 3 && reason.charAt(1) == '0' && reason.charAt(2) == '0' && reason.charAt(0) >= '3' && reason.charAt(0) <= '5') {
            try {
                int statusCode = Integer.parseInt(reason);
                this.session.getSocket().eventHandshakeFailedAuth(this.session.getEndpoint(), statusCode);
                rc = 0;
            }
            catch (NumberFormatException e) {
                this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x20000001);
            }
        } else {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x20000001);
        }
        return rc;
    }

    protected final void sendZapRequest(Mechanisms mechanism, boolean more) {
        assert (this.session != null);
        assert (this.peerAddress != null);
        assert (mechanism != null);
        Msg msg = new Msg();
        msg.setFlags(1);
        boolean rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(3);
        msg.setFlags(1);
        msg.put("1.0".getBytes(ZMQ.CHARSET));
        rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(1);
        msg.setFlags(1);
        msg.put("1".getBytes(ZMQ.CHARSET));
        rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(this.options.zapDomain.length());
        msg.setFlags(1);
        msg.put(this.options.zapDomain.getBytes(ZMQ.CHARSET));
        rc = this.session.writeZapMsg(msg);
        assert (rc);
        byte[] host2 = this.peerAddress.host().getBytes(ZMQ.CHARSET);
        msg = new Msg(host2.length);
        msg.setFlags(1);
        msg.put(host2);
        rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(this.options.identitySize);
        msg.setFlags(1);
        msg.put(this.options.identity, 0, (int)this.options.identitySize);
        rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(mechanism.name().length());
        msg.put(mechanism.name().getBytes(ZMQ.CHARSET));
        if (more) {
            msg.setFlags(1);
        }
        rc = this.session.writeZapMsg(msg);
        assert (rc);
    }

    protected final int receiveAndProcessZapReply() {
        assert (this.session != null);
        ArrayList<Msg> msgs = new ArrayList<Msg>(7);
        for (int idx = 0; idx < 7; ++idx) {
            Msg msg = this.session.readZapMsg();
            if (msg == null) {
                return this.session.errno.get();
            }
            if ((msg.flags() & 1) == (idx < 6 ? 0 : 1)) {
                this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x20000001);
                return 156384820;
            }
            msgs.add(msg);
        }
        if (((Msg)msgs.get(0)).size() > 0) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x20000000);
            return 156384820;
        }
        if (((Msg)msgs.get(1)).size() != 3 || !this.compare((Msg)msgs.get(1), "1.0", false)) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x20000003);
            return 156384820;
        }
        if (((Msg)msgs.get(2)).size() != 1 || !this.compare((Msg)msgs.get(2), "1", false)) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x20000002);
            return 156384820;
        }
        if (((Msg)msgs.get(3)).size() != 3) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x20000004);
            return 156384820;
        }
        this.statusCode = new String(((Msg)msgs.get(3)).data(), ZMQ.CHARSET);
        this.setUserId(((Msg)msgs.get(5)).data());
        return this.parseMetadata((Msg)msgs.get(6), 0, true);
    }

    public void destroy() {
    }

    public static enum Status {
        HANDSHAKING,
        READY,
        ERROR;

    }
}

