/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.zeromq.ZConfig;
import org.zeromq.ZMQ;
import zmq.io.Metadata;

public class ZMetadata {
    private final Metadata metadata;

    public ZMetadata() {
        this(new Metadata());
    }

    public ZMetadata(Metadata metadata2) {
        this.metadata = metadata2;
    }

    public Set<String> keySet() {
        return this.metadata.keySet();
    }

    public String get(String key2) {
        return this.metadata.get(key2);
    }

    public void set(String key2, String value) {
        this.metadata.put(key2, value);
    }

    public void remove(String key2) {
        this.metadata.remove(key2);
    }

    public byte[] bytes() {
        return this.metadata.bytes();
    }

    public String toString() {
        return this.metadata.toString();
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ZMetadata zMetadata = (ZMetadata)o2;
        return Objects.equals(this.metadata, zMetadata.metadata);
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.metadata.entrySet();
    }

    public Collection<String> values() {
        return this.metadata.values();
    }

    public void set(Metadata zapProperties) {
        this.metadata.set(zapProperties);
    }

    public boolean isEmpty() {
        return this.metadata.isEmpty();
    }

    public boolean containsKey(String property) {
        return this.metadata.containsKey(property);
    }

    public void clear() {
        this.metadata.clear();
    }

    public int size() {
        return this.metadata.size();
    }

    public void write(OutputStream stream) throws IOException {
        this.metadata.write(stream);
    }

    public static ZMetadata read(String meta) {
        if (meta == null || meta.isEmpty()) {
            return null;
        }
        try {
            ByteBuffer buffer = ZMQ.CHARSET.newEncoder().encode(CharBuffer.wrap(meta));
            Metadata data = new Metadata();
            data.read(buffer, 0, null);
            return new ZMetadata(data);
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("Not a parsable metadata string");
        }
    }

    public static ZMetadata read(ZConfig conf) {
        ZConfig meta = conf.getChild("metadata");
        if (meta == null) {
            return null;
        }
        ZMetadata metadata2 = new ZMetadata();
        for (Map.Entry<String, String> entry : meta.getValues().entrySet()) {
            metadata2.set(entry.getKey(), entry.getValue());
        }
        return metadata2;
    }
}

