/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.zeromq.Utils;
import org.zeromq.ZConfig;
import org.zeromq.ZMQ;
import org.zeromq.util.ZMetadata;

public class ZCert {
    private final byte[] publicKey;
    private final byte[] secretKey;
    private final String publicTxt;
    private final String secretTxt;
    private final ZMetadata metadata = new ZMetadata();

    public ZCert() {
        this(ZMQ.Curve.generateKeyPair());
    }

    public ZCert(String publicKey) {
        this(publicKey, null);
    }

    public ZCert(ZMQ.Curve.KeyPair keypair) {
        this(keypair.publicKey, keypair.secretKey);
    }

    public ZCert(byte[] publicKey, byte[] secretKey) {
        Utils.checkArgument(publicKey != null, "Public key has to be provided for a ZCert");
        this.assertKey(publicKey.length, 32, "Public");
        if (secretKey != null) {
            this.assertKey(secretKey.length, 32, "Secret");
        }
        this.publicKey = Arrays.copyOf(publicKey, publicKey.length);
        this.publicTxt = ZMQ.Curve.z85Encode(this.publicKey);
        if (secretKey == null) {
            this.secretKey = null;
            this.secretTxt = null;
        } else {
            this.secretKey = Arrays.copyOf(secretKey, secretKey.length);
            this.secretTxt = ZMQ.Curve.z85Encode(this.secretKey);
        }
    }

    public ZCert(String publicKey, String secretKey) {
        Utils.checkArgument(publicKey != null, "Public key has to be provided for a ZCert");
        this.assertKey(publicKey.length(), 40, "Public");
        if (secretKey != null) {
            this.assertKey(secretKey.length(), 40, "Secret");
        }
        this.publicKey = ZMQ.Curve.z85Decode(publicKey);
        this.publicTxt = publicKey;
        if (secretKey == null) {
            this.secretKey = null;
            this.secretTxt = null;
        } else {
            this.secretKey = ZMQ.Curve.z85Decode(secretKey);
            this.secretTxt = secretKey;
        }
    }

    private void assertKey(int length, int expected, String flavour) {
        Utils.checkArgument(length == expected, flavour + " key shall have a size of " + expected);
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public String getPublicKeyAsZ85() {
        return this.publicTxt;
    }

    public String getSecretKeyAsZ85() {
        return this.secretTxt;
    }

    public void apply(ZMQ.Socket socket) {
        socket.setCurvePublicKey(this.publicKey);
        socket.setCurveSecretKey(this.secretKey);
    }

    public ZMetadata getMetadata() {
        return this.metadata;
    }

    public void setMeta(String key2, String value) {
        this.metadata.set(key2, value);
    }

    public void unsetMeta(String key2) {
        this.metadata.remove(key2);
    }

    public String getMeta(String key2) {
        return this.metadata.get(key2);
    }

    private void add(ZMetadata meta, ZConfig config) {
        String now = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ENGLISH).format(new Date());
        config.addComment(String.format("** Generated on %1$s by ZCert **", now));
        for (Map.Entry<String, String> e : meta.entrySet()) {
            config.putValue("metadata/" + e.getKey(), e.getValue());
        }
    }

    public File savePublic(String filename) throws IOException {
        return this.publicConfig().save(filename);
    }

    public void savePublic(Writer writer) throws IOException {
        this.publicConfig().save(writer);
    }

    private ZConfig publicConfig() {
        ZConfig conf = new ZConfig("root", null);
        this.add(this.metadata, conf);
        conf.addComment("   ZeroMQ CURVE Public Certificate");
        conf.addComment("   Exchange securely, or use a secure mechanism to verify the contents");
        conf.addComment("   of this file after exchange. Store public certificates in your home");
        conf.addComment("   directory, in the .curve subdirectory.");
        conf.putValue("/curve/public-key", this.publicTxt);
        return conf;
    }

    public File saveSecret(String filename) throws IOException {
        return this.secretConfig().save(filename);
    }

    public void saveSecret(Writer writer) throws IOException {
        this.secretConfig().save(writer);
    }

    private ZConfig secretConfig() {
        ZConfig conf = new ZConfig("root", null);
        this.add(this.metadata, conf);
        conf.addComment("   ZeroMQ CURVE **Secret** Certificate");
        conf.addComment("   DO NOT PROVIDE THIS FILE TO OTHER USERS nor change its permissions.");
        conf.putValue("/curve/public-key", this.publicTxt);
        conf.putValue("/curve/secret-key", this.secretTxt);
        return conf;
    }
}

