/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.IOException;
import java.nio.channels.Selector;
import java.util.Arrays;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;
import org.zeromq.ZMsg;

public interface ZAgent {
    public ZMsg recv();

    public ZMsg recv(int var1);

    public ZMsg recv(boolean var1);

    public boolean send(ZMsg var1);

    public boolean send(ZMsg var1, boolean var2);

    public boolean send(String var1);

    public boolean send(String var1, boolean var2);

    public boolean sign();

    public ZMQ.Socket pipe();

    public void close();

    @Deprecated
    public static interface SelectorCreator {
        public Selector create() throws IOException;

        public void destroy(Selector var1) throws IOException;
    }

    public static final class SimpleAgent
    implements ZAgent {
        private final ZMQ.Socket pipe;
        private final byte[] lock;
        private boolean locked;

        public SimpleAgent(ZMQ.Socket pipe, String lock) {
            this.pipe = pipe;
            this.lock = lock == null ? null : lock.getBytes(ZMQ.CHARSET);
        }

        @Override
        public boolean sign() {
            return !this.locked;
        }

        @Override
        public void close() {
            this.locked = true;
            this.pipe.close();
        }

        @Override
        public ZMsg recv() {
            return this.recv(true);
        }

        @Override
        public ZMsg recv(int timeout) {
            int old = this.pipe.getReceiveTimeOut();
            this.pipe.setReceiveTimeOut(timeout);
            ZMsg msg = this.recv(true);
            this.pipe.setReceiveTimeOut(old);
            return msg;
        }

        @Override
        public ZMsg recv(boolean wait) {
            if (this.locked) {
                return null;
            }
            try {
                ZMsg msg = ZMsg.recvMsg(this.pipe, wait);
                if (msg == null) {
                    return null;
                }
                if (msg.size() == 1) {
                    ZFrame frame = msg.peek();
                    byte[] key2 = frame.getData();
                    if (this.lock != null && Arrays.equals(this.lock, key2)) {
                        this.locked = true;
                        msg = null;
                        this.pipe.close();
                    }
                }
                return msg;
            }
            catch (ZMQException e) {
                this.locked = true;
                return null;
            }
        }

        @Override
        public boolean send(ZMsg message2) {
            if (this.locked) {
                return false;
            }
            return message2.send(this.pipe);
        }

        @Override
        public boolean send(String word) {
            if (this.locked) {
                return false;
            }
            return this.pipe.send(word);
        }

        @Override
        public boolean send(String word, boolean more) {
            if (this.locked) {
                return false;
            }
            return this.pipe.send(word, more ? 2 : 0);
        }

        @Override
        public boolean send(ZMsg msg, boolean destroy) {
            if (this.locked) {
                return false;
            }
            return msg.send(this.pipe, destroy);
        }

        @Override
        public ZMQ.Socket pipe() {
            return this.pipe;
        }
    }

    public static class Creator {
        private Creator() {
        }

        public static ZAgent create(ZMQ.Socket pipe, String lock) {
            return new SimpleAgent(pipe, lock);
        }
    }
}

