/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.DisplayResult;
import org.jetbrains.kotlinx.jupyter.exceptions.ErrorLocation;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplEvalRuntimeException;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplException;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplExceptionKt;
import org.jetbrains.kotlinx.jupyter.messaging.AbortJupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.ErrorJupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteAbortReply;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteErrorReply;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteReplyMetadata;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteSuccessReply;
import org.jetbrains.kotlinx.jupyter.messaging.ExecutionResultMessage;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacilityKt;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternalKt;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterOutType;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactory;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageReplyContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageStatus;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.messaging.OkJupyterResponse;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocketBase;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageImplKt;
import org.jetbrains.kotlinx.jupyter.repl.EvaluatedSnippetMetadata;
import org.jetbrains.kotlinx.jupyter.util.SerializersKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a,\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a&\u0010\f\u001a\u00020\u0003*\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a,\u0010\u0011\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u000b\u001a\u0016\u0010\u0013\u001a\u00020\u0006*\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u001c\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a\u001c\u0010\u0017\u001a\u00020\u0018*\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001e"}, d2={"EXECUTION_INTERRUPTED_MESSAGE", "", "sendExecuteReply", "", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;", "response", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterResponse;", "executionCount", "Lorg/jetbrains/kotlinx/jupyter/messaging/ExecutionCount;", "startedTime", "sendExecuteReply-zEAq3HY", "(Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterResponse;ILjava/lang/String;)V", "sendExecuteResult", "result", "Lorg/jetbrains/kotlinx/jupyter/api/DisplayResult;", "sendExecuteResult-Qdt-JXo", "(Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;Lorg/jetbrains/kotlinx/jupyter/api/DisplayResult;I)V", "sendResponse", "sendResponse-zEAq3HY", "toErrorJupyterResponse", "", "metadata", "Lorg/jetbrains/kotlinx/jupyter/repl/EvaluatedSnippetMetadata;", "toExecuteErrorReply", "Lorg/jetbrains/kotlinx/jupyter/messaging/ExecuteErrorReply;", "Lorg/jetbrains/kotlinx/jupyter/exceptions/ReplEvalRuntimeException;", "toExecuteErrorReply-wNURfNM", "(Lorg/jetbrains/kotlinx/jupyter/exceptions/ReplEvalRuntimeException;I)Lorg/jetbrains/kotlinx/jupyter/messaging/ExecuteErrorReply;", "Lorg/jetbrains/kotlinx/jupyter/exceptions/ReplException;", "(Lorg/jetbrains/kotlinx/jupyter/exceptions/ReplException;I)Lorg/jetbrains/kotlinx/jupyter/messaging/ExecuteErrorReply;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nJupyterResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterResponse.kt\norg/jetbrains/kotlinx/jupyter/messaging/JupyterResponseKt\n+ 2 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n211#2:209\n1559#3:210\n1590#3,4:211\n1855#3,2:215\n288#3,2:217\n*S KotlinDebug\n*F\n+ 1 JupyterResponse.kt\norg/jetbrains/kotlinx/jupyter/messaging/JupyterResponseKt\n*L\n133#1:209\n175#1:210\n175#1:211,4\n186#1:215,2\n191#1:217,2\n*E\n"})
public final class JupyterResponseKt {
    @NotNull
    public static final String EXECUTION_INTERRUPTED_MESSAGE = "The execution was interrupted";

    public static final void sendResponse-zEAq3HY(@NotNull JupyterCommunicationFacility $this$sendResponse_u2dzEAq3HY, @NotNull JupyterResponse response2, int executionCount, @NotNull String startedTime) {
        Intrinsics.checkNotNullParameter((Object)$this$sendResponse_u2dzEAq3HY, (String)"$this$sendResponse");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)startedTime, (String)"startedTime");
        JupyterResponse jupyterResponse = response2;
        if (jupyterResponse instanceof AbortJupyterResponse) {
            String string = response2.getStdErr();
            Intrinsics.checkNotNull((Object)string);
            String errorMessage = string;
            JupyterCommunicationFacilityKt.sendOut($this$sendResponse_u2dzEAq3HY, JupyterOutType.STDERR, errorMessage);
        } else if (jupyterResponse instanceof ErrorJupyterResponse) {
            JupyterCommunicationFacilityKt.sendError-zEAq3HY($this$sendResponse_u2dzEAq3HY, response2, executionCount, startedTime);
        } else if (jupyterResponse instanceof OkJupyterResponse) {
            JupyterResponseKt.sendExecuteResult-Qdt-JXo($this$sendResponse_u2dzEAq3HY, response2.getDisplayResult(), executionCount);
        }
        JupyterResponseKt.sendExecuteReply-zEAq3HY($this$sendResponse_u2dzEAq3HY, response2, executionCount, startedTime);
    }

    public static final void sendExecuteResult-Qdt-JXo(@NotNull JupyterCommunicationFacility $this$sendExecuteResult_u2dQdt_u2dJXo, @Nullable DisplayResult result2, int executionCount) {
        Intrinsics.checkNotNullParameter((Object)$this$sendExecuteResult_u2dQdt_u2dJXo, (String)"$this$sendExecuteResult");
        if (result2 == null) {
            return;
        }
        JsonObject resultJson = result2.toJson(SerializersKt.getEMPTY((Json)Json.Default), null);
        JupyterSocketBase jupyterSocketBase = $this$sendExecuteResult_u2dQdt_u2dJXo.getSocketManager().getIopub();
        MessageFactory messageFactory = $this$sendExecuteResult_u2dQdt_u2dJXo.getMessageFactory();
        Object object = resultJson.get((Object)"data");
        Intrinsics.checkNotNull((Object)object);
        JsonElement jsonElement = (JsonElement)object;
        Object object2 = resultJson.get((Object)"metadata");
        Intrinsics.checkNotNull((Object)object2);
        JsonElement jsonElement2 = (JsonElement)object2;
        JupyterConnectionInternalKt.sendMessage(jupyterSocketBase, MessageFactoryKt.makeReplyMessage$default(messageFactory, MessageType.EXECUTE_RESULT, null, null, null, null, new ExecutionResultMessage(jsonElement, jsonElement2, executionCount, null), 30, null));
    }

    public static final void sendExecuteReply-zEAq3HY(@NotNull JupyterCommunicationFacility $this$sendExecuteReply_u2dzEAq3HY, @NotNull JupyterResponse response2, int executionCount, @NotNull String startedTime) {
        MessageContent messageContent;
        Intrinsics.checkNotNullParameter((Object)$this$sendExecuteReply_u2dzEAq3HY, (String)"$this$sendExecuteReply");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)startedTime, (String)"startedTime");
        ExecuteReplyMetadata replyMetadata = new ExecuteReplyMetadata(true, $this$sendExecuteReply_u2dzEAq3HY.getMessageFactory().getSessionId(), response2.getStatus(), startedTime, response2.getMetadata());
        Object object = response2.getException();
        if (object != null && (object = JupyterResponseKt.toExecuteErrorReply-wNURfNM((ReplException)object, executionCount)) != null) {
            messageContent = (MessageContent)object;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[response2.getStatus().ordinal()]) {
                case 1: {
                    messageContent = new ExecuteAbortReply();
                    break;
                }
                case 2: {
                    messageContent = JupyterCommunicationFacilityKt.toAbortErrorReply-l9ycbII(executionCount, response2.getStdErr());
                    break;
                }
                case 3: {
                    messageContent = new ExecuteSuccessReply(executionCount, null, null, null, 14, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        MessageContent replyContent = messageContent;
        MessageFactory messageFactory = $this$sendExecuteReply_u2dzEAq3HY.getMessageFactory();
        MessageType messageType = MessageType.EXECUTE_REPLY;
        Intrinsics.checkNotNull((Object)replyContent, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.jupyter.messaging.MessageReplyContent");
        MessageReplyContent messageReplyContent = (MessageReplyContent)replyContent;
        Json $this$encodeToJsonElement$iv = RawMessageImplKt.getMessageFormat();
        boolean $i$f$encodeToJsonElement = false;
        $this$encodeToJsonElement$iv.getSerializersModule();
        JsonElement jsonElement = $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)ExecuteReplyMetadata.Companion.serializer(), (Object)replyMetadata);
        Message reply = MessageFactoryKt.makeReplyMessage$default(messageFactory, messageType, null, null, null, jsonElement, messageReplyContent, 14, null);
        switch (WhenMappings.$EnumSwitchMapping$0[response2.getStatus().ordinal()]) {
            case 2: {
                System.err.println("Sending error: " + reply);
                break;
            }
            case 1: {
                System.err.println("Sending abort: " + reply);
            }
        }
        JupyterConnectionInternalKt.sendMessage($this$sendExecuteReply_u2dzEAq3HY.getSocketManager().getShell(), reply);
    }

    @NotNull
    public static final JupyterResponse toErrorJupyterResponse(@NotNull Throwable $this$toErrorJupyterResponse, @Nullable EvaluatedSnippetMetadata metadata2) {
        Intrinsics.checkNotNullParameter((Object)$this$toErrorJupyterResponse, (String)"<this>");
        Throwable exception = $this$toErrorJupyterResponse;
        if (!(exception instanceof ReplException)) {
            throw exception;
        }
        return new ErrorJupyterResponse(((ReplException)exception).render(), (ReplException)exception, metadata2);
    }

    public static /* synthetic */ JupyterResponse toErrorJupyterResponse$default(Throwable throwable, EvaluatedSnippetMetadata evaluatedSnippetMetadata, int n, Object object) {
        if ((n & 1) != 0) {
            evaluatedSnippetMetadata = null;
        }
        return JupyterResponseKt.toErrorJupyterResponse(throwable, evaluatedSnippetMetadata);
    }

    @NotNull
    public static final ExecuteErrorReply toExecuteErrorReply-wNURfNM(@NotNull ReplException $this$toExecuteErrorReply_u2dwNURfNM, int executionCount) {
        Intrinsics.checkNotNullParameter((Object)$this$toExecuteErrorReply_u2dwNURfNM, (String)"$this$toExecuteErrorReply");
        String string = $this$toExecuteErrorReply_u2dwNURfNM.getClass().getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
        String string2 = $this$toExecuteErrorReply_u2dwNURfNM.getMessage();
        if (string2 == null) {
            string2 = "";
        }
        List list = StringsKt.lines((CharSequence)ReplExceptionKt.messageAndStackTrace($this$toExecuteErrorReply_u2dwNURfNM, false));
        JsonObject jsonObject = $this$toExecuteErrorReply_u2dwNURfNM.getAdditionalInfoJson();
        if (jsonObject == null) {
            jsonObject = SerializersKt.getEMPTY((Json)Json.Default);
        }
        return new ExecuteErrorReply(executionCount, string, string2, list, jsonObject, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ExecuteErrorReply toExecuteErrorReply-wNURfNM(@NotNull ReplEvalRuntimeException $this$toExecuteErrorReply_u2dwNURfNM, int executionCount) {
        Object v7;
        StringBuilder $this$toExecuteErrorReply_wNURfNM_u24lambda_u244;
        StringBuilder stringBuilder;
        Throwable userException;
        block16: {
            void $this$forEach$iv;
            Iterator $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$toExecuteErrorReply_u2dwNURfNM, (String)"$this$toExecuteErrorReply");
            Throwable throwable = $this$toExecuteErrorReply_u2dwNURfNM.getCause();
            Intrinsics.checkNotNull((Object)throwable);
            userException = throwable;
            $this$toExecuteErrorReply_wNURfNM_u24lambda_u244 = stringBuilder = new StringBuilder();
            boolean bl = false;
            Iterable $this$mapIndexed$iv = StringsKt.lines((CharSequence)ExceptionsKt.stackTraceToString((Throwable)userException));
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            Iterator iterator = $this$mapIndexedTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                Collection collection;
                block18: {
                    void line;
                    block17: {
                        String string;
                        boolean bl2;
                        void index;
                        int n;
                        Object item$iv$iv = iterator.next();
                        if ((n = index$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        String string2 = (String)item$iv$iv;
                        int n2 = n;
                        collection = destination$iv$iv;
                        boolean bl3 = false;
                        ErrorLocation errorMetadata = index >= 0 && index < $this$toExecuteErrorReply_u2dwNURfNM.getCellErrorLocations().size() ? $this$toExecuteErrorReply_u2dwNURfNM.getCellErrorLocations().get((int)index) : null;
                        object = errorMetadata;
                        if (object == null) break block17;
                        ErrorLocation metadata2 = object;
                        boolean bl4 = false;
                        boolean bl5 = bl2 = metadata2.getLineNumber() <= metadata2.getVisibleSourceLines();
                        if (bl2) {
                            string = " at Cell In[" + metadata2.getJupyterRequestCount() + "], line " + metadata2.getLineNumber();
                        } else if (!bl2) {
                            string = " at Cell In[" + metadata2.getJupyterRequestCount() + "]";
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        String string3 = (String)line + string;
                        object = string3;
                        if (string3 != null) break block18;
                    }
                    object = line;
                }
                collection.add(object);
            }
            $this$mapIndexed$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl6 = false;
                if (!(((CharSequence)it).length() > 0)) continue;
                StringBuilder stringBuilder2 = $this$toExecuteErrorReply_wNURfNM_u24lambda_u244.append(it);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            }
            Intrinsics.checkNotNullExpressionValue((Object)$this$toExecuteErrorReply_wNURfNM_u24lambda_u244.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder3 = $this$toExecuteErrorReply_wNURfNM_u24lambda_u244.append(userException.getClass().getCanonicalName() + ": " + userException.getMessage());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            Iterable $this$firstOrNull$iv = $this$toExecuteErrorReply_u2dwNURfNM.getCellErrorLocations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ErrorLocation it = (ErrorLocation)element$iv;
                boolean bl7 = false;
                if (!(it != null)) continue;
                v7 = element$iv;
                break block16;
            }
            v7 = null;
        }
        ErrorLocation topError = v7;
        if (topError != null) {
            if (topError.getLineNumber() > topError.getVisibleSourceLines()) {
                StringBuilder stringBuilder4 = $this$toExecuteErrorReply_wNURfNM_u24lambda_u244.append("at Cell In[" + topError.getJupyterRequestCount() + "]");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
            } else {
                StringBuilder stringBuilder5 = $this$toExecuteErrorReply_wNURfNM_u24lambda_u244.append("at Cell In[" + topError.getJupyterRequestCount() + "], line " + topError.getLineNumber());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String traceBack = string;
        String string4 = userException.getClass().getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getCanonicalName(...)");
        String string5 = userException.getMessage();
        if (string5 == null) {
            string5 = "";
        }
        List list = StringsKt.lines((CharSequence)traceBack);
        JsonObject jsonObject = $this$toExecuteErrorReply_u2dwNURfNM.getAdditionalInfoJson();
        if (jsonObject == null) {
            jsonObject = SerializersKt.getEMPTY((Json)Json.Default);
        }
        return new ExecuteErrorReply(executionCount, string4, string5, list, jsonObject, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageStatus.values().length];
            try {
                nArray[MessageStatus.ABORT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageStatus.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageStatus.OK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

