/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelVersion;
import org.jetbrains.kotlinx.jupyter.api.libraries.RawMessage;
import org.jetbrains.kotlinx.jupyter.commands.CommandsProcessingKt;
import org.jetbrains.kotlinx.jupyter.common.CommandsUtilKt;
import org.jetbrains.kotlinx.jupyter.config.NotebookMetadataKt;
import org.jetbrains.kotlinx.jupyter.config.RuntimePropertiesKt;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplException;
import org.jetbrains.kotlinx.jupyter.execution.ExecutionResult;
import org.jetbrains.kotlinx.jupyter.execution.JupyterExecutor;
import org.jetbrains.kotlinx.jupyter.messaging.AbstractMessageRequestProcessor;
import org.jetbrains.kotlinx.jupyter.messaging.Comm;
import org.jetbrains.kotlinx.jupyter.messaging.CommClose;
import org.jetbrains.kotlinx.jupyter.messaging.CommInfoReply;
import org.jetbrains.kotlinx.jupyter.messaging.CommInfoRequest;
import org.jetbrains.kotlinx.jupyter.messaging.CommMsg;
import org.jetbrains.kotlinx.jupyter.messaging.CommOpen;
import org.jetbrains.kotlinx.jupyter.messaging.CompleteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ConnectReply;
import org.jetbrains.kotlinx.jupyter.messaging.ConnectRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ErrorJupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ExecutionCounter;
import org.jetbrains.kotlinx.jupyter.messaging.ExecutionInputReply;
import org.jetbrains.kotlinx.jupyter.messaging.HistoryReply;
import org.jetbrains.kotlinx.jupyter.messaging.HistoryRequest;
import org.jetbrains.kotlinx.jupyter.messaging.IdeCompatibleMessageRequestProcessor;
import org.jetbrains.kotlinx.jupyter.messaging.InputReply;
import org.jetbrains.kotlinx.jupyter.messaging.InterruptRequest;
import org.jetbrains.kotlinx.jupyter.messaging.IsCompleteReply;
import org.jetbrains.kotlinx.jupyter.messaging.IsCompleteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterBaseSockets;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacilityKt;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternalKt;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterOutType;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterResponseKt;
import org.jetbrains.kotlinx.jupyter.messaging.KernelInfoReply;
import org.jetbrains.kotlinx.jupyter.messaging.KernelInfoReplyMetadata;
import org.jetbrains.kotlinx.jupyter.messaging.KernelInfoRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ListErrorsRequest;
import org.jetbrains.kotlinx.jupyter.messaging.MessageContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactory;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryProvider;
import org.jetbrains.kotlinx.jupyter.messaging.MessageKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageStatus;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.messaging.OkJupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.ShutdownRequest;
import org.jetbrains.kotlinx.jupyter.messaging.StdIOSubstitutionManager;
import org.jetbrains.kotlinx.jupyter.messaging.UpdateClientMetadataReply;
import org.jetbrains.kotlinx.jupyter.messaging.UpdateClientMetadataRequest;
import org.jetbrains.kotlinx.jupyter.messaging.comms.CommManagerInternal;
import org.jetbrains.kotlinx.jupyter.repl.CompletionResult;
import org.jetbrains.kotlinx.jupyter.repl.EvalRequestData;
import org.jetbrains.kotlinx.jupyter.repl.ListErrorsResult;
import org.jetbrains.kotlinx.jupyter.repl.OutputConfig;
import org.jetbrains.kotlinx.jupyter.repl.ReplForJupyter;
import org.jetbrains.kotlinx.jupyter.repl.notebook.MutableCodeCell;
import org.jetbrains.kotlinx.jupyter.repl.result.EvalResultEx;
import org.jetbrains.kotlinx.jupyter.streams.CapturingOutputStream;
import org.jetbrains.kotlinx.jupyter.streams.DisabledStdinInputStream;
import org.jetbrains.kotlinx.jupyter.streams.StdinInputStream;
import org.jetbrains.kotlinx.jupyter.util.SerializersKt;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J)\u0010.\u001a\u0002H/\"\u0004\b\u0000\u0010/2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H/03H\u0014\u00a2\u0006\u0002\u00104J\"\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u0001062\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u000201H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0014J\u0010\u0010?\u001a\u00020<2\u0006\u0010=\u001a\u00020@H\u0014J\u0010\u0010A\u001a\u00020<2\u0006\u0010=\u001a\u00020BH\u0014J\u0010\u0010C\u001a\u00020<2\u0006\u0010=\u001a\u00020DH\u0014J\u0010\u0010E\u001a\u00020<2\u0006\u0010=\u001a\u00020FH\u0014J\u0010\u0010G\u001a\u00020<2\u0006\u0010=\u001a\u00020HH\u0014J\u0010\u0010I\u001a\u00020<2\u0006\u0010=\u001a\u00020JH\u0014J\u0010\u0010K\u001a\u00020<2\u0006\u0010=\u001a\u00020LH\u0014J\u0010\u0010M\u001a\u00020<2\u0006\u0010=\u001a\u00020NH\u0014J\u0010\u0010O\u001a\u00020<2\u0006\u0010=\u001a\u00020PH\u0014J\u0010\u0010Q\u001a\u00020<2\u0006\u0010=\u001a\u00020RH\u0014J\u0010\u0010S\u001a\u00020<2\u0006\u0010=\u001a\u00020TH\u0014J\u0010\u0010U\u001a\u00020<2\u0006\u0010=\u001a\u00020VH\u0014J\u0010\u0010W\u001a\u00020<2\u0006\u0010=\u001a\u00020XH\u0014J\u0010\u0010Y\u001a\u00020<2\u0006\u0010=\u001a\u00020ZH\u0014J\u0010\u0010[\u001a\u00020<2\u0006\u0010=\u001a\u00020ZH\u0014J\u0010\u0010\\\u001a\u00020<2\u0006\u0010=\u001a\u00020ZH\u0014J\u0010\u0010]\u001a\u00020<2\u0006\u0010=\u001a\u00020^H\u0014J\u001e\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020b2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020d03H\u0014J!\u0010e\u001a\u0002H/\"\u0004\b\u0000\u0010/2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H/03H\u0002\u00a2\u0006\u0002\u0010fJ)\u0010g\u001a\u0002H/\"\u0004\b\u0000\u0010/2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H/03H\u0002\u00a2\u0006\u0002\u00104J!\u0010h\u001a\u0002H/\"\u0004\b\u0000\u0010/2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H/03H\u0002\u00a2\u0006\u0002\u0010fJ\f\u0010i\u001a\u000206*\u00020jH\u0002J\u0010\u0010k\u001a\u00020b*\u00060bj\u0002`lH\u0002R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b*\u0010+\u001a\u0004\b,\u0010-\u00a8\u0006m"}, d2={"Lorg/jetbrains/kotlinx/jupyter/messaging/IdeCompatibleMessageRequestProcessor;", "Lorg/jetbrains/kotlinx/jupyter/messaging/AbstractMessageRequestProcessor;", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;", "rawIncomingMessage", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/RawMessage;", "messageFactoryProvider", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageFactoryProvider;", "socketManager", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterBaseSockets;", "commManager", "Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerInternal;", "executor", "Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutor;", "executionCounter", "Lorg/jetbrains/kotlinx/jupyter/messaging/ExecutionCounter;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "repl", "Lorg/jetbrains/kotlinx/jupyter/repl/ReplForJupyter;", "(Lorg/jetbrains/kotlinx/jupyter/api/libraries/RawMessage;Lorg/jetbrains/kotlinx/jupyter/messaging/MessageFactoryProvider;Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterBaseSockets;Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerInternal;Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutor;Lorg/jetbrains/kotlinx/jupyter/messaging/ExecutionCounter;Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;Lorg/jetbrains/kotlinx/jupyter/repl/ReplForJupyter;)V", "getCommManager", "()Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerInternal;", "getExecutionCounter", "()Lorg/jetbrains/kotlinx/jupyter/messaging/ExecutionCounter;", "getExecutor", "()Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutor;", "logger", "Lorg/slf4j/Logger;", "messageFactory", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageFactory;", "getMessageFactory", "()Lorg/jetbrains/kotlinx/jupyter/messaging/MessageFactory;", "getRepl", "()Lorg/jetbrains/kotlinx/jupyter/repl/ReplForJupyter;", "replOutputConfig", "Lorg/jetbrains/kotlinx/jupyter/repl/OutputConfig;", "getReplOutputConfig", "()Lorg/jetbrains/kotlinx/jupyter/repl/OutputConfig;", "getSocketManager", "()Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterBaseSockets;", "stdinIn", "Ljava/io/InputStream;", "getStdinIn$annotations", "()V", "getStdinIn", "()Ljava/io/InputStream;", "evalWithIO", "T", "allowStdIn", "", "body", "Lkotlin/Function0;", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getCapturingStream", "Ljava/io/PrintStream;", "parentStream", "outType", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterOutType;", "captureOutput", "processCommClose", "", "content", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommClose;", "processCommInfoRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommInfoRequest;", "processCommMsg", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommMsg;", "processCommOpen", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommOpen;", "processCompleteRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/CompleteRequest;", "processConnectRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/ConnectRequest;", "processExecuteRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/ExecuteRequest;", "processHistoryRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/HistoryRequest;", "processInputReply", "Lorg/jetbrains/kotlinx/jupyter/messaging/InputReply;", "processInterruptRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/InterruptRequest;", "processIsCompleteRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/IsCompleteRequest;", "processKernelInfoRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/KernelInfoRequest;", "processListErrorsRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/ListErrorsRequest;", "processShutdownRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/ShutdownRequest;", "processUnknownControlMessage", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageContent;", "processUnknownShellMessage", "processUnknownStdinMessage", "processUpdateClientMetadata", "Lorg/jetbrains/kotlinx/jupyter/messaging/UpdateClientMetadataRequest;", "runExecution", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterResponse;", "executionName", "", "execution", "Lorg/jetbrains/kotlinx/jupyter/repl/result/EvalResultEx;", "withForkedErr", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withForkedIn", "withForkedOut", "asPrintStream", "Ljava/io/OutputStream;", "presentableForThreadName", "Lorg/jetbrains/kotlinx/jupyter/api/Code;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nIdeCompatibleMessageRequestProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeCompatibleMessageRequestProcessor.kt\norg/jetbrains/kotlinx/jupyter/messaging/IdeCompatibleMessageRequestProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,408:1\n1179#2,2:409\n1253#2,4:411\n211#3:415\n*S KotlinDebug\n*F\n+ 1 IdeCompatibleMessageRequestProcessor.kt\norg/jetbrains/kotlinx/jupyter/messaging/IdeCompatibleMessageRequestProcessor\n*L\n138#1:409,2\n138#1:411,4\n211#1:415\n*E\n"})
public class IdeCompatibleMessageRequestProcessor
extends AbstractMessageRequestProcessor
implements JupyterCommunicationFacility {
    @NotNull
    private final JupyterBaseSockets socketManager;
    @NotNull
    private final CommManagerInternal commManager;
    @NotNull
    private final JupyterExecutor executor;
    @NotNull
    private final ExecutionCounter executionCounter;
    @NotNull
    private final ReplForJupyter repl;
    @NotNull
    private final Logger logger;
    @NotNull
    private final MessageFactory messageFactory;
    @NotNull
    private final InputStream stdinIn;

    public IdeCompatibleMessageRequestProcessor(@NotNull RawMessage rawIncomingMessage, @NotNull MessageFactoryProvider messageFactoryProvider, @NotNull JupyterBaseSockets socketManager, @NotNull CommManagerInternal commManager2, @NotNull JupyterExecutor executor, @NotNull ExecutionCounter executionCounter, @NotNull KernelLoggerFactory loggerFactory2, @NotNull ReplForJupyter repl) {
        Intrinsics.checkNotNullParameter((Object)rawIncomingMessage, (String)"rawIncomingMessage");
        Intrinsics.checkNotNullParameter((Object)messageFactoryProvider, (String)"messageFactoryProvider");
        Intrinsics.checkNotNullParameter((Object)socketManager, (String)"socketManager");
        Intrinsics.checkNotNullParameter((Object)commManager2, (String)"commManager");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)executionCounter, (String)"executionCounter");
        Intrinsics.checkNotNullParameter((Object)loggerFactory2, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)repl, (String)"repl");
        super(rawIncomingMessage);
        this.socketManager = socketManager;
        this.commManager = commManager2;
        this.executor = executor;
        this.executionCounter = executionCounter;
        this.repl = repl;
        this.logger = KernelLoggerFactoryKt.getLogger(loggerFactory2, Reflection.getOrCreateKotlinClass(this.getClass()));
        StdIOSubstitutionManager.INSTANCE.setSubstitutionEngineType(this.repl.getNotebook().getKernelRunMode().getStreamSubstitutionType());
        StdIOSubstitutionManager.INSTANCE.setUseThreadLocal(this.repl.getNotebook().getKernelRunMode().getThreadLocalStreamSubstitution());
        IdeCompatibleMessageRequestProcessor ideCompatibleMessageRequestProcessor = this;
        IdeCompatibleMessageRequestProcessor ideCompatibleMessageRequestProcessor2 = this;
        boolean bl = false;
        messageFactoryProvider.update(rawIncomingMessage);
        Object t = messageFactoryProvider.provide();
        Intrinsics.checkNotNull(t);
        ideCompatibleMessageRequestProcessor2.messageFactory = (MessageFactory)t;
        this.stdinIn = new StdinInputStream(this);
    }

    @Override
    @NotNull
    public final JupyterBaseSockets getSocketManager() {
        return this.socketManager;
    }

    @NotNull
    protected final CommManagerInternal getCommManager() {
        return this.commManager;
    }

    @NotNull
    protected final JupyterExecutor getExecutor() {
        return this.executor;
    }

    @NotNull
    protected final ExecutionCounter getExecutionCounter() {
        return this.executionCounter;
    }

    @NotNull
    protected final ReplForJupyter getRepl() {
        return this.repl;
    }

    @Override
    @NotNull
    public final MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    @NotNull
    protected final InputStream getStdinIn() {
        return this.stdinIn;
    }

    protected static /* synthetic */ void getStdinIn$annotations() {
    }

    @Override
    protected void processUnknownShellMessage(@NotNull MessageContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        JupyterConnectionInternalKt.sendMessage(this.socketManager.getShell(), MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.NONE, null, null, null, null, null, 62, null));
    }

    @Override
    protected void processUnknownControlMessage(@NotNull MessageContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
    }

    @Override
    protected void processUnknownStdinMessage(@NotNull MessageContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
    }

    @Override
    protected void processIsCompleteRequest(@NotNull IsCompleteRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        JupyterConnectionInternalKt.sendMessage(this.socketManager.getShell(), MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.IS_COMPLETE_REPLY, null, null, null, null, new IsCompleteReply("complete", null, 2, null), 30, null));
    }

    @Override
    protected void processListErrorsRequest(@NotNull ListErrorsRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.executor.launchJob((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, content, null){
            int label;
            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
            final /* synthetic */ ListErrorsRequest $content;
            {
                this.this$0 = $receiver;
                this.$content = $content;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getRepl().listErrors(this.$content.getCode(), (Function1<? super ListErrorsResult, Unit>)((Function1)new Function1<ListErrorsResult, Unit>(this.this$0){
                            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ListErrorsResult result2) {
                                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                                JupyterCommunicationFacilityKt.sendWrapped(this.this$0, MessageFactoryKt.makeReplyMessage$default(this.this$0.getMessageFactory(), MessageType.LIST_ERRORS_REPLY, null, null, null, null, result2.getMessage(), 30, null));
                            }
                        }), (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    protected void processCompleteRequest(@NotNull CompleteRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.executor.launchJob((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, content, null){
            int label;
            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
            final /* synthetic */ CompleteRequest $content;
            {
                this.this$0 = $receiver;
                this.$content = $content;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getRepl().complete(this.$content.getCode(), this.$content.getCursorPos(), (Function1<? super CompletionResult, Unit>)((Function1)new Function1<CompletionResult, Unit>(this.this$0){
                            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull CompletionResult result2) {
                                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                                JupyterCommunicationFacilityKt.sendWrapped(this.this$0, MessageFactoryKt.makeReplyMessage$default(this.this$0.getMessageFactory(), MessageType.COMPLETE_REPLY, null, null, null, null, result2.getMessage(), 30, null));
                            }
                        }), (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    protected void processCommMsg(@NotNull CommMsg content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        JupyterExecutor.DefaultImpls.runExecution$default(this.executor, "Execution of comm_msg request for " + content.getCommId(), null, (Function0)new Function0<Unit>(this, content){
            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
            final /* synthetic */ CommMsg $content;
            {
                this.this$0 = $receiver;
                this.$content = $content;
                super(0);
            }

            public final void invoke() {
                this.this$0.getCommManager().processCommMessage(this.this$0.getIncomingMessage(), this.$content);
            }
        }, 2, null);
    }

    @Override
    protected void processCommClose(@NotNull CommClose content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        JupyterExecutor.DefaultImpls.runExecution$default(this.executor, "Execution of comm_close request for " + content.getCommId(), null, (Function0)new Function0<Unit>(this, content){
            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
            final /* synthetic */ CommClose $content;
            {
                this.this$0 = $receiver;
                this.$content = $content;
                super(0);
            }

            public final void invoke() {
                this.this$0.getCommManager().processCommClose(this.this$0.getIncomingMessage(), this.$content);
            }
        }, 2, null);
    }

    @Override
    protected void processCommOpen(@NotNull CommOpen content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        JupyterExecutor.DefaultImpls.runExecution$default(this.executor, "Execution of comm_open request for " + content.getCommId() + " of target " + content.getTargetName(), null, (Function0)new Function0<org.jetbrains.kotlinx.jupyter.api.libraries.Comm>(this, content){
            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
            final /* synthetic */ CommOpen $content;
            {
                this.this$0 = $receiver;
                this.$content = $content;
                super(0);
            }

            @NotNull
            public final org.jetbrains.kotlinx.jupyter.api.libraries.Comm invoke() {
                org.jetbrains.kotlinx.jupyter.api.libraries.Comm comm = this.this$0.getCommManager().processCommOpen(this.this$0.getIncomingMessage(), this.$content);
                if (comm == null) {
                    throw new ReplException("Cannot open comm for " + this.$content.getCommId() + " of target " + this.$content.getTargetName(), null, 2, null);
                }
                return comm;
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processCommInfoRequest(@NotNull CommInfoRequest content) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Collection<org.jetbrains.kotlinx.jupyter.api.libraries.Comm> comms = this.commManager.getComms(content.getTargetName());
        Iterable $this$associate$iv = comms;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            org.jetbrains.kotlinx.jupyter.api.libraries.Comm comm = (org.jetbrains.kotlinx.jupyter.api.libraries.Comm)element$iv$iv;
            boolean bl = false;
            Pair pair2 = TuplesKt.to((Object)comm.getId(), (Object)new Comm(comm.getTarget()));
            map.put(pair2.getFirst(), pair2.getSecond());
        }
        Map replyMap = destination$iv$iv;
        JupyterCommunicationFacilityKt.sendWrapped(this, MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.COMM_INFO_REPLY, null, null, null, null, new CommInfoReply(replyMap), 30, null));
    }

    @Override
    protected void processExecuteRequest(@NotNull ExecuteRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        int count = this.executionCounter.next-7ImE1O0(content.getStoreHistory());
        String startedTime = MessageKt.getISO8601DateNow();
        JupyterCommunicationFacilityKt.doWrappedInBusyIdle(this, (Function0<Unit>)((Function0)new Function0<Unit>(content, this, count, startedTime){
            final /* synthetic */ ExecuteRequest $content;
            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
            final /* synthetic */ int $count;
            final /* synthetic */ String $startedTime;
            {
                this.$content = $content;
                this.this$0 = $receiver;
                this.$count = $count;
                this.$startedTime = $startedTime;
                super(0);
            }

            public final void invoke() {
                String code = this.$content.getCode();
                JupyterConnectionInternalKt.sendMessage(this.this$0.getSocketManager().getIopub(), MessageFactoryKt.makeReplyMessage$default(this.this$0.getMessageFactory(), MessageType.EXECUTE_INPUT, null, null, null, null, new ExecutionInputReply(code, this.$count, null), 30, null));
                JupyterResponse response2 = CommandsUtilKt.looksLikeReplCommand(code) ? CommandsProcessingKt.runCommand(code, this.this$0.getRepl()) : this.this$0.runExecution("Execution of code '" + IdeCompatibleMessageRequestProcessor.access$presentableForThreadName(this.this$0, code) + "'", (Function0<? extends EvalResultEx>)((Function0)new Function0<EvalResultEx>(this.this$0, this.$content, code, this.$count){
                    final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
                    final /* synthetic */ ExecuteRequest $content;
                    final /* synthetic */ String $code;
                    final /* synthetic */ int $count;
                    {
                        this.this$0 = $receiver;
                        this.$content = $content;
                        this.$code = $code;
                        this.$count = $count;
                        super(0);
                    }

                    @NotNull
                    public final EvalResultEx invoke() {
                        return (EvalResultEx)this.this$0.evalWithIO(this.$content.getAllowStdin(), (Function0)new Function0<EvalResultEx>(this.this$0, this.$code, this.$count, this.$content){
                            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
                            final /* synthetic */ String $code;
                            final /* synthetic */ int $count;
                            final /* synthetic */ ExecuteRequest $content;
                            {
                                this.this$0 = $receiver;
                                this.$code = $code;
                                this.$count = $count;
                                this.$content = $content;
                                super(0);
                            }

                            @NotNull
                            public final EvalResultEx invoke() {
                                return this.this$0.getRepl().evalEx(new EvalRequestData(this.$code, this.$count, this.$content.getStoreHistory(), this.$content.getSilent(), null));
                            }
                        });
                    }
                }));
                JupyterResponseKt.sendResponse-zEAq3HY(this.this$0, response2, this.$count, this.$startedTime);
            }
        }));
    }

    @Override
    protected void processConnectRequest(@NotNull ConnectRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        JupyterCommunicationFacilityKt.sendWrapped(this, MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.CONNECT_REPLY, null, null, null, null, new ConnectReply(SerializersKt.getEMPTY((Json)Json.Default)), 30, null));
    }

    @Override
    protected void processHistoryRequest(@NotNull HistoryRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        JupyterCommunicationFacilityKt.sendWrapped(this, MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.HISTORY_REPLY, null, null, null, null, new HistoryReply(CollectionsKt.emptyList()), 30, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processKernelInfoRequest(@NotNull KernelInfoRequest content) {
        void value$iv;
        void $this$encodeToJsonElement$iv;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        JupyterCommunicationFacility jupyterCommunicationFacility = this;
        MessageFactory messageFactory = this.messageFactory;
        MessageType messageType = MessageType.KERNEL_INFO_REPLY;
        KernelInfoReply kernelInfoReply = new KernelInfoReply("5.3", "Kotlin", KotlinKernelVersion.Companion.toMaybeUnspecifiedString(RuntimePropertiesKt.getCurrentKernelVersion()), "Kotlin kernel v. " + KotlinKernelVersion.Companion.toMaybeUnspecifiedString(RuntimePropertiesKt.getCurrentKernelVersion()) + ", Kotlin v. " + RuntimePropertiesKt.getCurrentKotlinVersion(), NotebookMetadataKt.getNotebookLanguageInfo(), CollectionsKt.emptyList());
        Json json = (Json)Json.Default;
        KernelInfoReplyMetadata kernelInfoReplyMetadata = new KernelInfoReplyMetadata(this.repl.getCurrentSessionState());
        boolean $i$f$encodeToJsonElement = false;
        $this$encodeToJsonElement$iv.getSerializersModule();
        JsonElement jsonElement = $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)KernelInfoReplyMetadata.Companion.serializer(), (Object)value$iv);
        JupyterCommunicationFacilityKt.sendWrapped(jupyterCommunicationFacility, MessageFactoryKt.makeReplyMessage$default(messageFactory, messageType, null, null, null, jsonElement, kernelInfoReply, 14, null));
    }

    @Override
    protected void processUpdateClientMetadata(@NotNull UpdateClientMetadataRequest content) {
        boolean path22;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            Path path22 = content.getAbsoluteNotebookFilePath();
            this.repl.getNotebook().updateFilePath(path22);
            path22 = true;
        }
        catch (InvalidPathException ex) {
            this.logger.error("Invalid notebook file path: " + content.getAbsoluteNotebookFilePath(), (Throwable)ex);
            path22 = false;
        }
        boolean metadataUpdated = path22;
        MessageStatus status = metadataUpdated ? MessageStatus.OK : MessageStatus.ABORT;
        JupyterCommunicationFacilityKt.sendWrapped(this, MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.UPDATE_CLIENT_METADATA_REPLY, null, null, null, null, new UpdateClientMetadataReply(status), 30, null));
    }

    @Override
    protected void processShutdownRequest(@NotNull ShutdownRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.repl.evalOnShutdown();
        this.executor.close();
        JupyterConnectionInternalKt.sendMessage(this.socketManager.getControl(), MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.SHUTDOWN_REPLY, null, null, null, null, this.getIncomingMessage().getContent(), 30, null));
        if (this.repl.getKernelRunMode().getShouldKillProcessOnShutdown()) {
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        this.logger.info("Interrupting controlThread to trigger kernel shutdown");
        throw new InterruptedException();
    }

    @Override
    protected void processInterruptRequest(@NotNull InterruptRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.executor.interruptExecution();
        JupyterConnectionInternalKt.sendMessage(this.socketManager.getControl(), MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.INTERRUPT_REPLY, null, null, null, null, this.getIncomingMessage().getContent(), 30, null));
    }

    @Override
    protected void processInputReply(@NotNull InputReply content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
    }

    @NotNull
    protected JupyterResponse runExecution(@NotNull String executionName, @NotNull Function0<? extends EvalResultEx> execution2) {
        JupyterResponse jupyterResponse;
        Intrinsics.checkNotNullParameter((Object)executionName, (String)"executionName");
        Intrinsics.checkNotNullParameter(execution2, (String)"execution");
        ExecutionResult<? extends EvalResultEx> res2 = this.executor.runExecution(executionName, this.repl.getCurrentClassLoader(), execution2);
        if (res2 instanceof ExecutionResult.Success) {
            JupyterResponse jupyterResponse2;
            try {
                JupyterResponse jupyterResponse3;
                EvalResultEx replResult = (EvalResultEx)((ExecutionResult.Success)res2).getResult();
                if (replResult instanceof EvalResultEx.Success) {
                    jupyterResponse3 = new OkJupyterResponse(((EvalResultEx.Success)replResult).getDisplayValue(), replResult.getMetadata());
                } else if (replResult instanceof EvalResultEx.Error) {
                    jupyterResponse3 = JupyterResponseKt.toErrorJupyterResponse(((EvalResultEx.Error)replResult).getError(), replResult.getMetadata());
                } else if (replResult instanceof EvalResultEx.RenderedError) {
                    jupyterResponse3 = new OkJupyterResponse(((EvalResultEx.RenderedError)replResult).getDisplayError(), replResult.getMetadata());
                } else if (replResult instanceof EvalResultEx.Interrupted) {
                    jupyterResponse3 = new ErrorJupyterResponse("The execution was interrupted", null, replResult.getMetadata(), 2, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                jupyterResponse2 = jupyterResponse3;
            }
            catch (Throwable e) {
                jupyterResponse2 = new ErrorJupyterResponse("error:  Unable to convert result to a string: " + e, null, null, 6, null);
            }
            jupyterResponse = jupyterResponse2;
        } else if (res2 instanceof ExecutionResult.Failure) {
            jupyterResponse = JupyterResponseKt.toErrorJupyterResponse$default(((ExecutionResult.Failure)res2).getThrowable(), null, 1, null);
        } else if (Intrinsics.areEqual(res2, (Object)ExecutionResult.Interrupted.INSTANCE)) {
            jupyterResponse = new ErrorJupyterResponse("The execution was interrupted", null, null, 6, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jupyterResponse;
    }

    private final OutputConfig getReplOutputConfig() {
        return this.repl.getOptions().getOutputConfig();
    }

    private final PrintStream getCapturingStream(PrintStream parentStream, JupyterOutType outType, boolean captureOutput) {
        return this.asPrintStream(new CapturingOutputStream(parentStream, this.getReplOutputConfig(), captureOutput, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, outType){
            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
            final /* synthetic */ JupyterOutType $outType;
            {
                this.this$0 = $receiver;
                this.$outType = $outType;
                super(1);
            }

            public final void invoke(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                MutableCodeCell mutableCodeCell = this.this$0.getRepl().getNotebook().getCurrentCell();
                if (mutableCodeCell != null) {
                    mutableCodeCell.appendStreamOutput(text2);
                }
                JupyterCommunicationFacilityKt.sendOut(this.this$0, this.$outType, text2);
            }
        })));
    }

    private final PrintStream asPrintStream(OutputStream $this$asPrintStream) {
        return new PrintStream($this$asPrintStream, false, "UTF-8");
    }

    private final <T> T withForkedOut(Function0<? extends T> body) {
        return StdIOSubstitutionManager.INSTANCE.getStdoutContext().withSubstitutedStreams((Function1)new Function1<PrintStream, PrintStream>(this){
            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final PrintStream invoke(@Nullable PrintStream out2) {
                return IdeCompatibleMessageRequestProcessor.access$getCapturingStream(this.this$0, out2, JupyterOutType.STDOUT, IdeCompatibleMessageRequestProcessor.access$getReplOutputConfig(this.this$0).getCaptureOutput());
            }
        }, withForkedOut.2.INSTANCE, body);
    }

    private final <T> T withForkedErr(Function0<? extends T> body) {
        return StdIOSubstitutionManager.INSTANCE.getStderrContext().withSubstitutedStreams((Function1)new Function1<PrintStream, PrintStream>(this){
            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final PrintStream invoke(@Nullable PrintStream err) {
                return IdeCompatibleMessageRequestProcessor.access$getCapturingStream(this.this$0, err, JupyterOutType.STDERR, false);
            }
        }, (Function1)new Function1<PrintStream, PrintStream>(this){
            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final PrintStream invoke(@Nullable PrintStream it) {
                return IdeCompatibleMessageRequestProcessor.access$getCapturingStream(this.this$0, null, JupyterOutType.STDERR, true);
            }
        }, body);
    }

    private final <T> T withForkedIn(boolean allowStdIn, Function0<? extends T> body) {
        return StdIOSubstitutionManager.INSTANCE.getStdinContext().withSubstitutedStreams((Function1)new Function1<InputStream, InputStream>(allowStdIn, this){
            final /* synthetic */ boolean $allowStdIn;
            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
            {
                this.$allowStdIn = $allowStdIn;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final InputStream invoke(@Nullable InputStream it) {
                return this.$allowStdIn ? this.this$0.getStdinIn() : (InputStream)DisabledStdinInputStream.INSTANCE;
            }
        }, withForkedIn.2.INSTANCE, body);
    }

    protected <T> T evalWithIO(boolean allowStdIn, @NotNull Function0<? extends T> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.repl.getNotebook().beginEvalSession();
        return this.withForkedOut((Function0)new Function0<T>(this, allowStdIn, body){
            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
            final /* synthetic */ boolean $allowStdIn;
            final /* synthetic */ Function0<T> $body;
            {
                this.this$0 = $receiver;
                this.$allowStdIn = $allowStdIn;
                this.$body = $body;
                super(0);
            }

            public final T invoke() {
                return (T)IdeCompatibleMessageRequestProcessor.access$withForkedErr(this.this$0, (Function0)new Function0<T>(this.this$0, this.$allowStdIn, this.$body){
                    final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
                    final /* synthetic */ boolean $allowStdIn;
                    final /* synthetic */ Function0<T> $body;
                    {
                        this.this$0 = $receiver;
                        this.$allowStdIn = $allowStdIn;
                        this.$body = $body;
                        super(0);
                    }

                    public final T invoke() {
                        return (T)IdeCompatibleMessageRequestProcessor.access$withForkedIn(this.this$0, this.$allowStdIn, this.$body);
                    }
                });
            }
        });
    }

    private final String presentableForThreadName(String $this$presentableForThreadName) {
        String newName = StringsKt.take((String)StringsKt.substringBefore$default((String)$this$presentableForThreadName, (char)'\n', null, (int)2, null), (int)20);
        return newName.length() < $this$presentableForThreadName.length() ? newName + "..." : $this$presentableForThreadName;
    }

    public static final /* synthetic */ String access$presentableForThreadName(IdeCompatibleMessageRequestProcessor $this, String $receiver) {
        return $this.presentableForThreadName($receiver);
    }

    public static final /* synthetic */ PrintStream access$getCapturingStream(IdeCompatibleMessageRequestProcessor $this, PrintStream parentStream, JupyterOutType outType, boolean captureOutput) {
        return $this.getCapturingStream(parentStream, outType, captureOutput);
    }

    public static final /* synthetic */ OutputConfig access$getReplOutputConfig(IdeCompatibleMessageRequestProcessor $this) {
        return $this.getReplOutputConfig();
    }

    public static final /* synthetic */ Object access$withForkedErr(IdeCompatibleMessageRequestProcessor $this, Function0 body) {
        return $this.withForkedErr(body);
    }

    public static final /* synthetic */ Object access$withForkedIn(IdeCompatibleMessageRequestProcessor $this, boolean allowStdIn, Function0 body) {
        return $this.withForkedIn(allowStdIn, body);
    }
}

