/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.libraries.RawMessage;
import org.jetbrains.kotlinx.jupyter.messaging.CommClose;
import org.jetbrains.kotlinx.jupyter.messaging.CommInfoRequest;
import org.jetbrains.kotlinx.jupyter.messaging.CommMsg;
import org.jetbrains.kotlinx.jupyter.messaging.CommOpen;
import org.jetbrains.kotlinx.jupyter.messaging.CompleteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ConnectRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.HistoryRequest;
import org.jetbrains.kotlinx.jupyter.messaging.InputReply;
import org.jetbrains.kotlinx.jupyter.messaging.InterruptRequest;
import org.jetbrains.kotlinx.jupyter.messaging.IsCompleteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.KernelInfoRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ListErrorsRequest;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageRequestProcessor;
import org.jetbrains.kotlinx.jupyter.messaging.ShutdownRequest;
import org.jetbrains.kotlinx.jupyter.messaging.UpdateClientMetadataRequest;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH$J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH$J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H$J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H$J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H$J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0016H$J\b\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0019H$J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001bH$J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001dH$J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001fH$J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020!H$J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020#H$J\u0010\u0010$\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020%H$J\b\u0010&\u001a\u00020\nH\u0016J\u0010\u0010'\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020(H$J\b\u0010)\u001a\u00020\nH\u0016J\u0010\u0010*\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020+H$J\u0010\u0010,\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020+H$J\u0010\u0010-\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020+H$J\u0010\u0010.\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020/H$R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlinx/jupyter/messaging/AbstractMessageRequestProcessor;", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageRequestProcessor;", "rawIncomingMessage", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/RawMessage;", "(Lorg/jetbrains/kotlinx/jupyter/api/libraries/RawMessage;)V", "incomingMessage", "Lorg/jetbrains/kotlinx/jupyter/messaging/Message;", "getIncomingMessage", "()Lorg/jetbrains/kotlinx/jupyter/messaging/Message;", "processCommClose", "", "content", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommClose;", "processCommInfoRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommInfoRequest;", "processCommMsg", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommMsg;", "processCommOpen", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommOpen;", "processCompleteRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/CompleteRequest;", "processConnectRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/ConnectRequest;", "processControlMessage", "processExecuteRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/ExecuteRequest;", "processHistoryRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/HistoryRequest;", "processInputReply", "Lorg/jetbrains/kotlinx/jupyter/messaging/InputReply;", "processInterruptRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/InterruptRequest;", "processIsCompleteRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/IsCompleteRequest;", "processKernelInfoRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/KernelInfoRequest;", "processListErrorsRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/ListErrorsRequest;", "processShellMessage", "processShutdownRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/ShutdownRequest;", "processStdinMessage", "processUnknownControlMessage", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageContent;", "processUnknownShellMessage", "processUnknownStdinMessage", "processUpdateClientMetadata", "Lorg/jetbrains/kotlinx/jupyter/messaging/UpdateClientMetadataRequest;", "shared-compiler"})
public abstract class AbstractMessageRequestProcessor
implements MessageRequestProcessor {
    @NotNull
    private final Message incomingMessage;

    public AbstractMessageRequestProcessor(@NotNull RawMessage rawIncomingMessage) {
        Intrinsics.checkNotNullParameter((Object)rawIncomingMessage, (String)"rawIncomingMessage");
        this.incomingMessage = MessageKt.toMessage(rawIncomingMessage);
    }

    @NotNull
    protected final Message getIncomingMessage() {
        return this.incomingMessage;
    }

    @Override
    public void processControlMessage() {
        MessageContent content = this.incomingMessage.getContent();
        if (content instanceof InterruptRequest) {
            this.processInterruptRequest((InterruptRequest)content);
        } else if (content instanceof ShutdownRequest) {
            this.processShutdownRequest((ShutdownRequest)content);
        } else {
            this.processUnknownControlMessage(content);
        }
    }

    @Override
    public void processShellMessage() {
        MessageContent content = this.incomingMessage.getContent();
        if (content instanceof KernelInfoRequest) {
            this.processKernelInfoRequest((KernelInfoRequest)content);
        } else if (content instanceof UpdateClientMetadataRequest) {
            this.processUpdateClientMetadata((UpdateClientMetadataRequest)content);
        } else if (content instanceof HistoryRequest) {
            this.processHistoryRequest((HistoryRequest)content);
        } else if (content instanceof ConnectRequest) {
            this.processConnectRequest((ConnectRequest)content);
        } else if (content instanceof ExecuteRequest) {
            this.processExecuteRequest((ExecuteRequest)content);
        } else if (content instanceof CommInfoRequest) {
            this.processCommInfoRequest((CommInfoRequest)content);
        } else if (content instanceof CommOpen) {
            this.processCommOpen((CommOpen)content);
        } else if (content instanceof CommClose) {
            this.processCommClose((CommClose)content);
        } else if (content instanceof CommMsg) {
            this.processCommMsg((CommMsg)content);
        } else if (content instanceof CompleteRequest) {
            this.processCompleteRequest((CompleteRequest)content);
        } else if (content instanceof ListErrorsRequest) {
            this.processListErrorsRequest((ListErrorsRequest)content);
        } else if (content instanceof IsCompleteRequest) {
            this.processIsCompleteRequest((IsCompleteRequest)content);
        } else {
            this.processUnknownShellMessage(content);
        }
    }

    @Override
    public void processStdinMessage() {
        MessageContent content = this.incomingMessage.getContent();
        if (content instanceof InputReply) {
            this.processInputReply((InputReply)content);
        } else {
            this.processUnknownStdinMessage(content);
        }
    }

    protected abstract void processIsCompleteRequest(@NotNull IsCompleteRequest var1);

    protected abstract void processListErrorsRequest(@NotNull ListErrorsRequest var1);

    protected abstract void processCompleteRequest(@NotNull CompleteRequest var1);

    protected abstract void processCommMsg(@NotNull CommMsg var1);

    protected abstract void processCommClose(@NotNull CommClose var1);

    protected abstract void processCommOpen(@NotNull CommOpen var1);

    protected abstract void processCommInfoRequest(@NotNull CommInfoRequest var1);

    protected abstract void processExecuteRequest(@NotNull ExecuteRequest var1);

    protected abstract void processConnectRequest(@NotNull ConnectRequest var1);

    protected abstract void processHistoryRequest(@NotNull HistoryRequest var1);

    protected abstract void processKernelInfoRequest(@NotNull KernelInfoRequest var1);

    protected abstract void processUpdateClientMetadata(@NotNull UpdateClientMetadataRequest var1);

    protected abstract void processUnknownShellMessage(@NotNull MessageContent var1);

    protected abstract void processShutdownRequest(@NotNull ShutdownRequest var1);

    protected abstract void processInterruptRequest(@NotNull InterruptRequest var1);

    protected abstract void processUnknownControlMessage(@NotNull MessageContent var1);

    protected abstract void processInputReply(@NotNull InputReply var1);

    protected abstract void processUnknownStdinMessage(@NotNull MessageContent var1);
}

