/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.config.LoggingKt;
import org.jetbrains.kotlinx.jupyter.config.RuntimePropertiesKt;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptor;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptorGlobalOptions;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptorsProvider;
import org.jetbrains.kotlinx.jupyter.libraries.ParsingKt;
import org.jetbrains.kotlinx.jupyter.libraries.ResourceLibraryDescriptorsProvider;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR'\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/ResourceLibraryDescriptorsProvider;", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptorsProvider;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;)V", "descriptorOptionsFromResources", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptorGlobalOptions;", "getDescriptorOptionsFromResources", "()Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptorGlobalOptions;", "descriptorOptionsFromResources$delegate", "Lkotlin/Lazy;", "librariesFromResources", "", "", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptor;", "getLibrariesFromResources", "()Ljava/util/Map;", "librariesFromResources$delegate", "logger", "Lorg/slf4j/Logger;", "getDescriptorGlobalOptions", "getDescriptors", "Companion", "shared-compiler"})
public class ResourceLibraryDescriptorsProvider
implements LibraryDescriptorsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy librariesFromResources$delegate;
    @NotNull
    private final Lazy descriptorOptionsFromResources$delegate;
    @NotNull
    private static final String RESOURCES_LIBRARY_PATH = "jupyterLibraries";

    public ResourceLibraryDescriptorsProvider(@NotNull KernelLoggerFactory loggerFactory2) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory2, (String)"loggerFactory");
        this.logger = KernelLoggerFactoryKt.getLogger(loggerFactory2, Reflection.getOrCreateKotlinClass(this.getClass()));
        this.librariesFromResources$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends LibraryDescriptor>>(this){
            final /* synthetic */ ResourceLibraryDescriptorsProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, LibraryDescriptor> invoke() {
                Sequence sequence;
                Sequence sequence2;
                URL listText = RuntimePropertiesKt.getKernelClassLoader().getResource("jupyterLibraries/libraries.list");
                if (listText != null) {
                    URL uRL = listText;
                    Charset charset = Charsets.UTF_8;
                    byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
                    sequence2 = StringsKt.lineSequence((CharSequence)new String(byArray, charset));
                } else {
                    sequence2 = sequence = null;
                }
                if (sequence2 == null) {
                    sequence = SequencesKt.emptySequence();
                }
                return MapsKt.toMap((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)sequence, (Function1)librariesFromResources.1.INSTANCE), (Function1)((Function1)new Function1<String, Pair<? extends String, ? extends LibraryDescriptor>>(this.this$0){
                    final /* synthetic */ ResourceLibraryDescriptorsProvider this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final Pair<String, LibraryDescriptor> invoke(@NotNull String descriptorFile) {
                        Pair pair2;
                        Intrinsics.checkNotNullParameter((Object)descriptorFile, (String)"descriptorFile");
                        URL uRL = RuntimePropertiesKt.getKernelClassLoader().getResource("jupyterLibraries/" + descriptorFile);
                        if (uRL != null) {
                            Object object = uRL;
                            Object object2 = Charsets.UTF_8;
                            byte[] byArray = TextStreamsKt.readBytes((URL)object);
                            object = new String(byArray, (Charset)object2);
                            object2 = this.this$0;
                            Object text2 = object;
                            boolean bl = false;
                            String libraryName = StringsKt.removeSuffix((String)descriptorFile, (CharSequence)".json");
                            ResourceLibraryDescriptorsProvider.access$getLogger$p((ResourceLibraryDescriptorsProvider)object2).info("Parsing library " + libraryName + " from resources");
                            pair2 = (Pair)LoggingKt.catchAll$default(ResourceLibraryDescriptorsProvider.access$getLogger$p((ResourceLibraryDescriptorsProvider)object2), null, "Parsing descriptor for library '" + libraryName + "' failed", (Function0)new Function0<Pair<? extends String, ? extends LibraryDescriptor>>(libraryName, (String)text2){
                                final /* synthetic */ String $libraryName;
                                final /* synthetic */ String $text;
                                {
                                    this.$libraryName = $libraryName;
                                    this.$text = $text;
                                    super(0);
                                }

                                @NotNull
                                public final Pair<String, LibraryDescriptor> invoke() {
                                    return TuplesKt.to((Object)this.$libraryName, (Object)ParsingKt.parseLibraryDescriptor(this.$text));
                                }
                            }, 1, null);
                        } else {
                            pair2 = null;
                        }
                        return pair2;
                    }
                })));
            }
        }));
        this.descriptorOptionsFromResources$delegate = LazyKt.lazy((Function0)descriptorOptionsFromResources.2.INSTANCE);
    }

    private final Map<String, LibraryDescriptor> getLibrariesFromResources() {
        Lazy lazy = this.librariesFromResources$delegate;
        return (Map)lazy.getValue();
    }

    private final LibraryDescriptorGlobalOptions getDescriptorOptionsFromResources() {
        Lazy lazy = this.descriptorOptionsFromResources$delegate;
        return (LibraryDescriptorGlobalOptions)lazy.getValue();
    }

    @Override
    @NotNull
    public Map<String, LibraryDescriptor> getDescriptors() {
        return this.getLibrariesFromResources();
    }

    @Override
    @NotNull
    public LibraryDescriptorGlobalOptions getDescriptorGlobalOptions() {
        return this.getDescriptorOptionsFromResources();
    }

    @Override
    @Nullable
    public LibraryDescriptor getDescriptorForVersionsCompletion(@NotNull String fullName) {
        return LibraryDescriptorsProvider.DefaultImpls.getDescriptorForVersionsCompletion(this, fullName);
    }

    public static final /* synthetic */ Logger access$getLogger$p(ResourceLibraryDescriptorsProvider $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/ResourceLibraryDescriptorsProvider$Companion;", "", "()V", "RESOURCES_LIBRARY_PATH", "", "shared-compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

