/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResource;
import org.jetbrains.kotlinx.jupyter.api.libraries.ResourceFallbacksBundle;
import org.jetbrains.kotlinx.jupyter.api.libraries.ResourceLocation;
import org.jetbrains.kotlinx.jupyter.api.libraries.ResourcePathType;
import org.jetbrains.kotlinx.jupyter.common.HttpClient;
import org.jetbrains.kotlinx.jupyter.common.HttpUtilKt;
import org.jetbrains.kotlinx.jupyter.libraries.JsLibraryResourcesProcessor;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResourcesProcessor;
import org.jetbrains.kotlinx.jupyter.libraries.ResourcesKt;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor;", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResourcesProcessor;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "httpClient", "Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;)V", "logger", "Lorg/slf4j/Logger;", "outputCounter", "", "loadBunch", "Lorg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$ScriptModifierFunctionGenerator;", "bundle", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/ResourceFallbacksBundle;", "classLoader", "Ljava/lang/ClassLoader;", "loadResourceAsText", "", "resource", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResource;", "wrapLibrary", "", "CodeScriptModifierFunctionGenerator", "ScriptModifierFunctionGenerator", "URLScriptModifierFunctionGenerator", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nJsLibraryResourcesProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsLibraryResourcesProcessor.kt\norg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1549#2:165\n1620#2,3:166\n*S KotlinDebug\n*F\n+ 1 JsLibraryResourcesProcessor.kt\norg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor\n*L\n65#1:165\n65#1:166,3\n*E\n"})
public final class JsLibraryResourcesProcessor
implements LibraryResourcesProcessor {
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final Logger logger;
    private int outputCounter;

    public JsLibraryResourcesProcessor(@NotNull KernelLoggerFactory loggerFactory2, @NotNull HttpClient httpClient2) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory2, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)httpClient2, (String)"httpClient");
        this.httpClient = httpClient2;
        this.logger = KernelLoggerFactoryKt.getLogger(loggerFactory2, Reflection.getOrCreateKotlinClass(this.getClass()));
    }

    private final ScriptModifierFunctionGenerator loadBunch(ResourceFallbacksBundle bundle, ClassLoader classLoader) {
        List exceptions = new ArrayList();
        for (ResourceLocation resourceLocation : bundle.getLocations()) {
            ScriptModifierFunctionGenerator scriptModifierFunctionGenerator;
            String path2 = resourceLocation.getPath();
            try {
                ScriptModifierFunctionGenerator scriptModifierFunctionGenerator2;
                switch (WhenMappings.$EnumSwitchMapping$0[resourceLocation.getType().ordinal()]) {
                    case 1: {
                        scriptModifierFunctionGenerator2 = new URLScriptModifierFunctionGenerator(path2);
                        break;
                    }
                    case 2: {
                        String scriptText = HttpUtilKt.getHttp(this.httpClient, path2).getText();
                        scriptModifierFunctionGenerator2 = new CodeScriptModifierFunctionGenerator(scriptText);
                        break;
                    }
                    case 3: {
                        File file = new File(path2);
                        this.logger.debug("Resolving resource file: " + file.getAbsolutePath());
                        scriptModifierFunctionGenerator2 = new CodeScriptModifierFunctionGenerator(FilesKt.readText$default((File)file, null, (int)1, null));
                        break;
                    }
                    case 4: {
                        String content = ResourcesKt.loadResourceFromClassLoader(path2, classLoader);
                        return new CodeScriptModifierFunctionGenerator(content);
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                scriptModifierFunctionGenerator = scriptModifierFunctionGenerator2;
            }
            catch (IOException e) {
                exceptions.add(e);
                continue;
            }
            return scriptModifierFunctionGenerator;
        }
        throw new Exception("No resource fallback found! Related exceptions: " + exceptions);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScriptModifierFunctionGenerator> loadResourceAsText(LibraryResource resource, ClassLoader classLoader) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = resource.getBundles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceFallbacksBundle resourceFallbacksBundle = (ResourceFallbacksBundle)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.loadBunch((ResourceFallbacksBundle)it, classLoader));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String wrapLibrary(@NotNull LibraryResource resource, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        String resourceName = resource.getName();
        String resourceIndex = "[\"" + resourceName + "\"]";
        String callResourceIndex = "[\"call_" + resourceName + "\"]";
        String elementId = "kotlin_out_" + this.outputCounter;
        ++this.outputCounter;
        List<ScriptModifierFunctionGenerator> generators = this.loadResourceAsText(resource, classLoader);
        String jsScriptModifiers2 = CollectionsKt.joinToString$default((Iterable)generators, (CharSequence)",\n", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)wrapLibrary.jsScriptModifiers.1.INSTANCE, (int)24, null);
        String wrapper = StringsKt.trimIndent((String)("\n            if(!window.kotlinQueues) {\n                window.kotlinQueues = {};\n            }\n            if(!window.kotlinQueues" + resourceIndex + ") {\n                var resQueue = [];\n                window.kotlinQueues" + resourceIndex + " = resQueue;\n                window" + callResourceIndex + " = function(f) {\n                    resQueue.push(f);\n                }\n            }\n            (function (){\n                var modifiers = " + jsScriptModifiers2 + ";\n                var e = document.getElementById(\"" + elementId + "\");\n                modifiers.forEach(function (gen) {\n                    var script = document.createElement(\"script\");\n                    gen(script)\n                    script.addEventListener(\"load\", function() {\n                        window" + callResourceIndex + " = function(f) {f();};\n                        window.kotlinQueues" + resourceIndex + ".forEach(function(f) {f();});\n                        window.kotlinQueues" + resourceIndex + " = [];\n                    }, false);\n                    script.addEventListener(\"error\", function() {\n                        window" + callResourceIndex + " = function(f) {};\n                        window.kotlinQueues" + resourceIndex + " = [];\n                        var div = document.createElement(\"div\");\n                        div.style.color = 'darkred';\n                        div.textContent = 'Error loading resource " + resourceName + "';\n                        document.getElementById(\"" + elementId + "\").appendChild(div);\n                    }, false);\n                    \n                    e.appendChild(script);\n                });\n            })();\n            "));
        return StringsKt.trimIndent((String)("\n            <div id=\"" + elementId + "\"></div>\n            <script type=\"text/javascript\">\n                " + wrapper + "\n            </script>\n            "));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$CodeScriptModifierFunctionGenerator;", "Lorg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$ScriptModifierFunctionGenerator;", "code", "", "Lorg/jetbrains/kotlinx/jupyter/api/Code;", "(Ljava/lang/String;)V", "getCode", "()Ljava/lang/String;", "getScriptText", "shared-compiler"})
    @SourceDebugExtension(value={"SMAP\nJsLibraryResourcesProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsLibraryResourcesProcessor.kt\norg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$CodeScriptModifierFunctionGenerator\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,164:1\n113#2:165\n*S KotlinDebug\n*F\n+ 1 JsLibraryResourcesProcessor.kt\norg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$CodeScriptModifierFunctionGenerator\n*L\n139#1:165\n*E\n"})
    private static final class CodeScriptModifierFunctionGenerator
    implements ScriptModifierFunctionGenerator {
        @NotNull
        private final String code;

        public CodeScriptModifierFunctionGenerator(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            this.code = code;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String getScriptText() {
            void $this$encodeToString$iv;
            StringFormat stringFormat = (StringFormat)Json.Default;
            String value$iv = this.code;
            boolean $i$f$encodeToString = false;
            $this$encodeToString$iv.getSerializersModule();
            String escapedCode = $this$encodeToString$iv.encodeToString((SerializationStrategy)StringSerializer.INSTANCE, (Object)value$iv);
            return StringsKt.trimIndent((String)("\n                (function(script) {\n                    script.textContent = " + escapedCode + "\n                    script.type = \"text/javascript\";\n                })\n                "));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$ScriptModifierFunctionGenerator;", "", "getScriptText", "", "shared-compiler"})
    private static interface ScriptModifierFunctionGenerator {
        @NotNull
        public String getScriptText();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$URLScriptModifierFunctionGenerator;", "Lorg/jetbrains/kotlinx/jupyter/libraries/JsLibraryResourcesProcessor$ScriptModifierFunctionGenerator;", "url", "", "(Ljava/lang/String;)V", "getScriptText", "shared-compiler"})
    private static final class URLScriptModifierFunctionGenerator
    implements ScriptModifierFunctionGenerator {
        @NotNull
        private final String url;

        public URLScriptModifierFunctionGenerator(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
        }

        @Override
        @NotNull
        public String getScriptText() {
            return StringsKt.trimIndent((String)("\n                (function(script) {\n                    script.src = \"" + this.url + "\"\n                    script.type = \"text/javascript\";\n                })\n                "));
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourcePathType.values().length];
            try {
                nArray[ResourcePathType.URL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourcePathType.URL_EMBEDDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourcePathType.LOCAL_PATH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourcePathType.CLASSPATH_PATH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

