/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.common;

import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.common.CommonLoggerFactory;
import org.jetbrains.kotlinx.jupyter.common.ExceptionsHandler;
import org.jetbrains.kotlinx.jupyter.common.HttpClient;
import org.jetbrains.kotlinx.jupyter.common.HttpUtilKt;
import org.jetbrains.kotlinx.jupyter.common.LibraryDescriptorsManager;
import org.jetbrains.kotlinx.jupyter.common.ResponseKt;
import org.jetbrains.kotlinx.jupyter.common.ResponseWrapper;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0002\u0018\u0000 M2\u00020\u0001:\u0001MB]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J-\u0010(\u001a\u0004\u0018\u0001H)\"\u0004\b\u0000\u0010)2\b\b\u0002\u0010*\u001a\u00020\u00032\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H)0,H\u0002\u00a2\u0006\u0002\u0010-J\u0012\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020\u0003H\u0016J\u0010\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0003H\u0016J\u0012\u00105\u001a\u0004\u0018\u00010\u00032\u0006\u00102\u001a\u00020\u0003H\u0016J\u0010\u00106\u001a\u0002072\u0006\u00102\u001a\u00020\u0003H\u0016J\u0018\u00108\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0003H\u0016J\u0010\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u00020\u0003H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0003H\u0002J\u001c\u0010>\u001a\u0004\u0018\u00010?2\u0006\u00102\u001a\u00020\u00032\b\u0010@\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010A\u001a\u00020\r2\b\u0010B\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010C\u001a\u00020/2\u0006\u0010D\u001a\u00020\rH\u0016J\b\u0010E\u001a\u00020\u0003H\u0016J\u0018\u0010F\u001a\u00020\u00032\u0006\u0010G\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003H\u0002J\u0010\u0010H\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0003H\u0016J\b\u0010I\u001a\u00020\u0003H\u0016J\u0010\u0010J\u001a\u0002072\u0006\u00102\u001a\u00020\u0003H\u0002J\u0016\u0010K\u001a\u000207*\u00020\r2\b\b\u0002\u0010L\u001a\u00020\u0003H\u0002R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0018R\u0014\u0010&\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0018\u00a8\u0006N"}, d2={"Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManagerImpl;", "Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;", "user", "", "repo", "remotePath", "localPath", "homePath", "userPath", "resourcesPath", "exceptionsHandler", "Lorg/jetbrains/kotlinx/jupyter/common/ExceptionsHandler;", "userSettingsDir", "Ljava/io/File;", "httpClient", "Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/common/CommonLoggerFactory;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlinx/jupyter/common/ExceptionsHandler;Ljava/io/File;Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;Lorg/jetbrains/kotlinx/jupyter/common/CommonLoggerFactory;)V", "apiPrefix", "authToken", "authUser", "commitHashFile", "getCommitHashFile", "()Ljava/io/File;", "commitHashFile$delegate", "Lkotlin/Lazy;", "defaultBranch", "getDefaultBranch", "()Ljava/lang/String;", "latestCommitOnDefaultBranch", "getLatestCommitOnDefaultBranch", "localLibrariesDir", "getLocalLibrariesDir", "logger", "Lorg/slf4j/Logger;", "userCacheDir", "getUserCacheDir", "userLibrariesDir", "getUserLibrariesDir", "catchAll", "T", "message", "body", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "checkIfRefUpToDate", "", "remoteRef", "checkRefExistence", "ref", "descriptorFileName", "name", "downloadGlobalDescriptorOptions", "downloadLibraries", "", "downloadLibraryDescriptor", "downloadSingleFile", "contentsApiUrl", "getGithubHttpWithAuth", "Lorg/jetbrains/kotlinx/jupyter/common/ResponseWrapper;", "url", "getLatestCommitToLibraries", "Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager$CommitInfo;", "sinceTimestamp", "homeLibrariesDir", "homeDir", "isLibraryDescriptor", "file", "optionsFileName", "resolveAgainstRemotePath", "filePath", "resourceLibraryPath", "resourceOptionsPath", "saveLocalRef", "createDirsAndWrite", "text", "Companion", "common-dependencies"})
final class LibraryDescriptorsManagerImpl
implements LibraryDescriptorsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String remotePath;
    @NotNull
    private final String homePath;
    @NotNull
    private final String resourcesPath;
    @NotNull
    private final ExceptionsHandler exceptionsHandler;
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final Logger logger;
    @Nullable
    private final String authUser;
    @Nullable
    private final String authToken;
    @NotNull
    private final String apiPrefix;
    @NotNull
    private final File userLibrariesDir;
    @NotNull
    private final File userCacheDir;
    @NotNull
    private final File localLibrariesDir;
    @NotNull
    private final String defaultBranch;
    @NotNull
    private final Lazy commitHashFile$delegate;
    @NotNull
    private static final String GITHUB_API_HOST = "api.github.com";
    @NotNull
    private static final String DESCRIPTOR_EXTENSION = "json";
    @NotNull
    private static final String COMMIT_HASH_FILE = "commit_sha";
    @NotNull
    private static final String OPTIONS_FILE = "global.options";

    public LibraryDescriptorsManagerImpl(@NotNull String user, @NotNull String repo, @NotNull String remotePath, @NotNull String localPath, @NotNull String homePath, @NotNull String userPath, @NotNull String resourcesPath, @NotNull ExceptionsHandler exceptionsHandler, @NotNull File userSettingsDir, @NotNull HttpClient httpClient2, @NotNull CommonLoggerFactory loggerFactory2) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        Intrinsics.checkNotNullParameter((Object)homePath, (String)"homePath");
        Intrinsics.checkNotNullParameter((Object)userPath, (String)"userPath");
        Intrinsics.checkNotNullParameter((Object)resourcesPath, (String)"resourcesPath");
        Intrinsics.checkNotNullParameter((Object)exceptionsHandler, (String)"exceptionsHandler");
        Intrinsics.checkNotNullParameter((Object)userSettingsDir, (String)"userSettingsDir");
        Intrinsics.checkNotNullParameter((Object)httpClient2, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)loggerFactory2, (String)"loggerFactory");
        this.remotePath = remotePath;
        this.homePath = homePath;
        this.resourcesPath = resourcesPath;
        this.exceptionsHandler = exceptionsHandler;
        this.httpClient = httpClient2;
        this.logger = loggerFactory2.getLogger(this.getClass());
        this.authUser = System.getenv("KOTLIN_JUPYTER_GITHUB_USER");
        this.authToken = System.getenv("KOTLIN_JUPYTER_GITHUB_TOKEN");
        this.apiPrefix = "https://api.github.com/repos/" + user + "/" + repo;
        this.userLibrariesDir = FilesKt.resolve((File)userSettingsDir, (String)userPath);
        this.userCacheDir = FilesKt.resolve((File)userSettingsDir, (String)"cache");
        this.localLibrariesDir = new File(localPath);
        this.defaultBranch = "master";
        this.commitHashFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ LibraryDescriptorsManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                File file = FilesKt.resolve((File)this.this$0.getLocalLibrariesDir(), (String)"commit_sha");
                LibraryDescriptorsManagerImpl libraryDescriptorsManagerImpl = this.this$0;
                File file2 = file;
                boolean bl = false;
                if (!file2.exists()) {
                    LibraryDescriptorsManagerImpl.createDirsAndWrite$default(libraryDescriptorsManagerImpl, file2, null, 1, null);
                }
                return file;
            }
        }));
    }

    @Override
    @NotNull
    public File getUserLibrariesDir() {
        return this.userLibrariesDir;
    }

    @Override
    @NotNull
    public File getUserCacheDir() {
        return this.userCacheDir;
    }

    @Override
    @NotNull
    public File getLocalLibrariesDir() {
        return this.localLibrariesDir;
    }

    @Override
    @NotNull
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @Override
    @Nullable
    public String getLatestCommitOnDefaultBranch() {
        LibraryDescriptorsManager.CommitInfo commitInfo = LibraryDescriptorsManager.DefaultImpls.getLatestCommitToLibraries$default(this, this.getDefaultBranch(), null, 2, null);
        return commitInfo != null ? commitInfo.getSha() : null;
    }

    @Override
    @NotNull
    public File homeLibrariesDir(@Nullable File homeDir2) {
        File file = homeDir2;
        if (file == null) {
            file = new File("");
        }
        return FilesKt.resolve((File)file, (String)this.homePath);
    }

    @Override
    @NotNull
    public File getCommitHashFile() {
        Lazy lazy = this.commitHashFile$delegate;
        return (File)lazy.getValue();
    }

    @Override
    @NotNull
    public String descriptorFileName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return name + ".json";
    }

    @Override
    @NotNull
    public String optionsFileName() {
        return OPTIONS_FILE;
    }

    @Override
    @NotNull
    public String resourceLibraryPath(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.resourcesPath + "/" + this.descriptorFileName(name);
    }

    @Override
    @NotNull
    public String resourceOptionsPath() {
        return this.resourcesPath + "/" + this.optionsFileName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLibraryDescriptor(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isFile()) return false;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        if (!StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Override
    @Nullable
    public LibraryDescriptorsManager.CommitInfo getLatestCommitToLibraries(@NotNull String ref, @Nullable String sinceTimestamp) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return (LibraryDescriptorsManager.CommitInfo)LibraryDescriptorsManagerImpl.catchAll$default(this, null, (Function0)new Function0<LibraryDescriptorsManager.CommitInfo>(this, ref, sinceTimestamp){
            final /* synthetic */ LibraryDescriptorsManagerImpl this$0;
            final /* synthetic */ String $ref;
            final /* synthetic */ String $sinceTimestamp;
            {
                this.this$0 = $receiver;
                this.$ref = $ref;
                this.$sinceTimestamp = $sinceTimestamp;
                super(0);
            }

            @Nullable
            public final LibraryDescriptorsManager.CommitInfo invoke() {
                LibraryDescriptorsManager.CommitInfo commitInfo;
                String url = LibraryDescriptorsManagerImpl.access$getApiPrefix$p(this.this$0) + "/commits?path=" + LibraryDescriptorsManagerImpl.access$getRemotePath$p(this.this$0) + "&sha=" + this.$ref;
                if (this.$sinceTimestamp != null) {
                    url = url + "&since=" + this.$sinceTimestamp;
                }
                LibraryDescriptorsManagerImpl.access$getLogger$p(this.this$0).info("Checking for new commits to library descriptors at " + url);
                JsonArray arr = HttpUtilKt.getJsonArrayOrNull(LibraryDescriptorsManagerImpl.access$getGithubHttpWithAuth(this.this$0, url));
                if (arr == null) {
                    LibraryDescriptorsManagerImpl.access$getLogger$p(this.this$0).error("Request for the latest commit in libraries failed");
                    return null;
                }
                if (arr.isEmpty()) {
                    if (this.$sinceTimestamp != null) {
                        commitInfo = this.this$0.getLatestCommitToLibraries(this.$ref, null);
                    } else {
                        LibraryDescriptorsManagerImpl.access$getLogger$p(this.this$0).info("Didn't find any commits to libraries at " + url);
                        commitInfo = null;
                    }
                } else {
                    JsonElement jsonElement = arr.get(0);
                    Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
                    JsonObject commit = (JsonObject)jsonElement;
                    Object object = commit.get((Object)"sha");
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonPrimitive");
                    String sha2 = ((JsonPrimitive)object).getContent();
                    Object object2 = commit.get((Object)"commit");
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
                    Object object3 = ((JsonObject)object2).get((Object)"committer");
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
                    Object object4 = ((JsonObject)object3).get((Object)"date");
                    Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonPrimitive");
                    String timestamp = ((JsonPrimitive)object4).getContent();
                    commitInfo = new LibraryDescriptorsManager.CommitInfo(sha2, timestamp);
                }
                return commitInfo;
            }
        }, 1, null);
    }

    @Override
    @Nullable
    public String downloadGlobalDescriptorOptions(@NotNull String ref) {
        String string;
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        String url = this.resolveAgainstRemotePath(OPTIONS_FILE, ref);
        this.logger.info("Requesting global descriptor options at " + url);
        try {
            string = this.downloadSingleFile(url);
        }
        catch (Throwable e) {
            this.logger.warn("Unable to load global descriptor options", e);
            string = null;
        }
        return string;
    }

    @Override
    @NotNull
    public String downloadLibraryDescriptor(@NotNull String ref, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String url = this.resolveAgainstRemotePath(name + ".json", ref);
        this.logger.info("Requesting library descriptor at " + url);
        return this.downloadSingleFile(url);
    }

    @Override
    public boolean checkRefExistence(@NotNull String ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        ResponseWrapper response2 = this.getGithubHttpWithAuth(this.resolveAgainstRemotePath("", ref));
        return ResponseKt.getSuccessful(response2.getStatus());
    }

    private final String resolveAgainstRemotePath(String filePath, String ref) {
        StringBuilder stringBuilder;
        StringBuilder $this$resolveAgainstRemotePath_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$resolveAgainstRemotePath_u24lambda_u240.append(this.apiPrefix);
        $this$resolveAgainstRemotePath_u24lambda_u240.append("/contents");
        if (((CharSequence)this.remotePath).length() > 0) {
            $this$resolveAgainstRemotePath_u24lambda_u240.append("/");
            $this$resolveAgainstRemotePath_u24lambda_u240.append(this.remotePath);
        }
        if (((CharSequence)filePath).length() > 0) {
            $this$resolveAgainstRemotePath_u24lambda_u240.append("/");
            $this$resolveAgainstRemotePath_u24lambda_u240.append(filePath);
        }
        $this$resolveAgainstRemotePath_u24lambda_u240.append("?ref=");
        $this$resolveAgainstRemotePath_u24lambda_u240.append(ref);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public boolean checkIfRefUpToDate(@Nullable String remoteRef) {
        if (!this.getCommitHashFile().exists()) {
            return false;
        }
        if (remoteRef == null) {
            this.logger.warn("Considering reference up-to-date because getting the last reference failed");
            return true;
        }
        String localRef = FilesKt.readText$default((File)this.getCommitHashFile(), null, (int)1, null);
        return Intrinsics.areEqual((Object)localRef, (Object)remoteRef);
    }

    @Override
    public void downloadLibraries(@NotNull String ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        FilesKt.deleteRecursively((File)this.getLocalLibrariesDir());
        this.getLocalLibrariesDir().mkdirs();
        String url = this.resolveAgainstRemotePath("", ref);
        this.logger.info("Requesting library descriptors at " + url);
        JsonArray response2 = HttpUtilKt.getJsonArray(this.getGithubHttpWithAuth(url));
        for (JsonElement item : response2) {
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
            JsonObject cfr_ignored_0 = (JsonObject)item;
            JsonElement jsonElement = (JsonElement)((JsonObject)item).get((Object)"type");
            if (!Intrinsics.areEqual((Object)(jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : null), (Object)"file")) continue;
            Object object = ((JsonObject)item).get((Object)"name");
            Intrinsics.checkNotNull((Object)object);
            String fileName = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object)).getContent();
            if (!StringsKt.endsWith$default((String)fileName, (String)".json", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)fileName, (Object)OPTIONS_FILE)) continue;
            Object object2 = ((JsonObject)item).get((Object)"download_url");
            Intrinsics.checkNotNull((Object)object2);
            String downloadUrl = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object2)).getContent();
            ResponseWrapper descriptorResponse = HttpUtilKt.getHttp(this.httpClient, downloadUrl);
            String descriptorText = descriptorResponse.getText();
            File file = FilesKt.resolve((File)this.getLocalLibrariesDir(), (String)fileName);
            FilesKt.writeText$default((File)file, (String)descriptorText, null, (int)2, null);
        }
        this.saveLocalRef(ref);
    }

    private final ResponseWrapper getGithubHttpWithAuth(String url) {
        ResponseWrapper response2;
        ResponseWrapper responseWrapper = response2 = this.authToken == null || this.authUser == null ? HttpUtilKt.getHttp(this.httpClient, url) : HttpUtilKt.getHttpWithAuth(this.httpClient, url, this.authUser, this.authToken);
        if (this.logger.isDebugEnabled() && !ResponseKt.getSuccessful(response2.getStatus())) {
            this.logger.debug("Request to GitHub API '" + url + "' failed, response:\n" + response2.getText());
        }
        return response2;
    }

    private final String downloadSingleFile(String contentsApiUrl) {
        JsonObject response2 = HttpUtilKt.getJsonObject(this.getGithubHttpWithAuth(contentsApiUrl));
        Object object = response2.get((Object)"download_url");
        Intrinsics.checkNotNull((Object)object);
        String downloadUrl = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object)).getContent();
        ResponseWrapper res2 = HttpUtilKt.getHttp(this.httpClient, downloadUrl);
        HttpUtilKt.assertSuccessful(res2);
        return res2.getText();
    }

    private final void saveLocalRef(String ref) {
        this.createDirsAndWrite(this.getCommitHashFile(), ref);
    }

    private final void createDirsAndWrite(File $this$createDirsAndWrite, String text2) {
        $this$createDirsAndWrite.getParentFile().mkdirs();
        FilesKt.writeText$default((File)$this$createDirsAndWrite, (String)text2, null, (int)2, null);
    }

    static /* synthetic */ void createDirsAndWrite$default(LibraryDescriptorsManagerImpl libraryDescriptorsManagerImpl, File file, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        libraryDescriptorsManagerImpl.createDirsAndWrite(file, string);
    }

    private final <T> T catchAll(String message2, Function0<? extends T> body) {
        Object object;
        try {
            object = body.invoke();
        }
        catch (Throwable e) {
            this.exceptionsHandler.handle(this.logger, message2, e);
            object = null;
        }
        return (T)object;
    }

    static /* synthetic */ Object catchAll$default(LibraryDescriptorsManagerImpl libraryDescriptorsManagerImpl, String string, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return libraryDescriptorsManagerImpl.catchAll(string, function0);
    }

    public static final /* synthetic */ String access$getApiPrefix$p(LibraryDescriptorsManagerImpl $this) {
        return $this.apiPrefix;
    }

    public static final /* synthetic */ String access$getRemotePath$p(LibraryDescriptorsManagerImpl $this) {
        return $this.remotePath;
    }

    public static final /* synthetic */ Logger access$getLogger$p(LibraryDescriptorsManagerImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ ResponseWrapper access$getGithubHttpWithAuth(LibraryDescriptorsManagerImpl $this, String url) {
        return $this.getGithubHttpWithAuth(url);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManagerImpl$Companion;", "", "()V", "COMMIT_HASH_FILE", "", "DESCRIPTOR_EXTENSION", "GITHUB_API_HOST", "OPTIONS_FILE", "common-dependencies"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

