/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.batik.util.resources.ResourceFormatException;

public class ResourceManager {
    protected ResourceBundle bundle;

    public ResourceManager(ResourceBundle rb) {
        this.bundle = rb;
    }

    public String getString(String key2) throws MissingResourceException {
        return this.bundle.getString(key2);
    }

    public List getStringList(String key2) throws MissingResourceException {
        return this.getStringList(key2, " \t\n\r\f", false);
    }

    public List getStringList(String key2, String delim) throws MissingResourceException {
        return this.getStringList(key2, delim, false);
    }

    public List getStringList(String key2, String delim, boolean returnDelims) throws MissingResourceException {
        ArrayList<String> result2 = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.getString(key2), delim, returnDelims);
        while (st.hasMoreTokens()) {
            result2.add(st.nextToken());
        }
        return result2;
    }

    public boolean getBoolean(String key2) throws MissingResourceException, ResourceFormatException {
        String b = this.getString(key2);
        if (b.equals("true")) {
            return true;
        }
        if (b.equals("false")) {
            return false;
        }
        throw new ResourceFormatException("Malformed boolean", this.bundle.getClass().getName(), key2);
    }

    public int getInteger(String key2) throws MissingResourceException, ResourceFormatException {
        String i = this.getString(key2);
        try {
            return Integer.parseInt(i);
        }
        catch (NumberFormatException e) {
            throw new ResourceFormatException("Malformed integer", this.bundle.getClass().getName(), key2);
        }
    }

    public int getCharacter(String key2) throws MissingResourceException, ResourceFormatException {
        String s = this.getString(key2);
        if (s == null || s.length() == 0) {
            throw new ResourceFormatException("Malformed character", this.bundle.getClass().getName(), key2);
        }
        return s.charAt(0);
    }
}

