/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.util.CleanerThread;

public class SoftReferenceCache {
    protected final Map map = new HashMap();
    private final boolean synchronous;

    protected SoftReferenceCache() {
        this(false);
    }

    protected SoftReferenceCache(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public synchronized void flush() {
        this.map.clear();
        this.notifyAll();
    }

    protected final synchronized boolean isPresentImpl(Object key2) {
        if (!this.map.containsKey(key2)) {
            return false;
        }
        Object o2 = this.map.get(key2);
        if (o2 == null) {
            return true;
        }
        SoftReference sr = (SoftReference)o2;
        if ((o2 = sr.get()) != null) {
            return true;
        }
        this.clearImpl(key2);
        return false;
    }

    protected final synchronized boolean isDoneImpl(Object key2) {
        Object o2 = this.map.get(key2);
        if (o2 == null) {
            return false;
        }
        SoftReference sr = (SoftReference)o2;
        if ((o2 = sr.get()) != null) {
            return true;
        }
        this.clearImpl(key2);
        return false;
    }

    protected final synchronized Object requestImpl(Object key2) {
        if (this.map.containsKey(key2)) {
            SoftReference sr;
            Object o2 = this.map.get(key2);
            while (o2 == null) {
                if (this.synchronous) {
                    return null;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.map.containsKey(key2)) break;
                o2 = this.map.get(key2);
            }
            if (o2 != null && (o2 = (sr = (SoftReference)o2).get()) != null) {
                return o2;
            }
        }
        this.map.put(key2, null);
        return null;
    }

    protected final synchronized void clearImpl(Object key2) {
        this.map.remove(key2);
        this.notifyAll();
    }

    protected final synchronized void putImpl(Object key2, Object object) {
        if (this.map.containsKey(key2)) {
            SoftRefKey ref = new SoftRefKey(object, key2);
            this.map.put(key2, ref);
            this.notifyAll();
        }
    }

    class SoftRefKey
    extends CleanerThread.SoftReferenceCleared {
        Object key;

        public SoftRefKey(Object o2, Object key2) {
            super(o2);
            this.key = key2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleared() {
            SoftReferenceCache cache = SoftReferenceCache.this;
            if (cache == null) {
                return;
            }
            SoftReferenceCache softReferenceCache = cache;
            synchronized (softReferenceCache) {
                if (!cache.map.containsKey(this.key)) {
                    return;
                }
                Object o2 = cache.map.remove(this.key);
                if (this == o2) {
                    cache.notifyAll();
                } else {
                    cache.map.put(this.key, o2);
                }
            }
        }
    }
}

