/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class PreferenceManager {
    protected Properties internal;
    protected Map defaults;
    protected String prefFileName;
    protected String fullName = null;
    protected static final String USER_HOME = PreferenceManager.getSystemProperty("user.home");
    protected static final String USER_DIR = PreferenceManager.getSystemProperty("user.dir");
    protected static final String FILE_SEP = PreferenceManager.getSystemProperty("file.separator");
    private static String PREF_DIR = null;

    protected static String getSystemProperty(String prop) {
        try {
            return System.getProperty(prop);
        }
        catch (AccessControlException e) {
            return "";
        }
    }

    public PreferenceManager(String prefFileName) {
        this(prefFileName, null);
    }

    public PreferenceManager(String prefFileName, Map defaults) {
        this.prefFileName = prefFileName;
        this.defaults = defaults;
        this.internal = new Properties();
    }

    public static void setPreferenceDirectory(String dir) {
        PREF_DIR = dir;
    }

    public static String getPreferenceDirectory() {
        return PREF_DIR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        FileInputStream fis = null;
        if (this.fullName != null) {
            try {
                fis = new FileInputStream(this.fullName);
            }
            catch (IOException e1) {
                this.fullName = null;
            }
        }
        if (this.fullName == null) {
            if (PREF_DIR != null) {
                try {
                    this.fullName = PREF_DIR + FILE_SEP + this.prefFileName;
                    fis = new FileInputStream((String)this.fullName);
                }
                catch (IOException e2) {
                    this.fullName = null;
                }
            }
            if (this.fullName == null) {
                try {
                    this.fullName = USER_HOME + FILE_SEP + this.prefFileName;
                    fis = new FileInputStream((String)this.fullName);
                }
                catch (IOException e3) {
                    try {
                        this.fullName = USER_DIR + FILE_SEP + this.prefFileName;
                        fis = new FileInputStream((String)this.fullName);
                    }
                    catch (IOException e4) {
                        this.fullName = null;
                    }
                }
            }
        }
        if (this.fullName != null) {
            try {
                this.internal.load(fis);
            }
            finally {
                fis.close();
            }
        }
    }

    public void save() throws IOException {
        FileOutputStream fos = null;
        if (this.fullName != null) {
            try {
                fos = new FileOutputStream(this.fullName);
            }
            catch (IOException e1) {
                this.fullName = null;
            }
        }
        if (this.fullName == null) {
            if (PREF_DIR != null) {
                try {
                    this.fullName = PREF_DIR + FILE_SEP + this.prefFileName;
                    fos = new FileOutputStream((String)this.fullName);
                }
                catch (IOException e2) {
                    this.fullName = null;
                }
            }
            if (this.fullName == null) {
                try {
                    this.fullName = USER_HOME + FILE_SEP + this.prefFileName;
                    fos = new FileOutputStream((String)this.fullName);
                }
                catch (IOException e3) {
                    this.fullName = null;
                    throw e3;
                }
            }
        }
        try {
            this.internal.store(fos, this.prefFileName);
        }
        finally {
            fos.close();
        }
    }

    private Object getDefault(String key2) {
        if (this.defaults != null) {
            return this.defaults.get(key2);
        }
        return null;
    }

    public Rectangle getRectangle(String key2) {
        Rectangle defaultValue = (Rectangle)this.getDefault(key2);
        String sp = this.internal.getProperty(key2);
        if (sp == null) {
            return defaultValue;
        }
        Rectangle result2 = new Rectangle();
        try {
            StringTokenizer st = new StringTokenizer(sp, " ", false);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            String token = st.nextToken();
            int x = Integer.parseInt(token);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            token = st.nextToken();
            int y = Integer.parseInt(token);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            token = st.nextToken();
            int w = Integer.parseInt(token);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            token = st.nextToken();
            int h = Integer.parseInt(token);
            result2.setBounds(x, y, w, h);
            return result2;
        }
        catch (NumberFormatException e) {
            this.internal.remove(key2);
            return defaultValue;
        }
    }

    public Dimension getDimension(String key2) {
        Dimension defaultValue = (Dimension)this.getDefault(key2);
        String sp = this.internal.getProperty(key2);
        if (sp == null) {
            return defaultValue;
        }
        Dimension result2 = new Dimension();
        try {
            StringTokenizer st = new StringTokenizer(sp, " ", false);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            String token = st.nextToken();
            int w = Integer.parseInt(token);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            token = st.nextToken();
            int h = Integer.parseInt(token);
            result2.setSize(w, h);
            return result2;
        }
        catch (NumberFormatException e) {
            this.internal.remove(key2);
            return defaultValue;
        }
    }

    public Point getPoint(String key2) {
        Point defaultValue = (Point)this.getDefault(key2);
        String sp = this.internal.getProperty(key2);
        if (sp == null) {
            return defaultValue;
        }
        Point result2 = new Point();
        try {
            StringTokenizer st = new StringTokenizer(sp, " ", false);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            String token = st.nextToken();
            int x = Integer.parseInt(token);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            token = st.nextToken();
            int y = Integer.parseInt(token);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            result2.setLocation(x, y);
            return result2;
        }
        catch (NumberFormatException e) {
            this.internal.remove(key2);
            return defaultValue;
        }
    }

    public Color getColor(String key2) {
        Color defaultValue = (Color)this.getDefault(key2);
        String sp = this.internal.getProperty(key2);
        if (sp == null) {
            return defaultValue;
        }
        try {
            StringTokenizer st = new StringTokenizer(sp, " ", false);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            String token = st.nextToken();
            int r = Integer.parseInt(token);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            token = st.nextToken();
            int g = Integer.parseInt(token);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            token = st.nextToken();
            int b = Integer.parseInt(token);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            token = st.nextToken();
            int a = Integer.parseInt(token);
            return new Color(r, g, b, a);
        }
        catch (NumberFormatException e) {
            this.internal.remove(key2);
            return defaultValue;
        }
    }

    public Font getFont(String key2) {
        Font defaultValue = (Font)this.getDefault(key2);
        String sp = this.internal.getProperty(key2);
        if (sp == null) {
            return defaultValue;
        }
        try {
            StringTokenizer st = new StringTokenizer(sp, " ", false);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            String name = st.nextToken();
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            String token = st.nextToken();
            int size = Integer.parseInt(token);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key2);
                return defaultValue;
            }
            token = st.nextToken();
            int type2 = Integer.parseInt(token);
            return new Font(name, type2, size);
        }
        catch (NumberFormatException e) {
            this.internal.remove(key2);
            return defaultValue;
        }
    }

    public String getString(String key2) {
        String sp = this.internal.getProperty(key2);
        if (sp == null) {
            sp = (String)this.getDefault(key2);
        }
        return sp;
    }

    public String[] getStrings(String mkey) {
        int i = 0;
        ArrayList<String> v = new ArrayList<String>();
        while (true) {
            String last = this.getString(mkey + i);
            ++i;
            if (last == null) break;
            v.add(last);
        }
        if (v.size() != 0) {
            String[] str = new String[v.size()];
            return v.toArray(str);
        }
        return (String[])this.getDefault(mkey);
    }

    public URL getURL(String key2) {
        URL url;
        URL defaultValue = (URL)this.getDefault(key2);
        String sp = this.internal.getProperty(key2);
        if (sp == null) {
            return defaultValue;
        }
        try {
            url = new URL(sp);
        }
        catch (MalformedURLException ex) {
            this.internal.remove(key2);
            return defaultValue;
        }
        return url;
    }

    public URL[] getURLs(String mkey) {
        int i = 0;
        ArrayList<URL> v = new ArrayList<URL>();
        while (true) {
            URL last = this.getURL(mkey + i);
            ++i;
            if (last == null) break;
            v.add(last);
        }
        if (v.size() != 0) {
            URL[] path2 = new URL[v.size()];
            return v.toArray(path2);
        }
        return (URL[])this.getDefault(mkey);
    }

    public File getFile(String key2) {
        File defaultValue = (File)this.getDefault(key2);
        String sp = this.internal.getProperty(key2);
        if (sp == null) {
            return defaultValue;
        }
        File file = new File(sp);
        if (file.exists()) {
            return file;
        }
        this.internal.remove(key2);
        return defaultValue;
    }

    public File[] getFiles(String mkey) {
        int i = 0;
        ArrayList<File> v = new ArrayList<File>();
        while (true) {
            File last = this.getFile(mkey + i);
            ++i;
            if (last == null) break;
            v.add(last);
        }
        if (v.size() != 0) {
            File[] path2 = new File[v.size()];
            return v.toArray(path2);
        }
        return (File[])this.getDefault(mkey);
    }

    public int getInteger(String key2) {
        int value;
        String sp;
        int defaultValue = 0;
        if (this.getDefault(key2) != null) {
            defaultValue = (Integer)this.getDefault(key2);
        }
        if ((sp = this.internal.getProperty(key2)) == null) {
            return defaultValue;
        }
        try {
            value = Integer.parseInt(sp);
        }
        catch (NumberFormatException ex) {
            this.internal.remove(key2);
            return defaultValue;
        }
        return value;
    }

    public float getFloat(String key2) {
        float value;
        String sp;
        float defaultValue = 0.0f;
        if (this.getDefault(key2) != null) {
            defaultValue = ((Float)this.getDefault(key2)).floatValue();
        }
        if ((sp = this.internal.getProperty(key2)) == null) {
            return defaultValue;
        }
        try {
            value = Float.parseFloat(sp);
        }
        catch (NumberFormatException ex) {
            this.setFloat(key2, defaultValue);
            return defaultValue;
        }
        return value;
    }

    public boolean getBoolean(String key2) {
        if (this.internal.getProperty(key2) != null) {
            return this.internal.getProperty(key2).equals("true");
        }
        if (this.getDefault(key2) != null) {
            return (Boolean)this.getDefault(key2);
        }
        return false;
    }

    public void setRectangle(String key2, Rectangle value) {
        if (value != null && !value.equals(this.getDefault(key2))) {
            this.internal.setProperty(key2, value.x + " " + value.y + " " + value.width + " " + value.height);
        } else {
            this.internal.remove(key2);
        }
    }

    public void setDimension(String key2, Dimension value) {
        if (value != null && !value.equals(this.getDefault(key2))) {
            this.internal.setProperty(key2, value.width + " " + value.height);
        } else {
            this.internal.remove(key2);
        }
    }

    public void setPoint(String key2, Point value) {
        if (value != null && !value.equals(this.getDefault(key2))) {
            this.internal.setProperty(key2, value.x + " " + value.y);
        } else {
            this.internal.remove(key2);
        }
    }

    public void setColor(String key2, Color value) {
        if (value != null && !value.equals(this.getDefault(key2))) {
            this.internal.setProperty(key2, value.getRed() + " " + value.getGreen() + " " + value.getBlue() + " " + value.getAlpha());
        } else {
            this.internal.remove(key2);
        }
    }

    public void setFont(String key2, Font value) {
        if (value != null && !value.equals(this.getDefault(key2))) {
            this.internal.setProperty(key2, value.getName() + " " + value.getSize() + " " + value.getStyle());
        } else {
            this.internal.remove(key2);
        }
    }

    public void setString(String key2, String value) {
        if (value != null && !value.equals(this.getDefault(key2))) {
            this.internal.setProperty(key2, value);
        } else {
            this.internal.remove(key2);
        }
    }

    public void setStrings(String mkey, String[] values) {
        String last;
        int j = 0;
        if (values != null) {
            for (String value : values) {
                if (value == null) continue;
                this.setString(mkey + j, value);
                ++j;
            }
        }
        while ((last = this.getString(mkey + j)) != null) {
            this.setString(mkey + j, null);
            ++j;
        }
    }

    public void setURL(String key2, URL value) {
        if (value != null && !value.equals(this.getDefault(key2))) {
            this.internal.setProperty(key2, value.toString());
        } else {
            this.internal.remove(key2);
        }
    }

    public void setURLs(String mkey, URL[] values) {
        String last;
        int j = 0;
        if (values != null) {
            for (URL value : values) {
                if (value == null) continue;
                this.setURL(mkey + j, value);
                ++j;
            }
        }
        while ((last = this.getString(mkey + j)) != null) {
            this.setString(mkey + j, null);
            ++j;
        }
    }

    public void setFile(String key2, File value) {
        if (value != null && !value.equals(this.getDefault(key2))) {
            this.internal.setProperty(key2, value.getAbsolutePath());
        } else {
            this.internal.remove(key2);
        }
    }

    public void setFiles(String mkey, File[] values) {
        String last;
        int j = 0;
        if (values != null) {
            for (File value : values) {
                if (value == null) continue;
                this.setFile(mkey + j, value);
                ++j;
            }
        }
        while ((last = this.getString(mkey + j)) != null) {
            this.setString(mkey + j, null);
            ++j;
        }
    }

    public void setInteger(String key2, int value) {
        if (this.getDefault(key2) != null && (Integer)this.getDefault(key2) != value) {
            this.internal.setProperty(key2, Integer.toString(value));
        } else {
            this.internal.remove(key2);
        }
    }

    public void setFloat(String key2, float value) {
        if (this.getDefault(key2) != null && ((Float)this.getDefault(key2)).floatValue() != value) {
            this.internal.setProperty(key2, Float.toString(value));
        } else {
            this.internal.remove(key2);
        }
    }

    public void setBoolean(String key2, boolean value) {
        if (this.getDefault(key2) != null && (Boolean)this.getDefault(key2) != value) {
            this.internal.setProperty(key2, value ? "true" : "false");
        } else {
            this.internal.remove(key2);
        }
    }
}

