/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.values.AnimatableNumberValue;
import org.apache.batik.anim.values.AnimatableValue;

public class AnimatableNumberOrIdentValue
extends AnimatableNumberValue {
    protected boolean isIdent;
    protected String ident;
    protected boolean numericIdent;

    protected AnimatableNumberOrIdentValue(AnimationTarget target) {
        super(target);
    }

    public AnimatableNumberOrIdentValue(AnimationTarget target, float v, boolean numericIdent) {
        super(target, v);
        this.numericIdent = numericIdent;
    }

    public AnimatableNumberOrIdentValue(AnimationTarget target, String ident) {
        super(target);
        this.ident = ident;
        this.isIdent = true;
    }

    @Override
    public boolean canPace() {
        return false;
    }

    @Override
    public float distanceTo(AnimatableValue other) {
        return 0.0f;
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatableNumberOrIdentValue(this.target, 0.0f, this.numericIdent);
    }

    @Override
    public String getCssText() {
        if (this.isIdent) {
            return this.ident;
        }
        if (this.numericIdent) {
            return Integer.toString((int)this.value);
        }
        return super.getCssText();
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue result2, AnimatableValue to, float interpolation, AnimatableValue accumulation, int multiplier) {
        AnimatableNumberOrIdentValue res2 = result2 == null ? new AnimatableNumberOrIdentValue(this.target) : (AnimatableNumberOrIdentValue)result2;
        if (to == null) {
            if (this.isIdent) {
                res2.hasChanged = !res2.isIdent || !res2.ident.equals(this.ident);
                res2.ident = this.ident;
                res2.isIdent = true;
            } else if (this.numericIdent) {
                res2.value = this.value;
                res2.isIdent = false;
                res2.hasChanged = true;
                res2.numericIdent = true;
            } else {
                float oldValue = res2.value;
                super.interpolate(res2, to, interpolation, accumulation, multiplier);
                res2.numericIdent = false;
                if (res2.value != oldValue) {
                    res2.hasChanged = true;
                }
            }
        } else {
            AnimatableNumberOrIdentValue toValue = (AnimatableNumberOrIdentValue)to;
            if (this.isIdent || toValue.isIdent || this.numericIdent) {
                if ((double)interpolation >= 0.5) {
                    if (res2.isIdent != toValue.isIdent || res2.value != toValue.value || res2.isIdent && toValue.isIdent && !toValue.ident.equals(this.ident)) {
                        res2.isIdent = toValue.isIdent;
                        res2.ident = toValue.ident;
                        res2.value = toValue.value;
                        res2.numericIdent = toValue.numericIdent;
                        res2.hasChanged = true;
                    }
                } else if (res2.isIdent != this.isIdent || res2.value != this.value || res2.isIdent && this.isIdent && !res2.ident.equals(this.ident)) {
                    res2.isIdent = this.isIdent;
                    res2.ident = this.ident;
                    res2.value = this.value;
                    res2.numericIdent = this.numericIdent;
                    res2.hasChanged = true;
                }
            } else {
                super.interpolate(res2, to, interpolation, accumulation, multiplier);
                res2.numericIdent = false;
            }
        }
        return res2;
    }
}

