/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.values.AnimatableLengthValue;
import org.apache.batik.anim.values.AnimatableValue;

public class AnimatableLengthOrIdentValue
extends AnimatableLengthValue {
    protected boolean isIdent;
    protected String ident;

    protected AnimatableLengthOrIdentValue(AnimationTarget target) {
        super(target);
    }

    public AnimatableLengthOrIdentValue(AnimationTarget target, short type2, float v, short pcInterp) {
        super(target, type2, v, pcInterp);
    }

    public AnimatableLengthOrIdentValue(AnimationTarget target, String ident) {
        super(target);
        this.ident = ident;
        this.isIdent = true;
    }

    public boolean isIdent() {
        return this.isIdent;
    }

    public String getIdent() {
        return this.ident;
    }

    @Override
    public boolean canPace() {
        return false;
    }

    @Override
    public float distanceTo(AnimatableValue other) {
        return 0.0f;
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatableLengthOrIdentValue(this.target, 1, 0.0f, this.percentageInterpretation);
    }

    @Override
    public String getCssText() {
        if (this.isIdent) {
            return this.ident;
        }
        return super.getCssText();
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue result2, AnimatableValue to, float interpolation, AnimatableValue accumulation, int multiplier) {
        AnimatableLengthOrIdentValue res2 = result2 == null ? new AnimatableLengthOrIdentValue(this.target) : (AnimatableLengthOrIdentValue)result2;
        if (to == null) {
            if (this.isIdent) {
                res2.hasChanged = !res2.isIdent || !res2.ident.equals(this.ident);
                res2.ident = this.ident;
                res2.isIdent = true;
            } else {
                short oldLengthType = res2.lengthType;
                float oldLengthValue = res2.lengthValue;
                short oldPercentageInterpretation = res2.percentageInterpretation;
                super.interpolate(res2, to, interpolation, accumulation, multiplier);
                if (res2.lengthType != oldLengthType || res2.lengthValue != oldLengthValue || res2.percentageInterpretation != oldPercentageInterpretation) {
                    res2.hasChanged = true;
                }
            }
        } else {
            AnimatableLengthOrIdentValue toValue = (AnimatableLengthOrIdentValue)to;
            if (this.isIdent || toValue.isIdent) {
                if ((double)interpolation >= 0.5) {
                    if (res2.isIdent != toValue.isIdent || res2.lengthType != toValue.lengthType || res2.lengthValue != toValue.lengthValue || res2.isIdent && toValue.isIdent && !toValue.ident.equals(this.ident)) {
                        res2.isIdent = toValue.isIdent;
                        res2.ident = toValue.ident;
                        res2.lengthType = toValue.lengthType;
                        res2.lengthValue = toValue.lengthValue;
                        res2.hasChanged = true;
                    }
                } else if (res2.isIdent != this.isIdent || res2.lengthType != this.lengthType || res2.lengthValue != this.lengthValue || res2.isIdent && this.isIdent && !res2.ident.equals(this.ident)) {
                    res2.isIdent = this.isIdent;
                    res2.ident = this.ident;
                    res2.lengthType = this.lengthType;
                    res2.hasChanged = true;
                }
            } else {
                super.interpolate(res2, to, interpolation, accumulation, multiplier);
            }
        }
        return res2;
    }
}

