/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.values.AnimatableValue;

public class AnimatableIntegerValue
extends AnimatableValue {
    protected int value;

    protected AnimatableIntegerValue(AnimationTarget target) {
        super(target);
    }

    public AnimatableIntegerValue(AnimationTarget target, int v) {
        super(target);
        this.value = v;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue result2, AnimatableValue to, float interpolation, AnimatableValue accumulation, int multiplier) {
        AnimatableIntegerValue res2 = result2 == null ? new AnimatableIntegerValue(this.target) : (AnimatableIntegerValue)result2;
        int v = this.value;
        if (to != null) {
            AnimatableIntegerValue toInteger = (AnimatableIntegerValue)to;
            v = (int)((float)v + ((float)this.value + interpolation * (float)(toInteger.getValue() - this.value)));
        }
        if (accumulation != null) {
            AnimatableIntegerValue accInteger = (AnimatableIntegerValue)accumulation;
            v += multiplier * accInteger.getValue();
        }
        if (res2.value != v) {
            res2.value = v;
            res2.hasChanged = true;
        }
        return res2;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public boolean canPace() {
        return true;
    }

    @Override
    public float distanceTo(AnimatableValue other) {
        AnimatableIntegerValue o2 = (AnimatableIntegerValue)other;
        return Math.abs(this.value - o2.value);
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatableIntegerValue(this.target, 0);
    }

    @Override
    public String getCssText() {
        return Integer.toString(this.value);
    }
}

