/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.values.AnimatableValue;

public class AnimatableColorValue
extends AnimatableValue {
    protected float red;
    protected float green;
    protected float blue;

    protected AnimatableColorValue(AnimationTarget target) {
        super(target);
    }

    public AnimatableColorValue(AnimationTarget target, float r, float g, float b) {
        super(target);
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue result2, AnimatableValue to, float interpolation, AnimatableValue accumulation, int multiplier) {
        AnimatableColorValue res2 = result2 == null ? new AnimatableColorValue(this.target) : (AnimatableColorValue)result2;
        float oldRed = res2.red;
        float oldGreen = res2.green;
        float oldBlue = res2.blue;
        res2.red = this.red;
        res2.green = this.green;
        res2.blue = this.blue;
        AnimatableColorValue toColor = (AnimatableColorValue)to;
        AnimatableColorValue accColor = (AnimatableColorValue)accumulation;
        if (to != null) {
            res2.red += interpolation * (toColor.red - res2.red);
            res2.green += interpolation * (toColor.green - res2.green);
            res2.blue += interpolation * (toColor.blue - res2.blue);
        }
        if (accumulation != null) {
            res2.red += (float)multiplier * accColor.red;
            res2.green += (float)multiplier * accColor.green;
            res2.blue += (float)multiplier * accColor.blue;
        }
        if (res2.red != oldRed || res2.green != oldGreen || res2.blue != oldBlue) {
            res2.hasChanged = true;
        }
        return res2;
    }

    @Override
    public boolean canPace() {
        return true;
    }

    @Override
    public float distanceTo(AnimatableValue other) {
        AnimatableColorValue o2 = (AnimatableColorValue)other;
        float dr = this.red - o2.red;
        float dg = this.green - o2.green;
        float db = this.blue - o2.blue;
        return (float)Math.sqrt(dr * dr + dg * dg + db * db);
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatableColorValue(this.target, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public String getCssText() {
        return "rgb(" + Math.round(this.red * 255.0f) + "," + Math.round(this.green * 255.0f) + "," + Math.round(this.blue * 255.0f) + ")";
    }
}

