/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.values.AnimatableAngleValue;
import org.apache.batik.anim.values.AnimatableValue;

public class AnimatableAngleOrIdentValue
extends AnimatableAngleValue {
    protected boolean isIdent;
    protected String ident;

    protected AnimatableAngleOrIdentValue(AnimationTarget target) {
        super(target);
    }

    public AnimatableAngleOrIdentValue(AnimationTarget target, float v, short unit) {
        super(target, v, unit);
    }

    public AnimatableAngleOrIdentValue(AnimationTarget target, String ident) {
        super(target);
        this.ident = ident;
        this.isIdent = true;
    }

    public boolean isIdent() {
        return this.isIdent;
    }

    public String getIdent() {
        return this.ident;
    }

    @Override
    public boolean canPace() {
        return false;
    }

    @Override
    public float distanceTo(AnimatableValue other) {
        return 0.0f;
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatableAngleOrIdentValue(this.target, 0.0f, 1);
    }

    @Override
    public String getCssText() {
        if (this.isIdent) {
            return this.ident;
        }
        return super.getCssText();
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue result2, AnimatableValue to, float interpolation, AnimatableValue accumulation, int multiplier) {
        AnimatableAngleOrIdentValue res2 = result2 == null ? new AnimatableAngleOrIdentValue(this.target) : (AnimatableAngleOrIdentValue)result2;
        if (to == null) {
            if (this.isIdent) {
                res2.hasChanged = !res2.isIdent || !res2.ident.equals(this.ident);
                res2.ident = this.ident;
                res2.isIdent = true;
            } else {
                short oldUnit = res2.unit;
                float oldValue = res2.value;
                super.interpolate(res2, to, interpolation, accumulation, multiplier);
                if (res2.unit != oldUnit || res2.value != oldValue) {
                    res2.hasChanged = true;
                }
            }
        } else {
            AnimatableAngleOrIdentValue toValue = (AnimatableAngleOrIdentValue)to;
            if (this.isIdent || toValue.isIdent) {
                if ((double)interpolation >= 0.5) {
                    if (res2.isIdent != toValue.isIdent || res2.unit != toValue.unit || res2.value != toValue.value || res2.isIdent && toValue.isIdent && !toValue.ident.equals(this.ident)) {
                        res2.isIdent = toValue.isIdent;
                        res2.ident = toValue.ident;
                        res2.unit = toValue.unit;
                        res2.value = toValue.value;
                        res2.hasChanged = true;
                    }
                } else if (res2.isIdent != this.isIdent || res2.unit != this.unit || res2.value != this.value || res2.isIdent && this.isIdent && !res2.ident.equals(this.ident)) {
                    res2.isIdent = this.isIdent;
                    res2.ident = this.ident;
                    res2.unit = this.unit;
                    res2.value = this.value;
                    res2.hasChanged = true;
                }
            } else {
                super.interpolate(res2, to, interpolation, accumulation, multiplier);
            }
        }
        return res2;
    }
}

