/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.tables;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterBrowserOutputDataKey;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterOutputDataKeyExtractor;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterOutputDataKeyExtractorKt;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.JupyterWebOutputInfo;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterExecuteResultOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputType;
import com.intellij.jupyter.tables.ExtractingKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookApplicationOptions;
import com.intellij.kotlin.jupyter.tables.KotlinDataframeParsing;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.outputs.NotebookOutputDataKey;
import com.intellij.notebooks.visualization.outputs.NotebookOutputDataKeyExtractor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.DSTableText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J9\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kotlin/jupyter/tables/KotlinDataframeOutputDataKeyExtractor;", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKeyExtractor;", "<init>", "()V", "jupyterDelegate", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterOutputDataKeyExtractor;", "extract", "", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "editor", "Lcom/intellij/openapi/editor/Editor;", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "isBrowserTableOutputKey", "", "key", "extractImpl", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "getKotlinDataframeOutputDataKey", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "dataObject", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "executionCount", "", "isLastForCell", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Lcom/fasterxml/jackson/databind/node/ObjectNode;Ljava/lang/Integer;Z)Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "intellij.kotlin.jupyter.tables"})
@SourceDebugExtension(value={"SMAP\nKotlinDataframeOutputDataKeyExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDataframeOutputDataKeyExtractor.kt\ncom/intellij/kotlin/jupyter/tables/KotlinDataframeOutputDataKeyExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,111:1\n827#2:112\n855#2,2:113\n19#3:115\n*S KotlinDebug\n*F\n+ 1 KotlinDataframeOutputDataKeyExtractor.kt\ncom/intellij/kotlin/jupyter/tables/KotlinDataframeOutputDataKeyExtractor\n*L\n47#1:112\n47#1:113,2\n73#1:115\n*E\n"})
public final class KotlinDataframeOutputDataKeyExtractor
implements NotebookOutputDataKeyExtractor {
    @NotNull
    private final JupyterOutputDataKeyExtractor jupyterDelegate = new JupyterOutputDataKeyExtractor();

    /*
     * WARNING - void declaration
     */
    @Nullable
    public List<NotebookOutputDataKey> extract(@NotNull Editor editor, @NotNull NotebookCellLines.Interval interval) {
        List list;
        List jupyterKeys;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        List<NotebookOutputDataKey> res2 = !KotlinNotebookApplicationOptions.INSTANCE.get().getShowDataFrameAsSwing() ? null : (!JupyterEditorExtensionsKt.isJupyter((Editor)editor) ? null : (!Intrinsics.areEqual((Object)interval.getLanguage(), (Object)KotlinLanguage.INSTANCE) ? null : this.extractImpl((EditorImpl)editor, interval)));
        Collection collection = res2;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        List list2 = jupyterKeys = this.jupyterDelegate.extract(editor, interval);
        if (list2 != null) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = list2;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                NotebookOutputDataKey it = (NotebookOutputDataKey)element$iv$iv;
                boolean bl = false;
                if (this.isBrowserTableOutputKey(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)list, (Iterable)res2);
    }

    private final boolean isBrowserTableOutputKey(NotebookOutputDataKey key2) {
        if (!(key2 instanceof JupyterBrowserOutputDataKey)) {
            return false;
        }
        JupyterWebOutputInfo info = ((JupyterBrowserOutputDataKey)key2).getInfo();
        if (!(info instanceof JupyterWebOutputInfo.Output)) {
            return false;
        }
        JsonNode jsonNode = JupyterJsonKt.getJackson().readTree(((JupyterWebOutputInfo.Output)info).getOutput());
        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        ObjectNode jsonOutput = (ObjectNode)jsonNode;
        return jsonOutput.get("application/kotlindataframe+json") != null;
    }

    private final List<NotebookOutputDataKey> extractImpl(EditorImpl editor, NotebookCellLines.Interval interval) {
        Object object = JupyterOutputDataKeyExtractorKt.getOutputsForIndex((Editor)((Editor)editor), (int)interval.getOrdinal());
        if (object == null || (object = object.getOutputs()) == null) {
            return CollectionsKt.emptyList();
        }
        Object outputSequence = object;
        NotebookIntervalPointer cellPointer = NotebookIntervalPointerFactory.Companion.get((Editor)editor).create(interval);
        ArrayList<NotebookOutputDataKey> result2 = new ArrayList<NotebookOutputDataKey>();
        Iterator iterator = ((Iterable)outputSequence).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int outputIndex = n++;
            JupyterOutput output = (JupyterOutput)iterator.next();
            if (output.getOutputType() != JupyterOutputType.EXECUTE_RESULT && output.getOutputType() != JupyterOutputType.DISPLAY_DATA) continue;
            JsonNode jsonNode = output.getJson().get("data");
            if (jsonNode == null) continue;
            JsonNode $this$asSafely$iv = jsonNode;
            boolean $i$f$asSafely = false;
            JsonNode jsonNode2 = $this$asSafely$iv;
            if (!(jsonNode2 instanceof ObjectNode)) {
                jsonNode2 = null;
            }
            if ((jsonNode = (ObjectNode)jsonNode2) == null) continue;
            JsonNode dataObject = jsonNode;
            boolean bl = false;
            JupyterExecuteResultOutput jupyterExecuteResultOutput = output instanceof JupyterExecuteResultOutput ? (JupyterExecuteResultOutput)output : null;
            Integer executionCount = jupyterExecuteResultOutput != null ? Integer.valueOf(jupyterExecuteResultOutput.getExecutionCount()) : null;
            NotebookOutputDataKey kotlinDfDataKey = this.getKotlinDataframeOutputDataKey(editor, cellPointer, (ObjectNode)dataObject, executionCount, outputIndex == outputSequence.size() - 1);
            if (kotlinDfDataKey == null) continue;
            result2.add(kotlinDfDataKey);
        }
        return result2;
    }

    private final NotebookOutputDataKey getKotlinDataframeOutputDataKey(EditorImpl editor, NotebookIntervalPointer cellPointer, ObjectNode dataObject, Integer executionCount, boolean isLastForCell) {
        if (!KotlinDataframeParsing.INSTANCE.isKotlinDataFrame(dataObject)) {
            return null;
        }
        String string = dataObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String serializedDataframe = string;
        DSTableText text2 = new DSTableText(serializedDataframe, serializedDataframe);
        DSTableDataType type2 = DSTableDataType.EXTERNAL;
        return ExtractingKt.createTableOutputDataKey((DSTableText)text2, (DSTableDataType)type2, (Editor)((Editor)editor), (NotebookIntervalPointer)cellPointer, (Integer)executionCount, (boolean)isLastForCell);
    }
}

