/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.k2.scriptingSupport;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.util.FilesKt;
import com.intellij.kotlin.jupyter.k2.scriptingSupport.KotlinNotebookScriptDefinitionsSource;
import com.intellij.kotlin.jupyter.k2.scriptingSupport.KotlinNotebookScriptEntitySource;
import com.intellij.kotlin.jupyter.k2.scriptingSupport.KotlinNotebookScriptModel;
import com.intellij.kotlin.jupyter.k2.scriptingSupport.KotlinNotebookScriptModelKt;
import com.intellij.kotlin.jupyter.k2.scriptingSupport.KotlinNotebookScriptsModuleConfigurationInfo;
import com.intellij.kotlin.jupyter.k2.scriptingSupport.UtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.DependenciesKt;
import com.intellij.platform.workspace.jps.entities.DependencyScope;
import com.intellij.platform.workspace.jps.entities.LibraryDependency;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.ModuleDependencyItem;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntityAndExtensions;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.jps.entities.SdkDependency;
import com.intellij.platform.workspace.jps.entities.SdkId;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.ContextModuleKt;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.k2.ScriptConfigurationWithSdk;
import org.jetbrains.kotlin.idea.core.script.k2.ScriptConfigurationsSource;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionsSource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0094@\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0017J,\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J\u0016\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0086@\u00a2\u0006\u0002\u0010 J(\u0010!\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006&"}, d2={"Lcom/intellij/kotlin/jupyter/k2/scriptingSupport/NotebookScriptConfigurationsSource;", "Lorg/jetbrains/kotlin/idea/core/script/k2/ScriptConfigurationsSource;", "Lcom/intellij/kotlin/jupyter/k2/scriptingSupport/KotlinNotebookScriptModel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScriptDefinitionsSource", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionsSource;", "getConfigurationWithSdk", "Lorg/jetbrains/kotlin/idea/core/script/k2/ScriptConfigurationWithSdk;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "updateConfigurations", "", "scripts", "", "(Ljava/lang/Iterable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateModules", "storage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "(Lcom/intellij/platform/workspace/storage/MutableEntityStorage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "creteOrUpdateScriptModules", "configurationsPerNotebook", "", "Lcom/intellij/kotlin/jupyter/k2/scriptingSupport/KotlinNotebookScriptsModuleConfigurationInfo;", "mutableEntityStorage", "clearNotebookLibraryDependencies", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateNotebookConfiguration", "notebookModuleConfiguration", "runtimeLibrary", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "Companion", "intellij.kotlin.jupyter.k2"})
@SourceDebugExtension(value={"SMAP\nNotebookScriptConfigurationsSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookScriptConfigurationsSource.kt\ncom/intellij/kotlin/jupyter/k2/scriptingSupport/NotebookScriptConfigurationsSource\n+ 2 scriptUtils.kt\norg/jetbrains/kotlin/idea/core/script/ScriptUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n68#2:200\n808#3,11:201\n1187#3,2:215\n1261#3,4:217\n123#4:212\n13#5:213\n25#6:214\n1#7:221\n*S KotlinDebug\n*F\n+ 1 NotebookScriptConfigurationsSource.kt\ncom/intellij/kotlin/jupyter/k2/scriptingSupport/NotebookScriptConfigurationsSource\n*L\n61#1:200\n61#1:201,11\n85#1:215,2\n85#1:217,4\n61#1:212\n73#1:213\n82#1:214\n*E\n"})
public final class NotebookScriptConfigurationsSource
extends ScriptConfigurationsSource<KotlinNotebookScriptModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    public static final String NOTEBOOK_MODULE_NAME_PREFIX = "kotlin.scripts.Kotlin Notebooks";

    public NotebookScriptConfigurationsSource(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ScriptDefinitionsSource getScriptDefinitionsSource() {
        void $this$filterIsInstanceTo$iv$iv$iv;
        Project $this$scriptDefinitionsSourceOfType$iv = this.getProject();
        boolean $i$f$scriptDefinitionsSourceOfType = false;
        Iterable $this$filterIsInstance$iv$iv = ScriptUtilsKt.getSCRIPT_DEFINITIONS_SOURCES().getExtensions((AreaInstance)$this$scriptDefinitionsSourceOfType$iv);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof KotlinNotebookScriptDefinitionsSource)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Object $this$safeAs$iv$iv = CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv));
        boolean $i$f$safeAs = false;
        Object object = $this$safeAs$iv$iv;
        if (!(object instanceof KotlinNotebookScriptDefinitionsSource)) {
            object = null;
        }
        return (KotlinNotebookScriptDefinitionsSource)object;
    }

    @Nullable
    public ScriptConfigurationWithSdk getConfigurationWithSdk(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        VirtualFile topLevelFile = com.intellij.kotlin.jupyter.core.util.UtilKt.getTopLevelFile(virtualFile);
        Map cache = (Map)this.getData().get();
        ScriptConfigurationWithSdk configuration = (ScriptConfigurationWithSdk)cache.get(topLevelFile);
        Intrinsics.checkNotNull((Object)cache);
        if (!cache.isEmpty() && configuration == null) {
            NotebookScriptConfigurationsSource $this$notebookLogger$iv = this;
            boolean $i$f$notebookLogger = false;
            KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(NotebookScriptConfigurationsSource.class)).warn("No configuration found for " + topLevelFile.getName());
        }
        return configuration;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Object updateConfigurations(@NotNull Iterable<KotlinNotebookScriptModel> scripts, @NotNull Continuation<? super Unit> $completion) {
        void $this$associateTo$iv$iv;
        Sdk sdk;
        Sdk sdk2 = ProjectRootManager.getInstance((Project)this.getProject()).getProjectSdk();
        if (sdk2 == null) {
            Sdk[] sdkArray = ProjectJdkTable.getInstance().getAllJdks();
            Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"getAllJdks(...)");
            sdk2 = (Sdk)ArraysKt.firstOrNull((Object[])sdkArray);
        }
        if ((sdk = sdk2) == null) {
            NotebookScriptConfigurationsSource $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(NotebookScriptConfigurationsSource.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("No JDK SDK is set for the project");
        }
        Iterable<KotlinNotebookScriptModel> $this$associate$iv = scripts;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
        Iterable<KotlinNotebookScriptModel> iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            KotlinNotebookScriptModel ktScript = (KotlinNotebookScriptModel)((Object)element$iv$iv);
            boolean bl = false;
            VirtualFile virtualFile = ktScript.getVirtualFile();
            ContextModuleKt.setAnalysisContextModule((VirtualFile)virtualFile, null);
            ResultWithDiagnostics.Success configuration = ErrorHandlingKt.asSuccess$default((Object)ktScript.getRefinedConfigurationResult(), null, (int)1, null);
            VirtualFile topLevelFile = com.intellij.kotlin.jupyter.core.util.UtilKt.getTopLevelFile(virtualFile);
            Pair pair2 = TuplesKt.to((Object)topLevelFile, (Object)new ScriptConfigurationWithSdk((ResultWithDiagnostics)configuration, sdk));
            map.put(pair2.getFirst(), pair2.getSecond());
        }
        Map configurations = destination$iv$iv;
        this.getData().accumulateAndGet(configurations, NotebookScriptConfigurationsSource::updateConfigurations$lambda$1);
        return Unit.INSTANCE;
    }

    @Nullable
    public Object updateModules(@Nullable MutableEntityStorage storage, @NotNull Continuation<? super Unit> $completion) {
        WorkspaceModel workspaceModel = WorkspaceModelKt.getWorkspaceModel((Project)this.getProject());
        MutableEntityStorage mutableEntityStorage = storage;
        if (mutableEntityStorage == null || (mutableEntityStorage = mutableEntityStorage.toSnapshot()) == null) {
            mutableEntityStorage = workspaceModel.getCurrentSnapshot();
        }
        MutableEntityStorage workspaceSnapshot = mutableEntityStorage;
        MutableEntityStorage tmp = MutableEntityStorage.Companion.from((ImmutableEntityStorage)workspaceSnapshot);
        Object v = this.getData().get();
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        Map<VirtualFile, KotlinNotebookScriptsModuleConfigurationInfo> configurationsByNotebook = KotlinNotebookScriptModelKt.toConfigurationInfoPerNotebook((Map)v);
        this.creteOrUpdateScriptModules(this.getProject(), configurationsByNotebook, tmp);
        Object object = workspaceModel.update("Updating Kotlin Notebook scripting modules", arg_0 -> NotebookScriptConfigurationsSource.updateModules$lambda$3(tmp, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void creteOrUpdateScriptModules(Project project, Map<VirtualFile, KotlinNotebookScriptsModuleConfigurationInfo> configurationsPerNotebook, MutableEntityStorage mutableEntityStorage) {
        VirtualFileUrlManager virtualFileManager = WorkspaceModel.Companion.getInstance(project).getVirtualFileUrlManager();
        for (Map.Entry<VirtualFile, KotlinNotebookScriptsModuleConfigurationInfo> entry : configurationsPerNotebook.entrySet()) {
            VirtualFile notebookFile = entry.getKey();
            KotlinNotebookScriptsModuleConfigurationInfo moduleConfigurations = entry.getValue();
            LibraryEntity notebookRuntimeDependencies = UtilKt.getNotebookDependenciesAsLibraryEntity(virtualFileManager, mutableEntityStorage, notebookFile, project, moduleConfigurations.getConfiguration());
            this.updateNotebookConfiguration(project, mutableEntityStorage, moduleConfigurations, notebookRuntimeDependencies);
        }
    }

    @Nullable
    public final Object clearNotebookLibraryDependencies(@NotNull BackedNotebookVirtualFile notebookFile, @NotNull Continuation<? super Unit> $completion) {
        WorkspaceModel workspaceModel = WorkspaceModelKt.getWorkspaceModel((Project)this.getProject());
        ImmutableEntityStorage workspaceSnapshot = workspaceModel.getCurrentSnapshot();
        MutableEntityStorage tmpSnapshot = MutableEntityStorage.Companion.from(workspaceSnapshot);
        LibraryEntity libraryEntity = com.intellij.kotlin.jupyter.core.projectModel.UtilKt.resolveLibraryDependencies(tmpSnapshot, UtilKt.toK2RuntimeDependencyLibraryName(notebookFile.getFile(), this.getProject()), (LibraryTableId)LibraryTableId.ProjectLibraryTableId.INSTANCE);
        if (libraryEntity == null) {
            return Unit.INSTANCE;
        }
        DependenciesKt.modifyLibraryEntity((MutableEntityStorage)tmpSnapshot, (LibraryEntity)libraryEntity, NotebookScriptConfigurationsSource::clearNotebookLibraryDependencies$lambda$4);
        Object object = workspaceModel.update("Clearing Kotlin Notebook scripting modules", arg_0 -> NotebookScriptConfigurationsSource.clearNotebookLibraryDependencies$lambda$5(tmpSnapshot, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void updateNotebookConfiguration(Project project, MutableEntityStorage mutableEntityStorage, KotlinNotebookScriptsModuleConfigurationInfo notebookModuleConfiguration, LibraryEntity runtimeLibrary) {
        SdkDependency sdkDependency;
        Object[] it;
        Path path2 = FilesKt.getRelativePathFromProjectRoot(notebookModuleConfiguration.getNotebookFile(), project);
        Path prefixFromProjectRoot = path2 != null ? path2.getParent() : null;
        Object moduleNamePrefix = prefixFromProjectRoot != null ? "kotlin.scripts.Kotlin Notebooks." + prefixFromProjectRoot : NOTEBOOK_MODULE_NAME_PREFIX;
        File file = Path.of(notebookModuleConfiguration.getNotebookFile().getPath(), new String[0]).toFile();
        Intrinsics.checkNotNull((Object)file);
        String relativeLocation = kotlin.io.FilesKt.getNameWithoutExtension((File)file);
        String locationName = StringsKt.replace$default((String)relativeLocation, (char)'/', (char)':', (boolean)false, (int)4, null);
        String moduleName = (String)moduleNamePrefix + "." + locationName;
        Object[] objectArray = notebookModuleConfiguration.getSdkInfo();
        if (objectArray != null) {
            it = objectArray;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = it.getSdkType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            sdkDependency = new SdkDependency(new SdkId(string, string2));
        } else {
            sdkDependency = null;
        }
        SdkDependency sdkDependency2 = sdkDependency;
        KotlinNotebookScriptEntitySource source = new KotlinNotebookScriptEntitySource(VirtualFileUrls.toVirtualFileUrl((VirtualFile)notebookModuleConfiguration.getNotebookFile(), (VirtualFileUrlManager)WorkspaceModel.Companion.getInstance(project).getVirtualFileUrlManager()));
        it = new ModuleDependencyItem[]{new LibraryDependency(runtimeLibrary.getSymbolicId(), false, DependencyScope.COMPILE), sdkDependency2};
        List dependencies = CollectionsKt.listOfNotNull((Object[])it);
        ModuleEntity.Builder newEntry = ModuleEntity.Companion.create$default((ModuleEntity.Companion)ModuleEntity.Companion, (String)moduleName, (List)dependencies, (EntitySource)((EntitySource)source), null, (int)8, null);
        ModuleEntity oldEntry = (ModuleEntity)mutableEntityStorage.resolve((SymbolicEntityId)new ModuleId(moduleName));
        if (oldEntry != null) {
            ModuleEntityAndExtensions.modifyModuleEntity((MutableEntityStorage)mutableEntityStorage, (ModuleEntity)oldEntry, arg_0 -> NotebookScriptConfigurationsSource.updateNotebookConfiguration$lambda$7(newEntry, arg_0));
            return;
        }
        mutableEntityStorage.addEntity((WorkspaceEntity.Builder)newEntry);
    }

    private static final Map updateConfigurations$lambda$1(Map old, Map map) {
        Intrinsics.checkNotNull((Object)old);
        Intrinsics.checkNotNull((Object)map);
        return MapsKt.plus((Map)old, (Map)map);
    }

    private static final boolean updateModules$lambda$3$lambda$2(EntitySource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof KotlinNotebookScriptEntitySource;
    }

    private static final Unit updateModules$lambda$3(MutableEntityStorage $tmp, MutableEntityStorage model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        model.replaceBySource(NotebookScriptConfigurationsSource::updateModules$lambda$3$lambda$2, (EntityStorage)$tmp);
        return Unit.INSTANCE;
    }

    private static final Unit clearNotebookLibraryDependencies$lambda$4(LibraryEntity.Builder $this$modifyLibraryEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyLibraryEntity, (String)"$this$modifyLibraryEntity");
        $this$modifyLibraryEntity.setRoots((List)new ArrayList());
        return Unit.INSTANCE;
    }

    private static final Unit clearNotebookLibraryDependencies$lambda$5(MutableEntityStorage $tmpSnapshot, MutableEntityStorage model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        model.applyChangesFrom($tmpSnapshot);
        return Unit.INSTANCE;
    }

    private static final Unit updateNotebookConfiguration$lambda$7(ModuleEntity.Builder $newEntry, ModuleEntity.Builder $this$modifyModuleEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyModuleEntity, (String)"$this$modifyModuleEntity");
        $this$modifyModuleEntity.setDependencies($newEntry.getDependencies());
        ModuleEntityAndExtensions.setSourceRoots((ModuleEntity.Builder)$this$modifyModuleEntity, (List)ModuleEntityAndExtensions.getSourceRoots((ModuleEntity.Builder)$newEntry));
        $this$modifyModuleEntity.setName($newEntry.getName());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/k2/scriptingSupport/NotebookScriptConfigurationsSource$Companion;", "", "<init>", "()V", "NOTEBOOK_MODULE_NAME_PREFIX", "", "intellij.kotlin.jupyter.k2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

