/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.util;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\b\b\u0002\u0010\u0004*\u00020\u00022\u00020\u0002BW\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00000\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u0004\u0018\u00018\u00022\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u0004\u0018\u00018\u00022\u0006\u0010\u0011\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0018J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0013R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/kotlin/jupyter/core/util/DoubleKeyMutableMap;", "K1", "", "K2", "V", "map1", "", "map2", "keyExtractor1", "Lkotlin/Function1;", "keyExtractor2", "<init>", "(Ljava/util/Map;Ljava/util/Map;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getByFirstKey", "key1", "(Ljava/lang/Object;)Ljava/lang/Object;", "getBySecondKey", "key2", "put", "", "value", "(Ljava/lang/Object;)V", "removeByFirstKey", "", "(Ljava/lang/Object;)Z", "removeBySecondKey", "removeByValue", "values", "", "clear", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nDoubleKeyMutableMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoubleKeyMutableMap.kt\ncom/intellij/kotlin/jupyter/core/util/DoubleKeyMutableMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class DoubleKeyMutableMap<K1, K2, V> {
    @NotNull
    private final Map<K1, V> map1;
    @NotNull
    private final Map<K2, V> map2;
    @NotNull
    private final Function1<V, K1> keyExtractor1;
    @NotNull
    private final Function1<V, K2> keyExtractor2;

    public DoubleKeyMutableMap(@NotNull Map<K1, V> map1, @NotNull Map<K2, V> map2, @NotNull Function1<? super V, ? extends K1> keyExtractor1, @NotNull Function1<? super V, ? extends K2> keyExtractor2) {
        Intrinsics.checkNotNullParameter(map1, (String)"map1");
        Intrinsics.checkNotNullParameter(map2, (String)"map2");
        Intrinsics.checkNotNullParameter(keyExtractor1, (String)"keyExtractor1");
        Intrinsics.checkNotNullParameter(keyExtractor2, (String)"keyExtractor2");
        this.map1 = map1;
        this.map2 = map2;
        this.keyExtractor1 = keyExtractor1;
        this.keyExtractor2 = keyExtractor2;
    }

    @Nullable
    public final V getByFirstKey(@NotNull K1 key1) {
        Intrinsics.checkNotNullParameter(key1, (String)"key1");
        return this.map1.get(key1);
    }

    @Nullable
    public final V getBySecondKey(@NotNull K2 key2) {
        Intrinsics.checkNotNullParameter(key2, (String)"key2");
        return this.map2.get(key2);
    }

    public final void put(@NotNull V value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.map1.put(this.keyExtractor1.invoke(value), value);
        this.map2.put(this.keyExtractor2.invoke(value), value);
    }

    public final boolean removeByFirstKey(@NotNull K1 key1) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key1, (String)"key1");
        V v = this.map1.get(key1);
        if (v != null) {
            V it = v;
            boolean bl2 = false;
            bl = this.removeByValue(it);
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean removeBySecondKey(@NotNull K2 key2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key2, (String)"key2");
        V v = this.map2.get(key2);
        if (v != null) {
            V it = v;
            boolean bl2 = false;
            bl = this.removeByValue(it);
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean removeByValue(@NotNull V value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        boolean res1 = this.map1.remove(this.keyExtractor1.invoke(value), value);
        boolean res2 = this.map2.remove(this.keyExtractor2.invoke(value), value);
        return res1 || res2;
    }

    @NotNull
    public final Collection<V> values() {
        return this.map1.values();
    }

    public final void clear() {
        this.map1.clear();
        this.map2.clear();
    }
}

