/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.settings.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookMissingJdkService;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookProjectOptionsProvider;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/ui/KotlinNotebookMissingJdkEditorNotification;", "Lcom/intellij/ui/EditorNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookMissingJdkEditorNotification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookMissingJdkEditorNotification.kt\ncom/intellij/kotlin/jupyter/core/settings/ui/KotlinNotebookMissingJdkEditorNotification\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,48:1\n31#2,2:49\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookMissingJdkEditorNotification.kt\ncom/intellij/kotlin/jupyter/core/settings/ui/KotlinNotebookMissingJdkEditorNotification\n*L\n23#1:49,2\n*E\n"})
public final class KotlinNotebookMissingJdkEditorNotification
implements EditorNotificationProvider,
DumbAware {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!IsKotlinNotebookKt.isKotlinNotebook(file)) {
            return null;
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<KotlinNotebookMissingJdkService> serviceClass$iv = KotlinNotebookMissingJdkService.class;
        if ($this$service$iv.getService(serviceClass$iv) == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        KotlinNotebookProjectOptionsProvider optionsProvider = KotlinNotebookProjectOptionsProvider.Companion.getInstance(project);
        if (optionsProvider.getJdk().getPath(project) != null) {
            return null;
        }
        return arg_0 -> KotlinNotebookMissingJdkEditorNotification.collectNotificationData$lambda$0(optionsProvider, arg_0);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$0(KotlinNotebookProjectOptionsProvider $optionsProvider, FileEditor it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EditorNotificationPanel panel = new EditorNotificationPanel(HintUtil.WARNING_COLOR_KEY, EditorNotificationPanel.Status.Error);
        String jdkName2 = $optionsProvider.getJdkName$intellij_kotlin_jupyter_core();
        if (jdkName2 == null) {
            string = KotlinNotebookBundle.message("kotlin.jupyter.missing.jdk.notification.not.selected.text", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{jdkName2};
            string = KotlinNotebookBundle.message("kotlin.jupyter.missing.jdk.notification.not.found.text", objectArray);
        }
        String message2 = string;
        panel.text(message2);
        panel.createActionLabel(KotlinNotebookBundle.message("kotlin.jupyter.missing.jdk.select.jdk.action", new Object[0]), "ShowKotlinNotebookPreferencesAction", false);
        return panel;
    }
}

