/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.settings.actions;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.action.JupyterShutdownNotebookActionKt;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookDependencies;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookDependenciesPropertyKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSettingsKt;
import com.intellij.kotlin.jupyter.core.settings.actions.SessionShutdownPromptKt;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.util.ui.JBFont;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0005\u0019\u001a\u001b\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u001e"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "<init>", "()V", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createPopupActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "createCustomComponentForResultViewToolbar", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "SelectDependenciesAction", "NoDependenciesAction", "AllProjectLibrariesAction", "SelectModuleAction", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookDependenciesComboBoxAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookDependenciesComboBoxAction.kt\ncom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1557#2:162\n1628#2,3:163\n1#3:166\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookDependenciesComboBoxAction.kt\ncom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction\n*L\n62#1:162\n62#1:163,3\n*E\n"})
public final class KotlinNotebookDependenciesComboBoxAction
extends DumbAwareAction
implements CustomComponentAction {
    @NotNull
    private static final Companion Companion = new Companion(null);

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return this.createCustomComponentForResultViewToolbar((AnAction)this, presentation, place);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JComponent jComponent = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (jComponent == null) {
            return;
        }
        Component component = jComponent;
        JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        ListPopup listPopup = jBPopupFactory.createActionGroupPopup(null, (ActionGroup)this.createPopupActionGroup(dataContext), e.getDataContext(), null, true, null);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        JBPopup popup = (JBPopup)listPopup;
        popup.showUnderneathOf(component);
    }

    /*
     * WARNING - void declaration
     */
    private final DefaultActionGroup createPopupActionGroup(DataContext context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new NoDependenciesAction(KotlinNotebookBundle.message("action.KotlinNotebookDependenciesComboBoxAction.NoDependenciesAction.text", new Object[0])));
        actionGroup.add((AnAction)new AllProjectLibrariesAction(KotlinNotebookBundle.message("action.KotlinNotebookDependenciesComboBoxAction.AllProjectLibrariesAction.text", new Object[0])));
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return actionGroup;
        }
        List<Module> modules = KotlinNotebookDependenciesPropertyKt.getSuitableModules(project);
        actionGroup.addSeparator();
        Iterable iterable = modules;
        DefaultActionGroup defaultActionGroup = actionGroup;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Module module = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SelectModuleAction((Module)it));
        }
        defaultActionGroup.addAll((Collection)((List)destination$iv$iv));
        return actionGroup;
    }

    private final JComponent createCustomComponentForResultViewToolbar(AnAction action, Presentation presentation, String place) {
        Dimension dimension = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
        ActionButtonWithText button2 = new ActionButtonWithText(action, presentation, place, dimension){

            protected boolean shallPaintDownArrow() {
                return true;
            }
        };
        button2.setHorizontalTextAlignment(2);
        button2.setFont((Font)JBFont.small());
        return (JComponent)button2;
    }

    public void update(@NotNull AnActionEvent e) {
        Pair pair2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        KotlinNotebookDependencies kotlinNotebookDependencies = Companion.getCurrentDependencies(e);
        if (kotlinNotebookDependencies == null) {
            return;
        }
        KotlinNotebookDependencies currentDependencies = kotlinNotebookDependencies;
        KotlinNotebookDependencies kotlinNotebookDependencies2 = currentDependencies;
        if (Intrinsics.areEqual((Object)kotlinNotebookDependencies2, (Object)KotlinNotebookDependencies.AllLibraries.INSTANCE)) {
            pair2 = TuplesKt.to(null, (Object)KotlinNotebookBundle.message("action.KotlinNotebookDependenciesComboBoxAction.AllProjectLibrariesAction.text", new Object[0]));
        } else if (Intrinsics.areEqual((Object)kotlinNotebookDependencies2, (Object)KotlinNotebookDependencies.None.INSTANCE)) {
            pair2 = TuplesKt.to(null, (Object)KotlinNotebookBundle.message("action.KotlinNotebookDependenciesComboBoxAction.NoDependenciesAction.text", new Object[0]));
        } else if (kotlinNotebookDependencies2 instanceof KotlinNotebookDependencies.SingleModule) {
            Icon icon;
            Module module;
            Module module2;
            Project project = e.getProject();
            if (project != null) {
                Project it = project;
                boolean bl = false;
                module2 = KotlinNotebookDependenciesPropertyKt.findModule(currentDependencies, it);
            } else {
                module2 = null;
            }
            Module module3 = module = module2;
            if (module3 != null) {
                Module it = module3;
                boolean bl = false;
                icon = ModuleType.get((Module)it).getIcon();
            } else {
                icon = null;
            }
            pair2 = TuplesKt.to((Object)icon, (Object)((KotlinNotebookDependencies.SingleModule)currentDependencies).getModuleName());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair3 = pair2;
        Icon icon = (Icon)pair3.component1();
        String text2 = (String)pair3.component2();
        e.getPresentation().setIcon(icon);
        e.getPresentation().setText(text2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$AllProjectLibrariesAction;", "Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectDependenciesAction;", "placeholder", "", "<init>", "(Ljava/lang/String;)V", "intellij.kotlin.jupyter.core"})
    private static final class AllProjectLibrariesAction
    extends SelectDependenciesAction {
        public AllProjectLibrariesAction(@NlsActions.ActionText @NotNull String placeholder) {
            Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
            super(placeholder, KotlinNotebookDependencies.AllLibraries.INSTANCE, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$Companion;", "", "<init>", "()V", "getCurrentDependencies", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookDependencies;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.kotlin.jupyter.core"})
    private static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KotlinNotebookDependencies getCurrentDependencies(@NotNull AnActionEvent $this$getCurrentDependencies) {
            Intrinsics.checkNotNullParameter((Object)$this$getCurrentDependencies, (String)"<this>");
            BackedNotebookVirtualFile notebookFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)$this$getCurrentDependencies);
            if (notebookFile == null || !IsKotlinNotebookKt.isKotlinNotebook(notebookFile)) {
                $this$getCurrentDependencies.getPresentation().setEnabledAndVisible(false);
                return null;
            }
            JupyterNotebook jupyterNotebook = notebookFile.getNotebookOrNull();
            return jupyterNotebook != null ? KotlinNotebookSettingsKt.getNotebookDependencies(jupyterNotebook) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$NoDependenciesAction;", "Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectDependenciesAction;", "placeholder", "", "<init>", "(Ljava/lang/String;)V", "intellij.kotlin.jupyter.core"})
    private static final class NoDependenciesAction
    extends SelectDependenciesAction {
        public NoDependenciesAction(@NlsActions.ActionText @NotNull String placeholder) {
            Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
            super(placeholder, KotlinNotebookDependencies.None.INSTANCE, null);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B\u001b\b\u0004\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectDependenciesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "placeholder", "", "dependencies", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookDependencies;", "<init>", "(Ljava/lang/String;Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookDependencies;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$AllProjectLibrariesAction;", "Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$NoDependenciesAction;", "Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectModuleAction;", "intellij.kotlin.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nKotlinNotebookDependenciesComboBoxAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookDependenciesComboBoxAction.kt\ncom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectDependenciesAction\n+ 2 SessionShutdownPrompt.kt\ncom/intellij/kotlin/jupyter/core/settings/actions/SessionShutdownPromptKt\n*L\n1#1,161:1\n27#2,12:162\n53#2,2:174\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookDependenciesComboBoxAction.kt\ncom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectDependenciesAction\n*L\n113#1:162,12\n113#1:174,2\n*E\n"})
    private static abstract class SelectDependenciesAction
    extends DumbAwareAction {
        @NotNull
        private final KotlinNotebookDependencies dependencies;

        private SelectDependenciesAction(@NlsActions.ActionText String placeholder, KotlinNotebookDependencies dependencies) {
            super(placeholder);
            this.dependencies = dependencies;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor = JupyterAnActionEventExtensionsKt.getEditor((AnActionEvent)e);
            if (editor == null) {
                return;
            }
            Editor editor2 = editor;
            if (Intrinsics.areEqual((Object)Companion.getCurrentDependencies(e), (Object)this.dependencies)) {
                return;
            }
            KClass classForLogging$iv = Reflection.getOrCreateKotlinClass(KotlinNotebookDependenciesComboBoxAction.class);
            boolean $i$f$promptSessionShutdownIfNeeded = false;
            BackedNotebookVirtualFile notebookFile$iv = JupyterEditorExtensionsKt.getNotebookFile((Editor)editor2);
            Project project$iv = editor2.getProject();
            if (IsKotlinNotebookKt.isKotlinNotebook(notebookFile$iv) && project$iv != null) {
                if (!JupyterRuntimeService.Companion.getInstance(project$iv).hasActiveSession(notebookFile$iv.getFile())) {
                    JupyterNotebook notebook2;
                    boolean bl = false;
                    JupyterNotebook jupyterNotebook = notebook2 = JupyterEditorExtensionsKt.getNotebookFile((Editor)editor2).getNotebookOrNull();
                    if (jupyterNotebook != null) {
                        KotlinNotebookSettingsKt.setNotebookDependencies(jupyterNotebook, this.dependencies);
                    }
                } else {
                    ComponentsKt.dialog$default((String)KotlinNotebookBundle.message("dialog.title.session.shutdown.prompt", new Object[0]), (JComponent)((JComponent)BuilderKt.panel((Function1)SessionShutdownPromptKt.promptSessionShutdownIfNeeded.1.INSTANCE)), (boolean)false, null, (boolean)false, null, null, null, null, null, (Function0)((Function0)new Function0<List<? extends ValidationInfo>>(classForLogging$iv, editor2, editor2, this){
                        final /* synthetic */ KClass $classForLogging;
                        final /* synthetic */ Editor $notebookEditor;
                        final /* synthetic */ Editor $editor$inlined;
                        final /* synthetic */ SelectDependenciesAction this$0;
                        {
                            this.$classForLogging = $classForLogging;
                            this.$notebookEditor = $notebookEditor;
                            this.$editor$inlined = editor;
                            this.this$0 = selectDependenciesAction;
                        }

                        public final List<ValidationInfo> invoke() {
                            JupyterNotebook notebook2;
                            boolean bl = false;
                            JupyterNotebook jupyterNotebook = notebook2 = JupyterEditorExtensionsKt.getNotebookFile((Editor)this.$editor$inlined).getNotebookOrNull();
                            if (jupyterNotebook != null) {
                                KotlinNotebookSettingsKt.setNotebookDependencies(jupyterNotebook, SelectDependenciesAction.access$getDependencies$p(this.this$0));
                            }
                            JupyterShutdownNotebookActionKt.shutdownNotebook((KClass)this.$classForLogging, (Project)this.$notebookEditor.getProject(), (List)CollectionsKt.listOf((Object)this.$notebookEditor), (List)CollectionsKt.emptyList());
                            return null;
                        }
                    }), (int)1020, null).show();
                }
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (Intrinsics.areEqual((Object)Companion.getCurrentDependencies(e), (Object)this.dependencies)) {
                e.getPresentation().setSelectedIcon(AllIcons.Actions.Checked);
            }
        }

        public /* synthetic */ SelectDependenciesAction(String placeholder, KotlinNotebookDependencies dependencies, DefaultConstructorMarker $constructor_marker) {
            this(placeholder, dependencies);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectModuleAction;", "Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectDependenciesAction;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.kotlin.jupyter.core"})
    private static final class SelectModuleAction
    extends SelectDependenciesAction {
        @NotNull
        private final Module module;

        public SelectModuleAction(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            String string = module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            super(string, new KotlinNotebookDependencies.SingleModule(string2), null);
            this.module = module;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setIcon(ModuleType.get((Module)this.module).getIcon());
            super.update(e);
        }
    }
}

