/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.scriptingSupport.definitions;

import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.host.ScriptDefinition;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.intellij.ScriptDefinitionsProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0013\u0010\u0007\u001a\u00070\u0002\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kotlin/jupyter/core/scriptingSupport/definitions/JupyterScriptDefinitionProvider;", "Lkotlin/script/experimental/intellij/ScriptDefinitionsProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "disposable", "Lorg/jetbrains/annotations/NotNull;", "projectCompilerService", "Lcom/intellij/kotlin/jupyter/core/scriptingSupport/JupyterCompilerService;", "id", "", "getId", "()Ljava/lang/String;", "getDefinitionClasses", "", "getDefinitionsClassPath", "Ljava/io/File;", "useDiscovery", "", "provideDefinitions", "Lkotlin/script/experimental/host/ScriptDefinition;", "baseHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "loadedScriptDefinitions", "", "dispose", "", "intellij.kotlin.jupyter.core"})
public final class JupyterScriptDefinitionProvider
implements ScriptDefinitionsProvider,
Disposable {
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final JupyterCompilerService projectCompilerService;
    @NotNull
    private final String id;

    public JupyterScriptDefinitionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.projectCompilerService = JupyterCompilerService.Companion.getInstance(project);
        this.id = "Jupyter Definition provider";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Iterable<String> getDefinitionClasses() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public Iterable<File> getDefinitionsClassPath() {
        return CollectionsKt.emptyList();
    }

    public boolean useDiscovery() {
        return false;
    }

    @NotNull
    public Iterable<ScriptDefinition> provideDefinitions(@NotNull ScriptingHostConfiguration baseHostConfiguration, @NotNull List<ScriptDefinition> loadedScriptDefinitions) {
        Intrinsics.checkNotNullParameter((Object)baseHostConfiguration, (String)"baseHostConfiguration");
        Intrinsics.checkNotNullParameter(loadedScriptDefinitions, (String)"loadedScriptDefinitions");
        return CollectionsKt.plus((Collection)loadedScriptDefinitions, (Object)this.projectCompilerService.getScriptDefinitionsWrapper().getScriptDefinitionData());
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.disposable);
    }
}

