/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.projectWizard.common;

import com.intellij.kotlin.jupyter.core.projectWizard.NotebookFileItem;
import com.intellij.kotlin.jupyter.core.projectWizard.NotebookItem;
import com.intellij.kotlin.jupyter.core.projectWizard.NotebookRootItem;
import com.intellij.kotlin.jupyter.core.projectWizard.NotebookTreeNode;
import com.intellij.kotlin.jupyter.core.projectWizard.RecentKotlinNotebooksService;
import com.intellij.kotlin.jupyter.core.projectWizard.common.ActionKeysKt;
import com.intellij.kotlin.jupyter.core.projectWizard.common.ActionUtilKt;
import com.intellij.kotlin.jupyter.core.projectWizard.common.KotlinNotebookTreeHolder;
import com.intellij.kotlin.jupyter.core.projectWizard.common.NotebookActionButtonViewModel;
import com.intellij.kotlin.jupyter.core.projectWizard.common.NotebookComponent;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.kotlin.jupyter.core.settings.recents.RecentNotebookWithIcon;
import com.intellij.kotlin.jupyter.core.util.KotlinNotebookPluginScope;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.render.RenderingHelper;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002J\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\rJ\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/kotlin/jupyter/core/projectWizard/common/KotlinNotebookTreeHolder;", "", "<init>", "()V", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "buttonViewModel", "Lcom/intellij/kotlin/jupyter/core/projectWizard/common/NotebookActionButtonViewModel;", "notebookComponent", "Lcom/intellij/kotlin/jupyter/core/projectWizard/common/NotebookComponent;", "setupTreeProperties", "", "setupTreeRenderer", "setupMouseListener", "getTree", "getRoot", "Lcom/intellij/kotlin/jupyter/core/projectWizard/NotebookTreeNode;", "updateAsync", "Lkotlinx/coroutines/Job;", "revalidateTree", "createScrollPane", "Ljavax/swing/JScrollPane;", "intellij.kotlin.jupyter.core"})
public final class KotlinNotebookTreeHolder {
    @NotNull
    private final Tree tree = new Tree();
    @NotNull
    private final DefaultTreeModel treeModel = new DefaultTreeModel(new NotebookTreeNode(new NotebookRootItem(CollectionsKt.emptyList())));
    @NotNull
    private final NotebookActionButtonViewModel buttonViewModel = new NotebookActionButtonViewModel(false, 1, null);
    @NotNull
    private final NotebookComponent notebookComponent = new NotebookComponent();

    public KotlinNotebookTreeHolder() {
        this.tree.setModel((TreeModel)this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setRowHeight(0);
        this.tree.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        this.tree.getEmptyText().setText(KotlinNotebookBundle.message("kotlin.notebook.no.recent.notebooks.found", new Object[0]));
        this.setupTreeProperties();
        this.setupTreeRenderer();
        this.setupMouseListener();
    }

    private final void setupTreeProperties() {
        this.tree.setBackground(WelcomeScreenUIManager.getProjectsBackground());
        this.tree.putClientProperty((Object)RenderingUtil.CUSTOM_SELECTION_BACKGROUND, KotlinNotebookTreeHolder::setupTreeProperties$lambda$0);
    }

    private final void setupTreeRenderer() {
        this.tree.setCellRenderer(new TreeCellRenderer(this){
            final /* synthetic */ KotlinNotebookTreeHolder this$0;
            {
                this.this$0 = $receiver;
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                NotebookTreeNode notebookTreeNode = value instanceof NotebookTreeNode ? (NotebookTreeNode)value : null;
                if (notebookTreeNode == null) {
                    return new JLabel();
                }
                NotebookTreeNode node = notebookTreeNode;
                NotebookItem item = node.getItem();
                if (item instanceof NotebookFileItem) {
                    return KotlinNotebookTreeHolder.access$getNotebookComponent$p(this.this$0).customizeComponent(((NotebookFileItem)item).getNotebookWithIcon(), selected, KotlinNotebookTreeHolder.access$getButtonViewModel$p(this.this$0));
                }
                return new JLabel(item.displayName());
            }
        });
    }

    private final void setupMouseListener() {
        AnAction anAction = ActionManager.getInstance().getAction("KotlinNotebookActionGroup");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup actionGroup = (ActionGroup)anAction;
        ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("WelcomeScreen", actionGroup);
        Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"createActionPopupMenu(...)");
        ActionPopupMenu popupMenu = actionPopupMenu;
        MouseAdapter mouseListener2 = new MouseAdapter(this, popupMenu){
            final /* synthetic */ KotlinNotebookTreeHolder this$0;
            final /* synthetic */ ActionPopupMenu $popupMenu;
            {
                this.this$0 = $receiver;
                this.$popupMenu = $popupMenu;
            }

            private final int getCurrentRow(MouseEvent e) {
                Point point = e.getPoint();
                return TreeUtil.getRowForLocation((JTree)((JTree)KotlinNotebookTreeHolder.access$getTree$p(this.this$0)), (int)point.x, (int)point.y);
            }

            private final boolean intersectWithActionIcon(Point point) {
                int row = TreeUtil.getRowForLocation((JTree)((JTree)KotlinNotebookTreeHolder.access$getTree$p(this.this$0)), (int)point.x, (int)point.y);
                if (row == -1) {
                    return false;
                }
                return this.getActionsButtonRect(row).contains(point);
            }

            private final Rectangle getActionsButtonRect(int row) {
                RenderingHelper helper = new RenderingHelper((JComponent)KotlinNotebookTreeHolder.access$getTree$p(this.this$0));
                Rectangle bounds = KotlinNotebookTreeHolder.access$getTree$p(this.this$0).getRowBounds(row);
                int size = JBUI.scale((int)24);
                TreePath treePath = KotlinNotebookTreeHolder.access$getTree$p(this.this$0).getPathForRow(row);
                Object object = treePath != null ? treePath.getLastPathComponent() : null;
                NotebookTreeNode notebookTreeNode = object instanceof NotebookTreeNode ? (NotebookTreeNode)object : null;
                if (notebookTreeNode == null) {
                    return new Rectangle();
                }
                NotebookTreeNode node = notebookTreeNode;
                NotebookItem item = node.getItem();
                if (!(item instanceof NotebookFileItem)) {
                    return new Rectangle();
                }
                int rightGap = JBUI.scale((int)20);
                return new Rectangle(helper.getWidth() - helper.getRightMargin() - size - rightGap, bounds.y + (bounds.height - size) / 2, size, size);
            }

            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.isConsumed()) {
                    return;
                }
                if (e.getClickCount() == 1 && e.getButton() == 1) {
                    Point point = e.getPoint();
                    TreePath treePath = TreeUtil.getPathForLocation((JTree)((JTree)KotlinNotebookTreeHolder.access$getTree$p(this.this$0)), (int)point.x, (int)point.y);
                    if (treePath == null) {
                        return;
                    }
                    TreePath treePath2 = treePath;
                    Object object = treePath2.getLastPathComponent();
                    NotebookTreeNode notebookTreeNode = object instanceof NotebookTreeNode ? (NotebookTreeNode)object : null;
                    if (notebookTreeNode == null) {
                        return;
                    }
                    NotebookTreeNode node = notebookTreeNode;
                    NotebookItem notebookItem = node.getItem();
                    NotebookFileItem notebookFileItem = notebookItem instanceof NotebookFileItem ? (NotebookFileItem)notebookItem : null;
                    if (notebookFileItem == null) {
                        return;
                    }
                    NotebookFileItem item = notebookFileItem;
                    Intrinsics.checkNotNull((Object)point);
                    if (this.intersectWithActionIcon(point)) {
                        DataContext dataContext = SimpleDataContext.builder().add(ActionKeysKt.getRECENT_NOTEBOOK_KEY(), (Object)item.getNotebookWithIcon().getNotebook()).add(ActionKeysKt.getNOTEBOOK_TREE_HOLDER_KEY(), (Object)this.this$0).build();
                        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
                        DataContext dataContext2 = dataContext;
                        this.$popupMenu.setDataContext(() -> setupMouseListener.mouseListener.1.mouseReleased$lambda$0(dataContext2));
                        this.$popupMenu.getComponent().show(e.getComponent(), e.getX(), e.getY());
                    } else {
                        ActionUtilKt.openNotebook(item.getNotebookWithIcon().getNotebook());
                    }
                    e.consume();
                }
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.$popupMenu.getComponent().isVisible()) {
                    return;
                }
                int row = this.getCurrentRow(e);
                if (row != -1) {
                    if (!KotlinNotebookTreeHolder.access$getTree$p(this.this$0).isRowSelected(row)) {
                        KotlinNotebookTreeHolder.access$getTree$p(this.this$0).setSelectionRow(row);
                        KotlinNotebookTreeHolder.access$getTree$p(this.this$0).repaint(KotlinNotebookTreeHolder.access$getTree$p(this.this$0).getRowBounds(row));
                    }
                    UIUtil.setCursor((Component)((Component)KotlinNotebookTreeHolder.access$getTree$p(this.this$0)), (Cursor)Cursor.getPredefinedCursor(12));
                    NotebookActionButtonViewModel notebookActionButtonViewModel = KotlinNotebookTreeHolder.access$getButtonViewModel$p(this.this$0);
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                    notebookActionButtonViewModel.setButtonHovered(this.intersectWithActionIcon(point));
                } else {
                    UIUtil.setCursor((Component)((Component)KotlinNotebookTreeHolder.access$getTree$p(this.this$0)), (Cursor)Cursor.getDefaultCursor());
                    KotlinNotebookTreeHolder.access$getTree$p(this.this$0).clearSelection();
                    KotlinNotebookTreeHolder.access$getButtonViewModel$p(this.this$0).setButtonHovered(false);
                }
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.$popupMenu.getComponent().isVisible()) {
                    return;
                }
                KotlinNotebookTreeHolder.access$getTree$p(this.this$0).clearSelection();
                KotlinNotebookTreeHolder.access$getButtonViewModel$p(this.this$0).setButtonHovered(false);
            }

            private static final DataContext mouseReleased$lambda$0(DataContext $dataContext) {
                return $dataContext;
            }
        };
        this.tree.addMouseListener((MouseListener)mouseListener2);
        this.tree.addMouseMotionListener((MouseMotionListener)mouseListener2);
    }

    @NotNull
    public final Tree getTree() {
        return this.tree;
    }

    @NotNull
    public final NotebookTreeNode getRoot() {
        Object object = this.treeModel.getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.kotlin.jupyter.core.projectWizard.NotebookTreeNode");
        return (NotebookTreeNode)object;
    }

    @NotNull
    public final Job updateAsync() {
        return BuildersKt.launch$default((CoroutineScope)KotlinNotebookPluginScope.Companion.getGlobal(), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ KotlinNotebookTreeHolder this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        List<RecentNotebookWithIcon> files = RecentKotlinNotebooksService.Companion.getInstance().getNotebooksWithIcons();
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(files, this.this$0, null){
                            int label;
                            final /* synthetic */ List<RecentNotebookWithIcon> $files;
                            final /* synthetic */ KotlinNotebookTreeHolder this$0;
                            {
                                this.$files = $files;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        NotebookTreeNode root = new NotebookTreeNode(new NotebookRootItem(this.$files));
                                        KotlinNotebookTreeHolder.access$getTreeModel$p(this.this$0).setRoot(root);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void revalidateTree() {
        this.tree.setModel((TreeModel)this.treeModel);
    }

    @NotNull
    public final JScrollPane createScrollPane() {
        JScrollPane jScrollPane;
        JScrollPane jScrollPane2 = ScrollPaneFactory.createScrollPane((Component)((Component)this.tree), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane2, (String)"createScrollPane(...)");
        JScrollPane $this$createScrollPane_u24lambda_u241 = jScrollPane = jScrollPane2;
        boolean bl = false;
        $this$createScrollPane_u24lambda_u241.setHorizontalScrollBarPolicy(31);
        $this$createScrollPane_u24lambda_u241.setOpaque(false);
        $this$createScrollPane_u24lambda_u241.setBackground(WelcomeScreenUIManager.getProjectsBackground());
        $this$createScrollPane_u24lambda_u241.setBorder((Border)JBUI.Borders.empty());
        return jScrollPane;
    }

    private static final Color setupTreeProperties$lambda$0() {
        return ListUiUtil.WithTallRow.INSTANCE.background(new JList(), true, true);
    }

    public static final /* synthetic */ NotebookComponent access$getNotebookComponent$p(KotlinNotebookTreeHolder $this) {
        return $this.notebookComponent;
    }

    public static final /* synthetic */ NotebookActionButtonViewModel access$getButtonViewModel$p(KotlinNotebookTreeHolder $this) {
        return $this.buttonViewModel;
    }

    public static final /* synthetic */ Tree access$getTree$p(KotlinNotebookTreeHolder $this) {
        return $this.tree;
    }

    public static final /* synthetic */ DefaultTreeModel access$getTreeModel$p(KotlinNotebookTreeHolder $this) {
        return $this.treeModel;
    }
}

