/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.outputs.swing;

import com.intellij.kotlin.jupyter.core.jupyter.outputs.swing.SwingOutputDataKey;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u001a\u001a\u00020\u0012H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/outputs/swing/SwingComponent;", "Ljavax/swing/JPanel;", "<init>", "()V", "_dataKey", "Lcom/intellij/kotlin/jupyter/core/jupyter/outputs/swing/SwingOutputDataKey;", "dataKey", "getDataKey", "()Lcom/intellij/kotlin/jupyter/core/jupyter/outputs/swing/SwingOutputDataKey;", "initialize", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "isInvisible", "", "component", "Ljava/awt/Component;", "jDialogLabelText", "", "dialog", "Ljavax/swing/JDialog;", "jFrameLabelText", "frame", "Ljavax/swing/JFrame;", "createLabel", "Lcom/intellij/ui/components/JBLabel;", "labelText", "intellij.kotlin.jupyter.core"})
public final class SwingComponent
extends JPanel {
    @Nullable
    private SwingOutputDataKey _dataKey;

    public SwingComponent() {
        super(new FlowLayout(0));
        this.setOpaque(false);
    }

    @Nullable
    public final SwingOutputDataKey getDataKey() {
        return this._dataKey;
    }

    public final void initialize(@NotNull EditorImpl editor, @NotNull SwingOutputDataKey dataKey) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataKey, (String)"dataKey");
        this._dataKey = dataKey;
        Object component = dataKey.getComponent();
        if (component instanceof JDialog) {
            String labelText = this.jDialogLabelText((JDialog)component);
            JBLabel label = this.createLabel(editor, labelText);
            v0 = this.add((Component)label, 0);
        } else if (component instanceof JFrame) {
            String labelText = this.jFrameLabelText((JFrame)component);
            JBLabel label = this.createLabel(editor, labelText);
            v0 = this.add((Component)label, -1);
        } else if (component instanceof JComponent) {
            if (this.isInvisible((Component)component)) {
                String labelText = KotlinNotebookBundle.message("kotlin.notebook.collapsed.swing.component.no_size.text", new Object[0]);
                JBLabel label = this.createLabel(editor, labelText);
                v0 = this.add((Component)label, -1);
            } else {
                v0 = this.add((Component)component, -1);
            }
        } else {
            throw new IllegalStateException("Unsupported Swing component: " + component);
        }
        this.invalidate();
    }

    private final boolean isInvisible(Component component) {
        return !component.isVisible() || Intrinsics.areEqual((Object)component.getSize(), (Object)new Dimension(0, 0));
    }

    private final String jDialogLabelText(JDialog dialog) {
        boolean invisible = this.isInvisible(dialog);
        return KotlinNotebookBundle.message("kotlin.notebook.outputs.swing.component.dialog" + (invisible ? ".no.size" : "") + ".text", new Object[0]);
    }

    private final String jFrameLabelText(JFrame frame) {
        boolean invisible = this.isInvisible(frame);
        String string = invisible ? ".no.size" : "";
        Object[] objectArray = new Object[]{frame.getTitle()};
        return KotlinNotebookBundle.message("kotlin.notebook.outputs.swing.component.frame" + string + ".text", objectArray);
    }

    private final JBLabel createLabel(EditorImpl editor, @NlsSafe String labelText) {
        JBLabel jBLabel;
        JBLabel $this$createLabel_u24lambda_u240 = jBLabel = new JBLabel(labelText);
        boolean bl = false;
        $this$createLabel_u24lambda_u240.setForeground(editor.getColorsScheme().getDefaultForeground());
        return jBLabel;
    }
}

