/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded;

import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.EmbeddedKernelClassLoaderHolder;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.EmbeddedKotlinKernelLoggerFactory;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.EmbeddedMessageHandler;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.IdeReplComponentsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.execution.JupyterExecutor;
import org.jetbrains.kotlinx.jupyter.execution.JupyterExecutorImpl;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterBaseSockets;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacilityImpl;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryProvider;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryProviderImpl;
import org.jetbrains.kotlinx.jupyter.messaging.MessageHandler;
import org.jetbrains.kotlinx.jupyter.messaging.comms.CommManagerImpl;
import org.jetbrains.kotlinx.jupyter.messaging.comms.CommManagerInternal;
import org.jetbrains.kotlinx.jupyter.repl.ReplForJupyter;
import org.jetbrains.kotlinx.jupyter.repl.config.DefaultReplSettings;
import org.jetbrains.kotlinx.jupyter.repl.creating.ProvidersKt;
import org.jetbrains.kotlinx.jupyter.repl.creating.ReplComponentsProvider;
import org.jetbrains.kotlinx.jupyter.repl.creating.ReplFactory;
import org.jetbrains.kotlinx.jupyter.repl.embedded.InMemoryReplResultsHolder;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006\u0012"}, d2={"createEmbeddedMessageHandler", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageHandler;", "project", "Lcom/intellij/openapi/project/Project;", "replSettings", "Lorg/jetbrains/kotlinx/jupyter/repl/config/DefaultReplSettings;", "loggerFactory", "Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/EmbeddedKotlinKernelLoggerFactory;", "socketManager", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterBaseSockets;", "inMemoryHolder", "Lorg/jetbrains/kotlinx/jupyter/repl/embedded/InMemoryReplResultsHolder;", "kernelVersion", "", "getReplFactory", "Lorg/jetbrains/kotlinx/jupyter/repl/creating/ReplFactory;", "replComponentsProvider", "Lorg/jetbrains/kotlinx/jupyter/repl/creating/ReplComponentsProvider;", "intellij.kotlin.jupyter.core"})
public final class MessageHanderFactoryKt {
    @NotNull
    public static final MessageHandler createEmbeddedMessageHandler(@NotNull Project project, @NotNull DefaultReplSettings replSettings, @NotNull EmbeddedKotlinKernelLoggerFactory loggerFactory2, @NotNull JupyterBaseSockets socketManager, @NotNull InMemoryReplResultsHolder inMemoryHolder, @NotNull String kernelVersion2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)replSettings, (String)"replSettings");
        Intrinsics.checkNotNullParameter((Object)loggerFactory2, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)socketManager, (String)"socketManager");
        Intrinsics.checkNotNullParameter((Object)inMemoryHolder, (String)"inMemoryHolder");
        Intrinsics.checkNotNullParameter((Object)kernelVersion2, (String)"kernelVersion");
        MessageFactoryProvider messageFactoryProvider = new MessageFactoryProviderImpl();
        JupyterCommunicationFacility communicationFacility2 = new JupyterCommunicationFacilityImpl(socketManager, messageFactoryProvider);
        JupyterExecutor executor = new JupyterExecutorImpl(loggerFactory2);
        CommManagerInternal commManager2 = new CommManagerImpl(communicationFacility2);
        IdeReplComponentsProvider replComponentsProvider = new IdeReplComponentsProvider(replSettings, communicationFacility2, commManager2, inMemoryHolder, loggerFactory2);
        ReplFactory replFactory = MessageHanderFactoryKt.getReplFactory(project, kernelVersion2, replComponentsProvider);
        ReplForJupyter repl = replFactory.createRepl();
        return new EmbeddedMessageHandler(repl, loggerFactory2, commManager2, messageFactoryProvider, socketManager, executor);
    }

    @RequiresBackgroundThread
    @NotNull
    public static final ReplFactory getReplFactory(@NotNull Project project, @NotNull String kernelVersion2, @NotNull ReplComponentsProvider replComponentsProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)kernelVersion2, (String)"kernelVersion");
        Intrinsics.checkNotNullParameter((Object)replComponentsProvider, (String)"replComponentsProvider");
        ThreadingAssertions.assertBackgroundThread();
        ClassLoader classLoader = EmbeddedKernelClassLoaderHolder.Companion.getInstance(project).getClassLoader(kernelVersion2);
        return ProvidersKt.loadDefaultReplFactory(replComponentsProvider, classLoader);
    }
}

