/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.kernel.server;

import com.intellij.kotlin.jupyter.core.resources.KotlinNotebookMavenArtifacts;
import com.intellij.kotlin.jupyter.core.resources.KotlinNotebookMavenArtifactsDownloader;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookProjectOptionsProvider;
import com.intellij.kotlin.jupyter.core.settings.OptionsUtilKt;
import com.intellij.kotlin.jupyter.core.settings.ui.JvmTargetForSnippetsComboBoxKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\b"}, d2={"chooseJvmTargetForSnippets", "Lcom/intellij/pom/java/LanguageLevel;", "project", "Lcom/intellij/openapi/project/Project;", "getClasspathArtifacts", "", "Ljava/io/File;", "Lcom/intellij/kotlin/jupyter/core/resources/KotlinNotebookMavenArtifactsDownloader;", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKernelConfigFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KernelConfigFactory.kt\ncom/intellij/kotlin/jupyter/core/jupyter/kernel/server/KernelConfigFactoryKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,104:1\n15#2:105\n*S KotlinDebug\n*F\n+ 1 KernelConfigFactory.kt\ncom/intellij/kotlin/jupyter/core/jupyter/kernel/server/KernelConfigFactoryKt\n*L\n97#1:105\n*E\n"})
public final class KernelConfigFactoryKt {
    @Nullable
    public static final LanguageLevel chooseJvmTargetForSnippets(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KotlinNotebookProjectOptionsProvider options2 = KotlinNotebookProjectOptionsProvider.Companion.getInstance(project);
        LanguageLevel selectedTarget = options2.getJvmTargetForSnippets();
        LanguageLevel myMaxBytecodeVersion = JvmTargetForSnippetsComboBoxKt.getMaxBytecodeVersion();
        if (selectedTarget != null) {
            return myMaxBytecodeVersion != null ? (LanguageLevel)RangesKt.coerceAtMost((Comparable)((Comparable)selectedTarget), (Comparable)((Comparable)myMaxBytecodeVersion)) : selectedTarget;
        }
        JavaSdkVersion jdkVersion = options2.getJdk().getVersion(project);
        if (jdkVersion == null) {
            return null;
        }
        if (myMaxBytecodeVersion == null) {
            return null;
        }
        if (jdkVersion.getMaxLanguageLevel().compareTo((Enum)myMaxBytecodeVersion) <= 0) {
            return null;
        }
        return myMaxBytecodeVersion;
    }

    private static final List<File> getClasspathArtifacts(KotlinNotebookMavenArtifactsDownloader $this$getClasspathArtifacts, Project project) {
        List<File> list;
        try {
            list = KotlinNotebookMavenArtifactsDownloader.downloadAndUnzipBlocking$default($this$getClasspathArtifacts, KotlinNotebookMavenArtifacts.INSTANCE.getSCRIPT_CLASSPATH_SHADOWED_ZIP(), null, 2, null);
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(KotlinNotebookMavenArtifactsDownloader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Unable to download artifacts zip", (Throwable)e);
            list = $this$getClasspathArtifacts.downloadArtifactBlocking(KotlinNotebookMavenArtifacts.INSTANCE.getSCRIPT_CLASSPATH_SHADOWED(), OptionsUtilKt.getSelectedKernelVersionAsString(project));
        }
        return list;
    }

    public static final /* synthetic */ List access$getClasspathArtifacts(KotlinNotebookMavenArtifactsDownloader $receiver, Project project) {
        return KernelConfigFactoryKt.getClasspathArtifacts($receiver, project);
    }
}

