/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.refactoring;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.editor.find.FindUsagesHandlerKt;
import com.intellij.kotlin.jupyter.core.editor.find.NotebookReferenceFinder;
import com.intellij.kotlin.jupyter.core.editor.refactoring.NotebookMemberInplaceRenamer;
import com.intellij.kotlin.jupyter.core.editor.refactoring.NotebookPropertyRenameProcessor;
import com.intellij.kotlin.jupyter.core.editor.refactoring.NotebookRefactoringSupport;
import com.intellij.kotlin.jupyter.core.editor.refactoring.RenamingKt;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.scriptingSupport.NotebookStructureTrackerService;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import java.awt.Component;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterNotebook;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.impl.JupyterPsiCellImpl;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J+\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J&\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0002J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\"\u0010\"\u001a\u00020\u00192\b\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006$"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/refactoring/KotlinNotebookPropertiesRenameHandler;", "Lcom/intellij/refactoring/rename/inplace/MemberInplaceRenameHandler;", "<init>", "()V", "findNearestActualElementAt", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "caretModel", "Lcom/intellij/openapi/editor/CaretModel;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "createDataContext", "contextComponent", "Ljava/awt/Component;", "newName", "", "newElementToRename", "checkAvailable", "", "elementToRename", "isRenaming", "doRename", "Lcom/intellij/refactoring/rename/inplace/InplaceRefactoring;", "createMemberRenamer", "Lcom/intellij/refactoring/rename/inplace/MemberInplaceRenamer;", "element", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "isAvailable", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nrenaming.kt\nKotlin\n*S Kotlin\n*F\n+ 1 renaming.kt\ncom/intellij/kotlin/jupyter/core/editor/refactoring/KotlinNotebookPropertiesRenameHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,296:1\n1#2:297\n27#3:298\n13#4:299\n*S KotlinDebug\n*F\n+ 1 renaming.kt\ncom/intellij/kotlin/jupyter/core/editor/refactoring/KotlinNotebookPropertiesRenameHandler\n*L\n227#1:298\n145#1:299\n*E\n"})
public final class KotlinNotebookPropertiesRenameHandler
extends MemberInplaceRenameHandler {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger log;

    private final PsiElement findNearestActualElementAt(PsiFile file, CaretModel caretModel) {
        int shift = 0;
        PsiElement element = null;
        while (!FindUsagesHandlerKt.isIdentifier(element = file.findElementAt(caretModel.getOffset() - shift++)) && element != null) {
        }
        return element;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Editor editor2 = editor;
        Intrinsics.checkNotNull((Object)editor2);
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        PsiElement element = this.findNearestActualElementAt(file, caretModel);
        if (element == null) {
            if (LookupManager.getActiveLookup((Editor)editor) != null) {
                PsiElement elementUnderCaret = file.findElementAt(editor.getCaretModel().getOffset());
                if (elementUnderCaret != null) {
                    PsiElement parent = elementUnderCaret.getParent();
                    PsiElement psiElement = element = parent instanceof PsiReference ? ((PsiReference)parent).resolve() : PsiTreeUtil.getParentOfType((PsiElement)elementUnderCaret, PsiNamedElement.class);
                }
                if (element == null) {
                    return;
                }
            } else {
                return;
            }
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (this.checkAvailable(element, editor, dataContext)) {
            this.doRename(element, editor, dataContext);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final DataContext createDataContext(Component contextComponent, String newName, PsiElement newElementToRename) {
        DataContext dataContext;
        DataContext dataContext2 = DataManager.getInstance().getDataContext(contextComponent);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext context = dataContext2;
        if (newName == null && newElementToRename == null) {
            dataContext = context;
        } else {
            PsiElement[] psiElementArray;
            SimpleDataContext.Builder builder = SimpleDataContext.builder().setParent(context).add(PsiElementRenameHandler.DEFAULT_NAME, (Object)newName);
            DataKey dataKey = LangDataKeys.PSI_ELEMENT_ARRAY;
            PsiElement psiElement = newElementToRename;
            if (psiElement != null) {
                void it;
                PsiElement psiElement2 = psiElement;
                DataKey dataKey2 = dataKey;
                SimpleDataContext.Builder builder2 = builder;
                boolean bl = false;
                PsiElement[] psiElementArray2 = new PsiElement[]{it};
                PsiElement[] psiElementArray3 = psiElementArray2;
                builder = builder2;
                dataKey = dataKey2;
                psiElementArray = psiElementArray3;
            } else {
                psiElementArray = null;
            }
            DataContext dataContext3 = builder.add(dataKey, psiElementArray).build();
            dataContext = dataContext3;
            Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"build(...)");
        }
        return dataContext;
    }

    protected boolean checkAvailable(@NotNull PsiElement elementToRename, @Nullable Editor editor, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        return RenamingKt.isKotlinNotebookInjectedFile(psiFile2) || UtilKt.isInsideKotlinNotebookFile((PsiElement)psiFile2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRenaming(@NotNull DataContext dataContext) {
        PsiLanguageInjectionHost psiLanguageInjectionHost;
        JupyterPsiCellImpl cell;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        PsiElement storedPsiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        PsiElement psiElement2 = storedPsiElement;
        if (psiElement2 == null && (psiElement2 = UtilKt.retrieveElementUnderCaret(psiFile2)) == null) {
            return false;
        }
        PsiElement psiElement3 = psiElement2;
        PsiElement parent = psiElement3.getParent();
        if (parent instanceof KtReferenceExpression) {
            PsiReference psiReference = ((KtReferenceExpression)parent).getReference();
            if (psiReference == null) return false;
            psiElement = psiReference.resolve();
        } else {
            psiElement = psiElement3;
        }
        if (psiElement == null) {
            return false;
        }
        PsiElement resolvedElement = psiElement;
        PsiFile containingFile = resolvedElement.getContainingFile();
        boolean isCompiledElem = containingFile instanceof KtClsFile;
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)psiFile2.getProject());
        if (isCompiledElem) {
            String string = ((KtClsFile)containingFile).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)"Line_", (boolean)false, (int)2, null)) {
                return false;
            }
        }
        JupyterPsiCellImpl jupyterPsiCellImpl = cell = (psiLanguageInjectionHost = manager.getInjectionHost((PsiElement)psiElement3.getContainingFile())) instanceof JupyterPsiCellImpl ? (JupyterPsiCellImpl)psiLanguageInjectionHost : null;
        Object object = jupyterPsiCellImpl != null ? jupyterPsiCellImpl.getParent() : null;
        Object object2 = object instanceof JupyterNotebook ? (JupyterNotebook)object : null;
        Integer ind = object2 != null && (object2 = object2.getPsiCellList()) != null ? Integer.valueOf(object2.indexOf(cell)) : null;
        VirtualFile virtualFile3 = virtualFile2 instanceof VirtualFileWindow ? ((VirtualFileWindow)virtualFile2).getDelegate() : virtualFile2;
        Intrinsics.checkNotNull((Object)virtualFile3);
        VirtualFile notebookFile = virtualFile3;
        if (!UtilKt.isInsideKotlinNotebookFile((PsiElement)psiFile2)) return false;
        if (!NotebookRefactoringSupport.INSTANCE.isNotebookRefactoringSupported(resolvedElement)) return false;
        if (isCompiledElem) return true;
        JupyterPsiCellImpl jupyterPsiCellImpl2 = cell;
        if ((jupyterPsiCellImpl2 != null ? (Set)jupyterPsiCellImpl2.getUserData(NotebookReferenceFinder.INSTANCE.getCELL_CLASS_NAME()) : null) != null) return true;
        Project project = psiFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (NotebookStructureTrackerService.Companion.getForFile(project, BackedNotebookVirtualFile.Companion.takeBackend(notebookFile)).getCellOrdinalToClassNameStructure().get(ind) == null) return false;
        return true;
    }

    @Nullable
    public InplaceRefactoring doRename(@NotNull PsiElement elementToRename, @NotNull Editor editor, @Nullable DataContext dataContext) {
        PsiElement newElementToRename;
        String newName;
        Component contextComponent;
        block8: {
            block10: {
                NotebookPropertyRenameProcessor processor;
                block9: {
                    PsiElement psiElement;
                    Component component;
                    Component component2;
                    Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    boolean condition$iv = dataContext != null;
                    boolean $i$f$runIf = false;
                    if (condition$iv) {
                        boolean bl = false;
                        DataContext dataContext2 = dataContext;
                        Intrinsics.checkNotNull((Object)dataContext2);
                        component2 = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext2);
                    } else {
                        component2 = component = null;
                    }
                    if (component2 == null) {
                        JComponent jComponent = editor.getComponent();
                        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                        component = jComponent;
                    }
                    contextComponent = component;
                    DataContext dataContext3 = dataContext;
                    newName = dataContext3 != null ? (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext3) : null;
                    newElementToRename = null;
                    if (!(elementToRename instanceof PsiNameIdentifierOwner) && !(elementToRename instanceof LeafPsiElement) || !(processor = new NotebookPropertyRenameProcessor()).isInplaceRenameSupported()) break block8;
                    StartMarkAction startMarkAction = StartMarkAction.canStart((Editor)editor);
                    if (startMarkAction == null) break block9;
                    PsiElement it = psiElement = processor.substituteElementToRename(elementToRename, editor);
                    boolean bl = false;
                    newElementToRename = it;
                    if (psiElement != elementToRename) break block10;
                }
                processor.substituteElementToRename(elementToRename, editor, (Pass<? super PsiElement>)((Pass)new Pass<PsiElement>(elementToRename, this, editor, contextComponent, newName){
                    final /* synthetic */ PsiElement $elementToRename;
                    final /* synthetic */ KotlinNotebookPropertiesRenameHandler this$0;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ Component $contextComponent;
                    final /* synthetic */ String $newName;
                    {
                        this.$elementToRename = $elementToRename;
                        this.this$0 = $receiver;
                        this.$editor = $editor;
                        this.$contextComponent = $contextComponent;
                        this.$newName = $newName;
                    }

                    public void pass(PsiElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        PsiNameIdentifierOwner identifier = (PsiNameIdentifierOwner)element;
                        if (this.$elementToRename instanceof LeafPsiElement && !Intrinsics.areEqual((Object)identifier.getName(), (Object)((LeafPsiElement)this.$elementToRename).getText())) {
                            KotlinNotebookPropertiesRenameHandler.access$getLog$cp().debug("Renaming aborted: found element to rename " + this.$elementToRename + " differs from " + identifier.getName());
                            return;
                        }
                        MemberInplaceRenamer renamer = this.this$0.createMemberRenamer(this.$elementToRename, identifier, this.$editor);
                        boolean startedRename = renamer.performInplaceRename();
                        if (!startedRename) {
                            KotlinNotebookPropertiesRenameHandler.access$performDialogRename$s-2096093148(element, this.$editor, KotlinNotebookPropertiesRenameHandler.access$createDataContext(this.this$0, this.$contextComponent, this.$newName, element), renamer.getInitialName());
                        }
                    }
                }));
                return null;
            }
            InplaceRefactoring inplaceRefactoring = (InplaceRefactoring)editor.getUserData(InplaceRefactoring.INPLACE_RENAMER);
            if (inplaceRefactoring != null && Intrinsics.areEqual(inplaceRefactoring.getClass(), MemberInplaceRenamer.class)) {
                TemplateState templateState;
                TemplateState templateState2 = templateState = TemplateManagerImpl.getTemplateState((Editor)InjectedLanguageEditorUtil.getTopLevelEditor((Editor)editor));
                if (templateState2 != null) {
                    templateState2.gotoEnd(true);
                }
            }
        }
        MemberInplaceRenameHandler.performDialogRename((PsiElement)elementToRename, (Editor)editor, (DataContext)this.createDataContext(contextComponent, newName, newElementToRename), null);
        return null;
    }

    @NotNull
    protected MemberInplaceRenamer createMemberRenamer(@NotNull PsiElement element, @NotNull PsiNameIdentifierOwner elementToRename, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        PsiLanguageInjectionHost originalCaretElement = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element);
        return new NotebookMemberInplaceRenamer(element, (PsiNamedElement)elementToRename, editor, originalCaretElement);
    }

    protected boolean isAvailable(@Nullable PsiElement element, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isInsideKotlinNotebookFile((PsiElement)file) && (element == null || element.getContainingFile() instanceof KtFile && NotebookRefactoringSupport.INSTANCE.isNotebookRefactoringSupported(element));
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ void access$performDialogRename$s-2096093148(PsiElement p0, Editor p1, DataContext p2, String p3) {
        MemberInplaceRenameHandler.performDialogRename((PsiElement)p0, (Editor)p1, (DataContext)p2, (String)p3);
    }

    public static final /* synthetic */ DataContext access$createDataContext(KotlinNotebookPropertiesRenameHandler $this, Component contextComponent, String newName, PsiElement newElementToRename) {
        return $this.createDataContext(contextComponent, newName, newElementToRename);
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        log = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/refactoring/KotlinNotebookPropertiesRenameHandler$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

