/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.service.util;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"shadowedSymbolSeverity", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "Lorg/jetbrains/annotations/NotNull;", "unresolvedReferenceFactoryName", "", "convertToShadowedDeclaration", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "psiElement", "Lcom/intellij/psi/PsiElement;", "factoryName", "fillInProperDescription", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo$Builder;", "intellij.kotlin.jupyter.core"})
public final class HighlightInfoManipulationsKt {
    @NotNull
    private static final HighlightInfoType shadowedSymbolSeverity;
    @NotNull
    private static final String unresolvedReferenceFactoryName = "UNRESOLVED_REFERENCE";

    @NotNull
    public static final HighlightInfo convertToShadowedDeclaration(@NotNull PsiElement psiElement, @NotNull String factoryName) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)factoryName, (String)"factoryName");
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)shadowedSymbolSeverity).range(psiElement.getTextRange()).textAttributes(CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES).needsUpdateOnTyping(false).group(0);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"group(...)");
        HighlightInfo highlightInfo = HighlightInfoManipulationsKt.fillInProperDescription(builder, factoryName).createUnconditionally();
        Intrinsics.checkNotNullExpressionValue((Object)highlightInfo, (String)"createUnconditionally(...)");
        return highlightInfo;
    }

    private static final HighlightInfo.Builder fillInProperDescription(HighlightInfo.Builder $this$fillInProperDescription, String factoryName) {
        HighlightInfo.Builder builder;
        if (Intrinsics.areEqual((Object)factoryName, (Object)unresolvedReferenceFactoryName)) {
            String unresolvedMessage = KotlinNotebookBundle.message("kotlin.jupyter.highlighting.symbols.styles.shadowed.unresolved.description", new Object[0]);
            HighlightInfo.Builder builder2 = $this$fillInProperDescription.description(unresolvedMessage).unescapedToolTip(unresolvedMessage);
            Intrinsics.checkNotNull((Object)builder2);
            builder = builder2;
        } else {
            HighlightInfo.Builder builder3 = $this$fillInProperDescription.escapedToolTip(KotlinNotebookBundle.message("kotlin.jupyter.highlighting.symbols.styles.shadowed.error.description", new Object[0]));
            Intrinsics.checkNotNull((Object)builder3);
            builder = builder3;
        }
        return builder;
    }

    static {
        HighlightInfoType highlightInfoType = HighlightInfo.convertSeverity((HighlightSeverity)HighlightSeverity.INFORMATION);
        Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType, (String)"convertSeverity(...)");
        shadowedSymbolSeverity = highlightInfoType;
    }
}

