/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.NotebookHighlightingService;
import com.intellij.kotlin.jupyter.core.ide.handlers.KotlinPluginModeAwareHandlerKt;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.analysis.KotlinIdeInjectedFilesAnalysisPromoter;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/KotlinNotebookInjectedFilesAnalysisPromoter;", "Lorg/jetbrains/kotlin/idea/base/analysis/KotlinIdeInjectedFilesAnalysisPromoter;", "<init>", "()V", "modeAwareFileFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiFile;", "", "createK2Handler", "shouldRunAnalysisForInjectedFile", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "shouldRunOnlyEssentialHighlightingForInjectedFile", "psiFile", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookInjectedFilesAnalysisPromoter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookInjectedFilesAnalysisPromoter.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/KotlinNotebookInjectedFilesAnalysisPromoter\n+ 2 KotlinPluginModeAwareHandler.kt\ncom/intellij/kotlin/jupyter/core/ide/handlers/KotlinPluginModeAwareHandlerKt\n*L\n1#1,43:1\n39#2,3:44\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookInjectedFilesAnalysisPromoter.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/KotlinNotebookInjectedFilesAnalysisPromoter\n*L\n19#1:44,3\n*E\n"})
public final class KotlinNotebookInjectedFilesAnalysisPromoter
implements KotlinIdeInjectedFilesAnalysisPromoter {
    @NotNull
    private final Function1<PsiFile, Boolean> modeAwareFileFilter;

    public KotlinNotebookInjectedFilesAnalysisPromoter() {
        Function1<PsiFile, Boolean> function1;
        KotlinNotebookInjectedFilesAnalysisPromoter kotlinNotebookInjectedFilesAnalysisPromoter = this;
        boolean $i$f$createPluginModeAwareInstance = false;
        switch (KotlinPluginModeAwareHandlerKt.WhenMappings.$EnumSwitchMapping$0[KotlinPluginModeProvider.Companion.getCurrentPluginMode().ordinal()]) {
            case 1: {
                KotlinNotebookInjectedFilesAnalysisPromoter kotlinNotebookInjectedFilesAnalysisPromoter2 = kotlinNotebookInjectedFilesAnalysisPromoter;
                boolean bl = false;
                function1 = KotlinNotebookInjectedFilesAnalysisPromoter::modeAwareFileFilter$lambda$1$lambda$0;
                KotlinNotebookInjectedFilesAnalysisPromoter kotlinNotebookInjectedFilesAnalysisPromoter3 = kotlinNotebookInjectedFilesAnalysisPromoter2;
                break;
            }
            case 2: {
                KotlinNotebookInjectedFilesAnalysisPromoter kotlinNotebookInjectedFilesAnalysisPromoter4 = kotlinNotebookInjectedFilesAnalysisPromoter;
                boolean bl = false;
                function1 = this.createK2Handler();
                KotlinNotebookInjectedFilesAnalysisPromoter kotlinNotebookInjectedFilesAnalysisPromoter3 = kotlinNotebookInjectedFilesAnalysisPromoter4;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        kotlinNotebookInjectedFilesAnalysisPromoter3.modeAwareFileFilter = function1;
    }

    private final Function1<PsiFile, Boolean> createK2Handler() {
        return KotlinNotebookInjectedFilesAnalysisPromoter::createK2Handler$lambda$2;
    }

    public boolean shouldRunAnalysisForInjectedFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        VirtualFile virtualFile2 = virtualFile;
        VirtualFileWindow virtualFileWindow = virtualFile2 instanceof VirtualFileWindow ? (VirtualFileWindow)virtualFile2 : null;
        return virtualFileWindow != null && (virtualFileWindow = virtualFileWindow.getDelegate()) != null ? IsKotlinNotebookKt.isKotlinNotebook((VirtualFile)virtualFileWindow) : false;
    }

    public boolean shouldRunOnlyEssentialHighlightingForInjectedFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return (Boolean)this.modeAwareFileFilter.invoke((Object)psiFile);
    }

    private static final boolean modeAwareFileFilter$lambda$1$lambda$0(PsiFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }

    private static final boolean createK2Handler$lambda$2(PsiFile psiFile) {
        boolean bl;
        BackedNotebookVirtualFile backedNotebook;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
        VirtualFileWindow virtualFileWindow = virtualFile instanceof VirtualFileWindow ? (VirtualFileWindow)virtualFile : null;
        BackedNotebookVirtualFile backedNotebookVirtualFile = virtualFileWindow != null && (virtualFileWindow = virtualFileWindow.getDelegate()) != null ? UtilKt.toBackedNotebookFile((VirtualFile)virtualFileWindow) : (backedNotebook = null);
        if (backedNotebook == null) {
            bl = false;
        } else {
            Project project = psiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            bl = !NotebookHighlightingService.Companion.getForFile(project, backedNotebook).isFileTarget(psiFile);
        }
        return bl;
    }
}

