/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.gutterMarks;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.OverridingAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.actions.EditorActionsProviderKt;
import com.jetbrains.rd.actions.GutterActionKind;
import com.jetbrains.rd.ide.model.DndCopyArgs;
import com.jetbrains.rd.ide.model.GutterMarkActionModel;
import com.jetbrains.rd.ide.model.GutterMarkDnDModel;
import com.jetbrains.rd.ide.model.GutterMarkHoverModel;
import com.jetbrains.rd.ide.model.RdFileId;
import com.jetbrains.rd.ide.vfs.IProtocolVirtualFile;
import com.jetbrains.rdclient.actions.base.BackendAction;
import com.jetbrains.rdclient.actions.base.BackendActionGroup;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.FrontendGutterIconRenderer;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.GutterMarkInfo;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendTooltipProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0016J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/FrontendAsyncGutterIconRenderer;", "Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/FrontendGutterIconRenderer;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "info", "Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/GutterMarkInfo;", "gutterMarkActionModel", "Lcom/jetbrains/rd/ide/model/GutterMarkActionModel;", "gutterMarkHoverModel", "Lcom/jetbrains/rd/ide/model/GutterMarkHoverModel;", "tooltipProvider", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "dndModel", "Lcom/jetbrains/rd/ide/model/GutterMarkDnDModel;", "<init>", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/GutterMarkInfo;Lcom/jetbrains/rd/ide/model/GutterMarkActionModel;Lcom/jetbrains/rd/ide/model/GutterMarkHoverModel;Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;Lcom/jetbrains/rd/ide/model/GutterMarkDnDModel;)V", "getPopupMenuActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getClickAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getMiddleButtonClickAction", "getRightButtonClickAction", "clickAction", "kind", "Lcom/jetbrains/rd/actions/GutterActionKind;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "getDraggableObject", "Lcom/intellij/openapi/editor/markup/GutterDraggableObject;", "intellij.rd.client"})
public final class FrontendAsyncGutterIconRenderer
extends FrontendGutterIconRenderer {
    public FrontendAsyncGutterIconRenderer(@NotNull RangeHighlighter highlighter, @NotNull GutterMarkInfo info2, @NotNull GutterMarkActionModel gutterMarkActionModel, @NotNull GutterMarkHoverModel gutterMarkHoverModel, @NotNull FrontendTooltipProvider tooltipProvider, @NotNull GutterMarkDnDModel dndModel) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Intrinsics.checkNotNullParameter((Object)gutterMarkActionModel, (String)"gutterMarkActionModel");
        Intrinsics.checkNotNullParameter((Object)gutterMarkHoverModel, (String)"gutterMarkHoverModel");
        Intrinsics.checkNotNullParameter((Object)tooltipProvider, (String)"tooltipProvider");
        Intrinsics.checkNotNullParameter((Object)dndModel, (String)"dndModel");
        super(highlighter, info2, gutterMarkActionModel, gutterMarkHoverModel, tooltipProvider, dndModel);
    }

    @Override
    @Nullable
    public ActionGroup getPopupMenuActions() {
        BackendActionGroup backendActionGroup;
        if (this.getInfo().getPopupGroup() == null) {
            return null;
        }
        String actionId = EditorActionsProviderKt.makeGutterIconRendererActionId((GutterActionKind)GutterActionKind.POPUP_GROUP, (long)this.getInfo().getId());
        BackendActionGroup $this$getPopupMenuActions_u24lambda_u240 = backendActionGroup = new BackendActionGroup(actionId, null);
        boolean bl = false;
        $this$getPopupMenuActions_u24lambda_u240.getTemplatePresentation().copyFrom(this.getInfo().getPopupGroup(), null, true);
        return backendActionGroup;
    }

    @Override
    @Nullable
    public AnAction getClickAction() {
        return this.clickAction(GutterActionKind.LEFT_CLICK, this.getInfo().getLeftAction());
    }

    @Nullable
    public AnAction getMiddleButtonClickAction() {
        return this.clickAction(GutterActionKind.MIDDLE_CLICK, this.getInfo().getMiddleAction());
    }

    @Nullable
    public AnAction getRightButtonClickAction() {
        return this.clickAction(GutterActionKind.RIGHT_CLICK, this.getInfo().getRightAction());
    }

    private final AnAction clickAction(GutterActionKind kind, Presentation presentation) {
        if (presentation == null) {
            return null;
        }
        String actionId = EditorActionsProviderKt.makeGutterIconRendererActionId((GutterActionKind)kind, (long)this.getInfo().getId());
        OverridingAction overridingAction = presentation.isPopupGroup() ? new BackendActionGroup(actionId, null) : new BackendAction(actionId, null, 2, null);
        AnAction $this$clickAction_u24lambda_u241 = (AnAction)overridingAction;
        boolean bl = false;
        $this$clickAction_u24lambda_u241.getTemplatePresentation().copyFrom(presentation, null, true);
        return (AnAction)overridingAction;
    }

    @Nullable
    public GutterDraggableObject getDraggableObject() {
        if (!this.getInfo().getSupportsDnD()) {
            return null;
        }
        return new GutterDraggableObject(this){
            final /* synthetic */ FrontendAsyncGutterIconRenderer this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean copy(int line, VirtualFile file, int actionId) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                IProtocolVirtualFile iProtocolVirtualFile = file instanceof IProtocolVirtualFile ? (IProtocolVirtualFile)file : null;
                RdFileId fileId = iProtocolVirtualFile != null ? iProtocolVirtualFile.getFileId() : null;
                this.this$0.getDndModel().getCopy().fire((Object)new DndCopyArgs(this.this$0.getInfo().getId(), line, fileId, actionId));
                return false;
            }

            public void remove() {
                this.this$0.getDndModel().getRemove().fire((Object)this.this$0.getInfo().getId());
            }
        };
    }
}

