/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\b\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0014J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lkotlinx/serialization/protobuf/internal/ByteArrayOutput;", "", "<init>", "()V", "array", "", "position", "", "ensureCapacity", "", "elementsToAppend", "size", "toByteArray", "write", "buffer", "output", "writeInt", "intValue", "writeLong", "longValue", "", "encodeVarint32", "value", "encodeVarint64", "encodeVarint", "length", "varIntLength", "Companion", "kotlinx-serialization-protobuf"})
public final class ByteArrayOutput {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] array = new byte[32];
    private int position;
    @NotNull
    private static final int[] VAR_INT_LENGTHS;

    private final void ensureCapacity(int elementsToAppend) {
        if (this.position + elementsToAppend <= this.array.length) {
            return;
        }
        byte[] newArray = new byte[Integer.highestOneBit(this.position + elementsToAppend) << 1];
        ArraysKt.copyInto$default(this.array, newArray, 0, 0, 0, 14, null);
        this.array = newArray;
    }

    public final int size() {
        return this.position;
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] newArray = new byte[this.position];
        ArraysKt.copyInto$default(this.array, newArray, 0, 0, this.position, 2, null);
        return newArray;
    }

    public final void write(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        int count2 = buffer.length;
        if (count2 == 0) {
            return;
        }
        this.ensureCapacity(count2);
        ArraysKt.copyInto(buffer, this.array, this.position, 0, count2);
        this.position += count2;
    }

    public final void write(@NotNull ByteArrayOutput output) {
        Intrinsics.checkNotNullParameter(output, "output");
        int count2 = output.size();
        this.ensureCapacity(count2);
        ArraysKt.copyInto(output.array, this.array, this.position, 0, count2);
        this.position += count2;
    }

    public final void writeInt(int intValue) {
        this.ensureCapacity(4);
        for (int i = 3; -1 < i; --i) {
            int n = this.position;
            this.position = n + 1;
            this.array[n] = (byte)(intValue >> i * 8);
        }
    }

    public final void writeLong(long longValue) {
        this.ensureCapacity(8);
        for (int i = 7; -1 < i; --i) {
            int n = this.position;
            this.position = n + 1;
            this.array[n] = (byte)(longValue >> i * 8);
        }
    }

    public final void encodeVarint32(int value) {
        this.ensureCapacity(5);
        if ((value & 0xFFFFFF80) == 0) {
            int n = this.position;
            this.position = n + 1;
            this.array[n] = (byte)value;
            return;
        }
        int length = this.varIntLength(value);
        this.encodeVarint(value, length);
    }

    public final void encodeVarint64(long value) {
        int length = this.varIntLength(value);
        this.ensureCapacity(length + 1);
        this.encodeVarint(value, length);
    }

    private final void encodeVarint(long value, int length) {
        long current = value;
        for (int i = 0; i < length; ++i) {
            this.array[this.position + i] = (byte)(current & 0x7FL | 0x80L);
            current >>>= 7;
        }
        this.array[this.position + length] = (byte)current;
        this.position += length + 1;
    }

    private final int varIntLength(long value) {
        return VAR_INT_LENGTHS[Long.numberOfLeadingZeros(value)];
    }

    static {
        int n = 0;
        int[] nArray = new int[65];
        while (n < 65) {
            int n2 = n++;
            nArray[n2] = (63 - n2) / 7;
        }
        VAR_INT_LENGTHS = nArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkotlinx/serialization/protobuf/internal/ByteArrayOutput$Companion;", "", "<init>", "()V", "VAR_INT_LENGTHS", "", "kotlinx-serialization-protobuf"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

