/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.actions.CellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterAllMetadataAware;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.time.ZonedDateTime;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000f\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n2\u0006\u0010\u0010\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u00060\tj\u0002`\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/editor/JupyterExecutionHistoryProvider;", "", "backedNotebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "executedCellsId", "", "", "", "Lcom/intellij/jupyter/core/jupyter/nbformat/CellId;", "jupyterNotebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "getJupyterNotebook", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "getIdForExecutionCount", "executionCount", "Companion", "intellij.jupyter.core"})
public final class JupyterExecutionHistoryProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BackedNotebookVirtualFile backedNotebookVirtualFile;
    @NotNull
    private final Map<Integer, String> executedCellsId;
    @NotNull
    private static final Key<JupyterExecutionHistoryProvider> EXECUTION_HISTORY_KEY;

    public JupyterExecutionHistoryProvider(@NotNull BackedNotebookVirtualFile backedNotebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)backedNotebookVirtualFile, (String)"backedNotebookVirtualFile");
        this.backedNotebookVirtualFile = backedNotebookVirtualFile;
        this.executedCellsId = new LinkedHashMap();
        this.getJupyterNotebook().getListeners().getCellExecutionListeners().addListener((EventListener)new CellExecutionListener(){

            @Override
            public void executionStopped(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook, JupyterExecutionStatus jupyterStatus, ZonedDateTime endTime) {
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Intrinsics.checkNotNullParameter((Object)((Object)jupyterStatus), (String)"jupyterStatus");
                Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
                JupyterNotebook jupyterNotebook = this.getJupyterNotebook();
                JupyterAllMetadataAware<ObjectNode> jupyterAllMetadataAware = jupyterNotebook instanceof JupyterNotebookBase ? (JupyterNotebookBase)jupyterNotebook : null;
                if (jupyterAllMetadataAware == null || (jupyterAllMetadataAware = ((JupyterNotebookBase)jupyterAllMetadataAware).getCellByInterval(cellPointer)) == null) {
                    return;
                }
                JupyterAllMetadataAware<ObjectNode> cell = jupyterAllMetadataAware;
                Integer n = cell.getExecutionCount();
                if (n == null) {
                    return;
                }
                int executionCount = n;
                String string = cell.getId();
                if (string == null) {
                    return;
                }
                String cellId = string;
                Integer n2 = executionCount;
                executedCellsId.put(n2, cellId);
            }
        });
    }

    private final JupyterNotebook getJupyterNotebook() {
        return this.backedNotebookVirtualFile.getNotebook();
    }

    @Nullable
    public final String getIdForExecutionCount(int executionCount) {
        return this.executedCellsId.get(executionCount);
    }

    static {
        Key key = Key.create((String)NotebookEditorAppearance.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        EXECUTION_HISTORY_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bR!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/editor/JupyterExecutionHistoryProvider$Companion;", "", "<init>", "()V", "EXECUTION_HISTORY_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/editor/JupyterExecutionHistoryProvider;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getOrInstall", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterExecutionHistoryProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterExecutionHistoryProvider.kt\ncom/intellij/jupyter/core/editor/JupyterExecutionHistoryProvider$Companion\n+ 2 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n*L\n1#1,48:1\n68#2,6:49\n*S KotlinDebug\n*F\n+ 1 JupyterExecutionHistoryProvider.kt\ncom/intellij/jupyter/core/editor/JupyterExecutionHistoryProvider$Companion\n*L\n43#1:49,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final JupyterExecutionHistoryProvider getOrInstall(@NotNull Editor editor) {
            void $this$getOrCreateUserDataUnsafe$iv;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            UserDataHolder userDataHolder = (UserDataHolder)document;
            Key key$iv = EXECUTION_HISTORY_KEY;
            boolean $i$f$getOrCreateUserDataUnsafe = false;
            Object existing$iv = $this$getOrCreateUserDataUnsafe$iv.getUserData(key$iv);
            Object object = existing$iv;
            if (object == null) {
                boolean bl = false;
                JupyterExecutionHistoryProvider value$iv = new JupyterExecutionHistoryProvider(JupyterEditorExtensionsKt.getNotebookFile(editor));
                $this$getOrCreateUserDataUnsafe$iv.putUserData(key$iv, (Object)value$iv);
                object = value$iv;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrCreateUserDataUnsafe(...)");
            return (JupyterExecutionHistoryProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

