/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.lang.UrlClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.compiler.rt.ClassDependencyLoader;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.groovy.GroovyBuilder;
import org.jetbrains.jps.incremental.groovy.GroovyCompilerResult;
import org.jetbrains.jps.incremental.groovy.GroovycContinuation;
import org.jetbrains.jps.incremental.groovy.GroovycFlavor;
import org.jetbrains.jps.incremental.groovy.GroovycOutputParser;
import org.jetbrains.jps.incremental.groovy.JointCompilationClassLoader;
import org.jetbrains.jps.incremental.groovy.JpsGroovySettings;
import org.jetbrains.jps.incremental.groovy.JpsGroovycRunner;
import org.jetbrains.jps.service.SharedThreadPool;

@ApiStatus.Internal
public final class InProcessGroovyc
implements GroovycFlavor {
    private static final Logger LOG = Logger.getInstance(InProcessGroovyc.class);
    private static final Pattern GROOVY_ALL_JAR_PATTERN = Pattern.compile("groovy-all(-(.*))?\\.jar");
    private static final Pattern GROOVY_JAR_PATTERN = Pattern.compile("groovy(-(\\d.*))?\\.jar");
    private static final Pattern GROOVY_ECLIPSE_BATCH_PATTERN = Pattern.compile("groovy-eclipse-batch-(.*)\\.jar");
    private static final Pattern GROOVY_JPS_PLUGIN_JARS_PATTERN = Pattern.compile("groovy-((jps-)|(rt-)|(constants-rt-)).*\\.jar");
    private static final ThreadPoolExecutor ourExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"Groovyc");
    private static final String GROOVYC_FINISHED = "Groovyc finished";
    private static java.lang.ref.SoftReference<Pair<String, ClassLoader>> ourParentLoaderCache;
    private static final UrlClassLoader.CachePool ourLoaderCachePool;
    private final Collection<String> myOutputs;
    private final boolean myHasStubExcludes;
    private final boolean mySharedPool;

    InProcessGroovyc(Collection<String> outputs, boolean hasStubExcludes) {
        this.myOutputs = outputs;
        this.myHasStubExcludes = hasStubExcludes;
        this.mySharedPool = SystemProperties.getBooleanProperty((String)"groovyc.in.process.shared.pool", (boolean)true);
    }

    @Override
    public GroovycContinuation runGroovyc(Collection<String> compilationClassPath, boolean forStubs, CompileContext context, File tempFile, GroovycOutputParser parser, String byteCodeTargetLevel) throws Exception {
        boolean jointPossible = forStubs && !this.myHasStubExcludes;
        LinkedBlockingQueue mailbox = jointPossible && SystemProperties.getBooleanProperty((String)"groovyc.joint.compilation", (boolean)true) ? new LinkedBlockingQueue() : null;
        JointCompilationClassLoader loader = this.createCompilationClassLoader(compilationClassPath);
        if (loader == null) {
            parser.addCompilerMessage(parser.reportNoGroovy(null));
            return null;
        }
        Object executorService = this.mySharedPool ? SharedThreadPool.getInstance() : ourExecutor;
        Future<Void> future = executorService.submit(() -> {
            try {
                InProcessGroovyc.runGroovycInThisProcess((ClassLoader)((Object)loader), forStubs, context, tempFile, parser, byteCodeTargetLevel, mailbox, this.mySharedPool);
            }
            finally {
                if (mailbox != null) {
                    mailbox.offer(GROOVYC_FINISHED);
                }
            }
            return null;
        });
        if (mailbox == null) {
            future.get();
            return null;
        }
        return InProcessGroovyc.waitForStubGeneration(future, mailbox, parser, loader);
    }

    @Nullable
    private static GroovycContinuation waitForStubGeneration(Future<Void> future, LinkedBlockingQueue<?> mailbox, GroovycOutputParser parser, JointCompilationClassLoader loader) throws InterruptedException {
        Object msg;
        do {
            if (GROOVYC_FINISHED.equals(msg = mailbox.poll(1L, TimeUnit.MINUTES))) {
                return null;
            }
            if (!(msg instanceof Queue)) continue;
            Queue toGroovyc = (Queue)msg;
            loader.resetCache();
            return InProcessGroovyc.createContinuation(future, toGroovyc, parser, loader);
        } while (msg == null);
        throw new AssertionError((Object)("Unknown message: " + String.valueOf(msg)));
    }

    @NotNull
    private static GroovycContinuation createContinuation(final Future<Void> future, final @NotNull Queue<String> mailbox, final GroovycOutputParser parser, final @NotNull JointCompilationClassLoader loader) {
        if (mailbox == null) {
            InProcessGroovyc.$$$reportNull$$$0(0);
        }
        if (loader == null) {
            InProcessGroovyc.$$$reportNull$$$0(1);
        }
        return new GroovycContinuation(){

            @Override
            @NotNull
            public GroovyCompilerResult continueCompilation() throws Exception {
                loader.resetCache();
                parser.onContinuation();
                mailbox.offer("Javac completed");
                future.get();
                GroovyCompilerResult groovyCompilerResult = parser.result();
                if (groovyCompilerResult == null) {
                    1.$$$reportNull$$$0(0);
                }
                return groovyCompilerResult;
            }

            @Override
            public void buildAborted() {
                mailbox.offer("Build aborted");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/InProcessGroovyc$1", "continueCompilation"));
            }
        };
    }

    private static void runGroovycInThisProcess(ClassLoader loader, boolean forStubs, CompileContext context, File tempFile, GroovycOutputParser parser, @Nullable String byteCodeTargetLevel, @Nullable Queue<? super Object> mailbox, boolean sharedPool) throws IOException {
        PrintStream oldOut = sharedPool ? null : System.out;
        PrintStream oldErr = sharedPool ? null : System.err;
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        PrintStream out = InProcessGroovyc.createStream(parser, ProcessOutputTypes.STDOUT, oldOut);
        PrintStream err = InProcessGroovyc.createStream(parser, ProcessOutputTypes.STDERR, oldErr);
        if (!sharedPool) {
            System.setOut(out);
            System.setErr(err);
        }
        Thread.currentThread().setContextClassLoader(loader);
        try {
            Class<?> runnerClass = loader.loadClass("org.jetbrains.groovy.compiler.rt.GroovycRunner");
            Method intMain = runnerClass.getDeclaredMethod("intMain2", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, String.class, String.class, Queue.class, PrintStream.class, PrintStream.class);
            JpsGroovySettings groovySettings = JpsGroovycRunner.getGroovyCompilerSettings(context);
            Integer exitCode = (Integer)intMain.invoke(null, groovySettings.invokeDynamic, false, forStubs, tempFile.getPath(), groovySettings.configScript, byteCodeTargetLevel, mailbox, out, err);
            parser.notifyFinished(exitCode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            out.flush();
            err.flush();
            if (!sharedPool) {
                System.setOut(oldOut);
                System.setErr(oldErr);
            }
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    @Nullable
    private JointCompilationClassLoader createCompilationClassLoader(Collection<String> compilationClassPath) throws Exception {
        ClassLoader groovyClassLoader;
        ClassLoader parent = InProcessGroovyc.obtainParentLoader(compilationClassPath);
        try {
            ClassLoader auxiliary = parent == null ? this.buildCompilationClassLoader(compilationClassPath, null).get() : parent;
            Class<?> gcl = auxiliary.loadClass("groovy.lang.GroovyClassLoader");
            groovyClassLoader = (ClassLoader)gcl.getConstructor(ClassLoader.class).newInstance(parent != null ? parent : InProcessGroovyc.getPlatformLoaderParentIfOnJdk9());
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Throwable)e);
            return null;
        }
        return new JointCompilationClassLoader(this.buildCompilationClassLoader(compilationClassPath, groovyClassLoader));
    }

    private UrlClassLoader.Builder buildCompilationClassLoader(Collection<String> compilationClassPath, ClassLoader parent) {
        return UrlClassLoader.build().files(InProcessGroovyc.toPaths(compilationClassPath)).parent(parent).useCache(ourLoaderCachePool, file -> {
            String filePath = FileUtil.toCanonicalPath((String)file.toString());
            for (String output : this.myOutputs) {
                if (!FileUtil.startsWith((String)output, (String)filePath)) continue;
                return false;
            }
            return true;
        });
    }

    @Nullable
    private static ClassLoader getPlatformLoaderParentIfOnJdk9() {
        if (JavaVersion.current().feature >= 9) {
            try {
                return (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    static String evaluatePathToGroovyJarForParentClassloader(Collection<String> compilationClassPath) {
        String version;
        if (!"true".equals(System.getProperty("groovyc.reuse.compiler.classes", "true"))) {
            return null;
        }
        List groovyJars = ContainerUtil.findAll(compilationClassPath, s -> {
            String fileName = PathUtilRt.getFileName((String)s);
            return (GROOVY_ALL_JAR_PATTERN.matcher(fileName).matches() || GROOVY_JAR_PATTERN.matcher(fileName).matches()) && !GROOVY_ECLIPSE_BATCH_PATTERN.matcher(fileName).matches() && !GROOVY_JPS_PLUGIN_JARS_PATTERN.matcher(fileName).matches();
        });
        LOG.debug("Groovy jars: " + String.valueOf(groovyJars));
        String singleJar = (String)ContainerUtil.getOnlyItem((Collection)groovyJars);
        if (singleJar == null) {
            return null;
        }
        String fileName = PathUtilRt.getFileName((String)singleJar);
        if (GROOVY_ALL_JAR_PATTERN.matcher(fileName).matches()) {
            return singleJar;
        }
        Matcher matcher = GROOVY_JAR_PATTERN.matcher(fileName);
        if (matcher.matches() && (version = matcher.group(2)) != null && version.startsWith("2.5")) {
            return singleJar;
        }
        return null;
    }

    @Nullable
    private static ClassLoader obtainParentLoader(Collection<String> compilationClassPath) {
        String groovyJar = InProcessGroovyc.evaluatePathToGroovyJarForParentClassloader(compilationClassPath);
        if (groovyJar == null) {
            return null;
        }
        Pair pair = (Pair)SoftReference.dereference(ourParentLoaderCache);
        if (pair != null && ((String)pair.first).equals(groovyJar)) {
            return (ClassLoader)pair.second;
        }
        final ClassDependencyLoader checkWellFormed = new ClassDependencyLoader(){

            protected void loadClassDependencies(Class aClass) throws ClassNotFoundException {
                if (!this.isCompilerCoreClass(aClass.getName()) || !(aClass.getClassLoader() instanceof UrlClassLoader)) {
                    super.loadClassDependencies(aClass);
                }
            }

            private boolean isCompilerCoreClass(String name) {
                if (name.startsWith("groovyjarjar")) {
                    return true;
                }
                if (name.startsWith("org.codehaus.groovy.")) {
                    String tail = name.substring("org.codehaus.groovy.".length());
                    if (tail.startsWith("ast") || tail.startsWith("classgen") || tail.startsWith("tools.javac") || tail.startsWith("antlr") || tail.startsWith("vmplugin") || tail.startsWith("reflection") || tail.startsWith("control")) {
                        return true;
                    }
                    if (tail.startsWith("runtime") && name.contains("GroovyMethods")) {
                        return true;
                    }
                }
                return false;
            }
        };
        UrlClassLoader groovyAllLoader = UrlClassLoader.build().files(InProcessGroovyc.toPaths(ContainerUtil.concat(GroovyBuilder.getGroovyRtRoots(false), Collections.singletonList(groovyJar)))).useCache(ourLoaderCachePool, url -> true).parent(InProcessGroovyc.getPlatformLoaderParentIfOnJdk9()).get();
        URLClassLoader wrapper = new URLClassLoader(new URL[0], (ClassLoader)groovyAllLoader){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.startsWith("groovy.grape.")) {
                    throw new ClassNotFoundException(name);
                }
                try {
                    return checkWellFormed.loadDependencies(super.loadClass(name, resolve));
                }
                catch (NoClassDefFoundError e) {
                    throw new ClassNotFoundException(name, e);
                }
            }
        };
        ourParentLoaderCache = new java.lang.ref.SoftReference<Pair>(Pair.create((Object)groovyJar, (Object)wrapper));
        return wrapper;
    }

    @NotNull
    private static List<Path> toPaths(Collection<String> paths) {
        ArrayList<Path> result = new ArrayList<Path>();
        for (String s : paths) {
            result.add(Paths.get(s, new String[0]));
        }
        ArrayList<Path> arrayList = result;
        if (arrayList == null) {
            InProcessGroovyc.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static PrintStream createStream(final @NotNull GroovycOutputParser parser, final @NotNull Key<?> type, final @Nullable(value="null means not overridden") @Nullable(value="null means not overridden") PrintStream overridden) throws IOException {
        if (parser == null) {
            InProcessGroovyc.$$$reportNull$$$0(3);
        }
        if (type == null) {
            InProcessGroovyc.$$$reportNull$$$0(4);
        }
        final Thread thread = Thread.currentThread();
        OutputStream out = new OutputStream(){
            ByteArrayOutputStream line = new ByteArrayOutputStream();
            boolean hasLineSeparator = false;

            @Override
            public void write(int b) {
                if (overridden != null && Thread.currentThread() != thread) {
                    overridden.write(b);
                    return;
                }
                if (this.hasLineSeparator && !this.isLineSeparator(b)) {
                    this.flush();
                } else {
                    this.hasLineSeparator |= this.isLineSeparator(b);
                }
                this.line.write(b);
            }

            private boolean isLineSeparator(int b) {
                return b == 10 || b == 13;
            }

            @Override
            public void flush() {
                if (overridden != null && Thread.currentThread() != thread) {
                    overridden.flush();
                    return;
                }
                if (this.line.size() > 0) {
                    parser.notifyTextAvailable(StringUtil.convertLineSeparators((String)this.line.toString(StandardCharsets.UTF_8)), type);
                    this.line = new ByteArrayOutputStream();
                    this.hasLineSeparator = false;
                }
            }
        };
        return new PrintStream(out, false, StandardCharsets.UTF_8);
    }

    static {
        ourLoaderCachePool = UrlClassLoader.createCachePool();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mailbox";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/groovy/InProcessGroovyc";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/groovy/InProcessGroovyc";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createContinuation";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

