/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.sourceSetModel;

import com.intellij.gradle.toolingExtension.impl.model.sourceSetModel.DefaultGradleSourceSetModel;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetModel.GradleSourceSetResolutionContext;
import com.intellij.gradle.toolingExtension.impl.util.GradleProjectUtil;
import com.intellij.gradle.toolingExtension.impl.util.GradleTaskUtil;
import com.intellij.gradle.toolingExtension.impl.util.collectionUtil.GradleCollectionUtil;
import com.intellij.gradle.toolingExtension.impl.util.collectionUtil.GradleCollectionVisitor;
import com.intellij.gradle.toolingExtension.impl.util.javaPluginUtil.JavaPluginUtil;
import com.intellij.gradle.toolingExtension.util.GradleReflectionUtil;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.GradleSourceSetModel;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.util.StringUtils;

@ApiStatus.Internal
public class GradleSourceSetModelBuilder
extends AbstractModelBuilderService {
    private static final String JVM_TEST_SUITE_PLUGIN_ID = "jvm-test-suite";
    private static final String TESTING_EXTENSION_CLASS = "org.gradle.testing.base.TestingExtension";
    private static final String JVM_TEST_SUITE_CLASS = "org.gradle.api.plugins.jvm.JvmTestSuite";

    public boolean canBuild(String modelName) {
        return GradleSourceSetModel.class.getName().equals(modelName);
    }

    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        if (modelName == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(2);
        }
        DefaultGradleSourceSetModel sourceSetModel = new DefaultGradleSourceSetModel();
        sourceSetModel.setSourceCompatibility(JavaPluginUtil.getSourceCompatibility(project));
        sourceSetModel.setTargetCompatibility(JavaPluginUtil.getTargetCompatibility(project));
        sourceSetModel.setTaskArtifacts(GradleSourceSetModelBuilder.collectProjectTaskArtifacts(project, context));
        sourceSetModel.setConfigurationArtifacts(GradleSourceSetModelBuilder.collectProjectConfigurationArtifacts(project, context));
        sourceSetModel.setAdditionalArtifacts(GradleSourceSetModelBuilder.collectNonSourceSetArtifacts(project, context));
        sourceSetModel.setSourceSets(GradleSourceSetModelBuilder.collectSourceSets(project, context));
        return sourceSetModel;
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        if (modelName == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(5);
        }
        if (exception == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(6);
        }
        context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.group").withKind(Message.Kind.ERROR).withTitle("Source set model building failure").withText("Project source sets cannot be resolved").withException(exception).reportMessage(project);
    }

    @NotNull
    private static List<File> collectProjectTaskArtifacts(final @NotNull Project project, final @NotNull ModelBuilderContext context) {
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(7);
        }
        if (context == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(8);
        }
        final ArrayList taskArtifacts = new ArrayList();
        GradleCollectionVisitor.accept(project.getTasks().withType(Jar.class), new GradleCollectionVisitor<Jar>(){

            @Override
            public void visit(Jar element) {
                File archiveFile = GradleTaskUtil.getTaskArchiveFile((AbstractArchiveTask)element);
                taskArtifacts.add(archiveFile);
            }

            @Override
            public void onFailure(Jar element, @NotNull Exception exception) {
                if (exception == null) {
                    1.$$$reportNull$$$0(0);
                }
                context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.projectArtifact.group").withTitle("Jar task configuration error").withText("Cannot resolve artifact file for the project Jar task: " + element.getPath()).withKind(Message.Kind.WARNING).withException(exception).reportMessage(project);
            }

            @Override
            public void visitAfterAccept(Jar element) {
                context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.projectArtifact.skipped.group").withTitle("Jar task configuration error").withText("Artifact files collecting for project Jar tasks was finished. Resolution for the Jar task " + element.getPath() + " will be skipped.").withInternal().withStackTrace().withKind(Message.Kind.WARNING).reportMessage(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetModelBuilder$1", "onFailure"));
            }
        });
        return new ArrayList<File>(taskArtifacts);
    }

    @NotNull
    private static List<File> collectNonSourceSetArtifacts(final @NotNull Project project, final @NotNull ModelBuilderContext context) {
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(9);
        }
        if (context == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(10);
        }
        final ArrayList<File> additionalArtifacts = new ArrayList<File>();
        GradleCollectionVisitor.accept(project.getTasks().withType(Jar.class), new GradleCollectionVisitor<Jar>(){

            @Override
            public void visit(Jar element) {
                if (GradleSourceSetModelBuilder.isShadowJar(element) || GradleSourceSetModelBuilder.containsPotentialClasspathElements((AbstractArchiveTask)element, project)) {
                    File archiveFile = GradleTaskUtil.getTaskArchiveFile((AbstractArchiveTask)element);
                    additionalArtifacts.add(archiveFile);
                }
            }

            @Override
            public void onFailure(Jar element, @NotNull Exception exception) {
                if (exception == null) {
                    2.$$$reportNull$$$0(0);
                }
                context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.nonSourceSetArtifact.group").withTitle("Jar task configuration error").withText("Cannot resolve an artifact file for the project Jar task: " + element.getPath()).withKind(Message.Kind.WARNING).withException(exception).reportMessage(project);
            }

            @Override
            public void visitAfterAccept(Jar element) {
                context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.nonSourceSetArtifact.skipped.group").withTitle("Jar task configuration error").withText("Artifact files collecting for project Jar tasks was finished. Resolution for the Jar task " + element.getPath() + " will be skipped.").withInternal().withStackTrace().withKind(Message.Kind.WARNING).reportMessage(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetModelBuilder$2", "onFailure"));
            }
        });
        ArrayList<File> arrayList = additionalArtifacts;
        if (arrayList == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static Map<String, Set<File>> collectProjectConfigurationArtifacts(final @NotNull Project project, final @NotNull ModelBuilderContext context) {
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(12);
        }
        if (context == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(13);
        }
        final HashMap<String, Set<File>> configurationArtifacts = new HashMap<String, Set<File>>();
        GradleCollectionVisitor.accept(project.getConfigurations(), new GradleCollectionVisitor<Configuration>(){

            @Override
            public void visit(Configuration element) {
                PublishArtifactSet artifactSet = element.getArtifacts();
                FileCollection fileCollection = artifactSet.getFiles();
                Set files = fileCollection.getFiles();
                configurationArtifacts.put(element.getName(), new LinkedHashSet(files));
            }

            @Override
            public void onFailure(Configuration element, @NotNull Exception exception) {
                if (exception == null) {
                    3.$$$reportNull$$$0(0);
                }
                context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.projectConfigurationArtifact.group").withTitle("Project configuration error").withText("Cannot resolve an artifact file for the project configuration" + element).withKind(Message.Kind.WARNING).withException(exception).reportMessage(project);
            }

            @Override
            public void visitAfterAccept(Configuration element) {
                context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.projectConfigurationArtifact.skipped.group").withTitle("Project configuration error").withText("Artifact files collecting for project configurations was finished. Resolution for the configuration " + element + " will be skipped.").withInternal().withStackTrace().withKind(Message.Kind.WARNING).reportMessage(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetModelBuilder$3", "onFailure"));
            }
        });
        HashMap<String, Set<File>> hashMap = configurationArtifacts;
        if (hashMap == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    @NotNull
    private static Collection<File> collectSourceSetArtifacts(final @NotNull Project project, final @NotNull ModelBuilderContext context, final @NotNull SourceSet sourceSet) {
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(15);
        }
        if (context == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(16);
        }
        if (sourceSet == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(17);
        }
        final LinkedHashSet<File> sourceSetArtifacts = new LinkedHashSet<File>();
        TaskCollection archiveTaskCollection = project.getTasks().withType(AbstractArchiveTask.class);
        GradleCollectionVisitor.accept(archiveTaskCollection, new GradleCollectionVisitor<AbstractArchiveTask>(){

            @Override
            public void visit(AbstractArchiveTask element) {
                if (GradleSourceSetModelBuilder.containsAllSourceSetOutput(element, sourceSet)) {
                    File archiveFile = GradleTaskUtil.getTaskArchiveFile(element);
                    sourceSetArtifacts.add(archiveFile);
                }
            }

            @Override
            public void onFailure(AbstractArchiveTask element, @NotNull Exception exception) {
                if (exception == null) {
                    4.$$$reportNull$$$0(0);
                }
                context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.sourceSetArtifact.group").withTitle("Project configuration error").withText("Cannot resolve an artifact file for the source set " + element).withKind(Message.Kind.WARNING).withException(exception).reportMessage(project);
            }

            @Override
            public void visitAfterAccept(AbstractArchiveTask element) {
                context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.sourceSetArtifact.skipped.group").withTitle("Project configuration error").withText("Artifact files collecting for source sets was finished. Resolution for the source set" + element + " will be skipped.").withInternal().withStackTrace().withKind(Message.Kind.WARNING).reportMessage(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetModelBuilder$4", "onFailure"));
            }
        });
        LinkedHashSet<File> linkedHashSet = sourceSetArtifacts;
        if (linkedHashSet == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(18);
        }
        return linkedHashSet;
    }

    private static void cleanupSharedSourceDirs(@NotNull Map<String, DefaultExternalSourceSet> externalSourceSets, @NotNull String sourceSetName, @Nullable String sourceSetNameToIgnore) {
        DefaultExternalSourceSet sourceSet;
        if (externalSourceSets == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(19);
        }
        if (sourceSetName == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(20);
        }
        if ((sourceSet = externalSourceSets.get(sourceSetName)) == null) {
            return;
        }
        for (Map.Entry<String, DefaultExternalSourceSet> sourceSetEntry : externalSourceSets.entrySet()) {
            if (Objects.equals(sourceSetEntry.getKey(), sourceSetName) || Objects.equals(sourceSetEntry.getKey(), sourceSetNameToIgnore)) continue;
            DefaultExternalSourceSet customSourceSet = sourceSetEntry.getValue();
            for (ExternalSystemSourceType sourceType : ExternalSystemSourceType.values()) {
                DefaultExternalSourceDirectorySet customSourceDirectorySet = customSourceSet.getSources().get(sourceType);
                if (customSourceDirectorySet == null) continue;
                for (Map.Entry<ExternalSystemSourceType, DefaultExternalSourceDirectorySet> sourceDirEntry : sourceSet.getSources().entrySet()) {
                    customSourceDirectorySet.getSrcDirs().removeAll(sourceDirEntry.getValue().getSrcDirs());
                }
            }
        }
    }

    private static void cleanupSharedIdeaSourceDirs(@NotNull DefaultExternalSourceSet externalSourceSet, @NotNull GradleSourceSetResolutionContext sourceSetResolutionContext) {
        if (externalSourceSet == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(21);
        }
        if (sourceSetResolutionContext == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(22);
        }
        if ("main".equals(externalSourceSet.getName())) {
            return;
        }
        if ("test".equals(externalSourceSet.getName())) {
            return;
        }
        for (DefaultExternalSourceDirectorySet sourceDirectorySet : externalSourceSet.getSources().values()) {
            sourceSetResolutionContext.ideaSourceDirs.removeAll(sourceDirectorySet.getSrcDirs());
            sourceSetResolutionContext.ideaResourceDirs.removeAll(sourceDirectorySet.getSrcDirs());
            sourceSetResolutionContext.ideaTestSourceDirs.removeAll(sourceDirectorySet.getSrcDirs());
            sourceSetResolutionContext.ideaTestResourceDirs.removeAll(sourceDirectorySet.getSrcDirs());
        }
    }

    private static boolean isShadowJar(Jar task) {
        Class<?> type = GradleTaskUtil.getTaskIdentityType((TaskInternal)task);
        return type != null && type.getName().equals("com.github.jengelman.gradle.plugins.shadow.tasks.ShadowJar");
    }

    private static boolean containsPotentialClasspathElements(@NotNull AbstractArchiveTask archiveTask, @NotNull Project project) {
        SourceSetContainer sourceSetContainer;
        if (archiveTask == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(23);
        }
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(24);
        }
        if ((sourceSetContainer = JavaPluginUtil.getSourceSetContainer(project)) == null || sourceSetContainer.isEmpty()) {
            return true;
        }
        HashSet outputFiles = new HashSet();
        sourceSetContainer.all(ss -> outputFiles.addAll(ss.getOutput().getFiles()));
        for (Object path : GradleSourceSetModelBuilder.getArchiveTaskSourcePaths(archiveTask)) {
            if (GradleSourceSetModelBuilder.isSafeToResolve(path, project) || GradleSourceSetModelBuilder.isResolvableFileCollection(path, project)) {
                for (File f : project.files(new Object[]{path}).getFiles()) {
                    if (outputFiles.contains(f) || !f.isDirectory() && (!f.isFile() || !f.getName().endsWith(".class"))) continue;
                    return true;
                }
                continue;
            }
            return true;
        }
        return false;
    }

    private static boolean containsAllSourceSetOutput(@NotNull AbstractArchiveTask archiveTask, @NotNull SourceSet sourceSet) {
        if (archiveTask == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(25);
        }
        if (sourceSet == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(26);
        }
        HashSet outputFiles = new HashSet(sourceSet.getOutput().getFiles());
        Project project = archiveTask.getProject();
        try {
            Set<Object> sourcePaths = GradleSourceSetModelBuilder.getArchiveTaskSourcePaths(archiveTask);
            for (Object path : sourcePaths) {
                if (!GradleSourceSetModelBuilder.isSafeToResolve(path, project) && !GradleSourceSetModelBuilder.isResolvableFileCollection(path, project)) continue;
                outputFiles.removeAll(project.files(new Object[]{path}).getFiles());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return outputFiles.isEmpty();
    }

    private static Set<Object> getArchiveTaskSourcePaths(AbstractArchiveTask archiveTask) {
        try {
            Method mainSpecGetter = AbstractCopyTask.class.getDeclaredMethod("getMainSpec", new Class[0]);
            mainSpecGetter.setAccessible(true);
            Object mainSpec = mainSpecGetter.invoke((Object)archiveTask, new Object[0]);
            Method getSourcePaths = mainSpec.getClass().getMethod("getSourcePaths", new Class[0]);
            Set sourcePaths = (Set)getSourcePaths.invoke(mainSpec, new Object[0]);
            if (sourcePaths != null) {
                return sourcePaths;
            }
            return Collections.emptySet();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
            return Collections.emptySet();
        }
    }

    private static boolean isResolvableFileCollection(Object param, Project project) {
        Object object = GradleSourceSetModelBuilder.tryUnpackPresentProvider(param, project);
        if (object instanceof FileCollection) {
            try {
                project.files(new Object[]{object}).getFiles();
                return true;
            }
            catch (Throwable ignored) {
                return false;
            }
        }
        return false;
    }

    private static boolean isSafeToResolve(Object param, Project project) {
        Object object = GradleSourceSetModelBuilder.tryUnpackPresentProvider(param, project);
        return object instanceof CharSequence || object instanceof File || object instanceof Path || object instanceof SourceSetOutput || GradleReflectionUtil.isInstance((Object)object, (String)"org.gradle.api.file.Directory") || GradleReflectionUtil.isInstance((Object)object, (String)"org.gradle.api.file.RegularFile");
    }

    private static Object tryUnpackPresentProvider(Object object, Project project) {
        if (!GradleReflectionUtil.isInstance((Object)object, (String)"org.gradle.api.provider.Provider")) {
            return object;
        }
        try {
            Class<?> providerClass = object.getClass();
            Method isPresentMethod = providerClass.getMethod("isPresent", new Class[0]);
            Method getterMethod = providerClass.getMethod("get", new Class[0]);
            if (((Boolean)isPresentMethod.invoke(object, new Object[0])).booleanValue()) {
                return getterMethod.invoke(object, new Object[0]);
            }
            return object;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            boolean isCodeException = GradleReflectionUtil.isInstance((Object)cause, (String)"org.gradle.api.InvalidUserCodeException");
            boolean isDataException = GradleReflectionUtil.isInstance((Object)cause, (String)"org.gradle.api.InvalidUserDataException");
            if (isCodeException || isDataException) {
                return object;
            }
            String msg = cause.getMessage();
            String className = cause.getClass().getCanonicalName();
            project.getLogger().info("Unable to resolve task source path: {} ({})", (Object)msg, (Object)className);
            return object;
        }
    }

    @NotNull
    static Collection<SourceSet> collectTestSourceSets(@NotNull Project project) {
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(27);
        }
        ArrayList<SourceSet> result = new ArrayList<SourceSet>();
        result.addAll(GradleSourceSetModelBuilder.collectJvmTestSuiteSourceSets(project));
        result.addAll(GradleSourceSetModelBuilder.collectTestFixtureSourceSets(project));
        ArrayList<SourceSet> arrayList = result;
        if (arrayList == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<SourceSet> collectJvmTestSuiteSourceSets(@NotNull Project project) {
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(29);
        }
        if (GradleVersionUtil.isCurrentGradleOlderThan((String)"7.4")) {
            List<SourceSet> list = Collections.emptyList();
            if (list == null) {
                GradleSourceSetModelBuilder.$$$reportNull$$$0(30);
            }
            return list;
        }
        Plugin plugin = project.getPlugins().findPlugin(JVM_TEST_SUITE_PLUGIN_ID);
        if (plugin == null) {
            List<SourceSet> list = Collections.emptyList();
            if (list == null) {
                GradleSourceSetModelBuilder.$$$reportNull$$$0(31);
            }
            return list;
        }
        ClassLoader pluginClassLoader = plugin.getClass().getClassLoader();
        Class testingExtensionClass = GradleReflectionUtil.loadClassOrNull((ClassLoader)pluginClassLoader, (String)TESTING_EXTENSION_CLASS);
        Class jvmTestSuiteClass = GradleReflectionUtil.loadClassOrNull((ClassLoader)pluginClassLoader, (String)JVM_TEST_SUITE_CLASS);
        if (testingExtensionClass == null || jvmTestSuiteClass == null) {
            List<SourceSet> list = Collections.emptyList();
            if (list == null) {
                GradleSourceSetModelBuilder.$$$reportNull$$$0(32);
            }
            return list;
        }
        Object testingExtension = project.findProperty("testing");
        if (testingExtension == null) {
            List<SourceSet> list = Collections.emptyList();
            if (list == null) {
                GradleSourceSetModelBuilder.$$$reportNull$$$0(33);
            }
            return list;
        }
        ArrayList<SourceSet> result = new ArrayList<SourceSet>();
        if (testingExtensionClass.isInstance(testingExtension)) {
            Collection suites = (Collection)GradleReflectionUtil.reflectiveCall((Object)testingExtension, (String)"getSuites", Collection.class);
            for (Object suite : suites) {
                SourceSet sourceSet;
                if (!jvmTestSuiteClass.isInstance(suite) || (sourceSet = (SourceSet)GradleReflectionUtil.reflectiveCall(suite, (String)"getSources", SourceSet.class)) == null) continue;
                result.add(sourceSet);
            }
        }
        ArrayList<SourceSet> arrayList = result;
        if (arrayList == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<SourceSet> collectTestFixtureSourceSets(@NotNull Project project) {
        SourceSetContainer sourceSets;
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(35);
        }
        if ((sourceSets = JavaPluginUtil.getSourceSetContainer(project)) == null) {
            List<SourceSet> list = Collections.emptyList();
            if (list == null) {
                GradleSourceSetModelBuilder.$$$reportNull$$$0(36);
            }
            return list;
        }
        SourceSet testFixtureSourceSet = (SourceSet)sourceSets.findByName("testFixtures");
        if (testFixtureSourceSet == null) {
            List<SourceSet> list = Collections.emptyList();
            if (list == null) {
                GradleSourceSetModelBuilder.$$$reportNull$$$0(37);
            }
            return list;
        }
        Set<SourceSet> set = Collections.singleton(testFixtureSourceSet);
        if (set == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(38);
        }
        return set;
    }

    private static void addJavaCompilerOptions(@NotNull DefaultExternalSourceSet externalSourceSet, @NotNull Project project, @NotNull SourceSet sourceSet, @NotNull GradleSourceSetResolutionContext sourceSetResolutionContext) {
        Task javaCompileTask;
        if (externalSourceSet == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(39);
        }
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(40);
        }
        if (sourceSet == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(41);
        }
        if (sourceSetResolutionContext == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(42);
        }
        if ((javaCompileTask = (Task)project.getTasks().findByName(sourceSet.getCompileJavaTaskName())) instanceof JavaCompile) {
            JavaCompile javaCompile = (JavaCompile)javaCompileTask;
            externalSourceSet.setJavaToolchainHome(GradleSourceSetModelBuilder.getJavaToolchainHome(project, javaCompile));
            externalSourceSet.setSourceCompatibility(javaCompile.getSourceCompatibility());
            externalSourceSet.setTargetCompatibility(javaCompile.getTargetCompatibility());
            externalSourceSet.setCompilerArguments(GradleCollectionUtil.collectionToString(javaCompile.getOptions().getAllCompilerArgs()));
        }
        if (externalSourceSet.getSourceCompatibility() == null) {
            externalSourceSet.setSourceCompatibility(sourceSetResolutionContext.projectSourceCompatibility);
        }
        if (externalSourceSet.getSourceCompatibility() == null) {
            externalSourceSet.setTargetCompatibility(sourceSetResolutionContext.projectTargetCompatibility);
        }
    }

    @Nullable
    private static File getJavaToolchainHome(@NotNull Project project, @NotNull JavaCompile javaCompile) {
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(43);
        }
        if (javaCompile == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(44);
        }
        if (GradleVersionUtil.isCurrentGradleOlderThan((String)"6.7")) {
            return null;
        }
        Property compiler = javaCompile.getJavaCompiler();
        if (!compiler.isPresent()) {
            return null;
        }
        try {
            JavaToolchain javaToolchain;
            JavaInstallationMetadata metadata = ((JavaCompiler)compiler.get()).getMetadata();
            File javaToolchainHome = metadata.getInstallationPath().getAsFile();
            if (GradleVersionUtil.isCurrentGradleOlderThan((String)"8.0")) {
                return javaToolchainHome;
            }
            if (metadata instanceof JavaToolchain && !(javaToolchain = (JavaToolchain)metadata).isFallbackToolchain()) {
                return javaToolchainHome;
            }
        }
        catch (Throwable e) {
            Logger logger = project.getLogger();
            logger.warn(String.format("Skipping java toolchain information for %s : %s", javaCompile.getPath(), e.getMessage()));
            logger.info(String.format("Failed to resolve java toolchain info for %s", javaCompile.getPath()), e);
        }
        return null;
    }

    @NotNull
    private static Map<String, DefaultExternalSourceSet> collectSourceSets(@NotNull Project project, @NotNull ModelBuilderContext context) {
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(45);
        }
        if (context == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(46);
        }
        GradleSourceSetResolutionContext sourceSetResolutionContext = new GradleSourceSetResolutionContext(project, context);
        SourceSetContainer sourceSets = JavaPluginUtil.getSourceSetContainer(project);
        if (sourceSets == null) {
            return new LinkedHashMap<String, DefaultExternalSourceSet>();
        }
        LinkedHashMap<String, DefaultExternalSourceSet> result = new LinkedHashMap<String, DefaultExternalSourceSet>();
        sourceSets.forEach(sourceSet -> {
            DefaultExternalSourceSet externalSourceSet = new DefaultExternalSourceSet();
            externalSourceSet.setName(sourceSet.getName());
            externalSourceSet.setArtifacts(GradleSourceSetModelBuilder.collectSourceSetArtifacts(project, context, sourceSet));
            GradleSourceSetModelBuilder.addJavaCompilerOptions(externalSourceSet, project, sourceSet, sourceSetResolutionContext);
            GradleSourceSetModelBuilder.addSourceDirs(externalSourceSet, project, sourceSet, sourceSetResolutionContext);
            GradleSourceSetModelBuilder.addLegacyTestSourceDirs(externalSourceSet, project, sourceSetResolutionContext);
            GradleSourceSetModelBuilder.cleanupSharedIdeaSourceDirs(externalSourceSet, sourceSetResolutionContext);
            result.put(externalSourceSet.getName(), externalSourceSet);
        });
        GradleSourceSetModelBuilder.addUnprocessedIdeaSourceDirs(result, sourceSets, sourceSetResolutionContext, "main");
        GradleSourceSetModelBuilder.addUnprocessedIdeaResourceDirs(result, sourceSetResolutionContext, "main");
        GradleSourceSetModelBuilder.addUnprocessedIdeaGeneratedSourcesDirs(result, sourceSetResolutionContext, "main");
        GradleSourceSetModelBuilder.addUnprocessedIdeaSourceDirs(result, sourceSets, sourceSetResolutionContext, "test");
        GradleSourceSetModelBuilder.addUnprocessedIdeaResourceDirs(result, sourceSetResolutionContext, "test");
        GradleSourceSetModelBuilder.addUnprocessedIdeaGeneratedSourcesDirs(result, sourceSetResolutionContext, "test");
        GradleSourceSetModelBuilder.cleanupSharedSourceDirs(result, "main", null);
        GradleSourceSetModelBuilder.cleanupSharedSourceDirs(result, "test", "main");
        LinkedHashMap<String, DefaultExternalSourceSet> linkedHashMap = result;
        if (linkedHashMap == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(47);
        }
        return linkedHashMap;
    }

    private static void addSourceDirs(@NotNull DefaultExternalSourceSet externalSourceSet, @NotNull Project project, @NotNull SourceSet sourceSet, @NotNull GradleSourceSetResolutionContext sourceSetResolutionContext) {
        if (externalSourceSet == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(48);
        }
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(49);
        }
        if (sourceSet == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(50);
        }
        if (sourceSetResolutionContext == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(51);
        }
        boolean resolveSourceSetDependencies = Boolean.getBoolean("idea.resolveSourceSetDependencies");
        DefaultExternalSourceDirectorySet sourceDirectorySet = new DefaultExternalSourceDirectorySet();
        sourceDirectorySet.setName(sourceSet.getAllJava().getName());
        sourceDirectorySet.setSrcDirs(sourceSet.getAllJava().getSrcDirs());
        sourceDirectorySet.setGradleOutputDirs(sourceSet.getOutput().getClassesDirs().getFiles());
        if (sourceDirectorySet.getGradleOutputDirs().isEmpty()) {
            sourceDirectorySet.setGradleOutputDirs(Collections.singleton(GradleProjectUtil.getBuildDirectory(project)));
        }
        sourceDirectorySet.setCompilerOutputPathInherited(sourceSetResolutionContext.isIdeaInheritOutputDirs);
        DefaultExternalSourceDirectorySet resourcesDirectorySet = new DefaultExternalSourceDirectorySet();
        resourcesDirectorySet.setName(sourceSet.getResources().getName());
        resourcesDirectorySet.setSrcDirs(sourceSet.getResources().getSrcDirs());
        resourcesDirectorySet.setExcludes(sourceSet.getResources().getExcludes());
        resourcesDirectorySet.setIncludes(sourceSet.getResources().getIncludes());
        if (sourceSet.getOutput().getResourcesDir() != null) {
            resourcesDirectorySet.setGradleOutputDirs(Collections.singleton(sourceSet.getOutput().getResourcesDir()));
        }
        if (resourcesDirectorySet.getGradleOutputDirs().isEmpty()) {
            resourcesDirectorySet.setGradleOutputDirs(sourceDirectorySet.getGradleOutputDirs());
        }
        resourcesDirectorySet.setCompilerOutputPathInherited(sourceSetResolutionContext.isIdeaInheritOutputDirs);
        DefaultExternalSourceDirectorySet generatedSourceDirectorySet = null;
        LinkedHashSet<File> generatedSourceDirs = new LinkedHashSet<File>(sourceDirectorySet.getSrcDirs());
        generatedSourceDirs.retainAll(sourceSetResolutionContext.ideaGeneratedSourceDirs);
        if (!generatedSourceDirs.isEmpty()) {
            sourceDirectorySet.getSrcDirs().removeAll(generatedSourceDirs);
            sourceSetResolutionContext.unprocessedIdeaGeneratedSourceDirs.removeAll(generatedSourceDirs);
            generatedSourceDirectorySet = new DefaultExternalSourceDirectorySet();
            generatedSourceDirectorySet.setName("generated " + sourceDirectorySet.getName());
            generatedSourceDirectorySet.setSrcDirs(generatedSourceDirs);
            generatedSourceDirectorySet.setGradleOutputDirs(sourceDirectorySet.getGradleOutputDirs());
            generatedSourceDirectorySet.setCompilerOutputPathInherited(sourceDirectorySet.isCompilerOutputPathInherited());
        }
        if (sourceSetResolutionContext.isJavaTestSourceSet(sourceSet)) {
            if (!sourceSetResolutionContext.isIdeaInheritOutputDirs && sourceSetResolutionContext.ideaTestOutputDir != null) {
                sourceDirectorySet.setOutputDir(sourceSetResolutionContext.ideaTestOutputDir);
                resourcesDirectorySet.setOutputDir(sourceSetResolutionContext.ideaTestOutputDir);
            } else if ("test".equals(sourceSet.getName()) || !resolveSourceSetDependencies) {
                sourceDirectorySet.setOutputDir(new File(project.getProjectDir(), "out/test/classes"));
                resourcesDirectorySet.setOutputDir(new File(project.getProjectDir(), "out/test/resources"));
            } else {
                String outputName = StringUtils.toCamelCase(sourceSet.getName(), true);
                sourceDirectorySet.setOutputDir(new File(project.getProjectDir(), String.format("out/%s/classes", outputName)));
                resourcesDirectorySet.setOutputDir(new File(project.getProjectDir(), String.format("out/%s/resources", outputName)));
            }
            if (generatedSourceDirectorySet != null) {
                generatedSourceDirectorySet.setOutputDir(sourceDirectorySet.getOutputDir());
            }
            resourcesDirectorySet.getExcludes().addAll(sourceSetResolutionContext.testResourcesExcludes);
            resourcesDirectorySet.getIncludes().addAll(sourceSetResolutionContext.testResourcesIncludes);
            resourcesDirectorySet.setFilters(sourceSetResolutionContext.testResourceFilters);
            externalSourceSet.addSource(ExternalSystemSourceType.TEST, sourceDirectorySet);
            externalSourceSet.addSource(ExternalSystemSourceType.TEST_RESOURCE, resourcesDirectorySet);
            if (generatedSourceDirectorySet != null) {
                externalSourceSet.addSource(ExternalSystemSourceType.TEST_GENERATED, generatedSourceDirectorySet);
            }
        } else {
            if (!sourceSetResolutionContext.isIdeaInheritOutputDirs && sourceSetResolutionContext.ideaOutputDir != null) {
                sourceDirectorySet.setOutputDir(sourceSetResolutionContext.ideaOutputDir);
                resourcesDirectorySet.setOutputDir(sourceSetResolutionContext.ideaOutputDir);
            } else if ("main".equals(sourceSet.getName()) || !resolveSourceSetDependencies) {
                sourceDirectorySet.setOutputDir(new File(project.getProjectDir(), "out/production/classes"));
                resourcesDirectorySet.setOutputDir(new File(project.getProjectDir(), "out/production/resources"));
            } else {
                String outputName = StringUtils.toCamelCase(sourceSet.getName(), true);
                sourceDirectorySet.setOutputDir(new File(project.getProjectDir(), String.format("out/%s/classes", outputName)));
                resourcesDirectorySet.setOutputDir(new File(project.getProjectDir(), String.format("out/%s/resources", outputName)));
            }
            if (generatedSourceDirectorySet != null) {
                generatedSourceDirectorySet.setOutputDir(sourceDirectorySet.getOutputDir());
            }
            resourcesDirectorySet.getExcludes().addAll(sourceSetResolutionContext.resourcesExcludes);
            resourcesDirectorySet.getIncludes().addAll(sourceSetResolutionContext.resourcesIncludes);
            resourcesDirectorySet.setFilters(sourceSetResolutionContext.resourceFilters);
            externalSourceSet.addSource(ExternalSystemSourceType.SOURCE, sourceDirectorySet);
            externalSourceSet.addSource(ExternalSystemSourceType.RESOURCE, resourcesDirectorySet);
            if (generatedSourceDirectorySet != null) {
                externalSourceSet.addSource(ExternalSystemSourceType.SOURCE_GENERATED, generatedSourceDirectorySet);
            }
        }
    }

    static void addLegacyTestSourceDirs(@NotNull DefaultExternalSourceSet externalSourceSet, @NotNull Project project, @NotNull GradleSourceSetResolutionContext sourceSetResolutionContext) {
        if (externalSourceSet == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(52);
        }
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(53);
        }
        if (sourceSetResolutionContext == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(54);
        }
        if (Boolean.getBoolean("idea.resolveSourceSetDependencies")) {
            return;
        }
        Map<ExternalSystemSourceType, DefaultExternalSourceDirectorySet> sources = externalSourceSet.getSources();
        DefaultExternalSourceDirectorySet sourceDirectorySet = sources.get(ExternalSystemSourceType.SOURCE);
        DefaultExternalSourceDirectorySet resourcesDirectorySet = sources.get(ExternalSystemSourceType.RESOURCE);
        DefaultExternalSourceDirectorySet generatedSourceDirectorySet = sources.get(ExternalSystemSourceType.SOURCE_GENERATED);
        if (sourceDirectorySet != null) {
            LinkedHashSet<File> testSourceDirs = new LinkedHashSet<File>(sourceDirectorySet.getSrcDirs());
            testSourceDirs.retainAll(sourceSetResolutionContext.ideaTestSourceDirs);
            if (!testSourceDirs.isEmpty()) {
                sourceDirectorySet.getSrcDirs().removeAll(sourceSetResolutionContext.ideaTestSourceDirs);
                DefaultExternalSourceDirectorySet testSourceDirectorySet = new DefaultExternalSourceDirectorySet();
                testSourceDirectorySet.setName(sourceDirectorySet.getName());
                testSourceDirectorySet.setSrcDirs(testSourceDirs);
                testSourceDirectorySet.setGradleOutputDirs(Collections.singleton(sourceDirectorySet.getOutputDir()));
                if (sourceSetResolutionContext.ideaTestOutputDir != null) {
                    testSourceDirectorySet.setOutputDir(sourceSetResolutionContext.ideaTestOutputDir);
                } else {
                    testSourceDirectorySet.setOutputDir(new File(project.getProjectDir(), "out/test/classes"));
                }
                testSourceDirectorySet.setCompilerOutputPathInherited(sourceDirectorySet.isCompilerOutputPathInherited());
                externalSourceSet.addSource(ExternalSystemSourceType.TEST, testSourceDirectorySet);
            }
        }
        if (resourcesDirectorySet != null) {
            LinkedHashSet<File> testResourceDirs = new LinkedHashSet<File>(resourcesDirectorySet.getSrcDirs());
            testResourceDirs.retainAll(sourceSetResolutionContext.ideaTestSourceDirs);
            if (!testResourceDirs.isEmpty()) {
                resourcesDirectorySet.getSrcDirs().removeAll(sourceSetResolutionContext.ideaTestSourceDirs);
                DefaultExternalSourceDirectorySet testResourcesDirectorySet = new DefaultExternalSourceDirectorySet();
                testResourcesDirectorySet.setName(resourcesDirectorySet.getName());
                testResourcesDirectorySet.setSrcDirs(testResourceDirs);
                testResourcesDirectorySet.setGradleOutputDirs(Collections.singleton(resourcesDirectorySet.getOutputDir()));
                if (sourceSetResolutionContext.ideaTestOutputDir != null) {
                    testResourcesDirectorySet.setOutputDir(sourceSetResolutionContext.ideaTestOutputDir);
                } else {
                    testResourcesDirectorySet.setOutputDir(new File(project.getProjectDir(), "out/test/resources"));
                }
                testResourcesDirectorySet.setCompilerOutputPathInherited(resourcesDirectorySet.isCompilerOutputPathInherited());
                externalSourceSet.addSource(ExternalSystemSourceType.TEST_RESOURCE, testResourcesDirectorySet);
            }
        }
        if (generatedSourceDirectorySet != null) {
            LinkedHashSet<File> testGeneratedSourceDirs = new LinkedHashSet<File>(generatedSourceDirectorySet.getSrcDirs());
            testGeneratedSourceDirs.retainAll(sourceSetResolutionContext.ideaTestSourceDirs);
            if (!testGeneratedSourceDirs.isEmpty()) {
                generatedSourceDirectorySet.getSrcDirs().removeAll(sourceSetResolutionContext.ideaTestSourceDirs);
                DefaultExternalSourceDirectorySet testGeneratedDirectorySet = new DefaultExternalSourceDirectorySet();
                testGeneratedDirectorySet.setName(generatedSourceDirectorySet.getName());
                testGeneratedDirectorySet.setSrcDirs(testGeneratedSourceDirs);
                testGeneratedDirectorySet.setGradleOutputDirs(Collections.singleton(generatedSourceDirectorySet.getOutputDir()));
                testGeneratedDirectorySet.setOutputDir(generatedSourceDirectorySet.getOutputDir());
                testGeneratedDirectorySet.setCompilerOutputPathInherited(generatedSourceDirectorySet.isCompilerOutputPathInherited());
                externalSourceSet.addSource(ExternalSystemSourceType.TEST_GENERATED, testGeneratedDirectorySet);
            }
        }
    }

    private static void addUnprocessedIdeaSourceDirs(@NotNull Map<String, DefaultExternalSourceSet> externalSourceSets, @NotNull SourceSetContainer sourceSets, @NotNull GradleSourceSetResolutionContext sourceSetResolutionContext, @NotNull String sourceSetName) {
        if (externalSourceSets == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(55);
        }
        if (sourceSets == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(56);
        }
        if (sourceSetResolutionContext == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(57);
        }
        if (sourceSetName == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(58);
        }
        Set<File> ideaSourceDirs = "test".equals(sourceSetName) ? sourceSetResolutionContext.ideaTestSourceDirs : sourceSetResolutionContext.ideaSourceDirs;
        ExternalSystemSourceType sourceType = "test".equals(sourceSetName) ? ExternalSystemSourceType.TEST : ExternalSystemSourceType.SOURCE;
        SourceSet sourceSet = (SourceSet)sourceSets.findByName(sourceSetName);
        if (sourceSet == null) {
            return;
        }
        DefaultExternalSourceSet externalSourceSet = externalSourceSets.get(sourceSetName);
        if (externalSourceSet == null) {
            return;
        }
        ExternalSourceDirectorySet sourceDirectorySet = externalSourceSet.getSources().get(sourceType);
        if (sourceDirectorySet == null) {
            return;
        }
        LinkedHashSet<File> sourceDirs = new LinkedHashSet<File>(ideaSourceDirs);
        sourceDirs.removeAll(sourceSet.getResources().getSrcDirs());
        sourceDirs.removeAll(sourceSetResolutionContext.ideaGeneratedSourceDirs);
        sourceDirectorySet.getSrcDirs().addAll(sourceDirs);
    }

    private static void addUnprocessedIdeaResourceDirs(@NotNull Map<String, DefaultExternalSourceSet> externalSourceSets, @NotNull GradleSourceSetResolutionContext sourceSetResolutionContext, @NotNull String sourceSetName) {
        if (externalSourceSets == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(59);
        }
        if (sourceSetResolutionContext == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(60);
        }
        if (sourceSetName == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(61);
        }
        Set<File> ideaResourceDirs = "test".equals(sourceSetName) ? sourceSetResolutionContext.ideaTestResourceDirs : sourceSetResolutionContext.ideaResourceDirs;
        ExternalSystemSourceType resourceType = "test".equals(sourceSetName) ? ExternalSystemSourceType.TEST_RESOURCE : ExternalSystemSourceType.RESOURCE;
        DefaultExternalSourceSet externalSourceSet = externalSourceSets.get(sourceSetName);
        if (externalSourceSet == null) {
            return;
        }
        ExternalSourceDirectorySet resourceDirectorySet = externalSourceSet.getSources().get(resourceType);
        if (resourceDirectorySet == null) {
            return;
        }
        resourceDirectorySet.getSrcDirs().addAll(ideaResourceDirs);
    }

    private static void addUnprocessedIdeaGeneratedSourcesDirs(@NotNull Map<String, DefaultExternalSourceSet> externalSourceSets, @NotNull GradleSourceSetResolutionContext sourceSetResolutionContext, @NotNull String sourceSetName) {
        if (externalSourceSets == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(62);
        }
        if (sourceSetResolutionContext == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(63);
        }
        if (sourceSetName == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(64);
        }
        Set<File> ideaSourceDirs = "test".equals(sourceSetName) ? sourceSetResolutionContext.ideaTestSourceDirs : sourceSetResolutionContext.ideaSourceDirs;
        ExternalSystemSourceType sourceType = "test".equals(sourceSetName) ? ExternalSystemSourceType.TEST : ExternalSystemSourceType.SOURCE;
        ExternalSystemSourceType generatedSourceType = "test".equals(sourceSetName) ? ExternalSystemSourceType.TEST_GENERATED : ExternalSystemSourceType.SOURCE_GENERATED;
        DefaultExternalSourceSet externalSourceSet = externalSourceSets.get(sourceSetName);
        if (externalSourceSet == null) {
            return;
        }
        LinkedHashSet<File> generatedSourceDirs = new LinkedHashSet<File>(sourceSetResolutionContext.unprocessedIdeaGeneratedSourceDirs);
        generatedSourceDirs.retainAll(ideaSourceDirs);
        if (!generatedSourceDirs.isEmpty()) {
            ExternalSourceDirectorySet generatedSourceDirectorySet = externalSourceSet.getSources().get(generatedSourceType);
            if (generatedSourceDirectorySet != null) {
                generatedSourceDirectorySet.getSrcDirs().addAll(generatedSourceDirs);
            } else {
                DefaultExternalSourceDirectorySet generatedDirectorySet = new DefaultExternalSourceDirectorySet();
                generatedDirectorySet.setName("generated " + externalSourceSet.getName());
                generatedDirectorySet.getSrcDirs().addAll(generatedSourceDirs);
                ExternalSourceDirectorySet sourceDirectorySet = externalSourceSet.getSources().get(sourceType);
                if (sourceDirectorySet != null) {
                    generatedDirectorySet.setGradleOutputDirs(Collections.singleton(sourceDirectorySet.getOutputDir()));
                    generatedDirectorySet.setOutputDir(sourceDirectorySet.getOutputDir());
                    generatedDirectorySet.setCompilerOutputPathInherited(sourceDirectorySet.isCompilerOutputPathInherited());
                }
                externalSourceSet.addSource(generatedSourceType, generatedDirectorySet);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: 
            case 18: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 14: 
            case 18: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelName";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 24: 
            case 27: 
            case 29: 
            case 35: 
            case 40: 
            case 43: 
            case 45: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 11: 
            case 14: 
            case 18: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetModelBuilder";
                break;
            }
            case 17: 
            case 26: 
            case 41: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSet";
                break;
            }
            case 19: 
            case 55: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSourceSets";
                break;
            }
            case 20: 
            case 58: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetName";
                break;
            }
            case 21: 
            case 39: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSourceSet";
                break;
            }
            case 22: 
            case 42: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetResolutionContext";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveTask";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaCompile";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetModelBuilder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNonSourceSetArtifacts";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProjectConfigurationArtifacts";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSourceSetArtifacts";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTestSourceSets";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "collectJvmTestSuiteSourceSets";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTestFixtureSourceSets";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSourceSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildAll";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reportErrorMessage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectProjectTaskArtifacts";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectNonSourceSetArtifacts";
                break;
            }
            case 11: 
            case 14: 
            case 18: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 47: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectProjectConfigurationArtifacts";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectSourceSetArtifacts";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "cleanupSharedSourceDirs";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "cleanupSharedIdeaSourceDirs";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "containsPotentialClasspathElements";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "containsAllSourceSetOutput";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectTestSourceSets";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "collectJvmTestSuiteSourceSets";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "collectTestFixtureSourceSets";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addJavaCompilerOptions";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getJavaToolchainHome";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "collectSourceSets";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addSourceDirs";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addLegacyTestSourceDirs";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "addUnprocessedIdeaSourceDirs";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "addUnprocessedIdeaResourceDirs";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "addUnprocessedIdeaGeneratedSourcesDirs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 14: 
            case 18: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

