/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.dependencyModel.auxiliary;

import com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel.GradleDependencyDownloadPolicy;
import com.intellij.gradle.toolingExtension.impl.model.dependencyModel.auxiliary.AuxiliaryArtifactResolver;
import com.intellij.gradle.toolingExtension.impl.model.dependencyModel.auxiliary.AuxiliaryConfigurationArtifacts;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.attributes.Usage;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ExperimentalAuxiliaryArtifactResolver
implements AuxiliaryArtifactResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final GradleDependencyDownloadPolicy policy;
    private final Set<String> allowedDependencyGroups;

    public ExperimentalAuxiliaryArtifactResolver(@NotNull Project project, @NotNull GradleDependencyDownloadPolicy policy, Set<String> allowedDependencyGroups) {
        if (project == null) {
            ExperimentalAuxiliaryArtifactResolver.$$$reportNull$$$0(0);
        }
        if (policy == null) {
            ExperimentalAuxiliaryArtifactResolver.$$$reportNull$$$0(1);
        }
        this.project = project;
        this.policy = policy;
        this.allowedDependencyGroups = allowedDependencyGroups;
    }

    @Override
    @NotNull
    public AuxiliaryConfigurationArtifacts resolve(@NotNull Configuration configuration) {
        if (configuration == null) {
            ExperimentalAuxiliaryArtifactResolver.$$$reportNull$$$0(2);
        }
        boolean downloadSources = this.policy.isDownloadSources();
        boolean downloadJavadoc = this.policy.isDownloadJavadoc();
        if (!downloadSources && !downloadJavadoc) {
            return new AuxiliaryConfigurationArtifacts(Collections.emptyMap(), Collections.emptyMap());
        }
        Map<ComponentIdentifier, Set<File>> javadocs = Collections.emptyMap();
        if (downloadJavadoc) {
            Set<ResolvedArtifactResult> artifacts = this.resolve(configuration, "javadoc");
            javadocs = ExperimentalAuxiliaryArtifactResolver.classify(artifacts);
        }
        Map<ComponentIdentifier, Set<File>> sources = Collections.emptyMap();
        if (downloadSources) {
            Set<ResolvedArtifactResult> artifacts = this.resolve(configuration, "sources");
            sources = ExperimentalAuxiliaryArtifactResolver.classify(artifacts);
        }
        return new AuxiliaryConfigurationArtifacts(sources, javadocs);
    }

    @NotNull
    private static Map<ComponentIdentifier, Set<File>> classify(@NotNull Set<ResolvedArtifactResult> artifacts) {
        if (artifacts == null) {
            ExperimentalAuxiliaryArtifactResolver.$$$reportNull$$$0(3);
        }
        HashMap<ComponentIdentifier, Set<File>> result = new HashMap<ComponentIdentifier, Set<File>>();
        for (ResolvedArtifactResult artifact : artifacts) {
            ComponentArtifactIdentifier identifier = artifact.getId();
            if (!(identifier instanceof ModuleComponentArtifactIdentifier)) continue;
            File file = artifact.getFile();
            result.computeIfAbsent(identifier.getComponentIdentifier(), __ -> new HashSet()).add(file);
        }
        HashMap<ComponentIdentifier, Set<File>> hashMap = result;
        if (hashMap == null) {
            ExperimentalAuxiliaryArtifactResolver.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @NotNull
    private Set<ResolvedArtifactResult> resolve(@NotNull Configuration configuration, @NotNull String docsType) {
        if (configuration == null) {
            ExperimentalAuxiliaryArtifactResolver.$$$reportNull$$$0(5);
        }
        if (docsType == null) {
            ExperimentalAuxiliaryArtifactResolver.$$$reportNull$$$0(6);
        }
        ObjectFactory objects = this.project.getObjects();
        Set set = configuration.getIncoming().artifactView(view -> {
            view.componentFilter(componentIdentifier -> {
                if (this.allowedDependencyGroups.isEmpty()) {
                    return true;
                }
                if (componentIdentifier instanceof ModuleComponentIdentifier) {
                    return this.allowedDependencyGroups.contains(((ModuleComponentIdentifier)componentIdentifier).getGroup());
                }
                return false;
            });
            view.withVariantReselection();
            view.setLenient(true);
            view.attributes(container -> {
                container.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objects.named(Usage.class, "java-runtime")));
                container.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objects.named(Category.class, "documentation")));
                container.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)objects.named(Bundling.class, "external")));
                container.attribute(DocsType.DOCS_TYPE_ATTRIBUTE, (Object)((DocsType)objects.named(DocsType.class, docsType)));
            });
        }).getArtifacts().getArtifacts();
        if (set == null) {
            ExperimentalAuxiliaryArtifactResolver.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/dependencyModel/auxiliary/ExperimentalAuxiliaryArtifactResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docsType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/dependencyModel/auxiliary/ExperimentalAuxiliaryArtifactResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

