/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.metadata.resolver.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.DuplicatedUniqueNameStrategy;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.SearchPathResolver;
import org.jetbrains.kotlin.library.SearchPathResolverKt;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.library.metadata.resolver.KotlinLibraryResolveResult;
import org.jetbrains.kotlin.library.metadata.resolver.KotlinLibraryResolver;
import org.jetbrains.kotlin.library.metadata.resolver.KotlinResolvedLibrary;
import org.jetbrains.kotlin.library.metadata.resolver.impl.KotlinLibraryResolverResultImpl;
import org.jetbrains.kotlin.library.metadata.resolver.impl.KotlinResolvedLibraryImpl;
import org.jetbrains.kotlin.util.Logger;
import org.jetbrains.kotlin.util.WithLogger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u001f\b\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ<\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J4\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0002J \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u001b\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u001d\u001a\u00020\u001eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/library/metadata/resolver/impl/KotlinLibraryResolverImpl;", "L", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/metadata/resolver/KotlinLibraryResolver;", "Lorg/jetbrains/kotlin/util/WithLogger;", "searchPathResolver", "Lorg/jetbrains/kotlin/library/SearchPathResolver;", "resolveManifestDependenciesLenient", "", "<init>", "(Lorg/jetbrains/kotlin/library/SearchPathResolver;Z)V", "getSearchPathResolver", "()Lorg/jetbrains/kotlin/library/SearchPathResolver;", "getResolveManifestDependenciesLenient", "()Z", "resolveWithoutDependencies", "", "unresolvedLibraries", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "noStdLib", "noDefaultLibs", "noEndorsedLibs", "duplicatedUniqueNameStrategy", "Lorg/jetbrains/kotlin/config/DuplicatedUniqueNameStrategy;", "findLibraries", "leaveDistinct", "omitDuplicateNames", "resolveDependencies", "Lorg/jetbrains/kotlin/library/metadata/resolver/KotlinLibraryResolveResult;", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "getLogger", "()Lorg/jetbrains/kotlin/util/Logger;", "kotlin-util-klib-metadata"})
@SourceDebugExtension(value={"SMAP\nKotlinLibraryResolverImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLibraryResolverImpl.kt\norg/jetbrains/kotlin/library/metadata/resolver/impl/KotlinLibraryResolverImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1516#2,3:189\n1519#2,3:199\n1563#2:202\n1634#2,3:203\n1491#2:206\n1516#2,3:207\n1519#2,3:217\n1056#2:227\n1869#2:228\n1563#2:229\n1634#2,3:230\n1870#2:233\n1563#2:238\n1634#2,3:239\n1563#2:242\n1634#2,3:243\n1563#2:246\n1634#2,3:247\n384#3,7:192\n384#3,7:210\n506#3,7:220\n126#4:234\n153#4,3:235\n1#5:250\n*S KotlinDebug\n*F\n+ 1 KotlinLibraryResolverImpl.kt\norg/jetbrains/kotlin/library/metadata/resolver/impl/KotlinLibraryResolverImpl\n*L\n75#1:189,3\n75#1:199,3\n76#1:202\n76#1:203,3\n89#1:206\n89#1:207,3\n89#1:217,3\n91#1:227\n91#1:228\n92#1:229\n92#1:230,3\n91#1:233\n123#1:238\n123#1:239,3\n130#1:242\n130#1:243,3\n134#1:246\n134#1:247,3\n75#1:192,7\n89#1:210,7\n90#1:220,7\n108#1:234\n108#1:235,3\n*E\n"})
public final class KotlinLibraryResolverImpl<L extends KotlinLibrary>
implements KotlinLibraryResolver<L>,
WithLogger {
    @NotNull
    private final SearchPathResolver<L> searchPathResolver;
    private final boolean resolveManifestDependenciesLenient;

    public KotlinLibraryResolverImpl(@NotNull SearchPathResolver<L> searchPathResolver, boolean resolveManifestDependenciesLenient) {
        Intrinsics.checkNotNullParameter(searchPathResolver, (String)"searchPathResolver");
        this.searchPathResolver = searchPathResolver;
        this.resolveManifestDependenciesLenient = resolveManifestDependenciesLenient;
    }

    @Override
    @NotNull
    public SearchPathResolver<L> getSearchPathResolver() {
        return this.searchPathResolver;
    }

    public final boolean getResolveManifestDependenciesLenient() {
        return this.resolveManifestDependenciesLenient;
    }

    @Override
    @NotNull
    public List<KotlinLibrary> resolveWithoutDependencies(@NotNull List<? extends UnresolvedLibrary> unresolvedLibraries, boolean noStdLib, boolean noDefaultLibs, boolean noEndorsedLibs, @NotNull DuplicatedUniqueNameStrategy duplicatedUniqueNameStrategy) {
        Intrinsics.checkNotNullParameter(unresolvedLibraries, (String)"unresolvedLibraries");
        Intrinsics.checkNotNullParameter((Object)duplicatedUniqueNameStrategy, (String)"duplicatedUniqueNameStrategy");
        return this.omitDuplicateNames(this.leaveDistinct(this.findLibraries(unresolvedLibraries, noStdLib, noDefaultLibs, noEndorsedLibs)), duplicatedUniqueNameStrategy);
    }

    private final List<KotlinLibrary> findLibraries(List<? extends UnresolvedLibrary> unresolvedLibraries, boolean noStdLib, boolean noDefaultLibs, boolean noEndorsedLibs) {
        List userProvidedLibraries = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)unresolvedLibraries), arg_0 -> KotlinLibraryResolverImpl.findLibraries$lambda$0(this, arg_0)));
        List defaultLibraries = this.getSearchPathResolver().defaultLinks(noStdLib, noDefaultLibs, noEndorsedLibs);
        return CollectionsKt.plus((Collection)userProvidedLibraries, (Iterable)defaultLibraries);
    }

    /*
     * WARNING - void declaration
     */
    private final List<KotlinLibrary> leaveDistinct(List<? extends KotlinLibrary> $this$leaveDistinct) {
        void $this$mapTo$iv$iv;
        void destination$iv;
        Object key$iv;
        void $this$groupByTo$iv;
        if ($this$leaveDistinct.size() <= 1) {
            return $this$leaveDistinct;
        }
        Iterable iterable = $this$leaveDistinct;
        Map map = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv : $this$groupByTo$iv) {
            Object object;
            KotlinLibrary it = (KotlinLibrary)element$iv;
            boolean bl = false;
            key$iv = it.getLibraryFile().getAbsolutePath();
            void $this$getOrPut$iv$iv = destination$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
            if (value$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                object = answer$iv$iv;
            } else {
                object = value$iv$iv;
            }
            List list$iv = (List)object;
            list$iv.add(element$iv);
        }
        void deduplicatedLibraries = destination$iv;
        Iterable $this$map$iv = deduplicatedLibraries.values();
        boolean $i$f$map = false;
        Iterable $i$f$groupByTo22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            key$iv = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((KotlinLibrary)CollectionsKt.first((List)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KotlinLibrary> omitDuplicateNames(List<? extends KotlinLibrary> $this$omitDuplicateNames, DuplicatedUniqueNameStrategy duplicatedUniqueNameStrategy) {
        void $this$mapTo$iv$iv;
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = $this$omitDuplicateNames;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            KotlinLibrary kotlinLibrary = (KotlinLibrary)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)((BaseKotlinLibrary)kotlinLibrary));
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list = (List)object;
            list.add(element$iv$iv);
        }
        Map groupedByUniqName = destination$iv$iv;
        boolean bl = false;
        Map $this$filterValues$iv = groupedByUniqName;
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            List it = (List)entry.getValue();
            boolean bl3 = false;
            if (!(it.size() > 1)) continue;
            ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
        }
        Map librariesWithDuplicatedUniqueNames = (Map)result$iv;
        Iterable $this$sortedBy$iv = librariesWithDuplicatedUniqueNames.entrySet();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl4 = false;
            String uniqueName = (String)entry.getKey();
            List libraries = (List)entry.getValue();
            Iterable $this$map$iv = libraries;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                KotlinLibrary kotlinLibrary = (KotlinLibrary)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl5 = false;
                collection.add(it.getLibraryFile().getAbsolutePath());
            }
            String libraryPaths = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv2)), null, null, null, (int)0, null, null, (int)63, null);
            String message = "KLIB resolver: The same 'unique_name=" + uniqueName + "' found in more than one library: " + libraryPaths;
            if (duplicatedUniqueNameStrategy == DuplicatedUniqueNameStrategy.ALLOW_ALL_WITH_WARNING || duplicatedUniqueNameStrategy == DuplicatedUniqueNameStrategy.ALLOW_FIRST_WITH_WARNING) {
                this.getLogger().strongWarning(message);
                continue;
            }
            this.getLogger().error(message + "\nPlease file an issue to https://kotl.in/issue and meanwhile use CLI flag `-Xklib-duplicated-unique-name-strategy` with one of the following values:\n" + DuplicatedUniqueNameStrategy.ALLOW_ALL_WITH_WARNING + ": Use all KLIB dependencies, even when they have same `unique_name` property.\n" + DuplicatedUniqueNameStrategy.ALLOW_FIRST_WITH_WARNING + ": Use the first KLIB dependency with clashing `unique_name` property. No order guarantees are given though.\n" + DuplicatedUniqueNameStrategy.DENY + ": Fail a compilation with the error.");
        }
        Map $this$map$iv = groupedByUniqName;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
        boolean bl2 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry libraries = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv3;
            boolean bl6 = false;
            collection.add((KotlinLibrary)CollectionsKt.first((List)((List)it.getValue())));
        }
        List<KotlinLibrary> deduplicatedLibs = (List<KotlinLibrary>)destination$iv$iv3;
        return duplicatedUniqueNameStrategy == DuplicatedUniqueNameStrategy.ALLOW_FIRST_WITH_WARNING ? deduplicatedLibs : $this$omitDuplicateNames;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KotlinLibraryResolveResult resolveDependencies(@NotNull List<? extends KotlinLibrary> $this$resolveDependencies) {
        Collection destination$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter($this$resolveDependencies, (String)"<this>");
        Iterable $this$map$iv2 = $this$resolveDependencies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator it;
            KotlinLibrary kotlinLibrary = (KotlinLibrary)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(new KotlinResolvedLibraryImpl((KotlinLibrary)it));
        }
        List rootLibraries = (List)destination$iv$iv2;
        KotlinLibraryResolverResultImpl result = new KotlinLibraryResolverResultImpl(rootLibraries);
        Map cache = new LinkedHashMap();
        $this$mapTo$iv$iv2 = rootLibraries;
        object = cache;
        boolean $i$f$map2 = false;
        void $i$f$mapTo22 = $this$map$iv;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinResolvedLibraryImpl kotlinResolvedLibraryImpl = (KotlinResolvedLibraryImpl)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getLibrary().getLibraryFile().getFileKey(), (Object)it));
        }
        MapsKt.putAll((Map)object, (Iterable)((List)destination$iv$iv3));
        List newDependencies = rootLibraries;
        do {
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv3 = newDependencies;
            boolean $i$f$map3 = false;
            destination$iv$iv3 = $this$map$iv3;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void library;
                KotlinResolvedLibraryImpl bl = (KotlinResolvedLibraryImpl)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add(SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)KotlinLibraryKt.unresolvedDependencies((BaseKotlinLibrary)((BaseKotlinLibrary)library.getLibrary()), (boolean)this.resolveManifestDependenciesLenient)), arg_0 -> KotlinLibraryResolverImpl.resolveDependencies$lambda$15$lambda$12(this, arg_0)), arg_0 -> KotlinLibraryResolverImpl.resolveDependencies$lambda$15$lambda$13(this, arg_0)), arg_0 -> KotlinLibraryResolverImpl.resolveDependencies$lambda$15$lambda$14(cache, (KotlinResolvedLibraryImpl)library, arg_0)))));
            }
        } while (!((Collection)(newDependencies = CollectionsKt.flatten((Iterable)((List)destination$iv$iv)))).isEmpty());
        return result;
    }

    @NotNull
    public Logger getLogger() {
        return this.searchPathResolver.getLogger();
    }

    private static final KotlinLibrary findLibraries$lambda$0(KotlinLibraryResolverImpl this$0, UnresolvedLibrary it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SearchPathResolverKt.resolve(this$0.getSearchPathResolver(), (UnresolvedLibrary)it);
    }

    private static final boolean resolveDependencies$lambda$15$lambda$12(KotlinLibraryResolverImpl this$0, UnresolvedLibrary it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getSearchPathResolver().isProvidedByDefault(it);
    }

    private static final KotlinResolvedLibraryImpl resolveDependencies$lambda$15$lambda$13(KotlinLibraryResolverImpl this$0, UnresolvedLibrary it) {
        KotlinResolvedLibraryImpl kotlinResolvedLibraryImpl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KotlinLibrary kotlinLibrary = SearchPathResolverKt.resolve(this$0.getSearchPathResolver(), (UnresolvedLibrary)it);
        if (kotlinLibrary != null) {
            KotlinLibrary p0 = kotlinLibrary;
            boolean bl = false;
            kotlinResolvedLibraryImpl = new KotlinResolvedLibraryImpl(p0);
        } else {
            kotlinResolvedLibraryImpl = null;
        }
        return kotlinResolvedLibraryImpl;
    }

    private static final KotlinResolvedLibraryImpl resolveDependencies$lambda$15$lambda$14(Map $cache, KotlinResolvedLibraryImpl $library, KotlinResolvedLibraryImpl resolved) {
        KotlinResolvedLibraryImpl kotlinResolvedLibraryImpl;
        Intrinsics.checkNotNullParameter((Object)resolved, (String)"resolved");
        Object fileKey = resolved.getLibrary().getLibraryFile().getFileKey();
        if ($cache.containsKey(fileKey)) {
            Object v = $cache.get(fileKey);
            Intrinsics.checkNotNull(v);
            $library.addDependency$kotlin_util_klib_metadata((KotlinResolvedLibrary)v);
            kotlinResolvedLibraryImpl = null;
        } else {
            $cache.put(fileKey, resolved);
            $library.addDependency$kotlin_util_klib_metadata(resolved);
            kotlinResolvedLibraryImpl = resolved;
        }
        return kotlinResolvedLibraryImpl;
    }
}

