/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.resolve;

import com.intellij.debugger.streams.core.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.trace.TraceInfo;
import com.intellij.debugger.streams.core.wrapper.TraceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J=\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b*\u0014\u0012\u0004\u0012\u0002H\n\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\r0\f2\u0006\u0010\u000e\u001a\u0002H\n2\u0006\u0010\u000f\u001a\u0002H\u000b\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/debugger/streams/core/resolve/PairMapResolver;", "Lcom/intellij/debugger/streams/core/resolve/ValuesOrderResolver;", "<init>", "()V", "resolve", "Lcom/intellij/debugger/streams/core/resolve/ValuesOrderResolver$Result;", "info", "Lcom/intellij/debugger/streams/core/trace/TraceInfo;", "add", "", "K", "V", "", "", "key", "value", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)V", "intellij.debugger.streams.core"})
public final class PairMapResolver
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Map direct = new LinkedHashMap();
        Map reverse = new LinkedHashMap();
        List<TraceElement> valuesBefore = TraceUtil.sortedByTime(info.getValuesOrderBefore().values());
        List<TraceElement> valuesAfter = TraceUtil.sortedByTime(info.getValuesOrderAfter().values());
        Iterator<TraceElement> beforeIterator = valuesBefore.iterator();
        Iterator<TraceElement> afterIterator = valuesAfter.iterator();
        TraceElement after = null;
        while (beforeIterator.hasNext()) {
            TraceElement before = beforeIterator.next();
            if (after != null) {
                this.add(direct, before, after);
                this.add(reverse, after, before);
            }
            if (!afterIterator.hasNext()) continue;
            after = afterIterator.next();
            this.add(direct, before, after);
            this.add(reverse, after, before);
        }
        ValuesOrderResolver.Result result = ValuesOrderResolver.Result.of(direct, reverse);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"of(...)");
        return result;
    }

    public final <K, V> void add(@NotNull Map<K, List<V>> $this$add, K key, V value) {
        Intrinsics.checkNotNullParameter($this$add, (String)"<this>");
        List list = $this$add.computeIfAbsent(key, arg_0 -> PairMapResolver.add$lambda$1(PairMapResolver::add$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"computeIfAbsent(...)");
        ((Collection)list).add(value);
    }

    private static final List add$lambda$0(Object it) {
        return new ArrayList();
    }

    private static final List add$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

