/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.axis.label;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeometryUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AbstractFixedBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.BreakLabelsLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.HorizontalRotatedLabelsLayout;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/HorizontalRotatedLabelsLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AbstractFixedBreaksLabelsLayout;", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "myRotationAngle", "", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;D)V", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "axisLength", "labelBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "labelNormalSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nHorizontalRotatedLabelsLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HorizontalRotatedLabelsLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/HorizontalRotatedLabelsLayout\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1789#2,3:74\n1549#2:77\n1620#2,3:78\n1549#2:81\n1620#2,3:82\n*S KotlinDebug\n*F\n+ 1 HorizontalRotatedLabelsLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/HorizontalRotatedLabelsLayout\n*L\n44#1:74,3\n57#1:77\n57#1:78,3\n64#1:81\n64#1:82,3\n*E\n"})
public final class HorizontalRotatedLabelsLayout
extends AbstractFixedBreaksLabelsLayout {
    private final double myRotationAngle;

    public HorizontalRotatedLabelsLayout(@NotNull Orientation orientation, @NotNull ScaleBreaks breaks, @NotNull AxisTheme theme, double myRotationAngle) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(orientation, breaks, theme);
        this.myRotationAngle = myRotationAngle;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AxisLabelsLayoutInfo doLayout(@NotNull DoubleSpan axisDomain, double axisLength) {
        DoubleRectangle it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Function1 function1;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        if (this.getBreaks().isEmpty()) {
            return this.noLabelsLayoutInfo(axisLength, this.getOrientation());
        }
        if (!this.getTheme().showLabels()) {
            return this.noLabelsLayoutInfo(axisLength, this.getOrientation());
        }
        List<Double> ticks = this.getBreaks().projectOnAxis(axisDomain, axisLength, true);
        List<DoubleRectangle> labelBoundsList2 = this.labelBoundsList(ticks, this.getBreaks().getLabels(), AbstractFixedBreaksLabelsLayout.Companion.getHORIZONTAL_TICK_LOCATION());
        boolean overlap = false;
        Iterable iterable = labelBoundsList2;
        DoubleRectangle initial$iv = null;
        boolean $i$f$fold = false;
        DoubleRectangle accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void b2;
            DoubleRectangle doubleRectangle = (DoubleRectangle)element$iv;
            DoubleRectangle acc = accumulator$iv;
            boolean bl = false;
            overlap = overlap || acc != null && acc.xRange().connected(b2.xRange().expanded(10.0));
            accumulator$iv = GeometryUtil.INSTANCE.union((DoubleRectangle)b2, acc);
        }
        DoubleRectangle doubleRectangle = accumulator$iv;
        Intrinsics.checkNotNull(doubleRectangle);
        DoubleRectangle bounds = doubleRectangle;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getOrientation().ordinal()]) {
            case 1: {
                function1 = doLayout.yOffset.1.INSTANCE;
                break;
            }
            case 2: {
                function1 = doLayout.yOffset.2.INSTANCE;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported orientation " + (Object)((Object)this.getOrientation()));
            }
        }
        Function1 yOffset2 = function1;
        Iterable $this$map$iv = labelBoundsList2;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DoubleRectangle doubleRectangle2 = (DoubleRectangle)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new DoubleVector(0.0, ((Number)yOffset2.invoke((Object)it)).doubleValue()));
        }
        List labelAdditionalOffsets = (List)destination$iv$iv;
        $this$map$iv = labelBoundsList2;
        object = this.createAxisLabelsLayoutInfoBuilder(bounds, overlap).labelHorizontalAnchor(Text.HorizontalAnchor.MIDDLE).labelVerticalAnchor(Text.VerticalAnchor.CENTER).labelRotationAngle(-this.myRotationAngle).labelAdditionalOffsets(labelAdditionalOffsets);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            it = (DoubleRectangle)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.alignToLabelMargin((DoubleRectangle)p0));
        }
        return ((AxisLabelsLayoutInfo.Builder)object).labelBoundsList((List)destination$iv$iv).build();
    }

    @Override
    @NotNull
    protected DoubleRectangle labelBounds(@NotNull DoubleVector labelNormalSize) {
        Intrinsics.checkNotNullParameter((Object)labelNormalSize, (String)"labelNormalSize");
        DoubleRectangle it = BreakLabelsLayoutUtil.INSTANCE.rotatedLabelBounds(labelNormalSize, this.myRotationAngle);
        boolean bl = false;
        return BreakLabelsLayoutUtil.INSTANCE.horizontalCenteredLabelBounds(it.getDimension());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

